/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.diagram.core.part.util;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.AbstractTreeIterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.impl.InternalTransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.emf.workspace.AbstractEMFOperation;
import org.eclipse.epf.common.CommonPlugin;
import org.eclipse.epf.diagram.core.DiagramCorePlugin;
import org.eclipse.epf.diagram.core.bridge.ActivityDiagramAdapter;
import org.eclipse.epf.diagram.core.bridge.BridgeHelper;
import org.eclipse.epf.diagram.core.bridge.DiagramAdapter;
import org.eclipse.epf.diagram.core.bridge.NodeAdapter;
import org.eclipse.epf.diagram.core.part.AbstractDiagramEditor;
import org.eclipse.epf.diagram.core.part.DiagramEditorInput;
import org.eclipse.epf.diagram.core.part.DiagramEditorInputProxy;
import org.eclipse.epf.diagram.core.part.DiagramFileEditorInputProxy;
import org.eclipse.epf.diagram.core.part.IDiagramEditorInputProvider;
import org.eclipse.epf.diagram.core.part.IDiagramFileEditorInputProxy;
import org.eclipse.epf.diagram.core.providers.SharedResourceDiagramDocumentProvider;
import org.eclipse.epf.diagram.core.resources.IDiagramStorage;
import org.eclipse.epf.diagram.core.services.DiagramManager;
import org.eclipse.epf.diagram.core.util.DiagramCoreUtil;
import org.eclipse.epf.diagram.model.ActivityDetailDiagram;
import org.eclipse.epf.diagram.model.ModelFactory;
import org.eclipse.epf.diagram.model.NamedNode;
import org.eclipse.epf.diagram.model.NodeContainer;
import org.eclipse.epf.diagram.model.RoleTaskComposite;
import org.eclipse.epf.diagram.model.WorkProductDependencyDiagram;
import org.eclipse.epf.diagram.model.impl.DiagramImpl;
import org.eclipse.epf.diagram.model.impl.NodeImpl;
import org.eclipse.epf.diagram.model.util.TxUtil;
import org.eclipse.epf.library.edit.TngAdapterFactory;
import org.eclipse.epf.library.edit.process.BreakdownElementWrapperItemProvider;
import org.eclipse.epf.library.edit.util.ProcessUtil;
import org.eclipse.epf.library.edit.util.Suppression;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.Process;
import org.eclipse.epf.uma.TaskDescriptor;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionNodeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ITextAwareEditPart;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramWorkbenchPart;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.IDocumentProvider;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.parts.DiagramDocumentEditor;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.FontStyle;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;

public class DiagramEditorUtil {
    private static final String AD_EDITOR_ID = "org.eclipse.epf.diagram.ad.part.ActivityDiagramEditorID";
    private static final String ADD_EDITOR_ID = "org.eclipse.epf.diagram.add.part.ActivityDetailDiagramEditorID";
    private static final String WPDD_EDITOR_ID = "org.eclipse.epf.diagram.wpdd.part.WorkProductDependencyDiagramEditorID";

    public static String getEditorId(int diagramType) {
        switch (diagramType) {
            case 0: {
                return AD_EDITOR_ID;
            }
            case 2: {
                return ADD_EDITOR_ID;
            }
            case 1: {
                return WPDD_EDITOR_ID;
            }
        }
        return null;
    }

    public static IEditorPart openDiagramEditor(IWorkbenchPage page, DiagramEditorInput input, PreferencesHint hint, IProgressMonitor progressMonitor) {
        DiagramEditorInputProxy inputProxy = new DiagramEditorInputProxy(input, hint);
        IEditorPart editorPart = null;
        try {
            editorPart = page.openEditor((IEditorInput)inputProxy, DiagramEditorUtil.getEditorId(input.getDiagramType()), true);
        }
        catch (Exception e) {
            CommonPlugin.getDefault().getLogger().logError((Throwable)e);
        }
        if (editorPart instanceof AbstractDiagramEditor) {
            if (input.getDiagramType() == 2) {
                AbstractDiagramEditor editor = (AbstractDiagramEditor)editorPart;
                editor.resetLayout();
                editor.resetLayout();
            }
            IDocumentProvider docProvider = ((DiagramDocumentEditor)editorPart).getDocumentProvider();
            Process proc = TngUtil.getOwningProcess((Object)input.getMethodElement());
            if (proc != null) {
                DiagramManager mgr = null;
                Object consumer = new Object();
                try {
                    mgr = DiagramManager.getInstance(proc, consumer);
                    if (mgr != null && inputProxy.isNewDiagram()) {
                        docProvider.setCanSaveDocument((Object)inputProxy);
                    }
                }
                finally {
                    if (mgr != null) {
                        mgr.removeConsumer(consumer);
                    }
                }
            }
            if (docProvider instanceof SharedResourceDiagramDocumentProvider && editorPart.isDirty() && !inputProxy.isNewDiagram()) {
                ((SharedResourceDiagramDocumentProvider)docProvider).markDocumentAsSaved(inputProxy);
            }
            if (!DiagramEditorUtil.isModifiable(inputProxy)) {
                ((SharedResourceDiagramDocumentProvider)((AbstractDiagramEditor)editorPart).getDocumentProvider()).lock(true);
                DiagramEditPart editPart = ((IDiagramWorkbenchPart)editorPart).getDiagramEditPart();
                editPart.disableEditMode();
            }
        }
        return editorPart;
    }

    public static void refreshVisual(DiagramEditPart editPart) {
        AbstractTreeIterator<Object> iter = new AbstractTreeIterator<Object>((Object)editPart, false){
            private static final long serialVersionUID = 1L;

            protected Iterator<?> getChildren(Object object) {
                if (object instanceof EditPart) {
                    return ((EditPart)object).getChildren().iterator();
                }
                return Collections.EMPTY_LIST.iterator();
            }
        };
        while (iter.hasNext()) {
            Object child = iter.next();
            if (!(child instanceof ITextAwareEditPart) && !(child instanceof ConnectionNodeEditPart)) continue;
            ((EditPart)child).refresh();
        }
        for (org.eclipse.gef.ConnectionEditPart conn : editPart.getConnections()) {
            conn.refresh();
        }
    }

    public static void refreshLabels(DiagramEditPart editPart) {
        AbstractTreeIterator iter = new AbstractTreeIterator(editPart, false){

            protected Iterator getChildren(Object object) {
                if (object instanceof EditPart) {
                    return ((EditPart)object).getChildren().iterator();
                }
                return Collections.EMPTY_LIST.iterator();
            }
        };
        while (iter.hasNext()) {
            Object child = iter.next();
            if (!(child instanceof ITextAwareEditPart)) continue;
            ((ITextAwareEditPart)child).refresh();
        }
    }

    private static Diagram getDiagram(DiagramEditorInputProxy inputProxy) throws CoreException {
        IStorage storage = inputProxy.getStorage();
        return storage instanceof IDiagramStorage ? ((IDiagramStorage)storage).getDiagram() : null;
    }

    private static boolean doInitialize(final DiagramEditorInputProxy inputProxy, IProgressMonitor monitor) throws CoreException {
        final Diagram model = DiagramEditorUtil.getDiagram(inputProxy);
        if (model == null) {
            return false;
        }
        if ("AD".equals(model.getType())) {
            ActivityDiagramAdapter adapter = (ActivityDiagramAdapter)BridgeHelper.getNodeAdapter(model.getElement());
            if (adapter == null) {
                adapter = new ActivityDiagramAdapter((Activity)inputProxy.getDiagramEditorInput().getMethodElement());
                adapter.setEditingDomain((InternalTransactionalEditingDomain)TransactionUtil.getEditingDomain((EObject)model));
                adapter.setSuppression(inputProxy.getDiagramEditorInput().getSuppression());
                adapter.setView((View)model);
                model.getElement().eAdapters().add((Object)adapter);
            }
            adapter.populateDiagram();
            return true;
        }
        if ("ADD".equals(model.getType()) || "WPDD".equals(model.getType())) {
            TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)model);
            AbstractEMFOperation op = new AbstractEMFOperation(domain, ""){

                protected IStatus doExecute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                    org.eclipse.epf.diagram.model.Diagram d = (org.eclipse.epf.diagram.model.Diagram)model.getElement();
                    DiagramEditorInput input = inputProxy.getDiagramEditorInput();
                    d.setSuppression(input.getSuppression());
                    d.setLinkedElement(input.getMethodElement());
                    d.setObject((Object)d.getLinkedElement());
                    return Status.OK_STATUS;
                }
            };
            try {
                op.execute(monitor, null);
                return true;
            }
            catch (ExecutionException e) {
                CommonPlugin.getDefault().getLogger().logError((Throwable)e);
            }
        }
        return false;
    }

    public static void initializeOnActivate(DiagramEditPart editPart) {
        IEditorPart editor;
        if (editPart.getViewer() instanceof IDiagramEditorInputProvider && (editor = ((IDiagramEditorInputProvider)editPart.getViewer()).getEditor()) != null && editor.getEditorInput() instanceof DiagramEditorInputProxy) {
            DiagramEditorInputProxy inputProxy = (DiagramEditorInputProxy)editor.getEditorInput();
            NullProgressMonitor monitor = new NullProgressMonitor();
            try {
                if (DiagramEditorUtil.doInitialize(inputProxy, (IProgressMonitor)monitor)) {
                    DiagramEditorUtil.doRefresh(editPart, (IProgressMonitor)monitor, false);
                    DiagramEditorUtil.refreshVisual(editPart);
                }
            }
            catch (CoreException e) {
                DiagramCorePlugin.getDefault().getLogger().logError((Throwable)e);
            }
        }
    }

    public static void initialize(DiagramEditPart editPart, DiagramEditorInputProxy inputProxy, IProgressMonitor monitor) {
        try {
            if (DiagramEditorUtil.doInitialize(inputProxy, monitor)) {
                DiagramEditorUtil.refresh(editPart, monitor);
                DiagramEditorUtil.refreshLabels(editPart);
            }
        }
        catch (CoreException e) {
            DiagramCorePlugin.getDefault().getLogger().logError((Throwable)e);
        }
    }

    private static void updateEdges(View view) {
        boolean allVisible = false;
        for (View child : view.getChildren()) {
            FontStyle style;
            if (!(child.getElement() instanceof NodeImpl)) continue;
            NodeImpl node = (NodeImpl)child.getElement();
            if (!node.isVisible()) {
                DiagramEditorUtil.setEdgeVisibility(view, node.isVisible());
            } else {
                child.setVisible(node.isVisible());
                DiagramEditorUtil.setEdgeVisibility(child, true);
            }
            if (node instanceof NamedNode && (style = (FontStyle)child.getStyle(NotationPackage.Literals.FONT_STYLE)) == null) {
                style = (FontStyle)child.createStyle(NotationPackage.Literals.FONT_STYLE);
            }
            if (child.isVisible() && child.getElement() instanceof NodeContainer) {
                DiagramEditorUtil.updateEdges(child);
            }
            if (!node.isVisible()) continue;
            allVisible = true;
        }
        if (view.getElement() instanceof NodeContainer && !(view.getElement() instanceof ActivityDetailDiagram) && !(view.getElement() instanceof WorkProductDependencyDiagram)) {
            DiagramEditorUtil.setEdgeVisibility(view, allVisible);
        }
    }

    private static void setEdgeVisibility(View view, boolean visibility) {
        Diagram diagram = view.getDiagram();
        for (Edge edge : diagram.getEdges()) {
            if (edge.getSource() != view && edge.getTarget() != view) continue;
            if (visibility) {
                view.setVisible(true);
            }
            edge.setVisible(visibility);
        }
    }

    private static void updateView(View view) {
        boolean allVisible = false;
        for (View child : view.getChildren()) {
            FontStyle style;
            if (!(child.getElement() instanceof NodeImpl)) continue;
            NodeImpl node = (NodeImpl)child.getElement();
            child.setVisible(node.isVisible());
            if (node instanceof NamedNode && (style = (FontStyle)child.getStyle(NotationPackage.Literals.FONT_STYLE)) == null) {
                style = (FontStyle)child.createStyle(NotationPackage.Literals.FONT_STYLE);
            }
            if (child.isVisible() && child.getElement() instanceof NodeContainer) {
                DiagramEditorUtil.updateView(child);
            }
            if (!node.isVisible()) continue;
            allVisible = true;
        }
        if (view.getElement() instanceof NodeContainer && !(view.getElement() instanceof ActivityDetailDiagram) && !(view.getElement() instanceof WorkProductDependencyDiagram)) {
            view.setVisible(allVisible);
        }
    }

    public static boolean isInherited(EditPart editPart) {
        EditPartViewer viewer = editPart.getViewer();
        if (viewer instanceof IDiagramEditorInputProvider) {
            DiagramEditorInput input = ((IDiagramEditorInputProvider)viewer).getDiagramEditorInput();
            return DiagramEditorUtil.isInherited(input);
        }
        return false;
    }

    private static boolean isInherited(DiagramEditorInput input) {
        return input != null && input.getWrapper() != null && input.getWrapper().isInherited();
    }

    private static Collection getSemanticChildren(DiagramEditPart editPart) {
        Object model;
        DiagramEditorInput input;
        EditPartViewer viewer = editPart.getViewer();
        if (viewer instanceof IDiagramEditorInputProvider && (input = ((IDiagramEditorInputProvider)viewer).getDiagramEditorInput()) != null && input.getWrapper() != null && input.getWrapper().isInherited() && (model = editPart.getModel()) instanceof View) {
            Collection children = null;
            Diagram diagram = editPart.getDiagramView();
            String type = diagram.getType();
            if ("AD".equals(type)) {
                DiagramAdapter da = (DiagramAdapter)BridgeHelper.getNodeAdapter(diagram.getElement());
                if (da != null) {
                    BreakdownElementWrapperItemProvider wrapper = input.getWrapper();
                    if (TngUtil.getBestAdapterFactory((AdapterFactory)wrapper.getAdapterFactory()) != TngAdapterFactory.INSTANCE.getWBS_ComposedAdapterFactory()) {
                        List wrappers = ProcessUtil.getWrappers((BreakdownElementWrapperItemProvider)wrapper, (AdapterFactory[])new AdapterFactory[]{TngAdapterFactory.INSTANCE.getWBS_ComposedAdapterFactory()});
                        wrapper = (BreakdownElementWrapperItemProvider)wrappers.get(0);
                    }
                    ActivityDiagramAdapter adapter = null;
                    try {
                        adapter = new ActivityDiagramAdapter(wrapper);
                        adapter.setFilter(da.getFilter());
                        adapter.setSuppression(Suppression.getSuppression((Process)TngUtil.getOwningProcess((BreakdownElementWrapperItemProvider)wrapper)));
                        children = adapter.getChildren();
                    }
                    finally {
                        if (adapter != null) {
                            adapter.dispose();
                        }
                    }
                }
            } else if ("ADD".equals(type) || "WPDD".equals(type)) {
                DiagramImpl d = "ADD".equals(type) ? (DiagramImpl)ModelFactory.eINSTANCE.createActivityDetailDiagram() : (DiagramImpl)ModelFactory.eINSTANCE.createWorkProductDependencyDiagram();
                DiagramImpl diagramInUse = (DiagramImpl)diagram.getElement();
                Suppression suppression = diagramInUse.getSuppression();
                if (suppression != null) {
                    d.setWrapper(input.getWrapper());
                    d.setFilter(diagramInUse.getFilter());
                    d.setSuppression(diagramInUse.getSuppression());
                    children = d.getChildren();
                }
            }
            return children;
        }
        return null;
    }

    public static void refreshConnections(DiagramEditPart editPart) {
        Diagram diagram = editPart.getDiagramView();
        for (Edge edge : diagram.getEdges()) {
            boolean visible;
            boolean bl = visible = edge.getSource() != null && edge.getSource().isVisible() && edge.getTarget() != null && edge.getTarget().isVisible();
            if (edge.isVisible() == visible) continue;
            edge.setVisible(visible);
        }
    }

    private static void refreshChildren(DiagramEditPart editPart) {
        Collection semanticChildren = DiagramEditorUtil.getSemanticChildren(editPart);
        if (semanticChildren != null) {
            DiagramEditorUtil.refreshChildren((EditPart)editPart, semanticChildren);
            DiagramEditorUtil.refreshConnections(editPart);
        }
    }

    public static void filterChildren(EditPart editPart, Collection children) {
        DiagramEditPart diagramEditPart = DiagramCoreUtil.getDiagramEditPart(editPart);
        Collection semanticChildren = DiagramEditorUtil.getSemanticChildren(diagramEditPart);
        if (semanticChildren == null) {
            children.clear();
        } else {
            Iterator iter = children.iterator();
            while (iter.hasNext()) {
                EObject child = (EObject)iter.next();
                MethodElement e = BridgeHelper.getMethodElement(child);
                if (DiagramEditorUtil.getWrapper(e, semanticChildren) != null) continue;
                iter.remove();
            }
        }
    }

    private static Object getWrapper(MethodElement e, Collection semanticChildren) {
        for (Object c : semanticChildren) {
            if (TngUtil.unwrap(c) != e) continue;
            return c;
        }
        return null;
    }

    private static void refreshChildren(EditPart editPart, Collection semanticChildren) {
        boolean isRoleTaskComposite = false;
        boolean hasTask = false;
        Object model = editPart.getModel();
        if (model instanceof View && ((View)model).getElement() instanceof RoleTaskComposite) {
            isRoleTaskComposite = true;
        }
        for (Object child : editPart.getChildren()) {
            View v;
            MethodElement e;
            if (!(child instanceof EditPart)) continue;
            boolean refreshChildren = true;
            EditPart childEditPart = (EditPart)child;
            Object m = childEditPart.getModel();
            if (m instanceof View && (e = BridgeHelper.getMethodElement(v = (View)m)) != null) {
                boolean visible;
                Object object = DiagramEditorUtil.getWrapper(e, semanticChildren);
                boolean bl = visible = object != null;
                if (v.isVisible() != visible) {
                    v.setVisible(visible);
                }
                if (!visible) {
                    refreshChildren = false;
                } else if (isRoleTaskComposite && !hasTask && e instanceof TaskDescriptor) {
                    hasTask = true;
                }
            }
            if (!refreshChildren) continue;
            DiagramEditorUtil.refreshChildren(childEditPart, semanticChildren);
        }
        if (isRoleTaskComposite && !hasTask) {
            ((View)editPart.getModel()).setVisible(false);
        }
    }

    public static void doRefresh(final DiagramEditPart editPart, IProgressMonitor monitor, final boolean refreshData) {
        final boolean isInherited = DiagramEditorUtil.isInherited((EditPart)editPart);
        final Diagram diagram = (Diagram)editPart.getModel();
        if (diagram.getElement() instanceof org.eclipse.epf.diagram.model.Diagram) {
            TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)diagram);
            AbstractEMFOperation op = new AbstractEMFOperation(domain, ""){

                protected IStatus doExecute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                    if (refreshData) {
                        org.eclipse.epf.diagram.model.Diagram d = (org.eclipse.epf.diagram.model.Diagram)diagram.getElement();
                        d.setObject((Object)d.getLinkedElement());
                    }
                    if (isInherited) {
                        DiagramEditorUtil.refreshChildren(editPart);
                    } else {
                        DiagramEditorUtil.updateEdges((View)diagram);
                        DiagramEditorUtil.updateView((View)diagram);
                    }
                    return Status.OK_STATUS;
                }
            };
            try {
                op.execute(monitor, null);
            }
            catch (ExecutionException e) {
                CommonPlugin.getDefault().getLogger().logError((Throwable)e);
            }
        } else {
            NodeAdapter adapter = BridgeHelper.getNodeAdapter(diagram.getElement());
            if (adapter instanceof DiagramAdapter) {
                if (refreshData) {
                    ((DiagramAdapter)adapter).populateDiagram();
                }
                if (isInherited) {
                    try {
                        new AbstractEMFOperation(TransactionUtil.getEditingDomain((EObject)diagram), ""){

                            protected IStatus doExecute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                                DiagramEditorUtil.refreshChildren(editPart);
                                return Status.OK_STATUS;
                            }
                        }.execute(monitor, null);
                    }
                    catch (ExecutionException e) {
                        DiagramCorePlugin.getDefault().getLogger().logError((Throwable)e);
                    }
                }
            }
        }
    }

    public static void refresh(DiagramEditPart editPart, IProgressMonitor monitor) {
        IDiagramEditorInputProvider p = (IDiagramEditorInputProvider)editPart.getViewer();
        boolean wasDirty = p.getEditor() != null ? p.getEditor().isDirty() : false;
        boolean wasBaseDirty = false;
        IEditorPart baseEditor = null;
        boolean isInherited = DiagramEditorUtil.isInherited((EditPart)editPart);
        if (isInherited) {
            MethodElement element = BridgeHelper.getMethodElement((View)editPart.getDiagramView());
            String type = editPart.getDiagramView().getType();
            if (p.getEditor() != null) {
                IEditorReference[] editorRefs = p.getEditor().getSite().getPage().getEditorReferences();
                int i = 0;
                while (i < editorRefs.length) {
                    IEditorReference ref = editorRefs[i];
                    try {
                        IEditorPart editor;
                        DiagramEditorInput input;
                        if (ref.getEditorInput() instanceof IDiagramFileEditorInputProxy && (input = ((IDiagramFileEditorInputProxy)ref.getEditorInput()).getDiagramEditorInput()).getWrapper() == null && input.getMethodElement() == element && DiagramManager.getDiagramType(type) == input.getDiagramType() && (editor = ref.getEditor(false)) != null) {
                            wasBaseDirty = editor.isDirty();
                            baseEditor = editor;
                            break;
                        }
                    }
                    catch (PartInitException e) {
                        DiagramCorePlugin.getDefault().getLogger().logError((Throwable)e);
                    }
                    ++i;
                }
            }
        }
        DiagramEditorUtil.doRefresh(editPart, monitor, true);
        if (!wasDirty && p.getEditor() != null && p.getEditor().isDirty()) {
            ((SharedResourceDiagramDocumentProvider)((DiagramDocumentEditor)p.getEditor()).getDocumentProvider()).markDocumentAsSaved((IFileEditorInput)p.getEditor().getEditorInput());
        }
        if (baseEditor != null && !wasBaseDirty) {
            ((SharedResourceDiagramDocumentProvider)((DiagramDocumentEditor)baseEditor).getDocumentProvider()).markDocumentAsSaved((IFileEditorInput)baseEditor.getEditorInput());
        }
    }

    public static void refresh(final DiagramEditPart editPart, IProgressMonitor monitor, boolean isinherited) {
        final boolean isInherited = DiagramEditorUtil.isInherited((EditPart)editPart);
        final Diagram diagram = (Diagram)editPart.getModel();
        if (diagram.getElement() instanceof org.eclipse.epf.diagram.model.Diagram) {
            try {
                TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((EObject)diagram);
                TxUtil.runInTransaction((EObject)diagram.getElement(), (Runnable)new Runnable(){

                    public void run() {
                        org.eclipse.epf.diagram.model.Diagram d = (org.eclipse.epf.diagram.model.Diagram)diagram.getElement();
                        d.setObject((Object)d.getLinkedElement());
                    }
                });
                TxUtil.runInTransaction((TransactionalEditingDomain)domain, (Runnable)new Runnable(){

                    public void run() {
                        if (isInherited) {
                            DiagramEditorUtil.refreshChildren(editPart);
                        } else {
                            DiagramEditorUtil.updateEdges((View)diagram);
                            DiagramEditorUtil.updateView((View)diagram);
                        }
                    }
                });
            }
            catch (Exception e) {
                DiagramCorePlugin.getDefault().getLogger().logError((Throwable)e);
            }
        } else {
            NodeAdapter adapter = BridgeHelper.getNodeAdapter(diagram.getElement());
            if (adapter instanceof DiagramAdapter) {
                ((DiagramAdapter)adapter).populateDiagram();
                if (isInherited) {
                    try {
                        new AbstractEMFOperation(TransactionUtil.getEditingDomain((EObject)diagram), ""){

                            protected IStatus doExecute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                                DiagramEditorUtil.refreshChildren(editPart);
                                return Status.OK_STATUS;
                            }
                        }.execute(monitor, null);
                    }
                    catch (ExecutionException e) {
                        DiagramCorePlugin.getDefault().getLogger().logError((Throwable)e);
                    }
                }
            }
        }
    }

    public static void resetEditor(AbstractDiagramEditor editor) {
        if (editor.isEditable()) {
            DiagramEditPart editPart = editor.getDiagramEditPart();
            IEditorInput input = editor.getEditorInput();
            if (input instanceof DiagramEditorInputProxy) {
                DiagramEditorUtil.initialize(editPart, (DiagramEditorInputProxy)input, (IProgressMonitor)new NullProgressMonitor());
            }
        }
    }

    public static boolean isModifiable(Object element) {
        DiagramEditorInput dInput;
        DiagramFileEditorInputProxy input;
        if (element instanceof DiagramFileEditorInputProxy && (input = (DiagramFileEditorInputProxy)element) != null && (dInput = input.getDiagramEditorInput()) != null) {
            MethodElement e = dInput.getMethodElement();
            if (e != null && TngUtil.isLocked((EObject)e)) {
                return false;
            }
            BreakdownElementWrapperItemProvider wrapper = dInput.getWrapper();
            if (wrapper != null && wrapper.isReadOnly()) {
                return false;
            }
        }
        return true;
    }

    public static void refreshConnectionEditParts(DiagramEditPart diagramEditPart) {
        block9: {
            org.eclipse.gef.ConnectionEditPart part;
            GraphicalViewer viewer = (GraphicalViewer)diagramEditPart.getViewer();
            Diagram act = (Diagram)diagramEditPart.getModel();
            EList edges = act.getEdges();
            for (Edge edge : edges) {
                Object model;
                if (!edge.isVisible() || (part = (org.eclipse.gef.ConnectionEditPart)viewer.getEditPartRegistry().get(edge)) == null) continue;
                if (part.getSource() == null) {
                    for (EditPart element : diagramEditPart.getChildren()) {
                        model = element.getModel();
                        if (edge.getSource() != model || !(element instanceof GraphicalEditPart)) continue;
                        if (((GraphicalEditPart)element).getFigure().isVisible()) {
                            part.setSource(element);
                            continue;
                        }
                        part.setSource(null);
                    }
                }
                if (part.getTarget() != null) continue;
                for (EditPart element : diagramEditPart.getChildren()) {
                    model = element.getModel();
                    if (edge.getTarget() != model || !(element instanceof GraphicalEditPart)) continue;
                    if (((GraphicalEditPart)element).getFigure().isVisible()) {
                        part.setTarget(element);
                        continue;
                    }
                    part.setTarget(null);
                }
            }
            try {
                for (Edge edge : edges) {
                    part = (ConnectionEditPart)viewer.getEditPartRegistry().get(edge);
                    if (part == null || part.getSource() != null && part.getTarget() != null || part.getFigure() == null) continue;
                    part.getFigure().setVisible(false);
                    part.getFigure().revalidate();
                    part.deactivate();
                }
            }
            catch (Exception e) {
                if (!DiagramCorePlugin.getDefault().isDebugging()) break block9;
                DiagramCorePlugin.getDefault().getLogger().logError("Error occured while refresh the connection: " + e);
                e.printStackTrace();
            }
        }
    }
}

