/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.diagram.core.providers;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.epf.common.CommonPlugin;
import org.eclipse.epf.common.ui.util.MsgBox;
import org.eclipse.epf.diagram.core.DiagramCorePlugin;
import org.eclipse.epf.diagram.core.part.DiagramEditorInputProxy;
import org.eclipse.epf.diagram.core.part.IDiagramFileEditorInputProxy;
import org.eclipse.epf.diagram.core.part.util.DiagramEditorUtil;
import org.eclipse.epf.diagram.core.providers.AccessibleDiagramModificationListener;
import org.eclipse.epf.diagram.core.resources.IDiagramStorage;
import org.eclipse.epf.diagram.core.services.DiagramManager;
import org.eclipse.epf.diagram.core.services.FileSynchronizer;
import org.eclipse.epf.diagram.model.util.TxUtil;
import org.eclipse.epf.services.ILibraryPersister;
import org.eclipse.epf.services.Services;
import org.eclipse.epf.uma.Activity;
import org.eclipse.gmf.runtime.common.core.util.Log;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.AbstractDocumentProvider;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.DiagramDocument;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.DiagramModificationListener;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.IDiagramDocument;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.IDocument;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.IDocumentListener;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.ide.document.FileDiagramDocumentProvider;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.ide.document.StorageDiagramDocumentProvider;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.ide.document.StorageDocumentProvider;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.ide.document.WorkspaceOperationRunner;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.ide.internal.EditorIDEPlugin;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.ide.internal.l10n.EditorMessages;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.internal.EditorPlugin;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IStorageEditorInput;

public class SharedResourceDiagramDocumentProvider
extends StorageDiagramDocumentProvider {
    private static final FileDiagramDocumentProviderEx fileDiagramDocumentProvider = new FileDiagramDocumentProviderEx();
    private WorkspaceOperationRunner fOperationRunner;
    private DiagramManager fDiagramMgr;
    private boolean locked = false;

    public SharedResourceDiagramDocumentProvider(DiagramManager diagramMgr) {
        this.fDiagramMgr = diagramMgr;
    }

    protected boolean setDocumentContent(IDocument document, IEditorInput editorInput) throws CoreException {
        if (document instanceof IDiagramDocument) {
            ((IDiagramDocument)document).setEditingDomain((TransactionalEditingDomain)this.fDiagramMgr.getEditingDomain());
        }
        return super.setDocumentContent(document, editorInput);
    }

    protected void setDocumentContentFromStorage(IDocument document, IStorage storage) throws CoreException {
        Resource resource;
        IFile resourceFile;
        Diagram diagram = (Diagram)document.getContent();
        if (diagram != null && (resourceFile = WorkspaceSynchronizer.getFile((Resource)(resource = diagram.eResource()))) != null) {
            if (resourceFile.equals((Object)storage)) {
                document.setContent(null);
            } else {
                throw new CoreException((IStatus)new Status(4, EditorIDEPlugin.getPluginId(), 1, EditorMessages.FileDocumentProvider_handleElementContentChanged, null));
            }
        }
        document.setContent((Object)((IDiagramStorage)storage).getDiagram());
    }

    protected void disposeElementInfo(Object element, AbstractDocumentProvider.ElementInfo info) {
        ((DiagramStorageInfo)info).fListener.stopListening();
    }

    protected void doSaveDocument(IProgressMonitor monitor, Object element, IDocument document, boolean overwrite) throws CoreException {
        IStatus status;
        final Diagram diagram = (Diagram)document.getContent();
        Resource resource = diagram.eResource();
        if (!overwrite) {
            DiagramManager.checkSynchronizationState(resource);
        }
        if (!(status = Services.getAccessController().checkModify(new Resource[]{resource}, (Object)MsgBox.getDefaultShell())).isOK()) {
            throw new CoreException(status);
        }
        this.fireElementStateChanging(element);
        if (diagram.getElement() instanceof org.eclipse.epf.diagram.model.Diagram) {
            try {
                TxUtil.runInTransaction((EObject)diagram, (Runnable)new Runnable(){

                    public void run() {
                        diagram.persistChildren();
                        for (Object child : diagram.getChildren()) {
                            ((View)child).persistChildren();
                        }
                    }
                });
            }
            catch (ExecutionException e) {
                DiagramCorePlugin.getDefault().getLogger().logError((Throwable)e);
            }
        }
        ILibraryPersister.FailSafeMethodLibraryPersister persister = Services.getLibraryPersister((String)"xmi").getFailSafePersister();
        try {
            persister.save(resource);
            persister.commit();
        }
        catch (Exception e) {
            CommonPlugin.getDefault().getLogger().logError((Throwable)e);
            persister.rollback();
            this.fireElementStateChangeFailed(element);
            throw new CoreException((IStatus)new Status(4, "org.eclipse.epf.diagram.core", 5, e.getLocalizedMessage(), null));
        }
        try {
            this.fDiagramMgr.removeDiagramBackup(SharedResourceDiagramDocumentProvider.getActivity((IEditorInput)element), diagram.getType());
            if ("ADD".equals(diagram.getType()) || "WPDD".equals(diagram.getType())) {
                org.eclipse.epf.diagram.model.Diagram d = (org.eclipse.epf.diagram.model.Diagram)diagram.getElement();
                d.setNew(false);
            }
        }
        catch (RuntimeException x) {
            this.fireElementStateChangeFailed(element);
            throw x;
        }
        if (monitor != null) {
            monitor.done();
        }
        SharedResourceDiagramDocumentProvider.logResourceErrorsAndWarnings(resource);
    }

    private static void logResourceErrorsAndWarnings(Resource resource) {
        for (Resource.Diagnostic diagnostic : resource.getErrors()) {
            Log.error((Plugin)EditorPlugin.getInstance(), (int)1, (String)diagnostic.getMessage());
        }
        for (Resource.Diagnostic diagnostic : resource.getWarnings()) {
            Log.warning((Plugin)EditorPlugin.getInstance(), (int)7, (String)diagnostic.getMessage());
        }
    }

    public long getModificationStamp(Object element) {
        if (element instanceof IFileEditorInput) {
            IFileEditorInput input = (IFileEditorInput)element;
            return FileSynchronizer.computeModificationStamp((IResource)input.getFile());
        }
        return super.getModificationStamp(element);
    }

    public void setContent(IEditorInput input) {
        AbstractDocumentProvider.ElementInfo info = this.getElementInfo(input);
        if (info == null) {
            return;
        }
        IDocument document = this.createEmptyDocument();
        IStatus status = null;
        try {
            this.setDocumentContent(document, input);
        }
        catch (CoreException x) {
            status = x.getStatus();
        }
        Object newContent = document.getContent();
        this.fireElementContentAboutToBeReplaced(input);
        this.removeUnchangedElementListeners(input, info);
        info.fDocument.removeDocumentListener((IDocumentListener)info);
        info.fDocument.setContent(newContent);
        info.fCanBeSaved = false;
        info.fStatus = status;
        this.addUnchangedElementListeners(input, info);
        this.fireElementContentReplaced(input);
    }

    public void handleElementContentChanged(IEditorInput input) {
        AbstractDocumentProvider.ElementInfo info = this.getElementInfo(input);
        if (info == null) {
            return;
        }
        IDocument document = this.createEmptyDocument();
        IStatus status = null;
        try {
            this.setDocumentContent(document, input);
        }
        catch (CoreException x) {
            status = x.getStatus();
        }
        Object newContent = document.getContent();
        if (!newContent.equals(info.fDocument.getContent())) {
            this.fireElementContentAboutToBeReplaced(input);
            this.removeUnchangedElementListeners(input, info);
            info.fDocument.removeDocumentListener((IDocumentListener)info);
            info.fDocument.setContent(newContent);
            info.fCanBeSaved = false;
            info.fStatus = status;
            this.addUnchangedElementListeners(input, info);
            this.fireElementContentReplaced(input);
        } else {
            this.handleExistingDocumentSaved(input, info, status);
        }
    }

    private void handleExistingDocumentSaved(IEditorInput input, AbstractDocumentProvider.ElementInfo info, IStatus status) {
        this.removeUnchangedElementListeners(input, info);
        info.fCanBeSaved = false;
        info.fStatus = status;
        this.addUnchangedElementListeners(input, info);
        this.fireElementDirtyStateChanged(input, false);
    }

    public void markDocumentAsSaved(IFileEditorInput input) {
        AbstractDocumentProvider.ElementInfo info = this.getElementInfo(input);
        if (info == null) {
            return;
        }
        this.handleExistingDocumentSaved((IEditorInput)input, info, null);
    }

    protected void doSynchronize(Object element, IProgressMonitor monitor) throws CoreException {
        if (element instanceof IEditorInput) {
            this.handleElementContentChanged((IEditorInput)element);
            return;
        }
        super.doSynchronize(element, monitor);
    }

    public boolean isSynchronized(Object element) {
        Diagram diagram;
        AbstractDocumentProvider.ElementInfo info = this.getElementInfo(element);
        if (info.fDocument instanceof IDiagramDocument && (diagram = ((IDiagramDocument)info.fDocument).getDiagram()) != null) {
            Resource resource = diagram.eResource();
            return resource != null && DiagramManager.isSynchronized(resource);
        }
        return super.isSynchronized(element);
    }

    public AbstractDocumentProvider.ElementInfo createNewElementInfo(IDocument document) {
        AccessibleDiagramModificationListener listener = new AccessibleDiagramModificationListener((AbstractDocumentProvider)this, (DiagramDocument)document);
        DiagramStorageInfo info = new DiagramStorageInfo(document, listener);
        listener.startListening();
        return info;
    }

    protected IRunnableContext getOperationRunner(IProgressMonitor monitor) {
        return fileDiagramDocumentProvider.getOperationRunner(monitor);
    }

    protected ISchedulingRule getSaveRule(Object element) {
        return fileDiagramDocumentProvider.getSaveRule(element);
    }

    public void allowEditing(IEditorInput input) {
        Activity act;
        Diagram diagram;
        AbstractDocumentProvider.ElementInfo info = this.getElementInfo(input);
        if (info.fDocument instanceof IDiagramDocument && (diagram = ((IDiagramDocument)info.fDocument).getDiagram()) != null && diagram.eResource() == null && input instanceof IDiagramFileEditorInputProxy && (act = SharedResourceDiagramDocumentProvider.getActivity(input)) != null) {
            this.fDiagramMgr.replaceTemporarily(act, diagram);
        }
    }

    private static Activity getActivity(IEditorInput input) {
        return (Activity)((IDiagramFileEditorInputProxy)input).getDiagramEditorInput().getMethodElement();
    }

    public void reverseToSaved(IEditorInput input) {
        Activity act;
        Diagram diagram;
        AbstractDocumentProvider.ElementInfo info = this.getElementInfo(input);
        if (info.fDocument instanceof IDiagramDocument && (diagram = ((IDiagramDocument)info.fDocument).getDiagram()) != null && diagram.eResource() != null && input instanceof DiagramEditorInputProxy && (act = SharedResourceDiagramDocumentProvider.getActivity(input)) != null) {
            this.fDiagramMgr.reverseToSaved(act, diagram, ((DiagramEditorInputProxy)input).getPreferenceHint());
        }
    }

    public void lock(boolean lock) {
        this.locked = lock;
    }

    protected void updateCache(IStorageEditorInput input) throws CoreException {
        super.updateCache(input);
        StorageDocumentProvider.StorageInfo info = (StorageDocumentProvider.StorageInfo)this.getElementInfo(input);
        if (info != null && this.locked && info.fIsModifiable) {
            info.fIsModifiable = !this.locked;
        }
    }

    public boolean getLockedState() {
        return this.locked;
    }

    public boolean isModifiable(Object element) {
        if (!DiagramEditorUtil.isModifiable(element)) {
            return false;
        }
        return super.isModifiable(element);
    }

    private class DiagramStorageInfo
    extends StorageDocumentProvider.StorageInfo {
        DiagramModificationListener fListener;

        public DiagramStorageInfo(IDocument document, DiagramModificationListener listener) {
            super((StorageDocumentProvider)SharedResourceDiagramDocumentProvider.this, document);
            this.fListener = listener;
        }
    }

    private static class FileDiagramDocumentProviderEx
    extends FileDiagramDocumentProvider {
        private FileDiagramDocumentProviderEx() {
        }

        protected ISchedulingRule getSaveRule(Object element) {
            if (element instanceof IFileEditorInput) {
                IFileEditorInput input = (IFileEditorInput)element;
                return this.computeSaveSchedulingRule((IResource)input.getFile());
            }
            return null;
        }

        private ISchedulingRule computeSaveSchedulingRule(IResource toCreateOrModify) {
            if (toCreateOrModify.exists() && toCreateOrModify.isSynchronized(0)) {
                return this.fResourceRuleFactory.refreshRule(toCreateOrModify);
            }
            IResource parent = toCreateOrModify;
            while ((parent = (toCreateOrModify = parent).getParent()) != null && !parent.exists() && !parent.isSynchronized(0)) {
            }
            return this.fResourceRuleFactory.createRule(toCreateOrModify);
        }

        protected IRunnableContext getOperationRunner(IProgressMonitor monitor) {
            return super.getOperationRunner(monitor);
        }
    }
}

