/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.epf.common.preferences.IPreferenceStoreWrapper;
import org.eclipse.epf.library.edit.ICommandListener;
import org.eclipse.epf.library.edit.IConfigurationApplicator;
import org.eclipse.epf.library.edit.IConfiguratorFactory;
import org.eclipse.epf.library.edit.LibraryEditPlugin;
import org.osgi.framework.Bundle;

public final class Providers {
    private static IConfiguratorFactory configuratorFactory;
    private static IConfigurationApplicator configurationApplicator;
    private static IPreferenceStoreWrapper preferenceStore;
    private static IPreferenceStoreWrapper authoringPluginPreferenceStore;
    private static Map commandTypeToListenersMap;

    static {
        block7: {
            commandTypeToListenersMap = new HashMap();
            try {
                String namespace = LibraryEditPlugin.getDefault().getId();
                String extensionPointName = "commandListeners";
                IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
                IExtensionPoint extensionPoint = extensionRegistry.getExtensionPoint(namespace, extensionPointName);
                if (extensionPoint == null) break block7;
                IExtension[] extensions = extensionPoint.getExtensions();
                int i = 0;
                while (i < extensions.length) {
                    IExtension extension = extensions[i];
                    String pluginId = extension.getNamespaceIdentifier();
                    Bundle bundle = Platform.getBundle((String)pluginId);
                    IConfigurationElement[] configElements = extension.getConfigurationElements();
                    int j = 0;
                    while (j < configElements.length) {
                        IConfigurationElement configElement = configElements[j];
                        try {
                            Object ext;
                            String className = configElement.getAttribute("class");
                            if (className != null && (ext = bundle.loadClass(className).newInstance()) instanceof ICommandListener) {
                                Providers.registerCommandListener((ICommandListener)ext);
                            }
                        }
                        catch (Exception e) {
                            LibraryEditPlugin.INSTANCE.log(e);
                        }
                        ++j;
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                LibraryEditPlugin.getDefault().getLogger().logError((Throwable)e);
            }
        }
    }

    private Providers() {
    }

    public static IConfiguratorFactory getConfiguratorFactory() {
        return configuratorFactory;
    }

    public static void setConfiguratorFactory(IConfiguratorFactory configuratorFactory) {
        Providers.configuratorFactory = configuratorFactory;
    }

    public static IConfigurationApplicator getConfigurationApplicator() {
        return configurationApplicator;
    }

    public static void setConfigurationApplicator(IConfigurationApplicator configurationApplicator) {
        Providers.configurationApplicator = configurationApplicator;
    }

    public static IPreferenceStoreWrapper getPreferenceStore() {
        return preferenceStore;
    }

    public static void setPreferenceStore(IPreferenceStoreWrapper preferenceStore) {
        Providers.preferenceStore = preferenceStore;
    }

    public static IPreferenceStoreWrapper getAuthoringPluginPreferenceStore() {
        return authoringPluginPreferenceStore;
    }

    public static void setAuthoringPluginPreferenceStore(IPreferenceStoreWrapper store) {
        authoringPluginPreferenceStore = store;
    }

    public static void registerCommandListener(ICommandListener listener) {
        ArrayList<ICommandListener> listeners = (ArrayList<ICommandListener>)commandTypeToListenersMap.get(listener.getCommandType());
        if (listeners == null) {
            listeners = new ArrayList<ICommandListener>();
            commandTypeToListenersMap.put(listener.getCommandType(), listeners);
        } else if (listeners.contains(listener)) {
            return;
        }
        listeners.add(listener);
    }

    public static void removeCommandListener(ICommandListener listener) {
        List listeners = (List)commandTypeToListenersMap.get(listener.getCommandType());
        if (listeners != null) {
            listeners.remove(listener);
            if (listeners.isEmpty()) {
                commandTypeToListenersMap.remove(listener.getCommandType());
            }
        }
    }

    public static List getCommandListeners(Class commandType) {
        return (List)commandTypeToListenersMap.get(commandType);
    }
}

