/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.command;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.epf.library.edit.TngAdapterFactory;
import org.eclipse.epf.library.edit.command.FullyRevertibleCommandStack;
import org.eclipse.epf.library.edit.command.IActionManager;
import org.eclipse.epf.library.edit.command.IResourceAwareCommand;

public class ActionManager
implements IActionManager {
    protected static final Map RESOURCE_TO_MODIFIERS_MAP = new HashMap();
    private EditingDomain editingDomain;
    private FullyRevertibleCommandStack commandStack = this.createCommandStack();

    public ActionManager() {
        this.editingDomain = new AdapterFactoryEditingDomain((AdapterFactory)TngAdapterFactory.INSTANCE.getNavigatorView_ComposedAdapterFactory(), (CommandStack)this.commandStack);
    }

    protected FullyRevertibleCommandStack createCommandStack() {
        return new FullyRevertibleCommandStack(this);
    }

    protected void registerAsModifierOf(EObject object) {
        Resource resource = object.eResource();
        if (resource == null) {
            return;
        }
        this.registerAsModifierOf(resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void registerAsModifierOf(Resource resource) {
        Map map = RESOURCE_TO_MODIFIERS_MAP;
        synchronized (map) {
            HashSet<ActionManager> mods = (HashSet<ActionManager>)RESOURCE_TO_MODIFIERS_MAP.get(resource);
            if (mods == null) {
                mods = new HashSet<ActionManager>();
                RESOURCE_TO_MODIFIERS_MAP.put(resource, mods);
            }
            mods.add(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unregisterAsModifier() {
        Map map = RESOURCE_TO_MODIFIERS_MAP;
        synchronized (map) {
            for (Resource resource : this.getModifiedResources()) {
                Set mods = (Set)RESOURCE_TO_MODIFIERS_MAP.get(resource);
                if (mods == null) continue;
                mods.remove(this);
                if (!mods.isEmpty()) continue;
                this.save(resource);
                RESOURCE_TO_MODIFIERS_MAP.remove(resource);
            }
        }
    }

    public boolean doAction(int actionType, EObject object, EStructuralFeature feature, Object value, int index) {
        RemoveCommand cmd = null;
        Object oldValue = null;
        switch (actionType) {
            case 3: {
                if (index >= 0) {
                    cmd = new AddCommand(this.editingDomain, object, feature, value, index);
                    break;
                }
                cmd = new AddCommand(this.editingDomain, object, feature, value);
                break;
            }
            case 5: {
                if (index >= 0) {
                    cmd = new AddCommand(this.editingDomain, object, feature, (Collection)value, index);
                    break;
                }
                cmd = new AddCommand(this.editingDomain, object, feature, (Collection)value);
                break;
            }
            case 4: {
                cmd = new RemoveCommand(this.editingDomain, object, feature, value);
                break;
            }
            case 6: {
                cmd = new RemoveCommand(this.editingDomain, object, feature, (Collection)value);
                break;
            }
            case 1: {
                oldValue = object.eGet(feature);
                if ((oldValue == null || oldValue.equals(value)) && (oldValue != null || value == null)) break;
                cmd = new SetCommand(this.editingDomain, object, feature, value);
            }
        }
        if (cmd != null) {
            return this.commandStack.doExecute((Command)cmd);
        }
        return false;
    }

    public void undo() {
        this.commandStack.undo();
    }

    public void redo() {
        this.commandStack.redo();
    }

    public boolean undoAll() {
        boolean b = this.commandStack.undoAll();
        this.unregisterAsModifier();
        return b;
    }

    public void saveIsDone() {
        this.commandStack.saveIsDone();
        this.unregisterAsModifier();
    }

    public boolean isSaveNeeded() {
        boolean ret = this.commandStack.isSaveNeeded();
        if (!ret) {
            return false;
        }
        if (this.getModifiedResources().isEmpty()) {
            return false;
        }
        return ret;
    }

    public void dispose() {
        this.commandStack.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getModifiedResources() {
        Map map = RESOURCE_TO_MODIFIERS_MAP;
        synchronized (map) {
            HashSet modifiedResources = new HashSet();
            for (Map.Entry entry : RESOURCE_TO_MODIFIERS_MAP.entrySet()) {
                Set mods = (Set)entry.getValue();
                if (!mods.contains(this)) continue;
                modifiedResources.add(entry.getKey());
            }
            return modifiedResources;
        }
    }

    protected void save(Resource resource) {
    }

    public CommandStack getCommandStack() {
        return this.commandStack;
    }

    public boolean execute(IResourceAwareCommand cmd) {
        if (cmd != null) {
            return this.commandStack.doExecute(cmd);
        }
        return false;
    }
}

