/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.command;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandWrapper;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EContentsEList;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.epf.common.utils.StrUtil;
import org.eclipse.epf.library.edit.ICommandListener;
import org.eclipse.epf.library.edit.IReferencer;
import org.eclipse.epf.library.edit.IStatefulItemProvider;
import org.eclipse.epf.library.edit.LibraryEditPlugin;
import org.eclipse.epf.library.edit.LibraryEditResources;
import org.eclipse.epf.library.edit.Providers;
import org.eclipse.epf.library.edit.command.BatchCommand;
import org.eclipse.epf.library.edit.command.IDeleteMethodElementCommandListener;
import org.eclipse.epf.library.edit.command.INestedCommandProvider;
import org.eclipse.epf.library.edit.command.IResourceAwareCommand;
import org.eclipse.epf.library.edit.command.IUserInteractionHandler;
import org.eclipse.epf.library.edit.command.Reference;
import org.eclipse.epf.library.edit.ui.UserInteractionHelper;
import org.eclipse.epf.library.edit.util.ExtensionManager;
import org.eclipse.epf.library.edit.util.IRunnableWithProgress;
import org.eclipse.epf.library.edit.util.Messenger;
import org.eclipse.epf.library.edit.util.ProcessUtil;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.services.ILibraryPersister;
import org.eclipse.epf.services.Services;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.CustomCategory;
import org.eclipse.epf.uma.Descriptor;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.epf.uma.VariabilityType;
import org.eclipse.epf.uma.ecore.impl.MultiResourceEObject;
import org.eclipse.epf.uma.util.AssociationHelper;
import org.eclipse.epf.uma.util.UmaUtil;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeleteMethodElementCommand
extends CommandWrapper {
    protected Collection elements;
    private boolean refRemoved;
    public boolean executed = false;
    private Collection commandListeners;
    private ILibraryPersister.FailSafeMethodLibraryPersister persister;
    protected ArrayList elementsToDeleteContent;
    protected Set<Resource> modifiedResources;
    protected Map<EObject, Map<EObject, Collection<EStructuralFeature>>> elementToRemovedRefsMap;
    private BatchCommand batchCommand = new BatchCommand(true);
    protected ArrayList removedReferences;
    public boolean failed;
    private boolean confirmRemoveReferences;
    private ArrayList<Command> nestedCommands;
    private HashSet<Descriptor> descriptors;

    public DeleteMethodElementCommand(Command command, Collection elements) {
        this(command, elements, true);
    }

    public DeleteMethodElementCommand(Command command, Collection elements, boolean confirmRemoveRefs) {
        super(command);
        this.elements = elements == null ? null : new ArrayList(elements);
        this.commandListeners = new ArrayList();
        this.confirmRemoveReferences = confirmRemoveRefs;
    }

    public void dispose() {
        this.batchCommand.dispose();
        if (this.commandListeners != null) {
            this.commandListeners.clear();
        }
        if (this.elements != null) {
            this.elements.clear();
        }
        if (this.elementsToDeleteContent != null) {
            this.elementsToDeleteContent.clear();
        }
        if (this.elementToRemovedRefsMap != null) {
            this.elementToRemovedRefsMap.clear();
        }
        if (this.modifiedResources != null) {
            this.modifiedResources.clear();
        }
        if (this.removedReferences != null) {
            this.removedReferences.clear();
        }
        if (this.nestedCommands != null && !this.nestedCommands.isEmpty()) {
            for (Command command : this.nestedCommands) {
                command.dispose();
            }
        }
        if (this.descriptors != null) {
            this.descriptors.clear();
        }
        super.dispose();
    }

    protected void superExecute() {
        super.execute();
    }

    private void notifyPreExecute() {
        List commandListeners = Providers.getCommandListeners(DeleteMethodElementCommand.class);
        if (commandListeners != null && !commandListeners.isEmpty()) {
            for (ICommandListener cmdListener : commandListeners) {
                try {
                    cmdListener.preExecute((Command)this);
                }
                catch (Exception e) {
                    LibraryEditPlugin.getDefault().getLogger().logError((Throwable)e);
                }
            }
        }
    }

    private void notifyPreUndo() {
        List commandListeners = Providers.getCommandListeners(DeleteMethodElementCommand.class);
        if (commandListeners != null && !commandListeners.isEmpty()) {
            for (ICommandListener cmdListener : commandListeners) {
                try {
                    cmdListener.preUndo((Command)this);
                }
                catch (Exception e) {
                    LibraryEditPlugin.getDefault().getLogger().logError((Throwable)e);
                }
            }
        }
    }

    protected void prepareElements() {
        ArrayList newElements = new ArrayList();
        for (Object element : this.elements) {
            Collection collection;
            RemoveCommand cmd;
            if (!(element instanceof CustomCategory) || !((cmd = this.getRemoveCommand(element)).getFeature() instanceof EReference) || !((EReference)cmd.getFeature()).isContainment() || !cmd.getOwnerList().contains(element) || (collection = TngUtil.getExclusiveSubCustomCategories((CustomCategory)element)).isEmpty()) continue;
            for (Object subCat : collection) {
                if (this.elements.contains(subCat) || newElements.contains(subCat)) continue;
                Collection col = cmd.getCollection();
                col.add(subCat);
                newElements.add(subCat);
            }
        }
        this.elements.addAll(newElements);
    }

    protected RemoveCommand getRemoveCommand(Object e) {
        if (this.command instanceof RemoveCommand) {
            if (((RemoveCommand)this.command).getCollection().contains(e)) {
                return (RemoveCommand)this.command;
            }
        } else if (this.command instanceof CompoundCommand) {
            for (Object cmd : ((CompoundCommand)this.command).getCommandList()) {
                RemoveCommand removeCommand;
                if (!(cmd instanceof RemoveCommand) || !(removeCommand = (RemoveCommand)cmd).getCollection().contains(e)) continue;
                return removeCommand;
            }
        }
        return null;
    }

    public void execute() {
        this.prepareElements();
        this.notifyPreExecute();
        this.elementsToDeleteContent = new ArrayList();
        this.descriptors = new HashSet();
        Iterator iter = this.elements.iterator();
        while (iter.hasNext()) {
            Object element = TngUtil.unwrap(iter.next());
            if (!(element instanceof MethodElement)) continue;
            this.collectObjectsToDeleteContent(this.elementsToDeleteContent, (MethodElement)element);
        }
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                DeleteMethodElementCommand.this.prepareRemovingReferences();
            }
        };
        UserInteractionHelper.runWithProgress(runnable, LibraryEditResources.processingReferencesTask_name);
        if (!this.confirmRemovingReferences()) {
            return;
        }
        this.modifiedResources = new HashSet<Resource>();
        HashSet unmodifiedResources = new HashSet();
        this.collectOwnerResources(this.modifiedResources, unmodifiedResources);
        this.superExecute();
        this.executeNestedCommands();
        this.collectNestedCommandResources(this.modifiedResources);
        DeleteMethodElementCommand.collectResources(this.modifiedResources, super.getAffectedObjects());
        this.modifiedResources.removeAll(unmodifiedResources);
        final Exception[] exceptions = new Exception[1];
        UserInteractionHelper.getUIHelper().runWithBusyIndicator(new Runnable(){

            public void run() {
                try {
                    DeleteMethodElementCommand.this.removeReferences();
                }
                catch (Exception e) {
                    exceptions[0] = e;
                }
            }
        });
        if (exceptions[0] != null) {
            Messenger.INSTANCE.showError(LibraryEditResources.deleteDialog_title, LibraryEditResources.deleteElementError_msg, LibraryEditResources.deleteReferencesError_reason, exceptions[0]);
            this.undo();
            return;
        }
        this.modifiedResources.addAll(this.getReferencingResources());
        Iterator iter2 = this.elementsToDeleteContent.iterator();
        while (iter2.hasNext()) {
            EObject element = (EObject)iter2.next();
            if (element.eContainer() == null) continue;
            iter2.remove();
        }
        this.elementsToDeleteContent.addAll(this.elements);
        HashSet deletedResources = new HashSet();
        for (Object obj : this.elementsToDeleteContent) {
            if (!(obj instanceof EObject)) {
                obj = TngUtil.unwrap(obj);
            }
            if (!(obj instanceof EObject)) continue;
            EObject e = (EObject)obj;
            UmaUtil.getResources((EObject)e, deletedResources);
        }
        this.modifiedResources.removeAll(deletedResources);
        Iterator<Object> iter3 = this.modifiedResources.iterator();
        while (iter3.hasNext()) {
            Resource resource = (Resource)iter3.next();
            for (Resource deletedResource : deletedResources) {
                if (!this.getPersister().isContainedBy(resource, deletedResource)) continue;
                iter3.remove();
            }
        }
        IStatus status = UserInteractionHelper.checkModify(this.modifiedResources, LibraryEditPlugin.getDefault().getContext());
        if (!status.isOK()) {
            Messenger.INSTANCE.showError(LibraryEditResources.deleteDialog_title, LibraryEditResources.deleteElementError_msg, status);
            this.undo();
            return;
        }
        runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                monitor.beginTask("", 3);
                DeleteMethodElementCommand.this.getPersister();
                try {
                    monitor.subTask(LibraryEditResources.deletingElementsTask_name);
                    monitor.worked(1);
                    DeleteMethodElementCommand.this.deleteContent();
                    monitor.subTask(LibraryEditResources.savingResources_msg);
                    monitor.worked(1);
                    for (Resource resource : DeleteMethodElementCommand.this.modifiedResources) {
                        if (!resource.isLoaded()) continue;
                        DeleteMethodElementCommand.this.persister.save(resource);
                    }
                    DeleteMethodElementCommand.this.persister.commit();
                    DeleteMethodElementCommand.this.executed = true;
                    DeleteMethodElementCommand.this.removeAdapters();
                }
                catch (Exception e) {
                    LibraryEditPlugin.INSTANCE.log(e);
                    try {
                        DeleteMethodElementCommand.this.persister.rollback();
                    }
                    catch (Exception exception) {
                        DeleteMethodElementCommand.this.failed = true;
                    }
                    if (e instanceof RuntimeException) {
                        throw (RuntimeException)e;
                    }
                    throw new WrappedException(e);
                }
            }
        };
        UserInteractionHelper.runWithProgress(runnable, LibraryEditResources.deletingElementsTask_name);
        if (this.executed) {
            try {
                List warnings = this.persister.getWarnings();
                if (!warnings.isEmpty()) {
                    String title = LibraryEditResources.deleteDialog_title;
                    String msg = LibraryEditResources.DeleteMethodElementCommand_warningMsg;
                    StringBuffer reason = new StringBuffer();
                    for (Exception e : warnings) {
                        String str = e.getMessage();
                        if (StrUtil.isBlank((String)str)) continue;
                        reason.append(str).append('\n');
                    }
                    Messenger.INSTANCE.showWarning(title, msg, reason.toString());
                }
            }
            catch (Exception e) {
                LibraryEditPlugin.getDefault().getLogger().logError((Throwable)e);
            }
            this.notifyExecuted();
        } else if (this.failed) {
            this.notifyFailure();
        } else {
            this.undo();
        }
    }

    private boolean confirmRemovingReferences() {
        if (!this.elementToRemovedRefsMap.isEmpty()) {
            HashSet<EObject> referencers = new HashSet<EObject>();
            for (Map<EObject, Collection<EStructuralFeature>> referencerToFeaturesMap : this.elementToRemovedRefsMap.values()) {
                for (Map.Entry<EObject, Collection<EStructuralFeature>> entry : referencerToFeaturesMap.entrySet()) {
                    Collection<EStructuralFeature> features = entry.getValue();
                    boolean canCollect = false;
                    boolean hasDescriptor = false;
                    for (EStructuralFeature f : features) {
                        EReference ref;
                        if (!canCollect && f instanceof EReference && ((ref = (EReference)f).isContainment() || ref.getEOpposite() == null)) {
                            canCollect = true;
                        }
                        if (!(hasDescriptor || f != UmaPackage.eINSTANCE.getTaskDescriptor_Task() && f != UmaPackage.eINSTANCE.getRoleDescriptor_Role() && f != UmaPackage.eINSTANCE.getWorkProductDescriptor_WorkProduct())) {
                            hasDescriptor = true;
                        }
                        if (canCollect && hasDescriptor) break;
                    }
                    if (canCollect) {
                        referencers.add(entry.getKey());
                    }
                    if (!hasDescriptor || !(entry.getKey() instanceof Descriptor)) continue;
                    this.descriptors.add((Descriptor)entry.getKey());
                }
            }
            if (this.confirmRemoveReferences) {
                IUserInteractionHandler iUserInteractionHandler;
                Status status;
                String msg;
                MultiStatus multiStatus = new MultiStatus(LibraryEditPlugin.INSTANCE.getSymbolicName(), 0, "", null);
                if (!this.descriptors.isEmpty()) {
                    for (EObject eObject : this.descriptors) {
                        msg = NLS.bind((String)LibraryEditResources.elementType_text, (Object)TngUtil.getTypeText(eObject), (Object)TngUtil.getLabelWithPath(eObject));
                        status = new Status(1, LibraryEditPlugin.INSTANCE.getSymbolicName(), 0, msg, null);
                        multiStatus.add((IStatus)status);
                    }
                    IUserInteractionHandler iUserInteractionHandler2 = ExtensionManager.getDefaultUserInteractionHandler();
                    if (iUserInteractionHandler2 != null) {
                        switch (iUserInteractionHandler2.selectOne(new int[]{4, 5, 1}, LibraryEditResources.confirmDescriptorsDeletion_title, LibraryEditResources.confirmDescriptorsDeletion_msg, (IStatus)multiStatus)) {
                            case 1: {
                                return false;
                            }
                            case 5: {
                                this.descriptors.clear();
                            }
                        }
                    }
                }
                if (!this.descriptors.isEmpty()) {
                    referencers.removeAll(this.descriptors);
                }
                multiStatus = new MultiStatus(LibraryEditPlugin.INSTANCE.getSymbolicName(), 0, "", null);
                for (EObject eObject : referencers) {
                    if (eObject instanceof MethodElement && TngUtil.isPredefined((MethodElement)eObject)) continue;
                    msg = NLS.bind((String)LibraryEditResources.elementType_text, (Object)TngUtil.getTypeText(eObject), (Object)TngUtil.getLabelWithPath(eObject));
                    status = new Status(1, LibraryEditPlugin.INSTANCE.getSymbolicName(), 0, msg, null);
                    multiStatus.add((IStatus)status);
                }
                if (multiStatus.getChildren().length > 0 && (iUserInteractionHandler = ExtensionManager.getDefaultUserInteractionHandler()) != null) {
                    int[] nArray = new int[2];
                    nArray[1] = 1;
                    if (iUserInteractionHandler.selectOne(nArray, LibraryEditResources.deleteReferencesDialog_title, LibraryEditResources.deleteReferencesDialog_text, (IStatus)multiStatus) == 1) {
                        return false;
                    }
                }
            }
            for (EObject e : referencers) {
                IStatus iStatus = UserInteractionHelper.checkModify(e, LibraryEditPlugin.getDefault().getContext());
                if (iStatus.isOK()) continue;
                Messenger.INSTANCE.showError(LibraryEditResources.deleteDialog_title, LibraryEditResources.deleteElementError_msg, iStatus);
                return false;
            }
        }
        return true;
    }

    private static void removeAdapters(EObject element) {
        for (Object adapter : new ArrayList(element.eAdapters())) {
            AdapterFactory adapterFactory;
            if (!(adapter instanceof IStatefulItemProvider)) continue;
            ((IStatefulItemProvider)adapter).dispose();
            if (!(adapter instanceof ItemProviderAdapter) || !((adapterFactory = ((ItemProviderAdapter)adapter).getAdapterFactory()) instanceof IReferencer)) continue;
            ((IReferencer)adapterFactory).remove(adapter);
        }
        element.eAdapters().clear();
    }

    protected void removeAdapters() {
        Iterator iter = this.elements.iterator();
        while (iter.hasNext()) {
            EObject element;
            Object obj = TngUtil.unwrap(iter.next());
            if (!(obj instanceof EObject) || (element = (EObject)obj).eContainer() != null) continue;
            TreeIterator iterator = element.eAllContents();
            while (iterator.hasNext()) {
                EObject e = (EObject)iterator.next();
                DeleteMethodElementCommand.removeAdapters(e);
            }
            DeleteMethodElementCommand.removeAdapters(element);
        }
    }

    private void notifyFailure() {
        EventObject eventObject = new EventObject((Object)this);
        for (CommandListener listener : this.commandListeners) {
            listener.notifyFailure(eventObject);
        }
    }

    protected ILibraryPersister.FailSafeMethodLibraryPersister getPersister() {
        if (this.persister == null) {
            this.persister = Services.getDefaultLibraryPersister().getFailSafePersister();
        }
        return this.persister;
    }

    private void notifyExecuted() {
        EventObject eventObject = new EventObject((Object)this);
        for (CommandListener listener : this.commandListeners) {
            listener.notifyExecuted(eventObject);
        }
        List commandListeners = Providers.getCommandListeners(DeleteMethodElementCommand.class);
        if (commandListeners != null && !commandListeners.isEmpty()) {
            for (ICommandListener cmdListener : commandListeners) {
                try {
                    cmdListener.notifyExecuted((Command)this);
                }
                catch (Exception e) {
                    LibraryEditPlugin.getDefault().getLogger().logError((Throwable)e);
                }
            }
        }
    }

    private Collection getReferencingResources() {
        HashSet<EObject> referrers = new HashSet<EObject>();
        for (Reference ref : this.removedReferences) {
            referrers.add(ref.owner);
        }
        HashSet<Resource> resources = new HashSet<Resource>();
        for (MethodElement methodElement : referrers) {
            if (methodElement.eResource() == null) continue;
            resources.add(methodElement.eResource());
        }
        return resources;
    }

    private void collectOwnerResources(Set resources, Set unmodifiedResources) {
        ILibraryPersister persister = Services.getDefaultLibraryPersister();
        Iterator iter = this.elements.iterator();
        while (iter.hasNext()) {
            EObject container;
            Resource resource;
            Object element = TngUtil.unwrap(iter.next());
            if (!(element instanceof MethodElement) || (resource = (container = ((MethodElement)element).eContainer()).eResource()) == null) continue;
            if (persister.hasOwnResourceWithoutReferrer(element)) {
                unmodifiedResources.add(resource);
                continue;
            }
            resources.add(resource);
        }
    }

    private static void collectResources(Set resources, Collection objects) {
        Iterator iter = objects.iterator();
        while (iter.hasNext()) {
            MethodElement eObj;
            Object element = TngUtil.unwrap(iter.next());
            if (!(element instanceof EObject) || (eObj = (MethodElement)element).eResource() == null) continue;
            resources.add(eObj.eResource());
        }
    }

    public void redo() {
        super.redo();
        this.removeReferences();
    }

    protected void deleteContent() throws Exception {
        ArrayList<MethodElement> toDeleteList = new ArrayList<MethodElement>();
        Iterator iter = this.elementsToDeleteContent.iterator();
        while (iter.hasNext()) {
            MethodElement e;
            Object element = TngUtil.unwrap(iter.next());
            if (!(element instanceof MethodElement) || (e = (MethodElement)element).eContainer() != null) continue;
            toDeleteList.add(e);
        }
        this.persister.delete(toDeleteList);
    }

    public Collection getElementsToRemoveReferences() {
        ArrayList<Object> list = new ArrayList<Object>();
        Iterator iter = this.elements.iterator();
        while (iter.hasNext()) {
            Object element = TngUtil.unwrap(iter.next());
            if (!(element instanceof EObject) || !this.willRemoveElementFromContainer((EObject)element)) continue;
            list.add(element);
        }
        return list;
    }

    protected boolean canRemoveReferences(MethodElement e) {
        Iterator iter = this.elements.iterator();
        while (iter.hasNext()) {
            Object obj = TngUtil.unwrap(iter.next());
            if (e != obj) continue;
            return e.eContainer() == null;
        }
        return true;
    }

    public List loadOppositeFeatures() {
        HashSet oppositeFeatures = new HashSet();
        HashSet<String> deletedGUIDs = new HashSet<String>();
        ArrayList elements = new ArrayList();
        for (Object obj : this.getElementsToRemoveReferences()) {
            if (!(obj instanceof MethodElement)) continue;
            MethodElement e = (MethodElement)obj;
            TreeIterator iterator = e.eAllContents();
            while (iterator.hasNext()) {
                Object element = iterator.next();
                if (!(element instanceof MethodElement)) continue;
                elements.add(element);
                Map oppositeFeatureMap = ((MultiResourceEObject)element).getOppositeFeatureMap();
                if (oppositeFeatureMap == null || oppositeFeatureMap.isEmpty()) continue;
                oppositeFeatures.addAll(oppositeFeatureMap.keySet());
                deletedGUIDs.add(((MethodElement)element).getGuid());
            }
            elements.add(e);
            Map oppositeFeatureMap = ((MultiResourceEObject)e).getOppositeFeatureMap();
            if (oppositeFeatureMap == null || oppositeFeatureMap.isEmpty()) continue;
            oppositeFeatures.addAll(oppositeFeatureMap.keySet());
            deletedGUIDs.add(e.getGuid());
        }
        this.loadOppositeFeatures(new ArrayList(oppositeFeatures), deletedGUIDs);
        return elements;
    }

    private boolean isContainedByDeletedElement(EObject e) {
        Iterator iter = this.elements.iterator();
        while (iter.hasNext()) {
            Object deleted = TngUtil.unwrap(iter.next());
            if (!(deleted instanceof EObject) || !UmaUtil.isContainedBy((EObject)e, (Object)deleted)) continue;
            return true;
        }
        return false;
    }

    protected boolean collectObjectsToRemove(Collection objectsToRemove, EObject elementToDelete, EObject referencer, Collection references) {
        boolean ret = false;
        List commandListeners = Providers.getCommandListeners(DeleteMethodElementCommand.class);
        if (commandListeners != null && !commandListeners.isEmpty()) {
            for (Object cmdListener : commandListeners) {
                if (!(cmdListener instanceof IDeleteMethodElementCommandListener)) continue;
                try {
                    boolean b = ((IDeleteMethodElementCommandListener)cmdListener).collectObjectsToRemove(objectsToRemove, elementToDelete, referencer, references);
                    if (!b) continue;
                    ret = true;
                }
                catch (Exception e) {
                    LibraryEditPlugin.getDefault().getLogger().logError((Throwable)e);
                }
            }
        }
        return ret;
    }

    protected boolean willRemoveElementFromContainer(EObject element) {
        if (DeleteMethodElementCommand.willRemoveElementFromContainer(this.command, element)) {
            return true;
        }
        if (this.command instanceof CompoundCommand) {
            for (Command cmd : ((CompoundCommand)this.command).getCommandList()) {
                if (!DeleteMethodElementCommand.willRemoveElementFromContainer(cmd, element)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean willRemoveElementFromContainer(Command cmd, EObject element) {
        if (cmd instanceof RemoveCommand) {
            RemoveCommand removeCommand = (RemoveCommand)cmd;
            return removeCommand.getCollection().contains(element) && removeCommand.getOwner() == element.eContainer();
        }
        return false;
    }

    protected void prepareRemovingReferences() {
        List elements = this.loadOppositeFeatures();
        this.elementToRemovedRefsMap = new HashMap<EObject, Map<EObject, Collection<EStructuralFeature>>>();
        HashSet objectsToRemove = new HashSet();
        for (Object element : elements) {
            Map refMap = AssociationHelper.getReferenceMap((MethodElement)element);
            if (refMap.isEmpty()) continue;
            Iterator iterator = refMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Collection references;
                Map.Entry entry = iterator.next();
                EObject referencer = (EObject)entry.getKey();
                boolean b = this.collectObjectsToRemove(objectsToRemove, (EObject)element, referencer, references = (Collection)entry.getValue());
                if (!b && !elements.contains(referencer) && !this.isContainedByDeletedElement(referencer)) continue;
                iterator.remove();
            }
            if (refMap.isEmpty()) continue;
            this.elementToRemovedRefsMap.put((EObject)element, refMap);
        }
        for (EObject obj : objectsToRemove) {
            Map<EObject, Collection<EStructuralFeature>> map = this.elementToRemovedRefsMap.get(obj);
            if (map == null) {
                map = new HashMap<EObject, Collection<EStructuralFeature>>();
                this.elementToRemovedRefsMap.put(obj, map);
            }
            EObject container = obj.eContainer();
            EReference containmentFeature = obj.eContainmentFeature();
            Collection<EStructuralFeature> refs = map.get(container);
            if (refs == null) {
                refs = new ArrayList<EStructuralFeature>();
                refs.add((EStructuralFeature)containmentFeature);
                map.put(container, refs);
                continue;
            }
            if (refs.contains(containmentFeature)) continue;
            refs.add((EStructuralFeature)containmentFeature);
        }
        for (Object element : elements) {
            if (!(element instanceof EObject)) continue;
            EObject eObject = (EObject)element;
            HashMap<EObject, ArrayList<EReference>> objToRefsMap = new HashMap<EObject, ArrayList<EReference>>();
            EContentsEList.FeatureIterator featureIterator = (EContentsEList.FeatureIterator)eObject.eCrossReferences().iterator();
            while (featureIterator.hasNext()) {
                EObject eObj = (EObject)featureIterator.next();
                EReference eReference = (EReference)featureIterator.feature();
                if (eReference.getEOpposite() == null) continue;
                ArrayList<EReference> refs = (ArrayList<EReference>)objToRefsMap.get(eObj);
                if (refs == null) {
                    refs = new ArrayList<EReference>();
                    objToRefsMap.put(eObj, refs);
                }
                refs.add(eReference.getEOpposite());
            }
            Map<EObject, Collection<EStructuralFeature>> map = this.elementToRemovedRefsMap.get(eObject);
            if (map == null) {
                this.elementToRemovedRefsMap.put(eObject, objToRefsMap);
                continue;
            }
            for (Map.Entry entry : objToRefsMap.entrySet()) {
                Object obj = entry.getKey();
                Collection refs = (Collection)entry.getValue();
                Collection<EStructuralFeature> existingRefs = map.get(obj);
                if (existingRefs != null) {
                    for (Object ref : refs) {
                        if (existingRefs.contains(ref)) continue;
                        existingRefs.add((EStructuralFeature)ref);
                    }
                    continue;
                }
                map.put((EObject)obj, refs);
            }
        }
    }

    protected void collectObjectsToDeleteContent(Collection collectedObjects, MethodElement element) {
        List commandListeners = Providers.getCommandListeners(DeleteMethodElementCommand.class);
        if (commandListeners != null && !commandListeners.isEmpty()) {
            for (Object cmdListener : commandListeners) {
                if (!(cmdListener instanceof IDeleteMethodElementCommandListener)) continue;
                try {
                    ((IDeleteMethodElementCommandListener)cmdListener).collectObjectsToDeleteContent(collectedObjects, element);
                }
                catch (Exception e) {
                    LibraryEditPlugin.getDefault().getLogger().logError((Throwable)e);
                }
            }
        }
    }

    protected void removeReferences() {
        if (this.refRemoved) {
            return;
        }
        if (this.removedReferences == null) {
            this.removedReferences = new ArrayList();
        } else {
            this.removedReferences.clear();
        }
        for (Map.Entry<EObject, Map<EObject, Collection<EStructuralFeature>>> entry : this.elementToRemovedRefsMap.entrySet()) {
            MethodElement referenced = (MethodElement)entry.getKey();
            if (!this.canRemoveReferences(referenced)) continue;
            Map<EObject, Collection<EStructuralFeature>> removedRefMap = entry.getValue();
            for (Map.Entry<EObject, Collection<EStructuralFeature>> ent : removedRefMap.entrySet()) {
                EObject referencer = ent.getKey();
                Collection<EStructuralFeature> features = ent.getValue();
                block2: for (EStructuralFeature feature : features) {
                    if (feature.isMany()) {
                        List list = (List)referencer.eGet(feature);
                        int index = list.indexOf(referenced);
                        if (index != -1) {
                            list.remove(index);
                            this.removedReferences.add(new Reference(referencer, feature, referenced, index));
                            continue;
                        }
                        if (TngUtil.DEBUG) {
                            System.out.println("DeleteMethodElementCommand.removeReferences(): index=" + index + ", size=" + list.size() + ", referencer=" + referencer + ", referenced=" + referenced + ", feature=" + feature);
                        }
                        String guid = referenced.getGuid();
                        int i = 0;
                        while (i < list.size()) {
                            InternalEObject ref = (InternalEObject)list.get(i);
                            URI uri = ref.eProxyURI();
                            if (uri != null && guid.equals(uri.fragment())) {
                                list.remove(i);
                                this.removedReferences.add(new Reference(referencer, feature, referenced, i));
                                continue block2;
                            }
                            ++i;
                        }
                        continue;
                    }
                    referencer.eSet(feature, null);
                    this.removedReferences.add(new Reference(referencer, feature, referenced, -1));
                }
            }
        }
        if (TngUtil.DEBUG) {
            System.out.println("removedReferences: size=" + this.removedReferences.size());
        }
        this.batchCommand.getObjectToNewFeatureValuesMap().clear();
        for (Reference ref : this.removedReferences) {
            Activity act;
            VariabilityType vType;
            if (ref.getFeature() != UmaPackage.Literals.VARIABILITY_ELEMENT__VARIABILITY_BASED_ON_ELEMENT) continue;
            this.batchCommand.addFeatureValue(ref.getOwner(), (EStructuralFeature)UmaPackage.Literals.VARIABILITY_ELEMENT__VARIABILITY_TYPE, UmaPackage.Literals.VARIABILITY_ELEMENT__VARIABILITY_TYPE.getDefaultValue());
            if (!(ref.getOwner() instanceof Activity) || (vType = (act = (Activity)ref.getOwner()).getVariabilityType()) != VariabilityType.EXTENDS && vType != VariabilityType.LOCAL_CONTRIBUTION || !StrUtil.isNull((String)act.getPresentationName())) continue;
            Activity base = (Activity)ref.getValue();
            this.batchCommand.addFeatureValue((EObject)act, (EStructuralFeature)UmaPackage.Literals.METHOD_ELEMENT__PRESENTATION_NAME, ProcessUtil.getPresentationName((BreakdownElement)base));
        }
        if (this.batchCommand.canExecute()) {
            this.batchCommand.execute();
        }
        this.refRemoved = true;
    }

    protected void loadOppositeFeatures(List oppositeFeatures, Set deletedGUIDs) {
    }

    protected static void restoreReferences(List removedReferences) {
        int i = removedReferences.size() - 1;
        while (i > -1) {
            Reference ref = (Reference)removedReferences.get(i);
            if (ref.feature.isMany()) {
                List list = (List)ref.owner.eGet(ref.feature);
                if (ref.index != -1) {
                    if (!list.contains(ref.value)) {
                        if (ref.index < list.size()) {
                            list.add(ref.index, ref.value);
                        } else {
                            if (TngUtil.DEBUG) {
                                System.out.println("DeleteMethodElementCommand.removeReferences(): index=" + ref.index + ", size=" + list.size() + ", referencer=" + ref.owner + ", referenced=" + ref.value + ", feature=" + ref.feature);
                            }
                            list.add(ref.value);
                        }
                    } else if (TngUtil.DEBUG) {
                        System.out.println("DeleteMethodElementCommand.removeReferences(): reference already exists: referencer=" + ref.owner + ", referenced=" + ref.value + ", feature=" + ref.feature);
                    }
                } else {
                    list.add(ref.value);
                }
            } else {
                ref.owner.eSet(ref.feature, ref.value);
            }
            --i;
        }
    }

    protected void restoreReferences() {
        if (!this.refRemoved) {
            return;
        }
        this.batchCommand.undo();
        DeleteMethodElementCommand.restoreReferences(this.removedReferences);
        this.refRemoved = false;
    }

    public void undo() {
        this.notifyPreUndo();
        try {
            super.undo();
            this.restoreReferences();
        }
        catch (Exception e) {
            LibraryEditPlugin.INSTANCE.log(e);
            this.notifyFailure();
        }
    }

    public Collection getAffectedObjects() {
        if (this.executed) {
            return super.getAffectedObjects();
        }
        return this.elements;
    }

    public void addCommandListener(CommandListener listener) {
        if (!this.commandListeners.contains(listener)) {
            this.commandListeners.add(listener);
        }
    }

    public void removeCommandListener(CommandListener listener) {
        this.commandListeners.remove(listener);
    }

    protected void executeNestedCommands() {
        List<INestedCommandProvider> nestedCommandProviders = ExtensionManager.getNestedCommandProviders();
        if (!nestedCommandProviders.isEmpty() && !this.elements.isEmpty()) {
            this.nestedCommands = new ArrayList();
            for (INestedCommandProvider cmdProvider : nestedCommandProviders) {
                try {
                    Command cmd = cmdProvider.removeRelatedObjects(this.elements, (Command)this);
                    if (cmd == null || !cmd.canExecute()) continue;
                    cmd.execute();
                    this.nestedCommands.add(cmd);
                }
                catch (Exception e) {
                    LibraryEditPlugin.getDefault().getLogger().logError((Throwable)e);
                }
            }
        }
    }

    private void collectNestedCommandResources(Set<Resource> modifiedResources) {
        if (this.nestedCommands != null && !this.nestedCommands.isEmpty()) {
            int i = this.nestedCommands.size() - 1;
            while (i > -1) {
                Command cmd = this.nestedCommands.get(i);
                try {
                    Collection<Resource> resources;
                    if (cmd instanceof IResourceAwareCommand && (resources = ((IResourceAwareCommand)cmd).getModifiedResources()) != null) {
                        modifiedResources.addAll(resources);
                    }
                }
                catch (Exception e) {
                    LibraryEditPlugin.getDefault().getLogger().logError((Throwable)e);
                }
                --i;
            }
        }
    }

    public Collection<Descriptor> getDescriptorsToDelete() {
        return this.descriptors;
    }

    public boolean isExecuted() {
        return this.executed;
    }

    public static interface CommandListener {
        public void notifyExecuted(EventObject var1);

        public void notifyFailure(EventObject var1);
    }
}

