/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.process.command;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.epf.library.edit.LibraryEditPlugin;
import org.eclipse.epf.library.edit.process.command.AddMethodElementCommand;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.Checklist;
import org.eclipse.epf.uma.Concept;
import org.eclipse.epf.uma.Example;
import org.eclipse.epf.uma.Guidance;
import org.eclipse.epf.uma.Guideline;
import org.eclipse.epf.uma.ReusableAsset;
import org.eclipse.epf.uma.Roadmap;
import org.eclipse.epf.uma.SupportingMaterial;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddGuidanceToBreakdownElementCommand
extends AddMethodElementCommand {
    private List<Guidance> guidances;
    private BreakdownElement brElement;
    private Collection modifiedResources;

    public AddGuidanceToBreakdownElementCommand(BreakdownElement brElement, List<Guidance> guidances) {
        super(TngUtil.getOwningProcess(brElement));
        this.guidances = guidances;
        this.brElement = brElement;
        this.modifiedResources = new HashSet();
    }

    @Override
    public void execute() {
        if (!super.addToDefaultConfiguration(this.guidances)) {
            return;
        }
        this.redo();
    }

    @Override
    public void redo() {
        if (!this.guidances.isEmpty()) {
            for (Guidance obj : this.guidances) {
                if (!(obj instanceof Guidance)) continue;
                Guidance item = obj;
                if (item instanceof Checklist) {
                    this.brElement.getChecklists().add((Checklist)item);
                    continue;
                }
                if (item instanceof Concept) {
                    this.brElement.getConcepts().add((Concept)item);
                    continue;
                }
                if (item instanceof Example) {
                    this.brElement.getExamples().add((Example)item);
                    continue;
                }
                if (item instanceof SupportingMaterial) {
                    this.brElement.getSupportingMaterials().add((SupportingMaterial)item);
                    continue;
                }
                if (item instanceof Guideline) {
                    this.brElement.getGuidelines().add((Guideline)item);
                    continue;
                }
                if (item instanceof ReusableAsset) {
                    this.brElement.getReusableAssets().add((ReusableAsset)item);
                    continue;
                }
                if (item instanceof Roadmap) {
                    if (!(this.brElement instanceof Activity)) continue;
                    ((Activity)this.brElement).getRoadmaps().add((Roadmap)item);
                    continue;
                }
                LibraryEditPlugin.getDefault().getLogger().logError("Cant set guidance " + item.getType().getName() + ":" + item.getName());
            }
        }
    }

    @Override
    public void undo() {
        if (!this.guidances.isEmpty()) {
            super.undo();
            for (Guidance obj : this.guidances) {
                if (!(obj instanceof Guidance)) continue;
                Guidance item = obj;
                if (item instanceof Checklist) {
                    this.brElement.getChecklists().remove(item);
                    continue;
                }
                if (item instanceof Concept) {
                    this.brElement.getConcepts().remove(item);
                    continue;
                }
                if (item instanceof Example) {
                    this.brElement.getExamples().remove(item);
                    continue;
                }
                if (item instanceof SupportingMaterial) {
                    this.brElement.getSupportingMaterials().remove(item);
                    continue;
                }
                if (item instanceof Guideline) {
                    this.brElement.getGuidelines().remove(item);
                    continue;
                }
                if (item instanceof ReusableAsset) {
                    this.brElement.getReusableAssets().remove(item);
                    continue;
                }
                if (item instanceof Roadmap) {
                    if (!(this.brElement instanceof Activity)) continue;
                    ((Activity)this.brElement).getRoadmaps().remove((Roadmap)item);
                    continue;
                }
                LibraryEditPlugin.getDefault().getLogger().logError("Cant set guidance " + item.getType().getName() + ":" + item.getName());
            }
        }
    }

    protected boolean prepare() {
        return true;
    }

    @Override
    public Collection getModifiedResources() {
        if (!this.guidances.isEmpty() && this.brElement.eResource() != null) {
            this.modifiedResources.add(this.brElement.eResource());
        }
        return this.modifiedResources;
    }

    public Collection getAffectedObjects() {
        if (this.brElement != null) {
            return Arrays.asList(this.brElement);
        }
        return super.getAffectedObjects();
    }
}

