/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.process.command;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.epf.library.edit.TngAdapterFactory;
import org.eclipse.epf.library.edit.process.command.AddMethodElementCommand;
import org.eclipse.epf.library.edit.process.command.ProcessCommandUtil;
import org.eclipse.epf.library.edit.ui.UserInteractionHelper;
import org.eclipse.epf.library.edit.util.ProcessUtil;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.Role;
import org.eclipse.epf.uma.RoleDescriptor;
import org.eclipse.epf.uma.TaskDescriptor;
import org.eclipse.epf.uma.TeamProfile;

public class AssignPrimaryPerformerToTaskDescriptor
extends AddMethodElementCommand {
    private RoleDescriptor newRoleDesc = null;
    private RoleDescriptor oldRoleDesc = null;
    private Role role;
    private List roles;
    private Activity activity;
    private TaskDescriptor taskDesc;
    private Collection modifiedResources;
    private TeamProfile team;
    private MethodConfiguration config;
    private boolean isNewRoleDescriptor = false;

    public AssignPrimaryPerformerToTaskDescriptor(TaskDescriptor taskDesc, Role role, MethodConfiguration config) {
        super(TngUtil.getOwningProcess((BreakdownElement)taskDesc));
        this.role = role;
        this.taskDesc = taskDesc;
        this.config = config;
        this.roles = new ArrayList();
        this.roles.add(role);
        ComposedAdapterFactory aFactory = TngAdapterFactory.INSTANCE.getWBS_ComposedAdapterFactory();
        ItemProviderAdapter adapter = (ItemProviderAdapter)aFactory.adapt((Notifier)taskDesc, ITreeItemContentProvider.class);
        Object parent = adapter.getParent((Object)taskDesc);
        if (parent instanceof Activity) {
            this.activity = (Activity)parent;
        }
        this.modifiedResources = new HashSet();
    }

    public void execute() {
        if (!super.addToDefaultConfiguration(this.roles)) {
            return;
        }
        if (!this.roles.isEmpty()) {
            this.isNewRoleDescriptor = false;
            this.newRoleDesc = (RoleDescriptor)ProcessCommandUtil.getDescriptor((Object)this.role, this.activity, this.config);
            if (this.newRoleDesc == null) {
                this.newRoleDesc = (RoleDescriptor)ProcessCommandUtil.getInheritedDescriptor(this.role, this.activity, this.config);
                if (this.newRoleDesc == null) {
                    this.newRoleDesc = ProcessUtil.createRoleDescriptor(this.role);
                    this.isNewRoleDescriptor = true;
                }
            }
            this.team = UserInteractionHelper.getTeam(this.activity, this.role);
            this.redo();
        }
    }

    public void redo() {
        this.taskDesc.getPerformedPrimarilyBy().add(this.newRoleDesc);
        if (this.isNewRoleDescriptor) {
            this.activity.getBreakdownElements().add(this.newRoleDesc);
        }
        if (this.team != null) {
            this.team.getTeamRoles().add(this.newRoleDesc);
        }
    }

    public void undo() {
        if (!this.roles.isEmpty()) {
            super.undo();
            this.taskDesc.getPerformedPrimarilyBy().remove(this.newRoleDesc);
            if (this.isNewRoleDescriptor) {
                this.activity.getBreakdownElements().remove(this.newRoleDesc);
            }
            if (this.team != null) {
                this.team.getTeamRoles().remove(this.newRoleDesc);
            }
        }
    }

    protected boolean prepare() {
        return true;
    }

    public Collection getModifiedResources() {
        if (this.role != null) {
            if (this.activity.eResource() != null) {
                this.modifiedResources.add(this.activity.eResource());
            }
            if (this.taskDesc.eResource() != null) {
                this.modifiedResources.add(this.taskDesc.eResource());
            }
        }
        return this.modifiedResources;
    }
}

