/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.process.command;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.provider.AdapterFactoryTreeIterator;
import org.eclipse.epf.library.edit.command.IResourceAwareCommand;
import org.eclipse.epf.library.edit.process.BreakdownElementWrapperItemProvider;
import org.eclipse.epf.library.edit.util.ProcessUtil;
import org.eclipse.epf.library.edit.util.Suppression;

public class UpdateSuppressionFromBaseCommand
extends AbstractCommand
implements IResourceAwareCommand {
    private Suppression suppression;
    private Collection elements;
    private HashSet inheritedElements;
    private AdapterFactory adapterFactory;
    private Collection affectedObjects;
    private HashMap objectToSuppressionStateMap;

    public UpdateSuppressionFromBaseCommand() {
    }

    public UpdateSuppressionFromBaseCommand(String label, Collection elements, AdapterFactory adapterFactory, Suppression suppression) {
        super(label);
        this.elements = elements;
        this.adapterFactory = adapterFactory;
        this.suppression = suppression;
    }

    public void dispose() {
        if (this.affectedObjects != null) {
            this.affectedObjects.clear();
            this.affectedObjects = null;
        }
        if (this.inheritedElements != null) {
            this.inheritedElements.clear();
            this.inheritedElements = null;
        }
        if (this.objectToSuppressionStateMap != null) {
            this.objectToSuppressionStateMap.clear();
            this.objectToSuppressionStateMap = null;
        }
        super.dispose();
    }

    public Collection getModifiedResources() {
        Resource resource = this.suppression.getProcess().eResource();
        if (resource != null) {
            return Collections.singletonList(resource);
        }
        return Collections.EMPTY_LIST;
    }

    public Collection getAffectedObjects() {
        if (this.affectedObjects == null) {
            return super.getAffectedObjects();
        }
        return this.affectedObjects;
    }

    public void execute() {
        if (this.affectedObjects == null) {
            this.affectedObjects = new ArrayList();
        } else {
            this.affectedObjects.clear();
        }
        if (this.objectToSuppressionStateMap == null) {
            this.objectToSuppressionStateMap = new HashMap();
        } else {
            this.objectToSuppressionStateMap.clear();
        }
        for (BreakdownElementWrapperItemProvider wrapper : this.getInheritedElements()) {
            boolean wasSuppressed = this.suppression.isInSuppressedList(wrapper);
            if (!this.suppression.updateSuppressionFromBase(wrapper)) continue;
            this.affectedObjects.add(wrapper);
            this.objectToSuppressionStateMap.put(wrapper, wasSuppressed);
        }
    }

    public void redo() {
        this.execute();
    }

    public void undo() {
        if (this.objectToSuppressionStateMap != null && !this.objectToSuppressionStateMap.isEmpty()) {
            for (Map.Entry entry : this.objectToSuppressionStateMap.entrySet()) {
                Boolean suppressed = (Boolean)entry.getValue();
                if (suppressed.booleanValue()) {
                    this.suppression.suppress(Collections.singletonList(entry.getKey()));
                    continue;
                }
                this.suppression.reveal(Collections.singletonList(entry.getKey()));
            }
            this.affectedObjects.clear();
            this.affectedObjects.addAll(this.elements);
        }
    }

    protected boolean prepare() {
        return true;
    }

    private Collection getInheritedElements() {
        if (this.inheritedElements == null) {
            this.inheritedElements = new HashSet();
            for (Object element : this.elements) {
                AdapterFactoryTreeIterator treeIter = new AdapterFactoryTreeIterator(this.adapterFactory, element);
                while (treeIter.hasNext()) {
                    Object e = treeIter.next();
                    if (!ProcessUtil.isInherited(e)) continue;
                    this.inheritedElements.add(e);
                }
            }
        }
        return this.inheritedElements;
    }
}

