/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.process.command;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.epf.library.edit.LibraryEditPlugin;
import org.eclipse.epf.library.edit.process.command.BSDropCommand;
import org.eclipse.epf.library.edit.process.command.ProcessCommandUtil;
import org.eclipse.epf.library.edit.ui.UserInteractionHelper;
import org.eclipse.epf.library.edit.validation.UniqueNamePNameHandler;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.DescribableElement;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.ProcessPackage;
import org.eclipse.epf.uma.RoleDescriptor;
import org.eclipse.epf.uma.Task;
import org.eclipse.epf.uma.TaskDescriptor;
import org.eclipse.epf.uma.TeamProfile;
import org.eclipse.epf.uma.WorkProductDescriptor;

public class WBSDropCommand
extends BSDropCommand {
    private ArrayList roleDescList;
    private ArrayList wpDescList;
    private HashMap wpDescToDeliverableParts;
    private HashMap<WorkProductDescriptor, WorkProductDescriptor> wpdToDeliverableDescriptorMap;
    private HashMap<RoleDescriptor, TeamProfile> roleDescTeamProfileMap;
    private BSDropCommand.IExecutor executor;

    public WBSDropCommand(Activity act, List tasks) {
        super(act, tasks);
        Iterator iter = this.dropElements.iterator();
        while (iter.hasNext()) {
            Object element = iter.next();
            if (element instanceof Task) continue;
            iter.remove();
        }
    }

    public WBSDropCommand(Activity activity, List dropElements, boolean synch) {
        super(activity, dropElements, synch);
    }

    public WBSDropCommand(Activity activity, List dropElements, MethodConfiguration config, Set synchFeatures) {
        super(activity, dropElements, config, synchFeatures);
    }

    public BSDropCommand.IExecutor getExecutor() {
        if (this.executor == null) {
            this.executor = new Executor();
        }
        return this.executor;
    }

    protected boolean preExecute() {
        if (!super.preExecute()) {
            return false;
        }
        return this.getExecutor().preExecute();
    }

    protected void doExecute() {
        this.executor.doExcecute();
    }

    public Collection getAffectedObjects() {
        if (this.taskDescList != null) {
            return this.taskDescList;
        }
        return super.getAffectedObjects();
    }

    protected void doUndo() {
        this.executor.doUndo();
    }

    public void dispose() {
        if (this.roleDescList != null) {
            this.roleDescList.clear();
        }
        if (this.roleDescTeamProfileMap != null) {
            this.roleDescTeamProfileMap.clear();
        }
        if (this.wpDescList != null) {
            this.wpDescList.clear();
        }
        if (this.wpDescToDeliverableParts != null) {
            this.wpDescToDeliverableParts.clear();
        }
        if (this.wpdToDeliverableDescriptorMap != null) {
            this.wpdToDeliverableDescriptorMap.clear();
        }
        super.dispose();
    }

    private class Executor
    implements BSDropCommand.IExecutor {
        private Executor() {
        }

        public boolean preExecute() {
            WBSDropCommand.this.taskDescList = new ArrayList();
            WBSDropCommand.this.roleDescList = new ArrayList();
            WBSDropCommand.this.wpDescList = new ArrayList();
            WBSDropCommand.this.wpDescToDeliverableParts = new HashMap();
            WBSDropCommand.this.wpdToDeliverableDescriptorMap = new HashMap();
            Set descriptorsToRefresh = WBSDropCommand.this.synchronize ? WBSDropCommand.this.batchCommand.getDescriptorsToRefresh() : null;
            List bes = WBSDropCommand.this.activity.getBreakdownElements();
            UniqueNamePNameHandler uniqueNamesHandler = new UniqueNamePNameHandler(bes);
            int i = 0;
            while (i < WBSDropCommand.this.dropElements.size()) {
                Task task = (Task)WBSDropCommand.this.dropElements.get(i);
                TaskDescriptor desc = ProcessCommandUtil.createTaskDescriptor(task, WBSDropCommand.this.activity, WBSDropCommand.this.roleDescList, WBSDropCommand.this.wpDescList, WBSDropCommand.this.wpDescToDeliverableParts, WBSDropCommand.this.wpdToDeliverableDescriptorMap, descriptorsToRefresh, WBSDropCommand.this.batchCommand.getObjectToNewFeatureValuesMap(), WBSDropCommand.this.getMethodConfiguration(), WBSDropCommand.this.synchronize, WBSDropCommand.this.synchFeatures);
                if (desc != null) {
                    uniqueNamesHandler.ensureUnique((DescribableElement)desc);
                    WBSDropCommand.this.taskDescList.add(desc);
                }
                ++i;
            }
            i = 0;
            while (i < WBSDropCommand.this.roleDescList.size()) {
                RoleDescriptor roleDesc = (RoleDescriptor)WBSDropCommand.this.roleDescList.get(i);
                if (roleDesc != null) {
                    uniqueNamesHandler.ensureUnique((DescribableElement)roleDesc);
                }
                ++i;
            }
            i = 0;
            while (i < WBSDropCommand.this.wpDescList.size()) {
                WorkProductDescriptor wpDesc = (WorkProductDescriptor)WBSDropCommand.this.wpDescList.get(i);
                if (wpDesc != null) {
                    uniqueNamesHandler.ensureUnique((DescribableElement)wpDesc);
                }
                ++i;
            }
            return !WBSDropCommand.this.taskDescList.isEmpty() || !WBSDropCommand.this.roleDescList.isEmpty() || !WBSDropCommand.this.wpDescList.isEmpty() || !WBSDropCommand.this.wpDescToDeliverableParts.isEmpty() || !WBSDropCommand.this.wpdToDeliverableDescriptorMap.isEmpty() || WBSDropCommand.this.batchCommand.canExecute();
        }

        public void doExcecute() {
            if (!WBSDropCommand.this.wpdToDeliverableDescriptorMap.isEmpty()) {
                for (Map.Entry entry : WBSDropCommand.this.wpdToDeliverableDescriptorMap.entrySet()) {
                    WorkProductDescriptor deliverable = (WorkProductDescriptor)entry.getValue();
                    if (deliverable.getDeliverableParts().contains(entry.getKey())) continue;
                    try {
                        deliverable.getDeliverableParts().add((WorkProductDescriptor)entry.getKey());
                    }
                    catch (Exception e) {
                        LibraryEditPlugin.INSTANCE.log("WBSDropCommand::doExecute - Adding deliverable part to deliverable" + e);
                    }
                }
            }
            WBSDropCommand.this.activity.getBreakdownElements().addAll(WBSDropCommand.this.taskDescList);
            WBSDropCommand.this.activity.getBreakdownElements().addAll(WBSDropCommand.this.roleDescList);
            WBSDropCommand.this.activity.getBreakdownElements().addAll(WBSDropCommand.this.wpDescList);
            if (!WBSDropCommand.this.wpDescToDeliverableParts.isEmpty()) {
                for (Map.Entry entry : WBSDropCommand.this.wpDescToDeliverableParts.entrySet()) {
                    WorkProductDescriptor wpDesc = (WorkProductDescriptor)entry.getKey();
                    wpDesc.getDeliverableParts().addAll((Collection)entry.getValue());
                }
            }
            if (WBSDropCommand.this.roleDescTeamProfileMap == null) {
                WBSDropCommand.this.roleDescTeamProfileMap = new HashMap();
                for (RoleDescriptor roleDesc : WBSDropCommand.this.roleDescList) {
                    TeamProfile teamProfile = UserInteractionHelper.getTeam(WBSDropCommand.this.activity, roleDesc.getRole());
                    if (teamProfile == null) continue;
                    WBSDropCommand.this.roleDescTeamProfileMap.put(roleDesc, teamProfile);
                }
            }
            for (Map.Entry entry : WBSDropCommand.this.roleDescTeamProfileMap.entrySet()) {
                TeamProfile team = (TeamProfile)entry.getValue();
                team.getTeamRoles().add((RoleDescriptor)entry.getKey());
            }
            ProcessPackage pkg = (ProcessPackage)WBSDropCommand.this.activity.eContainer();
            if (pkg != null) {
                pkg.getProcessElements().addAll(WBSDropCommand.this.taskDescList);
                pkg.getProcessElements().addAll(WBSDropCommand.this.roleDescList);
                pkg.getProcessElements().addAll(WBSDropCommand.this.wpDescList);
            }
        }

        public void doUndo() {
            WBSDropCommand.this.activity.getBreakdownElements().removeAll(WBSDropCommand.this.wpDescList);
            WBSDropCommand.this.activity.getBreakdownElements().removeAll(WBSDropCommand.this.roleDescList);
            WBSDropCommand.this.activity.getBreakdownElements().removeAll(WBSDropCommand.this.taskDescList);
            if (!WBSDropCommand.this.wpDescToDeliverableParts.isEmpty()) {
                for (Map.Entry entry : WBSDropCommand.this.wpDescToDeliverableParts.entrySet()) {
                    WorkProductDescriptor wpDesc = (WorkProductDescriptor)entry.getKey();
                    wpDesc.getDeliverableParts().removeAll((Collection)entry.getValue());
                }
            }
            if (!WBSDropCommand.this.wpdToDeliverableDescriptorMap.isEmpty()) {
                for (Map.Entry entry : WBSDropCommand.this.wpdToDeliverableDescriptorMap.entrySet()) {
                    WorkProductDescriptor deliverable = (WorkProductDescriptor)entry.getValue();
                    deliverable.getDeliverableParts().remove(entry.getKey());
                }
            }
            for (Map.Entry entry : WBSDropCommand.this.roleDescTeamProfileMap.entrySet()) {
                TeamProfile team = (TeamProfile)entry.getValue();
                team.getTeamRoles().remove(entry.getKey());
            }
            ProcessPackage pkg = (ProcessPackage)WBSDropCommand.this.activity.eContainer();
            if (pkg != null) {
                pkg.getProcessElements().removeAll(WBSDropCommand.this.taskDescList);
                pkg.getProcessElements().removeAll(WBSDropCommand.this.roleDescList);
                pkg.getProcessElements().removeAll(WBSDropCommand.this.wpDescList);
            }
        }
    }
}

