/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.command.CopyCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.AdapterFactoryTreeIterator;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.epf.library.edit.IConfigurator;
import org.eclipse.epf.library.edit.TngAdapterFactory;
import org.eclipse.epf.library.edit.process.IBSItemProvider;
import org.eclipse.epf.library.edit.process.command.ActivityDeepCopyCommand;
import org.eclipse.epf.library.edit.process.command.CopyHelper;
import org.eclipse.epf.library.edit.util.PredecessorList;
import org.eclipse.epf.library.edit.util.ProcessUtil;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.Process;
import org.eclipse.epf.uma.ProcessComponent;
import org.eclipse.epf.uma.ProcessPackage;
import org.eclipse.epf.uma.UmaFactory;
import org.eclipse.epf.uma.VariabilityType;
import org.eclipse.epf.uma.WorkBreakdownElement;
import org.eclipse.epf.uma.edit.domain.TraceableAdapterFactoryEditingDomain;
import org.eclipse.epf.uma.util.UmaUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActivityHandler {
    private ArrayList<ProcessPackage> procPackages;
    private ArrayList<Object> activitiesToDeepCopy;
    private MethodConfiguration deepCopyConfig;
    private List deepCopies;
    private Map deepCopyToOriginalMap;
    private ArrayList<Activity> activities = new ArrayList();
    private Map copyToOriginal;
    private AdapterFactoryEditingDomain editingDomain;
    private CopyCommand.Helper copyHelper;
    private CopyHelper deepCopyHelper;
    private Process targetProcess;
    private IProgressMonitor monitor;
    private IConfigurator activityDeepCopyConfigurator;
    private boolean copyExternalVariations = true;

    public ActivityHandler() {
        this.activitiesToDeepCopy = new ArrayList();
        this.deepCopies = new ArrayList();
        this.deepCopyToOriginalMap = new HashMap();
        this.copyToOriginal = new HashMap();
        this.procPackages = new ArrayList();
        this.copyHelper = new CopyCommand.Helper();
    }

    public void dispose() {
        this.activities.clear();
        this.activitiesToDeepCopy.clear();
        this.copyToOriginal.clear();
        this.procPackages.clear();
        this.copyHelper.clear();
        this.deepCopies.clear();
        if (this.deepCopyHelper != null) {
            this.deepCopyHelper.clear();
        }
        this.deepCopyToOriginalMap.clear();
    }

    public void setCopyExternalVariations(boolean copyExternalVariations) {
        this.copyExternalVariations = copyExternalVariations;
    }

    public void copy(Activity activity) {
        this.procPackages.add((ProcessPackage)activity.eContainer());
    }

    public MethodConfiguration getDeepCopyConfig() {
        return this.deepCopyConfig;
    }

    public void setDeepCopyConfig(MethodConfiguration deepCopyConfig) {
        this.deepCopyConfig = deepCopyConfig;
    }

    public Process getTargetProcess() {
        return this.targetProcess;
    }

    public void setTargetProcess(Process proc) {
        this.targetProcess = proc;
    }

    public void setMonitor(IProgressMonitor monitor) {
        this.monitor = monitor;
    }

    public List getDeepCopies() {
        return this.deepCopies;
    }

    public void deepCopy(Object activityOrWrapper) {
        Object unwrapped = TngUtil.unwrap(activityOrWrapper);
        if (unwrapped instanceof Activity && ((Activity)unwrapped).eContainer() != null) {
            this.activitiesToDeepCopy.add(activityOrWrapper);
        }
    }

    public void extend(Activity act) {
        Activity extendedAct = ProcessUtil.generalize(act, VariabilityType.EXTENDS);
        this.activities.add(extendedAct);
    }

    public List<Activity> getActivities() {
        if (!this.procPackages.isEmpty() || !this.activitiesToDeepCopy.isEmpty()) {
            this.editingDomain = new TraceableAdapterFactoryEditingDomain((AdapterFactory)TngAdapterFactory.INSTANCE.getWBS_ComposedAdapterFactory(), (CommandStack)new BasicCommandStack());
            if (!this.procPackages.isEmpty()) {
                this.activities.addAll(this.copy(this.procPackages));
            }
            if (!this.activitiesToDeepCopy.isEmpty()) {
                if (this.monitor == null) {
                    this.monitor = new NullProgressMonitor();
                }
                for (Object act : this.activitiesToDeepCopy) {
                    ActivityDeepCopyCommand cmd = new ActivityDeepCopyCommand(act, this.getDeepCopyHelper(), this.deepCopyConfig, this.targetProcess, this.monitor, this.activityDeepCopyConfigurator);
                    cmd.setCopyExternalVariations(this.copyExternalVariations);
                    try {
                        Collection<?> result;
                        long time = 0L;
                        if (TngUtil.DEBUG) {
                            time = System.currentTimeMillis();
                        }
                        cmd.execute();
                        if (TngUtil.DEBUG) {
                            System.out.println("ActivityDeepCopyCommand executed: " + (System.currentTimeMillis() - time) + " ms");
                            time = System.currentTimeMillis();
                        }
                        if ((result = cmd.getResult()).isEmpty()) continue;
                        Activity deepCopy = (Activity)result.iterator().next();
                        ProcessUtil.fixBreakdonwElementOrderRecursively(deepCopy);
                        if (TngUtil.DEBUG) {
                            System.out.println("ProcessUtil.fixBreakdonwElementOrderRecursively(): " + (System.currentTimeMillis() - time) + " ms");
                            time = System.currentTimeMillis();
                        }
                        cmd.copySuppressionStates();
                        if (TngUtil.DEBUG) {
                            System.out.println("ActivityDeepCopyCommand.copySuppressionStates(): " + (System.currentTimeMillis() - time) + " ms");
                            time = System.currentTimeMillis();
                        }
                        this.deepCopies.add(deepCopy);
                        this.deepCopyToOriginalMap.put(deepCopy, act);
                    }
                    finally {
                        cmd.dispose();
                    }
                }
                this.activities.addAll(this.deepCopies);
            }
        }
        return this.activities;
    }

    private void updatePredecessors(List workBreakdownElements) {
        ArrayList<PredecessorList> predecessorLists = new ArrayList<PredecessorList>();
        Object original = this.copyToOriginal.get(workBreakdownElements.get(0));
        AdapterFactory adapterFactory = this.editingDomain.getAdapterFactory();
        IBSItemProvider bsItemProvider2 = (IBSItemProvider)adapterFactory.adapt(original, ITreeItemContentProvider.class);
        int firstID = bsItemProvider2.getId();
        predecessorLists.add(bsItemProvider2.getPredecessors());
        IBSItemProvider lastWBIp = null;
        AdapterFactoryTreeIterator iter = new AdapterFactoryTreeIterator(adapterFactory, original, false);
        while (iter.hasNext()) {
            Object obj = iter.next();
            Object e = TngUtil.unwrap(obj);
            if (!(e instanceof WorkBreakdownElement)) continue;
            IBSItemProvider bsIp = null;
            if (obj instanceof IBSItemProvider) {
                bsIp = (IBSItemProvider)obj;
                predecessorLists.add(bsIp.getPredecessors());
            } else {
                Object ip = adapterFactory.adapt(obj, ITreeItemContentProvider.class);
                if (ip instanceof IBSItemProvider) {
                    bsIp = (IBSItemProvider)ip;
                    predecessorLists.add(bsIp.getPredecessors());
                }
            }
            if (bsIp == null) continue;
            lastWBIp = bsIp;
        }
        int lastID = lastWBIp != null ? lastWBIp.getId() : firstID;
        int size = workBreakdownElements.size();
        Assert.isTrue((size == predecessorLists.size() ? 1 : 0) != 0);
        int i = 0;
        while (i < size) {
            WorkBreakdownElement e = (WorkBreakdownElement)workBreakdownElements.get(i);
            e.getLinkToPredecessor().clear();
            PredecessorList predList = (PredecessorList)predecessorLists.get(i);
            for (IBSItemProvider bsItemProvider2 : predList) {
                int id = bsItemProvider2.getId();
                if (id < firstID || id > lastID) continue;
                WorkBreakdownElement pred = (WorkBreakdownElement)workBreakdownElements.get(id - firstID);
                e.getLinkToPredecessor().add(UmaUtil.createDefaultWorkOrder((WorkBreakdownElement)e, (WorkBreakdownElement)pred));
            }
            ++i;
        }
    }

    private Collection<?> copyProcessPackages(Collection<ProcessPackage> procPackages) {
        Command command = this.createCopyCommand((EditingDomain)this.editingDomain, procPackages);
        if (command != null) {
            try {
                command.execute();
                Collection collection = command.getResult();
                return collection;
            }
            finally {
                command.dispose();
            }
        }
        return Collections.EMPTY_LIST;
    }

    private Command createCopyCommand(EditingDomain domain, Collection collection) {
        if (collection == null || collection.isEmpty()) {
            return UnexecutableCommand.INSTANCE;
        }
        CompoundCommand copyCommand = new CompoundCommand(Integer.MAX_VALUE);
        Iterator objects = collection.iterator();
        while (objects.hasNext()) {
            copyCommand.append(domain.createCommand(CopyCommand.class, new CommandParameter(objects.next(), null, (Object)this.copyHelper)));
        }
        return copyCommand.unwrap();
    }

    private List<Activity> copy(List<ProcessPackage> procPackages) {
        Collection<?> copyPackages = this.copyProcessPackages(procPackages);
        ArrayList<Activity> activities = new ArrayList<Activity>();
        for (ProcessPackage copy : copyPackages) {
            if (copy instanceof ProcessComponent) {
                Process actCopy = ((ProcessComponent)copy).getProcess();
                ProcessPackage pkgCopy = UmaFactory.eINSTANCE.createProcessPackage();
                pkgCopy.setName(actCopy.getName());
                pkgCopy.getProcessElements().add(actCopy);
                pkgCopy.getProcessElements().addAll(copy.getProcessElements());
                pkgCopy.getDiagrams().addAll(copy.getDiagrams());
                pkgCopy.getChildPackages().addAll(copy.getChildPackages());
                activities.add((Activity)actCopy);
                continue;
            }
            activities.add(ProcessUtil.findActivity(copy));
        }
        return activities;
    }

    public Map getDeepCopyToOriginalMap() {
        return this.deepCopyToOriginalMap;
    }

    public CopyCommand.Helper getCopyHelper() {
        return this.copyHelper;
    }

    public CopyHelper getDeepCopyHelper() {
        if (this.deepCopyHelper == null) {
            this.deepCopyHelper = new CopyHelper();
        }
        return this.deepCopyHelper;
    }

    public void setActivityDeepCopyConfigurator(IConfigurator activityDeepCopyConfigurator) {
        this.activityDeepCopyConfigurator = activityDeepCopyConfigurator;
    }
}

