/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.publishing.ui.wizards;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.epf.authoring.ui.AuthoringUIText;
import org.eclipse.epf.common.utils.StrUtil;
import org.eclipse.epf.publishing.ui.PublishingUIPlugin;
import org.eclipse.epf.publishing.ui.PublishingUIResources;
import org.eclipse.epf.publishing.ui.preferences.PublishingUIPreferences;
import org.eclipse.epf.ui.wizards.BaseWizardPage;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

public class SelectDestinationPage
extends BaseWizardPage {
    public static final String PAGE_NAME = SelectDestinationPage.class.getName();
    public static final String PREFERENCE_DELIMITER = "|";
    public static final String SPLIT_PREFERENCE_DELIMITER = "\\|";
    protected Shell shell;
    protected Combo dirCombo;
    protected Button browseButton;
    protected Group webAppGroup;
    protected Button staticWebSiteRadioButton;
    protected Composite staticWebSiteComposite;
    protected Button javaWebAppRadioButton;
    protected Composite javaWebAppComposite;
    protected Label webAppNameLabel;
    protected Combo webAppNameCombo;
    protected Button includeSearchCheckbox;
    protected MethodConfiguration config;
    protected Composite composite;
    protected List<MethodConfiguration> selectedConfigs = new ArrayList<MethodConfiguration>();

    public SelectDestinationPage(String pageName) {
        super(pageName, PublishingUIResources.selectDestinationWizardPage_title, PublishingUIResources.selectDestinationWizardPage_text, PublishingUIPlugin.getDefault().getImageDescriptor("full/wizban/PublishConfiguration.gif"));
    }

    public SelectDestinationPage() {
        this(PAGE_NAME);
    }

    public void createControl(Composite parent) {
        this.shell = parent.getShell();
        this.composite = SelectDestinationPage.createGridLayoutComposite((Composite)parent, (int)1);
        Composite dirComposite = SelectDestinationPage.createGridLayoutComposite((Composite)this.composite, (int)3);
        SelectDestinationPage.createLabel((Composite)dirComposite, (String)PublishingUIResources.dirLabel_text);
        this.dirCombo = SelectDestinationPage.createCombobox((Composite)dirComposite);
        this.browseButton = SelectDestinationPage.createButton((Composite)dirComposite, (String)AuthoringUIText.BROWSE_BUTTON_TEXT);
        this.webAppGroup = BaseWizardPage.createGridLayoutGroup((Composite)this.composite, (String)PublishingUIResources.webAppGroup_text, (int)1);
        this.staticWebSiteRadioButton = SelectDestinationPage.createRadioButton((Composite)this.webAppGroup, (String)PublishingUIResources.staticWebSiteRadioButton_text);
        this.staticWebSiteComposite = SelectDestinationPage.createChildGridLayoutComposite((Composite)this.webAppGroup, (int)1);
        this.javaWebAppRadioButton = SelectDestinationPage.createRadioButton((Composite)this.webAppGroup, (String)PublishingUIResources.dynamicWebAppRadioButton_text);
        this.javaWebAppComposite = SelectDestinationPage.createChildGridLayoutComposite((Composite)this.webAppGroup, (int)3);
        this.includeSearchCheckbox = SelectDestinationPage.createCheckbox((Composite)this.javaWebAppComposite, (String)PublishingUIResources.includeSearchCheckbox_text, (int)3);
        this.webAppNameLabel = SelectDestinationPage.createLabel((Composite)this.javaWebAppComposite, (String)PublishingUIResources.webApplicationNameLabel_text);
        this.webAppNameCombo = SelectDestinationPage.createCombobox((Composite)this.javaWebAppComposite, (int)2);
        this.initControls();
        this.addListeners();
        this.setControl((Control)this.composite);
    }

    protected void initControls() {
        String configId = this.config != null ? this.config.getGuid() : "";
        String dir = PublishingUIPreferences.getPublishPath(configId);
        if (dir != null && dir.length() > 0) {
            this.dirCombo.setItems(this.coverStringToArray(dir));
            this.dirCombo.select(0);
        }
        boolean publishStaticWebSite = PublishingUIPreferences.getPublishStaticWebSite(configId);
        this.staticWebSiteRadioButton.setSelection(publishStaticWebSite);
        this.javaWebAppRadioButton.setSelection(!publishStaticWebSite);
        this.includeSearchCheckbox.setSelection(PublishingUIPreferences.getIncludeSearch(configId));
        String webAppName = PublishingUIPreferences.getWebAppName(configId);
        if (webAppName != null && webAppName.length() > 0) {
            this.webAppNameCombo.setItems(new String[]{webAppName});
            this.webAppNameCombo.setText(webAppName);
        }
        this.updateControls();
    }

    protected void addListeners() {
        this.dirCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SelectDestinationPage.this.setPageComplete(SelectDestinationPage.this.isPageComplete());
            }
        });
        this.dirCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String dir = SelectDestinationPage.this.dirCombo.getText();
                SelectDestinationPage.this.processDirectory(dir);
            }
        });
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                try {
                    DirectoryDialog dialog = new DirectoryDialog(SelectDestinationPage.this.shell, 0);
                    String selectedDir = dialog.open();
                    if (selectedDir != null) {
                        String dir = selectedDir.trim();
                        SelectDestinationPage.this.processDirectory(dir);
                    }
                }
                catch (Exception e) {
                    PublishingUIPlugin.getDefault().getLogger().logError((Throwable)e);
                }
            }
        });
        this.staticWebSiteRadioButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                SelectDestinationPage.this.updateControls();
            }
        });
        this.javaWebAppRadioButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                SelectDestinationPage.this.updateControls();
            }
        });
        this.webAppNameCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SelectDestinationPage.this.setPageComplete(SelectDestinationPage.this.isPageComplete());
            }
        });
    }

    protected String[] coverStringToArray(String preferenceStr) {
        return preferenceStr.split(SPLIT_PREFERENCE_DELIMITER);
    }

    protected String convertArrayToString(String[] arr) {
        StringBuffer sBuffer = new StringBuffer();
        if (arr == null || arr.length == 0) {
            return sBuffer.toString();
        }
        sBuffer.append(arr[0]);
        int i = 1;
        while (i < arr.length) {
            sBuffer.append(PREFERENCE_DELIMITER);
            sBuffer.append(arr[i]);
            ++i;
        }
        return sBuffer.toString();
    }

    protected void updateControls() {
        boolean publishStaticWebSite = this.getStaticWebSiteSelection();
        this.webAppNameLabel.setEnabled(!publishStaticWebSite);
        this.webAppNameCombo.setEnabled(!publishStaticWebSite);
        this.includeSearchCheckbox.setEnabled(!publishStaticWebSite);
        this.setPageComplete(this.isPageComplete());
    }

    public void onEnterPage(Object obj) {
        if (obj != null && obj instanceof MethodConfiguration) {
            this.config = (MethodConfiguration)obj;
            if (!this.selectedConfigs.contains(this.config)) {
                this.selectedConfigs.add(this.config);
                this.initControls();
            }
        }
    }

    public boolean isPageComplete() {
        String path = this.getPublishDirectory();
        IPath ecPath = Path.fromOSString((String)path);
        boolean isValid = ecPath.isValidPath(path);
        if (!isValid) {
            this.setErrorMessage(PublishingUIResources.invalidPathError_msg);
            return false;
        }
        if (!StrUtil.isValidPublishPath((String)path)) {
            this.setErrorMessage(PublishingUIResources.invalidPathCharsError_msg);
            return false;
        }
        this.setErrorMessage(null);
        if (path.length() == 0) {
            return false;
        }
        if (!this.getStaticWebSiteSelection()) {
            String webAppName = this.getWebAppName();
            if (webAppName.length() == 0) {
                this.setErrorMessage(PublishingUIResources.webAppNameError_msg);
                return false;
            }
            if (!StrUtil.isValidName((String)webAppName)) {
                this.setErrorMessage(PublishingUIResources.webAppNameCharsError_msg);
                return false;
            }
            this.setErrorMessage(null);
        }
        return true;
    }

    public String getPublishDirectory() {
        String dirText = this.dirCombo.getText().trim();
        if (dirText.length() > 0) {
            File dir = new File(dirText);
            return dir.getAbsolutePath();
        }
        return dirText;
    }

    protected String[] getPublishDirectoryArray() {
        String dir = this.dirCombo.getText().trim();
        this.processDirectory(dir);
        return this.dirCombo.getItems();
    }

    private void processDirectory(String dir) {
        if (this.dirCombo.indexOf(dir) != -1) {
            this.dirCombo.remove(dir);
        }
        this.dirCombo.add(dir, 0);
        this.dirCombo.select(0);
    }

    public boolean getStaticWebSiteSelection() {
        return this.staticWebSiteRadioButton.getSelection();
    }

    public boolean getJavaWebAppSelection() {
        return this.javaWebAppRadioButton.getSelection();
    }

    public boolean getIncludeSearchSelection() {
        return this.includeSearchCheckbox.getSelection();
    }

    public String getWebAppName() {
        return this.webAppNameCombo.getText().trim();
    }

    public void savePreferences() {
        if (this.config != null) {
            String configId = this.config.getGuid();
            PublishingUIPreferences.setPublishPath(configId, this.convertArrayToString(this.getPublishDirectoryArray()));
            PublishingUIPreferences.setPublishStaticWebSite(configId, this.getStaticWebSiteSelection());
            PublishingUIPreferences.setIncludeSearch(configId, this.getIncludeSearchSelection());
            PublishingUIPreferences.setWebAppName(configId, this.getWebAppName());
        }
    }
}

