/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.publishing.ui.wizards;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.epf.authoring.ui.AuthoringUIHelpContexts;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.authoring.ui.AuthoringUIText;
import org.eclipse.epf.common.utils.StrUtil;
import org.eclipse.epf.library.layout.elements.AbstractElementLayout;
import org.eclipse.epf.publishing.services.PublishHTMLOptions;
import org.eclipse.epf.publishing.services.PublishOptions;
import org.eclipse.epf.publishing.ui.PublishingUIPlugin;
import org.eclipse.epf.publishing.ui.PublishingUIResources;
import org.eclipse.epf.publishing.ui.preferences.PublishingUIPreferences;
import org.eclipse.epf.ui.wizards.BaseWizardPage;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class SelectPublishingOptionsPage
extends BaseWizardPage {
    public static final String PAGE_NAME = SelectPublishingOptionsPage.class.getName();
    protected Shell shell;
    protected Composite composite;
    protected Group layoutGroup;
    protected Text titleText;
    protected Text aboutHTMLText;
    protected Text feedbackURLText;
    protected Button selectHTMLButton;
    protected Button publishGlossaryCheckbox;
    protected Button publishIndexCheckbox;
    protected Text bannerImageText;
    protected Button selectImageButton;
    protected Button checkExternalLinksCheckbox;
    protected Button convertBrokenLinksCheckbox;
    protected Button publishUnopenADDCheckbox;
    protected Button publishBaseADCheckbox;
    protected Button publishLightWeightTreeCheckbox;
    protected Button extraDescriptorInfoCtr;
    protected Button showRelatedDescriptors;
    protected Button showRelatedDescriptorsOption;
    protected Button showDescriptorsInNavigationTree;
    protected Button showRelatedLinks;
    protected ComboViewer activityTabViewer;
    protected MethodConfiguration config;
    protected List<MethodConfiguration> selectedConfigs = new ArrayList<MethodConfiguration>();
    public static Map<String, String> activityTabMap = new TreeMap<String, String>();

    static {
        activityTabMap.put("Description", AuthoringUIResources.descriptionPage_title);
        activityTabMap.put("WBS", AuthoringUIResources.ProcessEditor_WorkBreakdownStructure);
        activityTabMap.put("TBS", AuthoringUIResources.ProcessEditor_TeamAllocation);
        activityTabMap.put("WPBS", AuthoringUIResources.ProcessEditor_WorkProductUsage);
    }

    public SelectPublishingOptionsPage(String pageName) {
        super(pageName, PublishingUIResources.selectPublishingOptionsWizardPage_title, PublishingUIResources.selectPublishingOptionsWizardPage_text, PublishingUIPlugin.getDefault().getImageDescriptor("full/wizban/PublishConfiguration.gif"));
    }

    public SelectPublishingOptionsPage() {
        this(PAGE_NAME);
    }

    public void createControl(Composite parent) {
        this.shell = parent.getShell();
        ScrolledComposite scrolledComposite = new ScrolledComposite(parent, 768);
        this.composite = SelectPublishingOptionsPage.createGridLayoutComposite((Composite)scrolledComposite, (int)1);
        scrolledComposite.setContent((Control)this.composite);
        this.createTitleAndLinksGroup(this.composite);
        this.createGlossaryAndIndexGroup(this.composite);
        this.createLookAndFeelGroup(this.composite);
        this.createValidation(this.composite);
        this.createDiagramGenerationGroup(this.composite);
        this.createLayoutGroup(this.composite);
        Point defaultSize = this.composite.computeSize(-1, -1);
        this.composite.setSize(defaultSize);
        this.initControls();
        this.addListeners();
        this.setControl((Control)scrolledComposite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)scrolledComposite, AuthoringUIHelpContexts.CONFIGURATION_PUBLISH_WIZARD_ALL_PAGES_CONTEXT);
    }

    protected Group createTitleAndLinksGroup(Composite composite) {
        Group titleAndLinksGroup = SelectPublishingOptionsPage.createGridLayoutGroup((Composite)composite, (String)PublishingUIResources.titleAndLinksGroup_text, (int)3);
        SelectPublishingOptionsPage.createLabel((Composite)titleAndLinksGroup, (String)PublishingUIResources.titleLabel_text);
        this.titleText = SelectPublishingOptionsPage.createEditableText((Composite)titleAndLinksGroup, (String)"", (int)360, (int)1);
        SelectPublishingOptionsPage.createLabel((Composite)titleAndLinksGroup, (String)"");
        SelectPublishingOptionsPage.createLabel((Composite)titleAndLinksGroup, (String)PublishingUIResources.aboutHTMLLabel_text);
        this.aboutHTMLText = SelectPublishingOptionsPage.createEditableText((Composite)titleAndLinksGroup, (String)"", (int)360, (int)1);
        this.selectHTMLButton = new Button((Composite)titleAndLinksGroup, 0);
        this.selectHTMLButton.setText(AuthoringUIText.SELECT_BUTTON_TEXT);
        SelectPublishingOptionsPage.createLabel((Composite)titleAndLinksGroup, (String)PublishingUIResources.feedbackURLLabel_text);
        this.feedbackURLText = SelectPublishingOptionsPage.createEditableText((Composite)titleAndLinksGroup, (String)"", (int)360, (int)1);
        SelectPublishingOptionsPage.createLabel((Composite)titleAndLinksGroup, (String)"");
        return titleAndLinksGroup;
    }

    protected Group createLookAndFeelGroup(Composite composite) {
        Group lookAndFeelGroup = SelectPublishingOptionsPage.createGridLayoutGroup((Composite)composite, (String)PublishingUIResources.lookAndFeelGroup_text, (int)3);
        SelectPublishingOptionsPage.createLabel((Composite)lookAndFeelGroup, (String)PublishingUIResources.bannerImageLabel_text);
        this.bannerImageText = SelectPublishingOptionsPage.createEditableText((Composite)lookAndFeelGroup, (String)"", (int)360, (int)1);
        this.selectImageButton = new Button((Composite)lookAndFeelGroup, 0);
        this.selectImageButton.setText(AuthoringUIText.SELECT_BUTTON_TEXT);
        return lookAndFeelGroup;
    }

    protected Group createGlossaryAndIndexGroup(Composite composite) {
        Group glossaryAndIndexGroup = SelectPublishingOptionsPage.createGridLayoutGroup((Composite)composite, (String)PublishingUIResources.glossaryAndIndexGroup_text, (int)2);
        this.publishGlossaryCheckbox = SelectPublishingOptionsPage.createCheckbox((Composite)glossaryAndIndexGroup, (String)PublishingUIResources.publishGlossaryLabel_text);
        this.publishIndexCheckbox = SelectPublishingOptionsPage.createCheckbox((Composite)glossaryAndIndexGroup, (String)PublishingUIResources.publishIndexLabel_text);
        return glossaryAndIndexGroup;
    }

    protected Group createValidation(Composite composite) {
        Group validationGroup = SelectPublishingOptionsPage.createGridLayoutGroup((Composite)composite, (String)PublishingUIResources.validationGroup_text, (int)2);
        this.checkExternalLinksCheckbox = SelectPublishingOptionsPage.createCheckbox((Composite)validationGroup, (String)PublishingUIResources.checkExternalLinksLabel_text);
        this.convertBrokenLinksCheckbox = SelectPublishingOptionsPage.createCheckbox((Composite)validationGroup, (String)PublishingUIResources.convertBrokenLinksLabel_text);
        return validationGroup;
    }

    protected Group createDiagramGenerationGroup(Composite composite) {
        Group diagramGroup = SelectPublishingOptionsPage.createGridLayoutGroup((Composite)composite, (String)PublishingUIResources.diagramGroup_text, (int)1);
        this.publishUnopenADDCheckbox = SelectPublishingOptionsPage.createCheckbox((Composite)diagramGroup, (String)PublishingUIResources.publishActivityDetailDiagramsLabel_text);
        this.publishBaseADCheckbox = SelectPublishingOptionsPage.createCheckbox((Composite)diagramGroup, (String)PublishingUIResources.publishExtendedActivityDiagramsLabel_text);
        return diagramGroup;
    }

    public Group getLayoutGroup() {
        return this.layoutGroup;
    }

    public void setLayoutGroup(Group layoutGroup) {
        this.layoutGroup = layoutGroup;
    }

    protected Group createLayoutGroup(Composite composite) {
        this.layoutGroup = SelectPublishingOptionsPage.createGridLayoutGroup((Composite)composite, (String)PublishingUIResources.layoutGroup_text, (int)1);
        this.publishLightWeightTreeCheckbox = SelectPublishingOptionsPage.createCheckbox((Composite)this.layoutGroup, (String)PublishingUIResources.publishLightWeightTreeLabel_text);
        this.showRelatedLinks = SelectPublishingOptionsPage.createCheckbox((Composite)this.layoutGroup, (String)PublishingUIResources.showRelatedLinks_text);
        this.showDescriptorsInNavigationTree = SelectPublishingOptionsPage.createCheckbox((Composite)this.layoutGroup, (String)PublishingUIResources.showDescriptorsInNavigationTree_text);
        this.extraDescriptorInfoCtr = SelectPublishingOptionsPage.createCheckbox((Composite)this.layoutGroup, (String)PublishingUIResources.publishExtraDescriptorInfoLabel_text);
        this.showRelatedDescriptors = SelectPublishingOptionsPage.createCheckbox((Composite)this.layoutGroup, (String)PublishingUIResources.showRelatedDescriptors_text);
        Composite descriptorComposite = SelectPublishingOptionsPage.createChildGridLayoutComposite((Composite)this.layoutGroup, (int)1);
        this.showRelatedDescriptorsOption = SelectPublishingOptionsPage.createCheckbox((Composite)descriptorComposite, (String)PublishingUIResources.showRelatedDescriptors_option_text);
        Composite activityTabComposite = SelectPublishingOptionsPage.createGridLayoutComposite((Composite)this.layoutGroup, (int)2);
        ((GridLayout)activityTabComposite.getLayout()).marginTop = -5;
        ((GridLayout)activityTabComposite.getLayout()).marginLeft = -5;
        SelectPublishingOptionsPage.createLabel((Composite)activityTabComposite, (String)PublishingUIResources.selectDefaultActivityTab_text);
        this.activityTabViewer = new ComboViewer(activityTabComposite, 2056);
        GridData gd = new GridData(769);
        this.activityTabViewer.getCombo().setLayoutData((Object)gd);
        LabelProvider labelProvider = new LabelProvider(){

            public String getText(Object param) {
                if (param instanceof Map.Entry) {
                    return (String)((Map.Entry)param).getValue();
                }
                return param.toString();
            }
        };
        this.activityTabViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        return this.layoutGroup;
    }

    protected void includeAdditionalPublishingOptions(Composite composite) {
    }

    protected void createPublishingOptionsGroups(Composite composite) {
    }

    protected void initControls() {
        String configId = this.config != null ? this.config.getGuid() : "";
        this.titleText.setText(PublishingUIPreferences.getTitle(configId));
        this.bannerImageText.setText(PublishingUIPreferences.getBannerImage(configId));
        this.aboutHTMLText.setText(PublishingUIPreferences.getAboutHTML(configId));
        this.feedbackURLText.setText(PublishingUIPreferences.getFeedbackURL(configId));
        this.publishGlossaryCheckbox.setSelection(PublishingUIPreferences.getIncludeGlossary(configId));
        this.publishIndexCheckbox.setSelection(PublishingUIPreferences.getIncludeIndex(configId));
        this.checkExternalLinksCheckbox.setSelection(PublishingUIPreferences.getCheckExternalLinks(configId));
        this.convertBrokenLinksCheckbox.setSelection(PublishingUIPreferences.getConvertBrokenLinks(configId));
        this.publishUnopenADDCheckbox.setSelection(PublishingUIPreferences.getPublishUnopenActivityDD(configId));
        this.publishBaseADCheckbox.setSelection(PublishingUIPreferences.getPublishADForActivityExtension(configId));
        this.publishLightWeightTreeCheckbox.setSelection(!PublishingUIPreferences.getLightWeightTree(configId));
        this.extraDescriptorInfoCtr.setSelection(PublishingUIPreferences.getExtraDescriptorInfo(configId));
        this.showRelatedDescriptors.setSelection(PublishingUIPreferences.getShowRelatedDescriptors(configId));
        this.showRelatedLinks.setSelection(PublishingUIPreferences.getShowRelatedLinks(configId));
        this.showRelatedDescriptorsOption.setSelection(PublishingUIPreferences.getShowRelatedDescriptorsOption(configId));
        if (this.showRelatedDescriptors.getSelection()) {
            this.showRelatedDescriptorsOption.setEnabled(true);
        } else {
            this.showRelatedDescriptorsOption.setEnabled(false);
        }
        AbstractElementLayout.processDescritorsNewOption = this.showRelatedDescriptorsOption.getSelection();
        this.showDescriptorsInNavigationTree.setSelection(PublishingUIPreferences.getShowDescriptorsInNavigationTree(configId));
        if (this.activityTabViewer.getCombo().getItemCount() == 0) {
            this.activityTabViewer.add(activityTabMap.entrySet().toArray());
        }
        this.activityTabViewer.getCombo().setText(activityTabMap.get(PublishingUIPreferences.getDefaultActivityTab(configId)));
    }

    protected void addListeners() {
        this.selectImageButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                try {
                    FileDialog dialog = new FileDialog(SelectPublishingOptionsPage.this.shell, 4096);
                    dialog.setFilterExtensions(new String[]{"*.gif", "*.jpg", "*.bmp"});
                    String imageFile = dialog.open();
                    if (imageFile != null) {
                        SelectPublishingOptionsPage.this.bannerImageText.setText(imageFile);
                    }
                }
                catch (Exception e) {
                    PublishingUIPlugin.getDefault().getLogger().logError((Throwable)e);
                }
            }
        });
        this.selectHTMLButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                try {
                    FileDialog dialog = new FileDialog(SelectPublishingOptionsPage.this.shell, 4096);
                    dialog.setFilterExtensions(new String[]{"*.htm", "*.html"});
                    String htmlFile = dialog.open();
                    if (htmlFile != null) {
                        SelectPublishingOptionsPage.this.aboutHTMLText.setText(htmlFile);
                    }
                }
                catch (Exception e) {
                    PublishingUIPlugin.getDefault().getLogger().logError((Throwable)e);
                }
            }
        });
        this.aboutHTMLText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SelectPublishingOptionsPage.this.setPageComplete(SelectPublishingOptionsPage.this.isPageComplete());
            }
        });
        this.showRelatedDescriptors.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (SelectPublishingOptionsPage.this.showRelatedDescriptors.getSelection()) {
                    SelectPublishingOptionsPage.this.showRelatedDescriptorsOption.setEnabled(true);
                } else {
                    SelectPublishingOptionsPage.this.showRelatedDescriptorsOption.setSelection(false);
                    AbstractElementLayout.processDescritorsNewOption = false;
                    SelectPublishingOptionsPage.this.showRelatedDescriptorsOption.setEnabled(false);
                }
            }
        });
        this.showRelatedDescriptorsOption.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                AbstractElementLayout.processDescritorsNewOption = SelectPublishingOptionsPage.this.showRelatedDescriptorsOption.getSelection();
            }
        });
    }

    public void onEnterPage(Object obj) {
        if (obj != null && obj instanceof MethodConfiguration) {
            MethodConfiguration selectedConfig = (MethodConfiguration)obj;
            if (!this.selectedConfigs.contains(selectedConfig)) {
                this.selectedConfigs.add(selectedConfig);
            }
            if (selectedConfig != this.config) {
                this.config = selectedConfig;
                this.initControls();
            }
        }
        Point size = this.composite.getSize();
        Point parentSize = this.composite.getParent().getSize();
        int borderWidth = this.composite.getParent().getBorderWidth();
        if (size.x < parentSize.x - 2 * borderWidth) {
            this.composite.setSize(parentSize.x - 2 * borderWidth, size.y);
        }
    }

    public boolean isPageComplete() {
        String path = this.aboutHTMLText.getText();
        IPath ecPath = Path.fromOSString((String)path);
        boolean isValid = ecPath.isValidPath(path);
        if (!isValid) {
            this.setErrorMessage(PublishingUIResources.invalidAboutPathError_msg);
            return false;
        }
        if (!StrUtil.isValidPublishPath((String)path)) {
            this.setErrorMessage(PublishingUIResources.invalidAboutPathCharsError_msg);
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }

    public Object getNextPageData() {
        return this.config;
    }

    public PublishOptions getPublishingOptions() {
        PublishHTMLOptions options = new PublishHTMLOptions();
        options.setTitle(this.getWebSiteTitle());
        options.setBannerImage(this.getBannerImagePath());
        options.setAboutHTML(this.getAboutHTMLPath());
        options.setFeedbackURL(this.getFeedbackURL());
        options.setPublishGlossary(this.getPublishGlossarySelection());
        options.setPublishIndex(this.getPublishIndexSelection());
        options.setCheckExternalLinks(this.getCheckExternalLinksSelection());
        options.setPublishUnopenADD(this.getPublishUnopenADDSelection());
        options.setPublishBaseAD(this.getPublishBaseADSelection());
        options.setConvertBrokenLinks(this.getConvertBrokenLinksSelection());
        options.setPublishLightWeightTree(this.getPublishLightWeightTreeSelection());
        options.setShowMethodContentInDescriptors(this.getShowExtraDescriptorInfoSelection());
        options.setShowRelatedDescriptors(this.showRelatedDescriptors.getSelection());
        options.setShowRelatedDescriptorsOption(this.showRelatedDescriptorsOption.getSelection());
        options.setShowRelatedLinks(this.showRelatedLinks.getSelection());
        options.setShowDescriptorsInNavigationTree(this.showDescriptorsInNavigationTree.getSelection());
        String defaultActivityTab = this.getDefaultActivityTabSelection();
        if (defaultActivityTab != null) {
            options.setDefaultActivityTab(defaultActivityTab);
        }
        return options;
    }

    protected String getWebSiteTitle() {
        return this.titleText.getText().trim();
    }

    protected String getBannerImagePath() {
        return this.bannerImageText.getText().trim();
    }

    protected String getAboutHTMLPath() {
        return this.aboutHTMLText.getText().trim();
    }

    protected String getFeedbackURL() {
        return this.feedbackURLText.getText().trim();
    }

    protected boolean getPublishGlossarySelection() {
        return this.publishGlossaryCheckbox.getSelection();
    }

    protected boolean getPublishIndexSelection() {
        return this.publishIndexCheckbox.getSelection();
    }

    protected boolean getCheckExternalLinksSelection() {
        return this.checkExternalLinksCheckbox.getSelection();
    }

    protected boolean getConvertBrokenLinksSelection() {
        return this.convertBrokenLinksCheckbox.getSelection();
    }

    protected boolean getPublishUnopenADDSelection() {
        return this.publishUnopenADDCheckbox.getSelection();
    }

    protected boolean getPublishBaseADSelection() {
        return this.publishBaseADCheckbox.getSelection();
    }

    protected boolean getPublishLightWeightTreeSelection() {
        return !this.publishLightWeightTreeCheckbox.getSelection();
    }

    protected boolean getShowExtraDescriptorInfoSelection() {
        return this.extraDescriptorInfoCtr.getSelection();
    }

    protected boolean getShowRelatedDescriptorsSelection() {
        return this.showRelatedDescriptors.getSelection();
    }

    protected boolean getShowRelatedDescriptorsOptionSelection() {
        return this.showRelatedDescriptorsOption.getSelection();
    }

    protected boolean getShowRelatedLinksSelection() {
        return this.showRelatedLinks.getSelection();
    }

    protected boolean getShowDescriptorsInNavigationTreeSelection() {
        return this.showDescriptorsInNavigationTree.getSelection();
    }

    protected String getDefaultActivityTabSelection() {
        IStructuredSelection sel = (IStructuredSelection)this.activityTabViewer.getSelection();
        Map.Entry item = (Map.Entry)sel.getFirstElement();
        if (item == null) {
            return null;
        }
        return (String)item.getKey();
    }

    public void savePreferences() {
        if (this.config != null) {
            String configId = this.config.getGuid();
            this.saveTitleAndLinksPreferences(configId);
            this.saveGlossaryAndIndexPreferences(configId);
            this.saveValidationPreferences(configId);
            this.saveDiagramGenerationPreferences(configId);
            this.saveLayoutPreferences(configId);
        }
    }

    protected void saveTitleAndLinksPreferences(String configId) {
        PublishingUIPreferences.setTitle(configId, this.getWebSiteTitle());
        PublishingUIPreferences.setBannerImage(configId, this.getBannerImagePath());
        PublishingUIPreferences.setAboutHTML(configId, this.getAboutHTMLPath());
        PublishingUIPreferences.setFeedbackURL(configId, this.getFeedbackURL());
    }

    protected void saveGlossaryAndIndexPreferences(String configId) {
        PublishingUIPreferences.setIncludeGlossary(configId, this.getPublishGlossarySelection());
        PublishingUIPreferences.setIncludeIndex(configId, this.getPublishIndexSelection());
    }

    protected void saveValidationPreferences(String configId) {
        PublishingUIPreferences.setCheckExternalLinks(configId, this.getCheckExternalLinksSelection());
        PublishingUIPreferences.setConvertBrokenLinks(configId, this.getConvertBrokenLinksSelection());
    }

    protected void saveDiagramGenerationPreferences(String configId) {
        PublishingUIPreferences.setPublishUnopenActivityDD(configId, this.getPublishUnopenADDSelection());
        PublishingUIPreferences.setPublishADForActivityExtension(configId, this.getPublishBaseADSelection());
    }

    protected void saveLayoutPreferences(String configId) {
        PublishingUIPreferences.setLightWeightTree(configId, this.getPublishLightWeightTreeSelection());
        PublishingUIPreferences.setExtraDescriptorInfo(configId, this.getShowExtraDescriptorInfoSelection());
        PublishingUIPreferences.setShowRelatedDescriptors(configId, this.getShowRelatedDescriptorsSelection());
        PublishingUIPreferences.setShowRelatedDescriptorsOption(configId, this.getShowRelatedDescriptorsOptionSelection());
        PublishingUIPreferences.setShowRelatedLinks(configId, this.getShowRelatedLinksSelection());
        PublishingUIPreferences.setShowDescriptorsInNavigationTree(configId, this.getShowDescriptorsInNavigationTreeSelection());
        PublishingUIPreferences.setDefaultActivityTab(configId, this.getDefaultActivityTabSelection());
    }
}

