/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.xmi;

import com.ibm.icu.util.Calendar;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.epf.common.service.versioning.VersionUtil;
import org.eclipse.epf.common.serviceability.DebugTrace;
import org.eclipse.epf.library.AbstractLibraryManager;
import org.eclipse.epf.library.ILibraryResourceManager;
import org.eclipse.epf.library.LibraryAlreadyExistsException;
import org.eclipse.epf.library.LibraryNotFoundException;
import org.eclipse.epf.library.LibraryResources;
import org.eclipse.epf.library.LibraryServiceException;
import org.eclipse.epf.library.layout.LayoutResources;
import org.eclipse.epf.library.persistence.ILibraryResourceSet;
import org.eclipse.epf.library.persistence.PersistenceService;
import org.eclipse.epf.library.project.MethodLibraryProject;
import org.eclipse.epf.library.util.ModelStorage;
import org.eclipse.epf.library.xmi.XMILibraryPlugin;
import org.eclipse.epf.library.xmi.XMILibraryResourceManager;
import org.eclipse.epf.library.xmi.XMILibraryResources;
import org.eclipse.epf.library.xmi.XMILibraryUtil;
import org.eclipse.epf.persistence.MultiFileResourceSetImpl;
import org.eclipse.epf.persistence.migration.MappingUtil;
import org.eclipse.epf.persistence.util.PersistenceUtil;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMILibraryManager
extends AbstractLibraryManager {
    public static final String LIBRARY_TYPE = "xmi";
    public static final String LIBRARY_XMI = "library.xmi";
    public static final String exportFile = "export.xmi";
    public static final String ARG_LIBRARY_PATH = "library.path";
    protected String path;
    private ILibraryResourceManager resourceMgr = new XMILibraryResourceManager();
    private IProject project;
    private String registerType = "Default";

    public MethodLibrary createMethodLibrary(final String name, final Map<String, Object> args) throws LibraryServiceException {
        final MethodLibrary[] resultHolder = new MethodLibrary[1];
        final LibraryServiceException[] exceptionHolder = new LibraryServiceException[1];
        IWorkspaceRunnable action = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                try {
                    resultHolder[0] = XMILibraryManager.this.doCreateMethodLibrary(name, args);
                }
                catch (LibraryServiceException e) {
                    exceptionHolder[0] = e;
                }
            }
        };
        try {
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            workspace.run(action, workspace.getRuleFactory().createRule((IResource)workspace.getRoot()), 1, null);
        }
        catch (CoreException e) {
            XMILibraryPlugin.getDefault().getLogger().logError((Throwable)e);
            throw new LibraryServiceException((Throwable)e);
        }
        if (exceptionHolder[0] != null) {
            throw exceptionHolder[0];
        }
        return resultHolder[0];
    }

    private MethodLibrary doCreateMethodLibrary(String name, Map<String, Object> args) throws LibraryServiceException {
        if (debug) {
            DebugTrace.print((Object)((Object)this), (String)"createMethodLibrary", (String)("name=" + name));
        }
        if (name == null || name.length() == 0 || args == null) {
            throw new IllegalArgumentException();
        }
        String path = (String)args.get(ARG_LIBRARY_PATH);
        if (path == null || path.length() == 0) {
            throw new IllegalArgumentException();
        }
        File libraryPath = new File(path);
        File libraryXMIFile = new File(libraryPath, LIBRARY_XMI);
        if (libraryXMIFile.exists()) {
            String msg = NLS.bind((String)XMILibraryResources.libraryAlreadyExistsError_msg, (Object)libraryPath.getAbsolutePath());
            throw new LibraryAlreadyExistsException(msg);
        }
        if (!libraryPath.exists()) {
            libraryPath.mkdirs();
        }
        try {
            this.skipEventProcessing = true;
            String regType = (String)args.get("libraryRegisterType");
            if (regType != null && regType.equals("ConfigExport")) {
                String time = Long.toHexString(Calendar.getInstance().getTimeInMillis());
                MethodLibraryProject.openProject((String)libraryPath.getAbsolutePath(), (String)("ExportLib" + time), null);
            } else {
                this.project = MethodLibraryProject.openProject((String)libraryPath.getAbsolutePath(), null);
            }
            ILibraryResourceSet resourceSet = (ILibraryResourceSet)this.editingDomain.getResourceSet();
            ModelStorage.newLibrary((ILibraryResourceSet)resourceSet, (String)name, (String)libraryPath.getAbsolutePath(), (boolean)true);
            this.library = resourceSet.getFirstMethodLibrary();
            this.addResourceChangedListeners();
            if (debug) {
                DebugTrace.print((Object)((Object)this), (String)"createMethodLibrary", (String)("library=" + this.library));
            }
            MethodLibrary methodLibrary = this.library;
            return methodLibrary;
        }
        catch (Exception e) {
            throw new LibraryServiceException((Throwable)e);
        }
        finally {
            this.skipEventProcessing = false;
        }
    }

    public MethodLibrary openMethodLibrary(java.net.URI uri) throws LibraryServiceException {
        if (debug) {
            DebugTrace.print((Object)((Object)this), (String)"openMethodLibrary");
        }
        if (uri == null) {
            throw new IllegalArgumentException();
        }
        try {
            File file = new File(uri);
            this.library = this.openMethodLibrary(file);
        }
        catch (LibraryServiceException e) {
            throw e;
        }
        catch (Exception exception) {
            this.library = null;
        }
        if (debug) {
            DebugTrace.print((Object)((Object)this), (String)"openMethodLibrary", (String)("library=" + this.library));
        }
        return this.library;
    }

    protected MethodLibrary openMethodLibrary(File path) throws LibraryServiceException {
        File libraryXMIFile = new File(path, LIBRARY_XMI);
        if (!libraryXMIFile.exists()) {
            throw new LibraryNotFoundException();
        }
        VersionUtil.VersionCheckInfo info = VersionUtil.checkLibraryVersion((File)libraryXMIFile);
        IStatus status = XMILibraryUtil.checkVersion(libraryXMIFile, info);
        if (!status.isOK()) {
            throw new LibraryServiceException(status.getMessage());
        }
        if (MappingUtil.conversionRequired((String)libraryXMIFile.getAbsolutePath(), (VersionUtil.VersionCheckInfo)info)) {
            throw new LibraryServiceException(LibraryResources.libUpgradeRequired_err_msg);
        }
        try {
            this.skipEventProcessing = true;
            this.project = MethodLibraryProject.openProject((String)path.getAbsolutePath(), null);
            ILibraryResourceSet resourceSet = (ILibraryResourceSet)this.editingDomain.getResourceSet();
            resourceSet.loadMethodLibraries(URI.createFileURI((String)libraryXMIFile.getAbsolutePath()), Collections.EMPTY_MAP);
            this.library = resourceSet.getFirstMethodLibrary();
            this.addResourceChangedListeners();
            System.gc();
            MethodLibrary methodLibrary = this.library;
            return methodLibrary;
        }
        catch (Exception e) {
            if (debug) {
                DebugTrace.print((Throwable)e);
            }
            throw new LibraryServiceException((Throwable)e);
        }
        finally {
            this.firePropertyChange(this.library, 1);
            this.skipEventProcessing = false;
        }
    }

    public MethodLibrary openMethodLibrary(Map args) throws LibraryServiceException {
        if (debug) {
            DebugTrace.print((Object)((Object)this), (String)"openMethodLibrary");
        }
        if (args == null) {
            throw new IllegalArgumentException();
        }
        String path = (String)args.get(ARG_LIBRARY_PATH);
        if (path == null || path.length() == 0) {
            throw new IllegalArgumentException();
        }
        this.library = this.openMethodLibrary(new File(path));
        if (debug) {
            DebugTrace.print((Object)((Object)this), (String)"openMethodLibrary", (String)("library=" + this.library));
        }
        return this.library;
    }

    public MethodLibrary reopenMethodLibrary() throws LibraryServiceException {
        if (debug) {
            DebugTrace.print((Object)((Object)this), (String)"reopenMethodLibrary");
        }
        this.library = this.openMethodLibrary(new File(this.getMethodLibraryLocation()));
        if (debug) {
            DebugTrace.print((Object)((Object)this), (String)"reopenMethodLibrary", (String)("library=" + this.library));
        }
        return this.library;
    }

    protected String getLibraryPersisterType() {
        return LIBRARY_TYPE;
    }

    protected ILibraryResourceSet createResourceSet() {
        return PersistenceService.INSTANCE.createResourceSet(LIBRARY_TYPE);
    }

    public String getMethodLibraryLocation() {
        java.net.URI libraryURI;
        if (debug) {
            DebugTrace.print((Object)((Object)this), (String)"getMethodLibraryPath");
        }
        if ((libraryURI = this.getMethodLibraryURI()) != null) {
            File libraryXMIFile = new File(libraryURI);
            if (libraryXMIFile.getName().equalsIgnoreCase(LIBRARY_XMI)) {
                libraryXMIFile = libraryXMIFile.getParentFile();
            }
            return libraryXMIFile.getAbsolutePath();
        }
        return null;
    }

    public IProject getMethodLibraryProject() {
        return this.project;
    }

    public void handleLibraryMoved() {
        if (this.library == null) {
            return;
        }
        String location = this.getMethodLibraryLocation();
        if (!this.project.isOpen() || this.project.getLocation().equals((Object)new Path(location))) {
            return;
        }
        Resource libResource = this.library.eResource();
        if (libResource == null || libResource.getResourceSet() == null) {
            return;
        }
        String newLocation = this.project.getLocation().toOSString();
        if (libResource.getResourceSet() instanceof MultiFileResourceSetImpl) {
            ((MultiFileResourceSetImpl)libResource.getResourceSet()).handleLibraryMoved(newLocation);
        } else {
            PersistenceUtil.replaceURIPrefix(new ArrayList(libResource.getResourceSet().getResources()), (String)location, (String)newLocation);
        }
    }

    public ILibraryResourceManager getResourceManager() {
        return this.resourceMgr;
    }

    public void backupMethodLibrary(String path) {
        String libPathStr = this.getMethodLibraryLocation();
        File libPath = new File(libPathStr);
        String excludes = ".lock";
        LayoutResources.copyDir((File)libPath, (File)new File(path), (String)"**", (String)excludes);
    }

    private String getRegisterType() {
        return this.registerType;
    }

    private void setRegisterType(String registerType) {
        this.registerType = registerType;
    }

    public void registerMethodLibrary(MethodLibrary lib, Map<String, Object> params) throws LibraryServiceException {
        String regType = (String)params.get("libraryRegisterType");
        if (regType != null) {
            this.setRegisterType(regType);
        }
        if ((regType = this.getRegisterType()).equals("ConfigExport")) {
            String name = LIBRARY_XMI;
            this.createMethodLibrary(name, params);
            this.setMethodLibrary(lib);
            return;
        }
        this.library = lib;
    }

    public void unRegisterMethodLibrary() throws LibraryServiceException {
        if (this.getRegisterType().equals("ConfigExport")) {
            this.closeMethodLibrary();
            return;
        }
        this.library = null;
    }
}

