/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.ui.dialogs;

import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.epf.library.edit.command.UserInput;
import org.eclipse.epf.library.edit.validation.IValidator;
import org.eclipse.epf.library.ui.providers.DelegateLabelProvider;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class UserInputsDialog
extends Dialog {
    IStructuredContentProvider contentProvider;
    ILabelProvider labelProvider;
    private String title;
    private String globalErrorTxt = "";
    private String message;
    private List userInputs;
    private boolean result = false;
    Label messageArea;
    Label errorArea;
    HashMap<Object, Object> oldInfoForCancel;
    private Color redColor;

    public UserInputsDialog(Shell parentShell, List userInputs, String title, String message) {
        super(parentShell);
        this.title = title;
        this.message = message;
        this.userInputs = userInputs;
        this.oldInfoForCancel = new HashMap();
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    protected void createTreeViewer(Composite parent, UserInput userInput) {
        TreeViewer viewer = !userInput.isMultiple() ? new TreeViewer(parent, 2820) : new TreeViewer(parent, 2818);
        GridData spec = new GridData(1808);
        spec.widthHint = 200;
        spec.heightHint = 200;
        spec.horizontalSpan = 3;
        viewer.getControl().setLayoutData((Object)spec);
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
            }
        });
        if (viewer != null) {
            viewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
            if (this.contentProvider != null) {
                viewer.setContentProvider((IContentProvider)this.contentProvider);
            } else {
                viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
            }
            viewer.setUseHashlookup(true);
            viewer.setInput((Object)userInput.getChoices());
            viewer.getControl().setFont(parent.getFont());
        }
    }

    protected void createTableViewer(Composite parent, UserInput userInput) {
        TableViewer viewer = new TableViewer(parent);
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
            }
        });
    }

    protected void createText(Composite parent, UserInput userInput) {
        final UserInput localinput = userInput;
        final IValidator validator = userInput.getValidator();
        final Text text = new Text(parent, 2052);
        text.setLayoutData((Object)new GridData(4, 4, true, true));
        if (userInput.getInput() != null) {
            text.setText((String)userInput.getInput());
        }
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                UserInputsDialog.this.getButton(0).setEnabled(true);
                UserInputsDialog.this.errorArea.setText("");
                String errorTxt = "";
                if (validator != null) {
                    errorTxt = validator.isValid(text.getText());
                    if (errorTxt != null && errorTxt.length() > 0) {
                        UserInputsDialog.this.errorArea.setText(errorTxt);
                        UserInputsDialog.this.getButton(0).setEnabled(false);
                    } else {
                        UserInputsDialog.this.errorArea.setText("");
                    }
                    UserInputsDialog.this.globalErrorTxt = errorTxt;
                }
                if (errorTxt == null || errorTxt.length() <= 0) {
                    localinput.setInput((Object)text.getText());
                }
            }
        });
        text.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                String errorTxt = "";
                if (validator != null) {
                    errorTxt = validator.isValid(text.getText());
                    if (errorTxt != null && errorTxt.length() > 0) {
                        UserInputsDialog.this.errorArea.setText(errorTxt);
                        UserInputsDialog.this.getButton(0).setEnabled(false);
                    } else {
                        UserInputsDialog.this.errorArea.setText("");
                    }
                    UserInputsDialog.this.globalErrorTxt = errorTxt;
                }
                if (errorTxt == null || errorTxt.length() <= 0) {
                    localinput.setInput((Object)text.getText());
                }
            }
        });
    }

    protected void setInput(UserInput input, Object obj) {
        input.setInput(obj);
    }

    protected void createComboViewer(Composite composite, UserInput userInput) {
        final UserInput localInput = userInput;
        final IValidator validator = userInput.getValidator();
        final ComboViewer viewer = new ComboViewer(composite);
        viewer.getCombo().setLayoutData((Object)new GridData(4, 4, true, true));
        viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        if (userInput.getLabelProvider() != null) {
            viewer.setLabelProvider((IBaseLabelProvider)new DelegateLabelProvider(userInput.getLabelProvider()));
        }
        List choices = userInput.getChoices();
        viewer.setInput((Object)choices);
        if (choices != null && choices.size() > 0) {
            viewer.setSelection((ISelection)new StructuredSelection(choices.get(0)));
            localInput.setInput(choices.get(0));
        }
        viewer.getCombo().addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                String errorTxt = "";
                IStructuredSelection selected = (IStructuredSelection)viewer.getSelection();
                if (validator == null || selected == null) {
                    return;
                }
                IStatus status = validator.isValid(selected.getFirstElement());
                if (status.getSeverity() == 4) {
                    errorTxt = status.getMessage();
                }
                if (errorTxt != null && errorTxt.length() > 0) {
                    UserInputsDialog.this.errorArea.setText(errorTxt);
                    UserInputsDialog.this.getButton(0).setEnabled(false);
                }
                if (UserInputsDialog.this.globalErrorTxt != null && UserInputsDialog.this.globalErrorTxt.length() > 0) {
                    UserInputsDialog.this.errorArea.setText(UserInputsDialog.this.globalErrorTxt);
                    UserInputsDialog.this.getButton(0).setEnabled(false);
                } else {
                    UserInputsDialog.this.errorArea.setText("");
                }
            }
        });
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                UserInputsDialog.this.getButton(0).setEnabled(true);
                UserInputsDialog.this.errorArea.setText("");
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                Object obj = selection.getFirstElement();
                String errorTxt = "";
                if (validator != null) {
                    IStatus status = validator.isValid(obj);
                    if (status.getCode() == 4) {
                        errorTxt = status.getMessage();
                    }
                    if (errorTxt != null && errorTxt.length() > 0) {
                        UserInputsDialog.this.errorArea.setText(errorTxt);
                    } else if (UserInputsDialog.this.globalErrorTxt != null && UserInputsDialog.this.globalErrorTxt.length() > 0) {
                        UserInputsDialog.this.errorArea.setText(UserInputsDialog.this.globalErrorTxt);
                        UserInputsDialog.this.getButton(0).setEnabled(false);
                    } else {
                        UserInputsDialog.this.errorArea.setText("");
                    }
                }
                if (errorTxt == null || errorTxt.length() <= 0) {
                    localInput.setInput(obj);
                }
            }
        });
    }

    protected Label createMessageArea(Composite composite) {
        Composite messageAreaComp = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginLeft = 0;
        messageAreaComp.setLayout((Layout)gridLayout);
        GridData gd = new GridData(1808);
        messageAreaComp.setLayoutData((Object)gd);
        this.messageArea = new Label(messageAreaComp, 64);
        if (this.message != null) {
            this.messageArea.setText(this.message);
        }
        gd = new GridData(768);
        gd.minimumWidth = 400;
        this.messageArea.setLayoutData((Object)gd);
        UserInputsDialog.applyDialogFont((Control)this.messageArea);
        Label separator = new Label(messageAreaComp, 258);
        GridData gd1 = new GridData(768);
        gd1.horizontalSpan = 2;
        separator.setLayoutData((Object)gd1);
        return this.messageArea;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        composite.setFont(parent.getFont());
        GridLayout layout = (GridLayout)composite.getLayout();
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        this.createMessageArea(composite);
        Composite dialogArea = new Composite(composite, 0);
        GridLayout dialogLayout = new GridLayout(2, false);
        dialogLayout.marginLeft = 0;
        dialogArea.setLayout((Layout)new GridLayout(2, false));
        GridData gd = new GridData(1808);
        dialogArea.setLayoutData((Object)gd);
        if (this.userInputs != null && this.userInputs.size() > 0) {
            for (Object object : this.userInputs) {
                if (!(object instanceof UserInput)) continue;
                UserInput userInput = (UserInput)object;
                this.oldInfoForCancel.put(userInput, userInput.getInput());
                Label label = new Label(dialogArea, 0);
                label.setText(userInput.getLabel());
                GridData gridData = new GridData(1);
                label.setLayoutData((Object)gridData);
                if (userInput.getType() == 0) {
                    this.createText(dialogArea, userInput);
                    continue;
                }
                if (userInput.getType() != 1) continue;
                this.createComboViewer(dialogArea, userInput);
            }
        }
        this.createErrorArea(composite);
        return composite;
    }

    private void createErrorArea(Composite composite) {
        Composite errorAreaComp = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.marginLeft = 0;
        errorAreaComp.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        errorAreaComp.setLayoutData((Object)gd);
        this.errorArea = new Label(errorAreaComp, 64);
        this.redColor = new Color(null, new RGB(255, 0, 0));
        if (this.redColor != null) {
            this.errorArea.setForeground(this.redColor);
        }
        gd = new GridData(1792);
        gd.heightHint = 80;
        this.errorArea.setLayoutData((Object)gd);
        UserInputsDialog.applyDialogFont((Control)this.errorArea);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        if (this.title != null) {
            newShell.setText(this.title);
        }
    }

    protected void okPressed() {
        this.result = true;
        super.okPressed();
    }

    protected void cancelPressed() {
        if (this.userInputs != null && this.userInputs.size() > 0) {
            for (Object object : this.userInputs) {
                if (!(object instanceof UserInput)) continue;
                UserInput userInput = (UserInput)object;
                userInput.setInput(this.oldInfoForCancel.get(userInput));
            }
        }
        super.cancelPressed();
    }

    public boolean getResult() {
        return this.result;
    }

    public boolean close() {
        if (this.redColor != null) {
            this.redColor.dispose();
        }
        return super.close();
    }
}

