/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.importing.services;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.epf.common.IActivator;
import org.eclipse.epf.common.ui.util.MsgBox;
import org.eclipse.epf.common.ui.util.MsgDialog;
import org.eclipse.epf.importing.ImportPlugin;
import org.eclipse.epf.importing.ImportResources;
import org.eclipse.epf.library.services.SafeUpdateController;
import org.eclipse.epf.services.IFileManager;
import org.eclipse.epf.services.Services;

public class FileModifyChecker {
    public static IStatus checkModify(List modifiedFiles) {
        try {
            String[] paths = new String[modifiedFiles.size()];
            modifiedFiles.toArray(paths);
            IFileManager fileMgr = Services.getFileManager();
            IStatus status = fileMgr.checkModify(paths, (Object)MsgBox.getDefaultShell());
            ArrayList<String> readonlyFiles = new ArrayList<String>();
            int i = 0;
            while (i < paths.length) {
                File f = new File(paths[i]);
                if (f.exists() && !f.canWrite()) {
                    readonlyFiles.add(paths[i]);
                }
                ++i;
            }
            if (readonlyFiles.size() > 0) {
                String title = ImportResources.FileModifyChecker_Checkout_failed_title;
                String msg = ImportResources.FileModifyChecker_Checkout_failed_msg;
                if (new MsgDialog((IActivator)ImportPlugin.getDefault()).displayPrompt(title, msg)) {
                    return FileModifyChecker.checkModify(readonlyFiles);
                }
            }
            return status;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return new Status(4, ImportPlugin.getDefault().getId(), 0, e.getMessage() == null ? "" : e.getMessage(), null);
        }
    }

    public static IStatus syncExecCheckModify(final List modifiedFiles) {
        final IStatus[] ret = new IStatus[1];
        SafeUpdateController.syncExec((Runnable)new Runnable(){

            public void run() {
                ret[0] = FileModifyChecker.checkModify(modifiedFiles);
            }
        });
        return ret[0];
    }

    public static List getModifiedFiles(ResourceSet resourceSet) {
        ArrayList<String> ret = new ArrayList<String>();
        for (Resource res : resourceSet.getResources()) {
            if (res == null || !res.isModified()) continue;
            ret.add(res.getURI().toFileString());
        }
        return ret;
    }
}

