/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.importing.wizards;

import org.eclipse.epf.importing.ImportResources;
import org.eclipse.epf.importing.services.ConfigurationImportData;
import org.eclipse.epf.importing.wizards.DiffReportContentProvider;
import org.eclipse.epf.importing.wizards.DiffReportLabelProvider;
import org.eclipse.epf.library.util.LibraryUtil;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;

public class DiffReportViewer {
    protected Composite parent;
    protected CheckboxTreeViewer treeViewer;
    ConfigurationImportData data;

    DiffReportViewer(Composite parent, ConfigurationImportData data) {
        this.parent = parent;
        this.data = data;
        this.treeViewer = new CheckboxTreeViewer(parent);
        this.treeViewer.getControl().setLayoutData((Object)new GridData(1808));
        this.treeViewer.setContentProvider((IContentProvider)new DiffReportContentProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new DiffReportLabelProvider());
        this.createTableColumns();
        this.addListeners();
    }

    private void createTableColumns() {
        Tree tree = this.treeViewer.getTree();
        tree.setLayoutData((Object)new GridData(1808));
        tree.setHeaderVisible(true);
        tree.setLinesVisible(true);
        TreeColumn column = new TreeColumn(tree, 0, 0);
        column.setText(ImportResources.DiffReportViewer_content);
        column.setWidth(200);
        column = new TreeColumn(tree, 0, 1);
        column.setText(ImportResources.DiffReportViewer_type);
        column.setWidth(150);
        column = new TreeColumn(tree, 0, 2);
        column.setText(ImportResources.DiffReportViewer_in_import);
        column.setWidth(75);
        column = new TreeColumn(tree, 0, 3);
        column.setText(ImportResources.DiffReportViewer_in_lib);
        column.setWidth(75);
        column = new TreeColumn(tree, 0, 4);
        column.setText(ImportResources.DiffReportViewer_status);
        column.setWidth(100);
    }

    public void showReport(Object input) {
        this.treeViewer.getTree().setVisible(false);
        this.treeViewer.setInput(input);
        this.setCheckStates();
        this.treeViewer.expandAll();
        this.treeViewer.getTree().setVisible(true);
    }

    private void addListeners() {
        this.treeViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                boolean checked = event.getChecked();
                DiffReportViewer.this.updateCheckStates(event.getElement(), checked);
            }
        });
    }

    private void updateCheckStates(Object element, boolean checked) {
        if (checked) {
            ITreeContentProvider cp = (ITreeContentProvider)this.treeViewer.getContentProvider();
            this.checkParent(cp, element);
        } else {
            this.treeViewer.setChecked(element, false);
        }
        this.selectionChildren(element, checked);
        this.setData(this.treeViewer.getCheckedElements());
    }

    public void selectionChildren(Object element, boolean checked) {
        ITreeContentProvider cp = (ITreeContentProvider)this.treeViewer.getContentProvider();
        Object[] childs = cp.getChildren(element);
        int i = 0;
        while (i < childs.length) {
            this.treeViewer.setChecked(childs[i], checked);
            this.selectionChildren(childs[i], checked);
            ++i;
        }
    }

    private void checkParent(ITreeContentProvider cp, Object element) {
        if (element == null || element instanceof MethodLibrary) {
            return;
        }
        Object parent = LibraryUtil.unwrap((Object)cp.getParent(element));
        if (parent != null) {
            this.treeViewer.setChecked(parent, true);
            this.checkParent(cp, parent);
        }
    }

    private void setCheckStates() {
        this.treeViewer.getTree().setVisible(false);
        try {
            Object element = this.treeViewer.getInput();
            this.selectionChildren(element, true);
        }
        finally {
            this.treeViewer.getTree().setVisible(true);
        }
        this.setData(this.treeViewer.getCheckedElements());
    }

    private void setData(Object[] sels) {
        if (sels == null) {
            return;
        }
        this.data.importList.clear();
        int i = 0;
        while (i < sels.length) {
            this.data.importList.add(sels[i]);
            ++i;
        }
    }
}

