/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.epf.library.ILibraryManager;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.LibraryServiceUtil;
import org.eclipse.epf.library.configuration.ConfigurationHelper;
import org.eclipse.epf.library.edit.configuration.PracticeSubgroupItemProvider;
import org.eclipse.epf.library.edit.process.ActivityWrapperItemProvider;
import org.eclipse.epf.library.edit.process.BreakdownElementWrapperItemProvider;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.layout.HtmlBuilder;
import org.eclipse.epf.library.layout.IElementLayout;
import org.eclipse.epf.library.layout.elements.AbstractElementLayout;
import org.eclipse.epf.library.layout.elements.AbstractProcessElementLayout;
import org.eclipse.epf.library.layout.elements.ElementLayoutExtender;
import org.eclipse.epf.library.layout.elements.SummaryPageLayout;
import org.eclipse.epf.library.persistence.ILibraryResourceSet;
import org.eclipse.epf.library.util.LibraryUtil;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.ContentCategory;
import org.eclipse.epf.uma.CustomCategory;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.epf.uma.MethodPackage;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.epf.uma.Process;
import org.eclipse.epf.uma.ProcessComponent;
import org.eclipse.epf.uma.ProcessPackage;
import org.eclipse.epf.uma.ecore.impl.MultiResourceEObject;
import org.eclipse.epf.uma.ecore.util.OppositeFeature;
import org.eclipse.swt.SWT;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigHelperDelegate {
    public boolean isSystemPackage(MethodPlugin plugin, MethodPackage pkg) {
        return TngUtil.getAllSystemPackages((MethodPlugin)plugin).contains(pkg);
    }

    public void loadOppositeFeatures(ILibraryResourceSet resouceSet, List<OppositeFeature> oppositeFeatures, MethodElement element) {
        HashSet<String> GUIDs = new HashSet<String>();
        GUIDs.add(element.getGuid());
        resouceSet.loadOppositeFeatures(oppositeFeatures, GUIDs);
    }

    public boolean isOwnerSelected(MethodElement element, MethodConfiguration config, boolean checkSubtracted) {
        Process owningProc;
        Activity base;
        List subtractedCategories;
        ILibraryManager libraryManager;
        MethodLibrary library = LibraryServiceUtil.getMethodLibrary((MethodElement)config);
        ILibraryManager iLibraryManager = libraryManager = library == null ? null : LibraryService.getInstance().getLibraryManager(library);
        if (libraryManager != null) {
            return LibraryService.getInstance().getConfigurationManager(config).getConfigurationData().isOwnerSelected(element, checkSubtracted);
        }
        if (element == null) {
            return false;
        }
        if (config == null || ConfigurationHelper.isDescriptionElement(element)) {
            return true;
        }
        if (checkSubtracted && (subtractedCategories = config.getSubtractedCategory()).size() > 0) {
            for (ContentCategory cc : subtractedCategories) {
                if (cc == element) {
                    return false;
                }
                if (cc instanceof CustomCategory) {
                    if (!((CustomCategory)cc).getCategorizedElements().contains(element)) continue;
                    return false;
                }
                System.out.println("TODO, isOwnerSelected: not implemented yet");
            }
        }
        if (element instanceof MethodLibrary || element instanceof MethodConfiguration) {
            return true;
        }
        if (element instanceof MethodPlugin) {
            List plugins = config.getMethodPluginSelection();
            return plugins != null && plugins.contains(element);
        }
        if (element instanceof Activity && (base = (Activity)((Activity)element).getVariabilityBasedOnElement()) != null && base != element && (owningProc = TngUtil.getOwningProcess((BreakdownElement)base)) != null && owningProc != element && !ConfigurationHelper.inConfig((MethodElement)owningProc, config, checkSubtracted)) {
            return false;
        }
        EObject pkg = LibraryUtil.getSelectable((EObject)element);
        if (pkg instanceof MethodPackage && ConfigurationHelper.isGlobalPackage((MethodPackage)pkg)) {
            MethodPlugin plugin = LibraryUtil.getMethodPlugin(pkg);
            return ConfigurationHelper.inConfig((MethodElement)plugin, config, checkSubtracted);
        }
        List pkgs = config.getMethodPackageSelection();
        if (pkgs == null) {
            return false;
        }
        if (pkg instanceof ProcessPackage) {
            while (pkg != null && !(pkg instanceof ProcessComponent) && !pkgs.contains(pkg)) {
                pkg = pkg.eContainer();
            }
        }
        return pkg != null && pkgs.contains(pkg);
    }

    public void loadOppositeFeatures(Map map, List oppositeFeatures, Set deletedGUIDs) {
        int max = oppositeFeatures.size() - 1;
        if (max < 0) {
            return;
        }
        HashSet elements = new HashSet(map.values());
        HashSet loadedElements = new HashSet();
        while (!elements.isEmpty()) {
            for (Object obj : elements) {
                if (!(obj instanceof MethodElement)) continue;
                MethodElement element = (MethodElement)obj;
                MultiResourceEObject mrEObject = (MultiResourceEObject)element;
                int i = max;
                while (i > -1) {
                    OppositeFeature oppositeFeature = (OppositeFeature)oppositeFeatures.get(i);
                    EStructuralFeature eFeature = oppositeFeature.getTargetFeature();
                    if (eFeature.getContainerClass().isInstance(element)) {
                        if (eFeature.isMany()) {
                            InternalEList list = (InternalEList)element.eGet(eFeature);
                            if (!list.isEmpty()) {
                                boolean resolve = false;
                                Iterator iterator = list.basicIterator();
                                while (iterator.hasNext()) {
                                    String guid;
                                    Object e = (InternalEObject)iterator.next();
                                    if (!e.eIsProxy() || !deletedGUIDs.contains(guid = e.eProxyURI().fragment())) continue;
                                    resolve = true;
                                    break;
                                }
                                if (resolve) {
                                    HashSet deletedElements = new HashSet();
                                    for (Object o : list) {
                                        if (!(o instanceof MethodElement) || !deletedGUIDs.contains(((MethodElement)o).getGuid())) continue;
                                        deletedElements.add(o);
                                    }
                                    for (Object e : deletedElements) {
                                        if (oppositeFeature.isMany()) {
                                            mrEObject.oppositeAdd(oppositeFeature, e);
                                            continue;
                                        }
                                        mrEObject.getOppositeFeatureMap().put(oppositeFeature, e);
                                    }
                                }
                            }
                        } else {
                            String guid;
                            InternalEObject e;
                            Object value = element.eGet(eFeature, false);
                            if (value instanceof InternalEObject && (e = (InternalEObject)value).eIsProxy() && deletedGUIDs.contains(guid = e.eProxyURI().fragment())) {
                                Object o = element.eGet(eFeature);
                                if (oppositeFeature.isMany()) {
                                    mrEObject.oppositeAdd(oppositeFeature, o);
                                } else {
                                    mrEObject.getOppositeFeatureMap().put(oppositeFeature, o);
                                }
                            }
                        }
                    }
                    --i;
                }
            }
            loadedElements.addAll(elements);
            elements = new HashSet(map.values());
            elements.removeAll(loadedElements);
        }
    }

    public String generateHtml(Object raw_element, HtmlBuilder htmlBuilder) {
        IElementLayout layout = null;
        String file_url = "about:blank";
        Object element = LibraryUtil.unwrap(raw_element);
        if (raw_element instanceof ActivityWrapperItemProvider) {
            ActivityWrapperItemProvider wrapper = (ActivityWrapperItemProvider)raw_element;
            Object proc = wrapper.getTopItem();
            if (element instanceof MethodElement && proc instanceof Process) {
                String path = AbstractProcessElementLayout.getPath((BreakdownElementWrapperItemProvider)wrapper);
                layout = htmlBuilder.getLayoutManager().createLayout((MethodElement)element, (Process)proc, path);
                file_url = htmlBuilder.generateHtml(layout);
            }
        } else if (raw_element instanceof PracticeSubgroupItemProvider) {
            PracticeSubgroupItemProvider provider = (PracticeSubgroupItemProvider)raw_element;
            layout = new SummaryPageLayout(htmlBuilder.getLayoutManager(), (MethodElement)provider.getPractice(), provider.getText(null), provider.getText(null), (List)provider.getChildren(null), provider.getText(null));
            ((SummaryPageLayout)layout).setHtmlBuilder(htmlBuilder);
            file_url = htmlBuilder.generateHtml(layout);
        } else if (element instanceof MethodElement) {
            file_url = htmlBuilder.generateHtml((MethodElement)element);
        }
        if (file_url == null) {
            file_url = "about:blank";
        } else {
            if (!(SWT.getPlatform().equals("win32") || file_url.startsWith("file://") || file_url.equals("about:blank"))) {
                file_url = "file://" + file_url;
            }
            if (layout instanceof AbstractProcessElementLayout) {
                file_url = String.valueOf(file_url) + ((AbstractProcessElementLayout)layout).getQueryString();
            }
        }
        return file_url;
    }

    public ElementLayoutExtender newElementLayoutExtender(AbstractElementLayout layout) {
        return null;
    }

    public void configViewRefreshNotified() {
    }

    public void debugDump(String msg) {
        System.out.println("LD> " + this.getClass() + ".debugDump: " + msg);
    }
}

