/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.configuration.closure;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.epf.library.IConfigurationClosure;
import org.eclipse.epf.library.IConfigurationManager;
import org.eclipse.epf.library.LibraryPlugin;
import org.eclipse.epf.library.LibraryResources;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.configuration.ConfigDataBase;
import org.eclipse.epf.library.configuration.ConfigurationData;
import org.eclipse.epf.library.configuration.ConfigurationHelper;
import org.eclipse.epf.library.configuration.ConfigurationProperties;
import org.eclipse.epf.library.configuration.SupportingElementData;
import org.eclipse.epf.library.configuration.closure.ClosureListener;
import org.eclipse.epf.library.configuration.closure.ConfigurationErrorMatrix;
import org.eclipse.epf.library.configuration.closure.DependencyManager;
import org.eclipse.epf.library.configuration.closure.ElementDependencyError;
import org.eclipse.epf.library.configuration.closure.ElementError;
import org.eclipse.epf.library.configuration.closure.ElementReference;
import org.eclipse.epf.library.configuration.closure.PackageDependency;
import org.eclipse.epf.library.configuration.closure.PackageError;
import org.eclipse.epf.library.edit.command.IActionManager;
import org.eclipse.epf.library.edit.util.MethodElementPropertyMgr;
import org.eclipse.epf.library.util.LibraryUtil;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.epf.uma.MethodPackage;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.epf.uma.VariabilityElement;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationClosure
implements IConfigurationClosure {
    protected static boolean debug = LibraryPlugin.getDefault().isDebugging();
    protected MethodConfiguration config = null;
    protected MethodLibrary library = null;
    protected IConfigurationManager configManager = null;
    protected DependencyManager dependencyManager = null;
    protected IActionManager actionMgr;
    protected List selectedNotes = new ArrayList();
    private List<ElementError> errors = new ArrayList<ElementError>();
    private boolean abortCheckError = false;
    public static ProcessNodeLock processNodeLock = new ProcessNodeLock();
    public static final String multipleReplacersMARKER_ID = "org.eclipse.epf.library.multipleReplacers";
    public static final String replacerGuids = "replacerGuids";
    protected Map<Object, ElementDependencyError> invalidNodesMap = new HashMap<Object, ElementDependencyError>();
    private List<ClosureListener> listeners;
    private MethodElementPropertyMgr.ChangeEventListener configPropListener;
    private Map<MethodElement, IMarker> replacerElementMarkerMap;
    private boolean runningCheckError = false;

    public ConfigurationClosure(IActionManager actionMgr, MethodConfiguration config) {
        this.config = config;
        this.actionMgr = actionMgr;
        this.configManager = LibraryService.getInstance().getConfigurationManager(config);
        if (this.configManager != null) {
            this.library = this.configManager.getMethodLibrary();
            ConfigurationProperties props = this.configManager.getConfigurationProperties();
            this.configPropListener = new MethodElementPropertyMgr.ChangeEventListener(){

                public void notifyChange(MethodElementPropertyMgr.ChangeEvent event) {
                    ConfigurationClosure.this.refreshErrormarks();
                }
            };
            props.addListener(this.configPropListener);
        }
        this.checkError();
    }

    @Override
    public IConfigurationManager getConfigurationManager() {
        return this.configManager;
    }

    @Override
    public MethodConfiguration getConfiguration() {
        return this.config;
    }

    @Override
    public MethodLibrary getLibrary() {
        return this.library;
    }

    public void checkError() {
        if (this.isRunningCheckError()) {
            if (ConfigDataBase.localDebug) {
                System.out.println("LD> checkError skipped");
            }
            return;
        }
        try {
            try {
                if (ConfigDataBase.localDebug) {
                    System.out.println("LD> checkError_ ->");
                }
                this.checkError_();
            }
            catch (Exception e) {
                LibraryPlugin.getDefault().getLogger().logError((Throwable)e);
                if (ConfigDataBase.localDebug) {
                    System.out.println("LD> checkError_ <-");
                }
                this.setRunningCheckError(false);
            }
        }
        finally {
            if (ConfigDataBase.localDebug) {
                System.out.println("LD> checkError_ <-");
            }
            this.setRunningCheckError(false);
        }
    }

    private synchronized boolean isRunningCheckError() {
        boolean ret = this.runningCheckError;
        if (!ret) {
            this.runningCheckError = true;
        }
        return ret;
    }

    private synchronized void setRunningCheckError(boolean b) {
        this.runningCheckError = b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkError_() {
        this.dependencyManager = new DependencyManager(this.library, this.getConfiguration());
        this.selectedNotes.clear();
        this.selectedNotes.addAll(this.config.getMethodPluginSelection());
        this.selectedNotes.addAll(this.config.getMethodPackageSelection());
        this.clearErrorMarks();
        this.invalidNodesMap.clear();
        ProcessNodeLock processNodeLock = ConfigurationClosure.processNodeLock;
        synchronized (processNodeLock) {
            ConfigurationClosure.processNodeLock.setLockingThread(Thread.currentThread());
            try {
                this.processChangedNodes(this.getSelection());
            }
            finally {
                ConfigurationClosure.processNodeLock.setLockingThread(null);
            }
        }
        this.processReplacers();
    }

    private void processReplacers() {
        ArrayList<VariabilityElement> replacers;
        VariabilityElement base;
        Set<VariabilityElement> replacerSet = this.dependencyManager.getReplacerSet();
        if (replacerSet == null || replacerSet.isEmpty()) {
            return;
        }
        HashMap<VariabilityElement, ArrayList<VariabilityElement>> baseReplacersMap = new HashMap<VariabilityElement, ArrayList<VariabilityElement>>();
        for (VariabilityElement variabilityElement : replacerSet) {
            if (!ConfigurationHelper.inConfig((MethodElement)variabilityElement, this.config, true, false) || !ConfigurationHelper.inConfig((MethodElement)(base = variabilityElement.getVariabilityBasedOnElement()), this.config, true, false)) continue;
            replacers = (ArrayList<VariabilityElement>)baseReplacersMap.get(base);
            if (replacers == null) {
                replacers = new ArrayList<VariabilityElement>();
                baseReplacersMap.put(base, replacers);
            }
            replacers.add(variabilityElement);
        }
        this.clearReplacerElementMarkerMap();
        this.replacerElementMarkerMap = new HashMap<MethodElement, IMarker>();
        for (Map.Entry entry : baseReplacersMap.entrySet()) {
            base = (VariabilityElement)entry.getKey();
            replacers = (List)entry.getValue();
            ConfigurationClosure.processReplacerError(this.replacerElementMarkerMap, (MethodElement)base, (Collection<MethodElement>)replacers);
        }
    }

    private static void processReplacerError(Map<MethodElement, IMarker> elementMarkerMap, MethodElement base, Collection<MethodElement> replacers) {
        if (replacers == null || replacers.isEmpty() || replacers.size() < 2) {
            return;
        }
        IMarker marker = elementMarkerMap.get(base);
        if (marker == null) {
            Resource res = base.eResource();
            if (res == null) {
                return;
            }
            URI containerURI = res.getURI();
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            Path path = new Path(containerURI.toFileString());
            IFile file = workspace.getRoot().getFileForLocation((IPath)path);
            if (file == null) {
                return;
            }
            String location = containerURI != null ? containerURI.toFileString() : "";
            try {
                marker = file.createMarker(multipleReplacersMARKER_ID);
                marker.setAttribute("location", (Object)location);
                marker.setAttribute("severity", 2);
                marker.setAttribute("guid", (Object)base.getGuid());
                elementMarkerMap.put(base, marker);
            }
            catch (Exception e) {
                LibraryPlugin.getDefault().getLogger().logError((Throwable)e);
            }
        }
        String replacerGuidsValue = "";
        for (MethodElement replacer : replacers) {
            if (replacerGuidsValue.length() != 0) {
                replacerGuidsValue = String.valueOf(replacerGuidsValue) + ", ";
            }
            replacerGuidsValue = String.valueOf(replacerGuidsValue) + replacer.getGuid();
        }
        String errMsg = LibraryResources.bind((String)LibraryResources.ElementError_having_multiple_replacers, (Object[])new String[]{LibraryUtil.getTypePath(base), replacerGuidsValue});
        try {
            marker.setAttribute(replacerGuids, (Object)replacerGuidsValue);
            marker.setAttribute("message", (Object)errMsg);
        }
        catch (Exception e) {
            LibraryPlugin.getDefault().getLogger().logError((Throwable)e);
        }
    }

    private void clearErrorMarks() {
        for (ElementError error : this.errors) {
            this.notifyError(error, 0);
        }
    }

    public void refreshErrormarks() {
        this.clearErrorMarks();
        for (ElementError error : this.errors) {
            this.notifyError(error, 1);
        }
    }

    @Override
    public boolean isSelected(Object input) {
        return input instanceof MethodLibrary || input == this.config || this.selectedNotes.contains(input);
    }

    @Override
    public ElementDependencyError getError(Object element) {
        return this.getError(element, false);
    }

    private ElementDependencyError getError(Object element, boolean create) {
        ElementDependencyError error = this.invalidNodesMap.get(element);
        if (error == null && create) {
            error = new ElementDependencyError(element);
            this.invalidNodesMap.put(element, error);
        }
        return error;
    }

    @Override
    public boolean hasError() {
        for (ElementDependencyError error : this.invalidNodesMap.values()) {
            if (!error.isError()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasProblem() {
        return this.invalidNodesMap.size() > 0;
    }

    @Override
    public List<ElementError> getAllErrors() {
        return this.errors;
    }

    private List<PackageError> getAllPackageErrors() {
        ArrayList<PackageError> perrors = new ArrayList<PackageError>();
        for (ElementDependencyError error : this.invalidNodesMap.values()) {
            perrors.addAll(error.getAll());
        }
        return perrors;
    }

    @Override
    public Object[] getDependencyErrors() {
        return this.invalidNodesMap.values().toArray();
    }

    @Override
    public List<Object> getInvalidElements() {
        return new ArrayList<Object>((Collection)this.invalidNodesMap.keySet());
    }

    private void removeError(Object element) {
        if (this.invalidNodesMap.containsKey(element)) {
            this.invalidNodesMap.remove(element);
        }
    }

    @Override
    public Object[] getSelection() {
        return this.selectedNotes.toArray();
    }

    private void processChangedNodes(Object[] changedNodes) {
        if (this.getConfigurationManager().getSupportingElementData() != null) {
            this.getConfigurationManager().getSupportingElementData().beginUpdateSupportingElements();
        }
        this.processChangedNodes_(changedNodes);
        HashMap<String, ElementReference> refMap = new HashMap<String, ElementReference>();
        this.getConfigurationManager().getSupportingElementData().endUpdateSupportingElements(refMap);
        if (this.isAbortCheckError()) {
            return;
        }
        for (ElementReference ref : refMap.values()) {
            ElementError error = ConfigurationErrorMatrix.getError(this.config, ref);
            if (error == null) continue;
            this.errors.add(error);
            this.notifyError(error, 1);
            this.processPackageError(LibraryUtil.getSelectable((EObject)ref.element), LibraryUtil.getSelectable((EObject)ref.refElement), error.getErrorLevel());
        }
    }

    private void processChangedNodes_(Object[] changedNodes) {
        SupportingElementData seData = this.getConfigurationManager().getSupportingElementData();
        int i = 0;
        while (i < changedNodes.length) {
            List refs;
            PackageDependency dependency;
            if (this.isAbortCheckError()) {
                return;
            }
            Object changedElement = changedNodes[i];
            if (!(seData != null && seData.isSupportingSelectable((MethodElement)changedElement) || (dependency = this.dependencyManager.getDependency((MethodElement)changedElement)) == null || (refs = dependency.getAllElementReferences()) == null || refs.size() == 0)) {
                for (ElementReference ref : refs) {
                    this.checkReference(ref);
                }
            }
            ++i;
        }
        ArrayList<MethodElement> list = new ArrayList<MethodElement>();
        list.addAll(this.configManager.getConfigurationData().getAddedElements());
        for (MethodElement e : list) {
            List refs;
            PackageDependency dependency = this.dependencyManager.getDependency((MethodElement)e.eContainer());
            if (dependency == null || (refs = dependency.getAllElementReferences()) == null || refs.size() == 0) continue;
            for (ElementReference ref : refs) {
                if (ref.getElement() != e) continue;
                this.checkReference(ref);
            }
        }
    }

    private void checkReference(ElementReference ref) {
        VariabilityElement replacer;
        MethodElement e = ref.getElement();
        MethodElement e_ref = ref.getRefElement();
        SupportingElementData seData = this.getConfigurationManager().getSupportingElementData();
        ConfigurationData configData = this.getConfigurationManager().getConfigurationData();
        if (e instanceof MethodPackage || e instanceof MethodConfiguration) {
            return;
        }
        if (e instanceof VariabilityElement && (replacer = ConfigurationHelper.getReplacer((VariabilityElement)e, this.config)) != null) {
            return;
        }
        if (configData.isSubstracted(e)) {
            return;
        }
        if (!(ConfigurationHelper.inConfig(e_ref, this.config) || seData != null && seData.isSupportingElementCallDuringUpdating(ref))) {
            ElementError error = ConfigurationErrorMatrix.getError(this.config, ref);
            if (error == null) {
                return;
            }
            this.errors.add(error);
            this.notifyError(error, 1);
            this.processPackageError(LibraryUtil.getSelectable((EObject)e), LibraryUtil.getSelectable((EObject)e_ref), error.getErrorLevel());
        }
    }

    private void processPackageError(Object pkg, Object pkg_ref, int errorLevel) {
        if (errorLevel > 0) {
            ElementDependencyError error = this.getError(pkg, true);
            PackageError pkgerror = error.getError(pkg_ref);
            if (pkgerror == null) {
                String message = LibraryResources.configClosureWarning_msg1;
                pkgerror = new PackageError(errorLevel, message, pkg, pkg_ref, 16);
                error.addError(pkgerror);
            } else {
                pkgerror.setErrorLevel(errorLevel);
                error.calculateErrorBits();
            }
        } else {
            this.removeError(pkg);
        }
        this.updateParentsForErrors((EObject)pkg);
    }

    private void notifyError(ElementError error, int type) {
        if (error == null || this.listeners == null || this.listeners.size() == 0) {
            return;
        }
        try {
            for (ClosureListener listener : this.listeners) {
                listener.fireEvent(type, this.config, error);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void updateParentError(EObject parent, EObject element, int errorType) {
        if (parent == null || parent instanceof MethodLibrary) {
            return;
        }
        ElementDependencyError error = this.getError(parent, false);
        if (error != null && error.size() > 0) {
            error.removeError(element);
        }
        if (errorType != 0) {
            error = this.getError(parent, true);
            String message = LibraryResources.configClosureWarning_msg1;
            PackageError pkgerr = new PackageError(errorType, message, parent, element, 0);
            error.addError(pkgerr);
        } else if (error != null && error.size() == 0) {
            this.removeError(parent);
        }
        this.updateParentError(parent.eContainer(), element, errorType);
    }

    private void updateParentsForErrors(EObject element) {
        int errorType = 0;
        ElementDependencyError error = this.getError(element);
        if (error != null && error.size() > 0) {
            if (error.isError() || error.isChildError()) {
                errorType = 8;
            } else if (error.isWarning() || error.isChildWarning()) {
                errorType = 16;
            }
        }
        this.updateParentError(element.eContainer(), element, errorType);
    }

    @Override
    public void fixErrors() {
        boolean changed = true;
        boolean forceCheck = true;
        while (changed) {
            changed = this.fixProblems(true, forceCheck);
            forceCheck = false;
        }
    }

    @Override
    public void fixProblems() {
        boolean changed = true;
        boolean forceCheck = true;
        while (changed) {
            changed = this.fixProblems(false, forceCheck);
            forceCheck = false;
        }
    }

    private boolean fixProblems(boolean errorOnly, boolean forceCheck) {
        boolean changed = forceCheck;
        List<PackageError> errors = this.getAllPackageErrors();
        if (errors.size() > 0) {
            this.invalidNodesMap.clear();
            for (PackageError error : errors) {
                EObject causeElement = (EObject)error.getCauseElement();
                boolean isError = error.isError();
                boolean isWarning = error.isWarning();
                if (!isError && !isWarning || !isError && errorOnly || this.isSelected(causeElement) || !this.selectErrorElement(causeElement)) continue;
                changed = true;
            }
        }
        if (changed) {
            this.checkError();
        }
        return changed;
    }

    private boolean selectErrorElement(EObject element) {
        boolean selected = true;
        if (element instanceof MethodPlugin && !this.config.getMethodPluginSelection().contains(element)) {
            this.config.getMethodPluginSelection().add((MethodPlugin)element);
        } else if (element instanceof MethodPackage && !this.config.getMethodPackageSelection().contains(element)) {
            this.config.getMethodPackageSelection().add((MethodPackage)element);
        } else {
            selected = false;
        }
        return selected;
    }

    @Override
    public MethodLibrary packageLibrary(boolean removeBrokenReferences) {
        this.processSelection((EObject)this.library, removeBrokenReferences);
        List configs = this.library.getPredefinedConfigurations();
        configs.clear();
        configs.add(this.config);
        return this.library;
    }

    private void processSelection(EObject element, boolean removeBrokenReferences) {
        EList elements;
        EList references;
        if (removeBrokenReferences && (references = element.eCrossReferences()) != null) {
            for (EObject ref : new ArrayList(references)) {
                EObject pkgRef = LibraryUtil.getSelectable(ref);
                if (pkgRef == null || this.isSelected(pkgRef)) continue;
                this.removeReference(element, ref);
            }
        }
        if ((elements = element.eContents()) != null) {
            for (EObject child : new ArrayList(elements)) {
                if (LibraryUtil.selectable(child) && !this.isSelected(child)) {
                    EcoreUtil.remove((EObject)child);
                    continue;
                }
                this.processSelection(child, removeBrokenReferences);
            }
        }
    }

    private void removeReference(EObject ownerElement, EObject refElement) {
        AdapterFactoryContentProvider provider = this.configManager.getContentProvider();
        IPropertySource ps = provider.getPropertySource((Object)ownerElement);
        IPropertyDescriptor[] pds = ps.getPropertyDescriptors();
        if (pds != null && pds.length > 0) {
            int i = 0;
            while (i < pds.length) {
                IPropertyDescriptor descriptor = pds[i];
                Object id = descriptor.getId();
                Object value = ps.getPropertyValue(id);
                IPropertySource source = provider.getPropertySource(value);
                if (source != null) {
                    value = source.getEditableValue();
                }
                if (value instanceof EList) {
                    EList refList = (EList)value;
                    if (refList.contains((Object)refElement)) {
                        if (debug) {
                            System.out.println("Reference [" + LibraryUtil.getName(refElement) + "] removed from [" + LibraryUtil.getName(ownerElement) + "]'s reference list");
                        }
                        refList.remove((Object)refElement);
                        ps.setPropertyValue(id, (Object)refList);
                    }
                } else if (value instanceof MethodElement) {
                    if (debug) {
                        System.out.println("Reference [" + LibraryUtil.getName(refElement) + "] removed from [" + LibraryUtil.getName(ownerElement) + "]");
                    }
                    ps.setPropertyValue(id, null);
                }
                ++i;
            }
        }
    }

    @Override
    public void dispose() {
        this.clearErrorMarks();
        if (this.configManager != null) {
            ConfigurationProperties props = this.configManager.getConfigurationProperties();
            props.removeListener(this.configPropListener);
        }
        this.configManager = null;
        this.config = null;
        this.library = null;
        this.dependencyManager = null;
        this.actionMgr = null;
        if (this.invalidNodesMap != null) {
            this.invalidNodesMap.clear();
        }
        if (this.listeners != null) {
            this.listeners.clear();
        }
        this.clearReplacerElementMarkerMap();
    }

    private void clearReplacerElementMarkerMap() {
        if (this.replacerElementMarkerMap != null) {
            for (IMarker marker : this.replacerElementMarkerMap.values()) {
                try {
                    marker.delete();
                }
                catch (Exception e) {
                    LibraryPlugin.getDefault().getLogger().logError((Throwable)e);
                }
            }
        }
        this.replacerElementMarkerMap = null;
    }

    public void addListener(ClosureListener listener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<ClosureListener>();
        }
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
        this.notifyListener(listener, this.errors);
    }

    public void removeListener(ClosureListener listener) {
        if (this.listeners != null && this.listeners.contains(listener)) {
            this.listeners.remove(listener);
        }
    }

    private void notifyListener(ClosureListener listener, List errors) {
        for (ElementError error : errors) {
            listener.fireEvent(1, this.config, error);
        }
    }

    public synchronized boolean isAbortCheckError() {
        return this.abortCheckError;
    }

    public synchronized void setAbortCheckError(boolean abortCheckError) {
        this.abortCheckError = abortCheckError;
        if (ConfigDataBase.localDebug) {
            System.out.println("LD> setAbortCheckError: " + abortCheckError);
        }
    }

    public static class ProcessNodeLock {
        private Thread lockingThread;

        public synchronized Thread getLockingThread() {
            return this.lockingThread;
        }

        public synchronized void setLockingThread(Thread lockingThread) {
            this.lockingThread = lockingThread;
        }
    }
}

