/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.configuration.closure;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.epf.library.util.LibraryUtil;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.Role;
import org.eclipse.epf.uma.Task;
import org.eclipse.epf.uma.WorkProduct;

public class ElementReference {
    MethodElement element;
    MethodElement refElement;
    private Set<EStructuralFeature> features = new HashSet<EStructuralFeature>();

    public ElementReference(MethodElement element, MethodElement refElement) {
        this.element = element;
        this.refElement = refElement;
    }

    public MethodElement getElement() {
        return this.element;
    }

    public MethodElement getRefElement() {
        return this.refElement;
    }

    public void addFeature(EStructuralFeature feature) {
        if (!this.features.contains(feature)) {
            this.features.add(feature);
        }
    }

    public boolean hasFeature(EStructuralFeature feature) {
        return this.features.contains(feature);
    }

    public void print() {
        System.out.println("    " + LibraryUtil.getName(this.element) + " --> " + LibraryUtil.getName(this.refElement));
    }

    public boolean canIgnore() {
        Role r;
        if (this.element instanceof EObject && this.element.eContainer() == null || this.refElement instanceof EObject && this.refElement.eContainer() == null) {
            return true;
        }
        if (this.element instanceof Task && this.refElement instanceof WorkProduct) {
            if (((Task)this.element).getMandatoryInput().contains(this.refElement)) {
                return false;
            }
            if (((Task)this.element).getOptionalInput().contains(this.refElement)) {
                return true;
            }
        }
        return this.element instanceof Role && this.refElement instanceof WorkProduct && (r = (Role)this.element).getModifies().contains(this.refElement) && !r.getResponsibleFor().contains(this.refElement);
    }

    public EStructuralFeature getSingleFeature() {
        Iterator<EStructuralFeature> iterator;
        if (this.features != null && this.features.size() == 1 && (iterator = this.features.iterator()).hasNext()) {
            EStructuralFeature f = iterator.next();
            return f;
        }
        return null;
    }
}

