/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.layout.elements;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.epf.common.utils.StrUtil;
import org.eclipse.epf.common.utils.Timer;
import org.eclipse.epf.common.utils.XMLUtil;
import org.eclipse.epf.diagram.model.util.DiagramInfo;
import org.eclipse.epf.library.LibraryPlugin;
import org.eclipse.epf.library.LibraryResources;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.configuration.ConfigurationHelper;
import org.eclipse.epf.library.edit.IFilter;
import org.eclipse.epf.library.edit.process.ComposedWPDescriptorWrapperItemProvider;
import org.eclipse.epf.library.edit.process.IBSItemProvider;
import org.eclipse.epf.library.edit.util.Comparators;
import org.eclipse.epf.library.edit.util.ConfigurableComposedAdapterFactory;
import org.eclipse.epf.library.edit.util.PredecessorList;
import org.eclipse.epf.library.edit.util.ProcessUtil;
import org.eclipse.epf.library.edit.util.Suppression;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.layout.ElementLayoutManager;
import org.eclipse.epf.library.layout.IElementLayout;
import org.eclipse.epf.library.layout.LayoutInfo;
import org.eclipse.epf.library.layout.diagram.IActivityDiagramService;
import org.eclipse.epf.library.layout.elements.AbstractElementLayout;
import org.eclipse.epf.library.layout.elements.AbstractProcessElementLayout;
import org.eclipse.epf.library.layout.elements.ActivityLayoutData;
import org.eclipse.epf.library.layout.elements.GeneralLayout;
import org.eclipse.epf.library.layout.elements.ProcessElementItem;
import org.eclipse.epf.library.layout.elements.ProcessLayoutData;
import org.eclipse.epf.library.layout.util.XmlElement;
import org.eclipse.epf.library.prefs.BSColumn;
import org.eclipse.epf.library.prefs.PreferenceUtil;
import org.eclipse.epf.library.util.LibraryUtil;
import org.eclipse.epf.library.util.ModelInfoKeyMap;
import org.eclipse.epf.library.util.ResourceHelper;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.Artifact;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.CompositeRole;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.epf.uma.Milestone;
import org.eclipse.epf.uma.Process;
import org.eclipse.epf.uma.Role;
import org.eclipse.epf.uma.RoleDescriptor;
import org.eclipse.epf.uma.SupportingMaterial;
import org.eclipse.epf.uma.Task;
import org.eclipse.epf.uma.TaskDescriptor;
import org.eclipse.epf.uma.TeamProfile;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.epf.uma.WorkBreakdownElement;
import org.eclipse.epf.uma.WorkProductDescriptor;
import org.eclipse.epf.uma.ecore.util.OppositeFeature;
import org.eclipse.epf.uma.util.AssociationHelper;
import org.eclipse.osgi.util.NLS;

public class ActivityLayout
extends AbstractProcessElementLayout {
    public static final String TAB_NAME_ACTIVITY_DESC = "Description";
    public static final String TAB_NAME_ACTIVITY_WBS = "WBS";
    public static final String TAB_NAME_ACTIVITY_TBS = "TBS";
    public static final String TAB_NAME_ACTIVITY_WPBS = "WPBS";
    DiagramInfo userDiagramInfo = null;
    boolean debug = LibraryPlugin.getDefault().isDebugging();
    private TBSItemDetail itemDetail = new TBSItemDetail();
    private static final String TABURL_SUFFIX_DESC = "_desc.html";
    private static final String TABURL_SUFFIX_WPBS = "_wpbs.html";
    private static final String TABURL_SUFFIX_TBS = "_tbs.html";
    private static final String TABURL_SUFFIX_WBS = "_wbs.html";
    private static final int ACTIVITY_SHOW_LEVEL = 1;
    private static int supCount = 0;

    public void init(ElementLayoutManager layoutManager, MethodElement element) {
        MethodPlugin plugin = LibraryUtil.getMethodPlugin((EObject)element);
        if (plugin == null || plugin.eContainer() == null) {
            if (this.debug && this.getLayoutMgr().isPublishingMode()) {
                System.out.println("Error: Element without a valid container: " + LibraryUtil.getTypeName(element));
            }
            LibraryUtil.loadAllProcesses(LibraryService.getInstance().getCurrentMethodLibrary());
        }
        super.__init(layoutManager, element);
        this.userDiagramInfo = new DiagramInfo((Activity)element);
        String file = this.getFileName(".html");
        if (file != null) {
            file = file.replace('\'', ' ').replace('\"', ' ');
            this.setLayoutInfo(new LayoutInfo(TAB_NAME_ACTIVITY_DESC, "activity_desc.xsl", String.valueOf(file) + TABURL_SUFFIX_DESC, true));
            this.setLayoutInfo(new LayoutInfo(TAB_NAME_ACTIVITY_WPBS, "activity_wpbs.xsl", String.valueOf(file) + TABURL_SUFFIX_WPBS, false));
            this.setLayoutInfo(new LayoutInfo(TAB_NAME_ACTIVITY_TBS, "activity_tbs.xsl", String.valueOf(file) + TABURL_SUFFIX_TBS, false));
            this.setLayoutInfo(new LayoutInfo(TAB_NAME_ACTIVITY_WBS, "activity_wbs.xsl", String.valueOf(file) + TABURL_SUFFIX_WBS, false));
        } else {
            System.out.println("Error in ActivityLayout.init: no file for element " + this.element.getName());
        }
    }

    public String getXslUrl() {
        LayoutInfo info;
        String tabName = this.getLayoutMgr().getValidator().getDefaultActivityTab();
        if (tabName == null) {
            tabName = TAB_NAME_ACTIVITY_WBS;
        }
        if ((info = this.getLayoutInfo(tabName)) == null) {
            info = this.getLayoutInfo(TAB_NAME_ACTIVITY_WBS);
        }
        return info.layout_xsl;
    }

    public static boolean isActivityTabUrl(String url) {
        if (url == null || url.length() == 0) {
            return false;
        }
        return url.endsWith(TABURL_SUFFIX_DESC) || url.endsWith(TABURL_SUFFIX_WPBS) || url.endsWith(TABURL_SUFFIX_TBS) || url.endsWith(TABURL_SUFFIX_WBS);
    }

    protected boolean acceptFeatureValue(EStructuralFeature feature, Object value) {
        if (value instanceof SupportingMaterial) {
            return !this.userDiagramInfo.isDiagram((SupportingMaterial)value);
        }
        if (value instanceof List) {
            List items = (List)value;
            int i = 0;
            while (i < items.size()) {
                Object o = items.get(i);
                if (o instanceof SupportingMaterial && this.userDiagramInfo.isDiagram((SupportingMaterial)o)) {
                    items.remove(i);
                    continue;
                }
                ++i;
            }
        }
        return true;
    }

    public XmlElement getXmlElement(boolean includeReferences) {
        String msg;
        Timer t = null;
        if (this.debug) {
            t = new Timer();
            msg = "Generating layout xml for " + LibraryUtil.getTypeName(this.element) + ", includeReferences = " + includeReferences;
            System.out.println(msg);
        }
        XmlElement elementXml = super.getXmlElement();
        this.loadAttributes(elementXml);
        Process proc = this.getOwningProcess();
        Suppression sup = this.getSuppression(proc);
        if (!includeReferences) {
            return elementXml;
        }
        elementXml.setAttribute("ShowFullMethodContent", this.layoutManager.getValidator().showExtraInfoForDescriptors() ? "true" : "false");
        XmlElement tabsXml = elementXml.newChild("tabs");
        for (LayoutInfo info : this.layouts) {
            tabsXml.newChild("tab").setAttribute("name", info.name).setAttribute("url", String.valueOf(this.elementPath) + info.fileName);
        }
        if (!this.getLayoutMgr().isPublishingMode() || this.element instanceof Process) {
            this.getLayoutMgr().prepareAdaptorFactoriesForProcess(proc);
        }
        this.loadCopyright(elementXml);
        List features = LibraryUtil.getStructuralFeatures(this.element);
        if (features != null) {
            int i = 0;
            while (i < features.size()) {
                EClassifier type;
                EStructuralFeature feature = (EStructuralFeature)features.get(i);
                if (feature != UmaPackage.eINSTANCE.getActivity_BreakdownElements() && (type = feature.getEType()) instanceof EClass) {
                    this.loadFeature(feature, elementXml, false);
                }
                ++i;
            }
        }
        ArrayList oppositeProperties = new ArrayList(this.element.getOppositeFeatures());
        for (OppositeFeature ofeature : oppositeProperties) {
            this.loadFeature(ofeature, elementXml, includeReferences);
        }
        if (this.debug) {
            t.stop();
            msg = String.valueOf(t.getTime()) + " mini seconds building Activity Descriotion xml for " + LibraryUtil.getTypeName(this.element);
            System.out.println(msg);
            t.start();
        }
        this.buildWBS(elementXml, sup);
        if (this.debug) {
            t.stop();
            msg = String.valueOf(t.getTime()) + " mini seconds building WBS for " + LibraryUtil.getTypeName(this.element);
            System.out.println(msg);
            t.start();
        }
        this.buildTBS(elementXml, sup);
        if (this.debug) {
            t.stop();
            msg = String.valueOf(t.getTime()) + " mini seconds building TBS for " + LibraryUtil.getTypeName(this.element);
            System.out.println(msg);
            t.start();
        }
        this.buildWPBS(elementXml, sup);
        if (this.debug) {
            t.stop();
            msg = String.valueOf(t.getTime()) + " mini seconds building WPBS for " + LibraryUtil.getTypeName(this.element);
            System.out.println(msg);
            msg = String.valueOf(t.getTotalTime()) + " mini seconds building layout xml for " + LibraryUtil.getTypeName(this.element);
            System.out.println(msg);
        }
        return elementXml;
    }

    private String getUserDiagramText(SupportingMaterial userDiagram) {
        GeneralLayout l = new GeneralLayout();
        ((AbstractElementLayout)l).init(this.getLayoutMgr(), (MethodElement)userDiagram.getPresentation());
        l.setContentTarget(this.element);
        EAttribute feature = UmaPackage.eINSTANCE.getContentDescription_MainDescription();
        return (String)l.getAttributeFeatureValue((EStructuralFeature)feature);
    }

    private void setColumns(XmlElement parentXml, List cols) {
        XmlElement colsXml = parentXml.newChild("columns");
        for (BSColumn col : cols) {
            colsXml.newChild("column").setAttribute("id", col.id).setAttribute("label", col.label);
        }
    }

    private void buildWBS(XmlElement elementXml, Suppression sup) {
        String imgFile;
        XmlElement bs = elementXml.newChild("breakdown").setAttribute("name", "Work Breakdown Structure").setAttribute("DisplayName", this.getDisplayName());
        this.setColumns(bs, PreferenceUtil.getWBSColumns());
        ConfigurableComposedAdapterFactory adapterFactory = this.layoutManager.getCBSAdapterFactory();
        CompositeRoles crs = null;
        ProcessUtil.updateIDs((AdapterFactory)adapterFactory, (Process)sup.getProcess());
        ActivityLayoutSetting setting = new ActivityLayoutSetting((ComposedAdapterFactory)adapterFactory, crs, sup);
        setting.escapeString = true;
        setting.showTaskOnly = true;
        Object wrapper = sup.getObjectByPath(this.paths, (AdapterFactory)adapterFactory);
        if (wrapper == null) {
            wrapper = this.element;
        }
        if (sup.isSuppressed(wrapper)) {
            return;
        }
        ProcessElementItem elementItem = new ProcessElementItem(wrapper, this.element, this.elementProcessPath);
        this.iterate(elementItem, bs, setting);
        XmlElement diagrams = elementXml.newChild("diagrams");
        String diagramType = "Activity";
        SupportingMaterial userDiagram = this.userDiagramInfo.getActivityDiagram();
        if (this.userDiagramInfo.canPublishADImage() && userDiagram != null) {
            diagrams.newChild("userdiagram").setAttribute("name", diagramType).setValue(this.getUserDiagramText(userDiagram));
        } else {
            org.eclipse.epf.library.layout.diagram.DiagramInfo diagram_workflow;
            DiagramInfo uddInfo = this.getRealizedUDD(sup, diagramType);
            boolean generatedDiagram = true;
            if (uddInfo != null) {
                userDiagram = uddInfo.getActivityDiagram();
                if (uddInfo.canPublishADImage() && userDiagram != null) {
                    diagrams.newChild("userdiagram").setAttribute("name", diagramType).setValue(this.getUserDiagramText(userDiagram));
                    generatedDiagram = false;
                }
            }
            if (generatedDiagram && (diagram_workflow = this.generateDiagram(sup, diagramType, imgFile = ResourceHelper.getDiagramFilePathName(this.element, diagramType))) != null && diagram_workflow.getImageFileName() != null) {
                diagrams.newChild("diagram").setAttribute("name", "Activity").setAttribute("alt", this.getDiagramDisplayName("Activity")).addChild(diagram_workflow.getXmlElement());
            }
        }
        diagramType = "ActivityDetail";
        userDiagram = this.userDiagramInfo.getActivityDetailDiagram();
        if (this.userDiagramInfo.canPublishADDImage() && userDiagram != null) {
            diagrams.newChild("userdiagram").setAttribute("name", diagramType).setValue(this.getUserDiagramText(userDiagram));
        } else {
            imgFile = ResourceHelper.getDiagramFilePathName(this.element, diagramType);
            org.eclipse.epf.library.layout.diagram.DiagramInfo diagram_detail = this.generateDiagram(sup, diagramType, imgFile);
            if (diagram_detail != null && diagram_detail.getImageFileName() != null) {
                diagrams.newChild("diagram").setAttribute("name", "ActivityDetail").setAttribute("alt", this.getDiagramDisplayName("ActivityDetail")).addChild(diagram_detail.getXmlElement());
            }
        }
        diagramType = "WPDependency";
        userDiagram = this.userDiagramInfo.getWPDDiagram();
        if (this.userDiagramInfo.canPublishWPDImage() && userDiagram != null) {
            diagrams.newChild("userdiagram").setAttribute("name", diagramType).setValue(this.getUserDiagramText(userDiagram));
        } else {
            imgFile = ResourceHelper.getDiagramFilePathName(this.element, diagramType);
            org.eclipse.epf.library.layout.diagram.DiagramInfo diagram_wp = this.generateDiagram(sup, diagramType, imgFile);
            if (diagram_wp != null && diagram_wp.getImageFileName() != null) {
                diagrams.newChild("diagram").setAttribute("name", "WPDependency").setAttribute("alt", this.getDiagramDisplayName("WPDependency")).addChild(diagram_wp.getXmlElement());
            }
        }
    }

    private String getDiagramDisplayName(String type) {
        String name = this.getDisplayName();
        if ("Activity".equals(type)) {
            return NLS.bind((String)LibraryResources.activityDiagramName, (Object)name);
        }
        if ("ActivityDetail".equals(type)) {
            return NLS.bind((String)LibraryResources.activityDetailDiagramName, (Object)name);
        }
        if ("WPDependency".equals(type)) {
            return NLS.bind((String)LibraryResources.wpDependencyDiagramName, (Object)name);
        }
        return "";
    }

    private org.eclipse.epf.library.layout.diagram.DiagramInfo generateDiagram(Suppression sup, String diagramType, String imgFile) {
        Timer timer = null;
        if (this.debug) {
            System.out.println("START: generating diagram " + imgFile);
            timer = new Timer();
        }
        IActivityDiagramService diagramService = this.layoutManager.getActivityDiagramService();
        org.eclipse.epf.library.layout.diagram.DiagramInfo diagram = null;
        if (diagramService != null) {
            IFilter filter = this.layoutManager.getDiagramAdapterFactory().getFilter();
            Object wrapper = sup.getObjectByPath(this.paths, (AdapterFactory)this.layoutManager.getDiagramAdapterFactory());
            boolean publishingmode = LibraryUtil.PUBLISH_MODE;
            LibraryUtil.PUBLISH_MODE = true;
            diagram = diagramService.saveDiagram(wrapper, imgFile, diagramType, filter, sup);
            LibraryUtil.PUBLISH_MODE = publishingmode;
        }
        if (timer != null) {
            timer.stop();
            String msg = String.valueOf(timer.getTime()) + " mini seconds generating " + diagramType + " diagram";
            System.out.println(msg);
            System.out.println("END: generating diagram " + imgFile);
        }
        return diagram;
    }

    private DiagramInfo getRealizedUDD(Suppression sup, String diagramType) {
        IActivityDiagramService diagramService = this.layoutManager.getActivityDiagramService();
        if (diagramService != null) {
            DiagramInfo uddInfo;
            IFilter filter = this.layoutManager.getDiagramAdapterFactory().getFilter();
            Object wrapper = sup.getObjectByPath(this.paths, (AdapterFactory)this.layoutManager.getDiagramAdapterFactory());
            Activity realized = diagramService.getRealizedForUnmodified(wrapper, filter, sup);
            if (realized instanceof Activity && (uddInfo = new DiagramInfo(realized)).canPublishADImage()) {
                return uddInfo;
            }
        }
        return null;
    }

    private void buildTBS(XmlElement elementXml, Suppression sup) {
        XmlElement bs = elementXml.newChild("breakdown").setAttribute("name", "Team Breakdown Structure").setAttribute("DisplayName", this.getDisplayName());
        this.setColumns(bs, PreferenceUtil.getTBSColumns());
        ConfigurableComposedAdapterFactory adapterFactory = this.layoutManager.getTBSAdapterFactory();
        CompositeRoles crs = null;
        IBSItemProvider provider = (IBSItemProvider)adapterFactory.adapt((Notifier)this.element, ITreeItemContentProvider.class);
        Object wrapper = sup.getObjectByPath(this.paths, (AdapterFactory)adapterFactory);
        if (wrapper == null) {
            wrapper = this.element;
        }
        ProcessElementItem elementItem = new ProcessElementItem(wrapper, this.element, this.elementProcessPath);
        provider.setRolledUp(false);
        this.itemDetail.iterate((ComposedAdapterFactory)adapterFactory, wrapper);
        provider.setRolledUp(true);
        ActivityLayoutSetting setting = new ActivityLayoutSetting((ComposedAdapterFactory)adapterFactory, crs, sup);
        setting.rollupRoles = true;
        setting.escapeString = true;
        this.iterate(elementItem, bs, setting);
    }

    private void buildWPBS(XmlElement elementXml, Suppression sup) {
        XmlElement bs = elementXml.newChild("breakdown").setAttribute("name", "Work Product Breakdown Structure").setAttribute("DisplayName", this.getDisplayName());
        this.setColumns(bs, PreferenceUtil.getWPBSColumns());
        ConfigurableComposedAdapterFactory adapterFactory = this.layoutManager.getWPBSAdapterFactory();
        CompositeRoles crs = null;
        IBSItemProvider provider = (IBSItemProvider)adapterFactory.adapt((Notifier)this.element, ITreeItemContentProvider.class);
        provider.setRolledUp(true);
        ActivityLayoutSetting setting = new ActivityLayoutSetting((ComposedAdapterFactory)adapterFactory, crs, sup);
        setting.escapeString = true;
        Object wrapper = sup.getObjectByPath(this.paths, (AdapterFactory)adapterFactory);
        if (wrapper == null) {
            wrapper = this.element;
        }
        ProcessElementItem elementItem = new ProcessElementItem(wrapper, this.element, this.elementProcessPath);
        this.iterate(elementItem, bs, setting);
    }

    private void iterate(ProcessElementItem parentItem, XmlElement parentXml, ActivityLayoutSetting setting) {
        this.iterate(parentItem, parentXml, setting, 0);
    }

    private void iterate(ProcessElementItem parentItem, XmlElement parentXml, ActivityLayoutSetting setting, int actLevel) {
        ITreeItemContentProvider provider = null;
        Object parentObj = parentItem.rawItem;
        Timer timer = null;
        if (this.debug) {
            timer = new Timer();
        }
        if ((provider = parentObj instanceof ITreeItemContentProvider ? (ITreeItemContentProvider)parentObj : (ITreeItemContentProvider)setting.adapterFactory.adapt(parentObj, ITreeItemContentProvider.class)) != null) {
            Collection items = provider.getChildren(parentObj);
            for (Object rawitem : items) {
                CompositeRole cr;
                MethodElement item = (MethodElement)LibraryUtil.unwrap(rawitem);
                boolean aSkipIterCond = false;
                if (setting.showTaskOnly && actLevel > 1 && !(item instanceof Activity) && !(item instanceof TaskDescriptor)) {
                    if (!(item instanceof Milestone)) continue;
                    aSkipIterCond = true;
                }
                if (item == null) continue;
                this.getLayoutMgr().getValidator().addReferencedElement(this.element, item);
                ProcessElementItem elementItem = new ProcessElementItem(rawitem, item, parentItem);
                if (parentObj instanceof Activity && setting.crs != null && item instanceof RoleDescriptor && (cr = setting.crs.getCompositeRole((Activity)parentObj, (RoleDescriptor)item)) != null) {
                    item = cr;
                }
                XmlElement child = this.generateChildXml(elementItem, parentXml, setting);
                parentXml.addChild(child);
                if (setting.showTaskOnly && actLevel > 1 && !(item instanceof Activity) || aSkipIterCond) continue;
                this.iterate(elementItem, child, setting, item instanceof Activity ? actLevel + 1 : actLevel);
            }
        }
        if (timer != null) {
            timer.stop();
            if (timer.getTime() > 100) {
                String msg = String.valueOf(timer.getTime()) + " mini seconds iterating breakdown item " + LibraryUtil.getTypeName(parentItem.element);
                System.out.println(msg);
            }
        }
    }

    private XmlElement generateChildXml(ProcessElementItem elementItem, XmlElement parentXml, ActivityLayoutSetting setting) {
        Timer timer = null;
        if (this.debug) {
            timer = new Timer();
        }
        MethodElement item = elementItem.element;
        IElementLayout l = this.getLayout(elementItem);
        boolean isSupressed = setting.sup.isSuppressed(elementItem.rawItem);
        if (isSupressed) {
            this.itemDetail.addSuppressed(elementItem.element);
        }
        XmlElement child = l.getXmlElement(false);
        if (!this.getLayoutMgr().isPublishingMode()) {
            child.setAttribute("isSupressed", isSupressed ? "true" : "false");
        }
        IBSItemProvider adapter = null;
        adapter = elementItem.rawItem instanceof IBSItemProvider ? (IBSItemProvider)elementItem.rawItem : (IBSItemProvider)setting.adapterFactory.adapt((Notifier)elementItem.element, ITreeItemContentProvider.class);
        if (elementItem.element instanceof BreakdownElement) {
            String index = this.getIndex(adapter);
            String modelInfo = null;
            if (adapter instanceof ComposedWPDescriptorWrapperItemProvider) {
                ComposedWPDescriptorWrapperItemProvider provider = (ComposedWPDescriptorWrapperItemProvider)adapter;
                modelInfo = provider.getAttribute((Object)item, "model_info");
            } else {
                modelInfo = ProcessUtil.getAttribute((Object)item, (String)"model_info", (Object)adapter);
            }
            String modelInfoKey = ModelInfoKeyMap.getInstance().getModelInfoKey(modelInfo);
            String team = ProcessUtil.getAttribute((Object)item, (String)"teams", (Object)adapter);
            String prefix = ProcessUtil.getAttribute((Object)item, (String)"prefix", (Object)adapter);
            String isEventDriven = ProcessUtil.getAttribute((Object)item, (String)"is_event_driven", (Object)adapter);
            String isOngoing = ProcessUtil.getAttribute((Object)item, (String)"is_ongoing", (Object)adapter);
            String isOptional = ProcessUtil.getAttribute((Object)item, (String)"is_optional", (Object)adapter);
            String isPlanned = ProcessUtil.getAttribute((Object)item, (String)"is_planned", (Object)adapter);
            String isRepeatable = ProcessUtil.getAttribute((Object)item, (String)"is_repeatable", (Object)adapter);
            String hasMultipleOccurrences = ProcessUtil.getAttribute((Object)item, (String)"has_multiple_occurrences", (Object)adapter);
            String displayName = ProcessUtil.getAttribute((Object)item, (String)"presentation_name", (Object)adapter);
            String mName = ProcessUtil.getAttribute((Object)item, (String)"name", (Object)adapter);
            if (setting.escapeString) {
                modelInfo = StrUtil.escape((String)modelInfo);
                displayName = XMLUtil.escape((String)displayName);
                mName = XMLUtil.escape((String)mName);
                String jsEscapedUrl = StrUtil.escape((String)l.getUrl());
                child.setAttribute("Url", jsEscapedUrl);
            }
            child.setAttribute("Index", index).setAttribute("ModelInfo", modelInfo).setAttribute("ModelInfoKey", modelInfoKey).setAttribute("Team", team);
            child.newChild("attribute").setAttribute("name", "prefix").setValue(prefix);
            child.newChild("attribute").setAttribute("name", "isEventDriven").setValue(isEventDriven);
            child.newChild("attribute").setAttribute("name", "isOngoing").setValue(isOngoing);
            child.newChild("attribute").setAttribute("name", "isOptional").setValue(isOptional);
            child.newChild("attribute").setAttribute("name", "isPlanned").setValue(isPlanned);
            child.newChild("attribute").setAttribute("name", "isRepeatable").setValue(isRepeatable);
            child.newChild("attribute").setAttribute("name", "hasMultipleOccurrences").setValue(hasMultipleOccurrences);
            child.setAttribute("DisplayName", displayName);
            child.setAttribute("Name", mName);
        }
        if (item instanceof WorkProductDescriptor) {
            String entryState = adapter.getAttribute((Object)item, "entry_state");
            String exitState = adapter.getAttribute((Object)item, "exit_state");
            String deliverable = adapter.getAttribute((Object)item, "deliverable");
            child.setAttribute("EntryState", entryState).setAttribute("ExitState", exitState).setAttribute("Deliverable", deliverable);
        }
        if (item instanceof WorkBreakdownElement) {
            String predecessors = this.getPredecessors(adapter, setting.sup);
            child.setAttribute("Predecessors", predecessors);
        }
        if (item instanceof TaskDescriptor) {
            XmlElement stepsXml = child.newChild("Steps");
            TaskDescriptor td = (TaskDescriptor)item;
            List selSteps = td.getSelectedSteps();
            Task t = (Task)ConfigurationHelper.getCalculatedElement((MethodElement)td.getTask(), this.getLayoutMgr().getConfiguration());
            if (t != null) {
                List steps = ConfigurationHelper.calc0nFeatureValue((MethodElement)t, (EStructuralFeature)UmaPackage.eINSTANCE.getTask_Steps(), this.getLayoutMgr().getElementRealizer());
                int i = 0;
                while (i < steps.size()) {
                    Object step = steps.get(i);
                    boolean selected = selSteps.contains(step);
                    stepsXml.newChild("Step").setAttribute("index", Integer.toString(i)).setAttribute("selected", selected ? "true" : "false");
                    ++i;
                }
            }
        }
        if (item instanceof TeamProfile) {
            TeamProfile superTeam = ((TeamProfile)item).getSuperTeam();
            child.setAttribute("hasSuperTeam", superTeam != null ? "true" : "false");
        }
        if (setting.rollupRoles && item instanceof RoleDescriptor) {
            this.buildRoleRollup((RoleDescriptor)item, child, setting);
        }
        if (timer != null) {
            timer.stop();
            if (timer.getTime() > 100) {
                String msg = String.valueOf(timer.getTime()) + " mini seconds generating xml for breakdown item " + LibraryUtil.getTypeName(elementItem.element);
                System.out.println(msg);
            }
        }
        return child;
    }

    private void buildRoleRollup(RoleDescriptor roleItem2, XmlElement parentXml, ActivityLayoutSetting setting) {
        Role r = roleItem2.getRole();
        ArrayList<RoleDescriptor> descriptors = this.itemDetail.getDescriptors(r);
        if (descriptors == null) {
            descriptors = new ArrayList<RoleDescriptor>();
        }
        if (!descriptors.contains(roleItem2)) {
            descriptors.add(roleItem2);
        }
        ArrayList responsibleFor = new ArrayList();
        ArrayList modifies = new ArrayList();
        ArrayList primaryTasks = new ArrayList();
        ArrayList additionalTasks = new ArrayList();
        ArrayList assistTasks = new ArrayList();
        for (RoleDescriptor roleItem2 : descriptors) {
            List items = ConfigurationHelper.calc0nFeatureValue((MethodElement)roleItem2, (EStructuralFeature)UmaPackage.eINSTANCE.getRoleDescriptor_ResponsibleFor(), this.getLayoutMgr().getElementRealizer());
            responsibleFor.addAll(items);
            items = ConfigurationHelper.calc0nFeatureValue((MethodElement)roleItem2, (EStructuralFeature)UmaPackage.eINSTANCE.getRoleDescriptor_Modifies(), this.getLayoutMgr().getElementRealizer());
            modifies.addAll(items);
            items = ConfigurationHelper.calc0nFeatureValue((MethodElement)roleItem2, AssociationHelper.RoleDescriptor_PrimaryTaskDescriptors, this.getLayoutMgr().getElementRealizer());
            primaryTasks.addAll(items);
            items = ConfigurationHelper.calc0nFeatureValue((MethodElement)roleItem2, AssociationHelper.RoleDescriptor_AdditionalTaskDescriptors, this.getLayoutMgr().getElementRealizer());
            additionalTasks.addAll(items);
            items = ConfigurationHelper.calc0nFeatureValue((MethodElement)roleItem2, AssociationHelper.RoleDescriptor_AssistsIn_TaskDescriptors, this.getLayoutMgr().getElementRealizer());
            assistTasks.addAll(items);
        }
        Collections.sort(responsibleFor, Comparators.PRESENTATION_NAME_COMPARATOR);
        this.createRoleRollupNodes(parentXml, responsibleFor, TngUtil.getFeatureText((EStructuralFeature)UmaPackage.eINSTANCE.getRoleDescriptor_ResponsibleFor()));
        Collections.sort(modifies, Comparators.PRESENTATION_NAME_COMPARATOR);
        this.createRoleRollupNodes(parentXml, modifies, TngUtil.getFeatureText((EStructuralFeature)UmaPackage.eINSTANCE.getRoleDescriptor_Modifies()));
        Collections.sort(primaryTasks, Comparators.PRESENTATION_NAME_COMPARATOR);
        this.createRoleRollupNodes(parentXml, primaryTasks, LibraryResources.ActivityLayout_primaryTasks_text);
        Collections.sort(additionalTasks, Comparators.PRESENTATION_NAME_COMPARATOR);
        this.createRoleRollupNodes(parentXml, additionalTasks, LibraryResources.ActivityLayout_additionalTasks_text);
        Collections.sort(assistTasks, Comparators.PRESENTATION_NAME_COMPARATOR);
        this.createRoleRollupNodes(parentXml, assistTasks, LibraryResources.ActivityLayout_assistTasks_text);
    }

    private void createRoleRollupNodes(XmlElement parentXml, List items, String info) {
        ArrayList<Task> processed = new ArrayList<Task>();
        Task linked = null;
        for (MethodElement e : items) {
            linked = null;
            if (e instanceof TaskDescriptor) {
                linked = ((TaskDescriptor)e).getTask();
            } else if (e instanceof WorkProductDescriptor) {
                linked = ((WorkProductDescriptor)e).getWorkProduct();
            }
            if (linked == null) {
                linked = e;
            }
            if (processed.contains(linked)) continue;
            processed.add(linked);
            IElementLayout l = this.layoutManager.getLayout(e, true);
            XmlElement child = l.getXmlElement(false);
            child.setAttribute("ModelInfo", info);
            String modelInfoKey = ModelInfoKeyMap.getInstance().getModelInfoKey(info);
            child.setAttribute("ModelInfoKey", modelInfoKey);
            parentXml.addChild(child);
        }
    }

    private String getIndex(IBSItemProvider adapter) {
        if (adapter != null) {
            int index = adapter.getId();
            if (index == 0) {
                return "";
            }
            return Integer.toString(index);
        }
        return "";
    }

    private String getPredecessors(IBSItemProvider adapter, Suppression sup) {
        PredecessorList list;
        if (adapter != null && (list = adapter.getPredecessors()) != null) {
            return list.toUnSuppressedString(sup, true);
        }
        return "";
    }

    public void loadLayoutData(ProcessLayoutData proc_data, boolean loadWbs, boolean loadTbs, boolean loadWpbs) {
        Timer t = new Timer();
        ActivityLayoutData act_data = proc_data.createActivityLauoutData(this.elementProcessPath);
        Process proc = this.getOwningProcess();
        if (proc == this.element) {
            supCount = 0;
        }
        Suppression sup = this.getSuppression(proc);
        if (loadWbs) {
            this.loadWBSLayoutData(act_data, sup);
        }
        if (loadTbs) {
            this.loadTBSLayoutData(act_data, sup);
        }
        if (loadWpbs) {
            this.loadWPBSLayoutData(act_data, sup);
        }
        if (this.debug) {
            t.stop();
            String msg = String.valueOf(t.getTime()) + " mini-second(s) loading layout data for process " + LibraryUtil.getTypeName((MethodElement)proc) + ", activity: " + LibraryUtil.getTypeName(this.element);
            System.out.println(msg);
        }
    }

    private void loadWBSLayoutData(ActivityLayoutData act_data, Suppression sup) {
        org.eclipse.epf.library.layout.diagram.DiagramInfo diagram_wp;
        org.eclipse.epf.library.layout.diagram.DiagramInfo diagram_detail;
        ConfigurableComposedAdapterFactory adapterFactory = this.layoutManager.getCBSAdapterFactory();
        CompositeRoles crs = null;
        ActivityLayoutSetting setting = new ActivityLayoutSetting((ComposedAdapterFactory)adapterFactory, crs, sup);
        Object wrapper = sup.getObjectByPath(this.paths, (AdapterFactory)adapterFactory);
        if (wrapper == null) {
            wrapper = this.element;
        }
        ProcessElementItem elementItem = new ProcessElementItem(wrapper, this.element, this.elementProcessPath);
        this.iterateProcessItem(elementItem, act_data, setting, true, false, false);
        String prefix = Integer.toHexString(this.elementProcessPath.hashCode());
        String diagramType = "Activity";
        String imgFile = ResourceHelper.getDiagramFilePathName(this.element, String.valueOf(prefix) + "_" + diagramType);
        org.eclipse.epf.library.layout.diagram.DiagramInfo diagram_workflow = this.generateDiagram(sup, diagramType, imgFile);
        if (diagram_workflow != null && diagram_workflow.getImageFileName() != null) {
            act_data.setActivityDiagramPath(diagram_workflow.getImageFileName());
        }
        if ((diagram_detail = this.generateDiagram(sup, diagramType = "ActivityDetail", imgFile = ResourceHelper.getDiagramFilePathName(this.element, String.valueOf(prefix) + "_" + diagramType))) != null && diagram_detail.getImageFileName() != null) {
            act_data.setActivityDetailDiagramPath(diagram_detail.getImageFileName());
        }
        if ((diagram_wp = this.generateDiagram(sup, diagramType = "WPDependency", imgFile = ResourceHelper.getDiagramFilePathName(this.element, String.valueOf(prefix) + "_" + diagramType))) != null && diagram_wp.getImageFileName() != null) {
            act_data.setWPDependencyDiagramPath(diagram_wp.getImageFileName());
        }
    }

    private void loadTBSLayoutData(ActivityLayoutData act_data, Suppression sup) {
        ConfigurableComposedAdapterFactory adapterFactory = this.layoutManager.getTBSAdapterFactory();
        CompositeRoles crs = null;
        IBSItemProvider provider = (IBSItemProvider)adapterFactory.adapt((Notifier)this.element, ITreeItemContentProvider.class);
        provider.setRolledUp(true);
        ActivityLayoutSetting setting = new ActivityLayoutSetting((ComposedAdapterFactory)adapterFactory, crs, sup);
        setting.rollupRoles = true;
        Object wrapper = sup.getObjectByPath(this.paths, (AdapterFactory)adapterFactory);
        if (wrapper == null) {
            wrapper = this.element;
        }
        ProcessElementItem elementItem = new ProcessElementItem(wrapper, this.element, this.elementProcessPath);
        this.iterateProcessItem(elementItem, act_data, setting, false, true, false);
    }

    private void loadWPBSLayoutData(ActivityLayoutData act_data, Suppression sup) {
        ConfigurableComposedAdapterFactory adapterFactory = this.layoutManager.getWPBSAdapterFactory();
        CompositeRoles crs = null;
        IBSItemProvider provider = (IBSItemProvider)adapterFactory.adapt((Notifier)this.element, ITreeItemContentProvider.class);
        provider.setRolledUp(true);
        ActivityLayoutSetting setting = new ActivityLayoutSetting((ComposedAdapterFactory)adapterFactory, crs, sup);
        Object wrapper = sup.getObjectByPath(this.paths, (AdapterFactory)adapterFactory);
        if (wrapper == null) {
            wrapper = this.element;
        }
        ProcessElementItem elementItem = new ProcessElementItem(wrapper, this.element, this.elementProcessPath);
        this.iterateProcessItem(elementItem, act_data, setting, false, false, true);
    }

    private void iterateProcessItem(ProcessElementItem parentItem, ActivityLayoutData act_data, ActivityLayoutSetting setting, boolean loadWbs, boolean loadTbs, boolean loadWpbs) {
        ITreeItemContentProvider provider = null;
        Object parentObj = parentItem.rawItem;
        provider = parentObj instanceof ITreeItemContentProvider ? (ITreeItemContentProvider)parentObj : (ITreeItemContentProvider)setting.adapterFactory.adapt(parentObj, ITreeItemContentProvider.class);
        if (provider != null) {
            Collection items = provider.getChildren(parentObj);
            for (Object rawitem : items) {
                IElementLayout l;
                boolean isSupressed = setting.sup.isSuppressed(rawitem);
                MethodElement item = (MethodElement)LibraryUtil.unwrap(rawitem);
                ProcessElementItem elementItem = new ProcessElementItem(rawitem, item, parentItem);
                if (this.debug && isSupressed) {
                    System.out.println("suppressed: " + ++supCount + " : " + LibraryUtil.getTypeName(item) + ": " + elementItem.path);
                }
                if (!((l = this.getLayout(elementItem)) instanceof AbstractProcessElementLayout)) continue;
                if (isSupressed) {
                    String relPath = ((AbstractProcessElementLayout)l).getRelativeProcessPath();
                    act_data.setSuppressed(relPath);
                    continue;
                }
                if (l instanceof ActivityLayout) {
                    ((ActivityLayout)l).loadLayoutData(act_data.getProcessLayoutData(), loadWbs, loadTbs, loadWpbs);
                    continue;
                }
                this.iterateProcessItem(elementItem, act_data, setting, loadWbs, loadTbs, loadWpbs);
            }
        }
    }

    public void findAllLinkedElements() {
        ConfigurableComposedAdapterFactory adapterFactory;
        Process proc = this.getOwningProcess();
        Suppression sup = this.getSuppression(proc);
        Object wrapper = sup.getObjectByPath(this.paths, (AdapterFactory)(adapterFactory = this.layoutManager.getCBSAdapterFactory()));
        if (wrapper == null) {
            wrapper = this.element;
        }
        this.getLayoutMgr().getValidator().addReferencedElement(null, this.element);
        this.iterateItemForLinkedElements(wrapper, (ComposedAdapterFactory)adapterFactory, sup);
    }

    private void iterateItemForLinkedElements(Object parentObj, ComposedAdapterFactory adapterFactory, Suppression sup) {
        ITreeItemContentProvider provider = null;
        provider = parentObj instanceof ITreeItemContentProvider ? (ITreeItemContentProvider)parentObj : (ITreeItemContentProvider)adapterFactory.adapt(parentObj, ITreeItemContentProvider.class);
        if (provider == null) {
            return;
        }
        Collection items = provider.getChildren(parentObj);
        for (Object rawitem : items) {
            if (sup.isSuppressed(rawitem)) continue;
            MethodElement item = (MethodElement)LibraryUtil.unwrap(rawitem);
            Task e = null;
            if (item instanceof TaskDescriptor) {
                e = ((TaskDescriptor)item).getTask();
            } else if (item instanceof RoleDescriptor) {
                e = ((RoleDescriptor)item).getRole();
            } else if (item instanceof WorkProductDescriptor) {
                e = ((WorkProductDescriptor)item).getWorkProduct();
            }
            if (e != null) {
                this.getLayoutMgr().getValidator().addReferencedElement(item, (MethodElement)e);
                if (e instanceof Artifact) {
                    TreeIterator ti = e.eAllContents();
                    while (ti.hasNext()) {
                        EObject obj = (EObject)ti.next();
                        if (!(obj instanceof Artifact)) continue;
                        this.getLayoutMgr().getValidator().addReferencedElement(item, (MethodElement)((Artifact)obj));
                    }
                }
            }
            MethodElement parent = (MethodElement)LibraryUtil.unwrap(rawitem);
            this.getLayoutMgr().getValidator().addReferencedElement(parent, item);
            this.iterateItemForLinkedElements(rawitem, adapterFactory, sup);
        }
    }

    public class ActivityLayoutSetting {
        public ComposedAdapterFactory adapterFactory;
        public CompositeRoles crs;
        public Suppression sup;
        boolean rollupRoles = false;
        public boolean escapeString = false;
        public boolean showTaskOnly = false;

        public ActivityLayoutSetting(ComposedAdapterFactory adapterFactory, CompositeRoles crs, Suppression sup) {
            this.adapterFactory = adapterFactory;
            this.crs = crs;
            this.sup = sup;
        }
    }

    public class CompositeRoleInfo {
        Activity parent;
        Activity owner;
        List items = new ArrayList();

        public CompositeRoleInfo(Activity parent, Activity owner) {
            this.parent = parent;
            this.owner = owner;
        }

        private void addCompositeRole(CompositeRole e) {
            if (!this.items.contains(e)) {
                this.items.add(e);
            }
        }

        private Activity getParentActivity() {
            return this.parent;
        }

        private CompositeRole getCompositeRole(RoleDescriptor item) {
            if (this.items.size() == 0) {
                return null;
            }
            Role r = item.getRole();
            for (CompositeRole cr : this.items) {
                if (!cr.getAggregatedRoles().contains(r)) continue;
                return cr;
            }
            return null;
        }
    }

    public class CompositeRoles {
        Map itemMap = new HashMap();

        public CompositeRoles(ComposedAdapterFactory adapterFactory, Activity act) {
            this.scan(adapterFactory, null, act);
        }

        private CompositeRoleInfo getCompositeRoleInfo(Activity parent, Activity act) {
            CompositeRoleInfo info = (CompositeRoleInfo)this.itemMap.get(act);
            if (info == null) {
                info = new CompositeRoleInfo(parent, act);
                this.itemMap.put(act, info);
            }
            return info;
        }

        private void scan(ComposedAdapterFactory adapterFactory, Activity parent, Activity act) {
            ITreeItemContentProvider provider = (ITreeItemContentProvider)adapterFactory.adapt((Notifier)act, ITreeItemContentProvider.class);
            if (provider != null) {
                Collection items = provider.getChildren((Object)act);
                Iterator it = items.iterator();
                while (it.hasNext()) {
                    MethodElement item = (MethodElement)LibraryUtil.unwrap(it.next());
                    if (item instanceof CompositeRole) {
                        this.getCompositeRoleInfo(parent, act).addCompositeRole((CompositeRole)item);
                        continue;
                    }
                    if (!(item instanceof Activity)) continue;
                    this.scan(adapterFactory, act, (Activity)item);
                }
            }
        }

        private CompositeRole getCompositeRole(Activity activity, RoleDescriptor item) {
            if (activity == null) {
                return null;
            }
            CompositeRole desc = null;
            CompositeRoleInfo info = (CompositeRoleInfo)this.itemMap.get(activity);
            if (info != null) {
                desc = info.getCompositeRole(item);
                if (desc != null) {
                    return desc;
                }
                return this.getCompositeRole(info.getParentActivity(), item);
            }
            return null;
        }
    }

    public class TBSItemDetail {
        List suppressedItems = new ArrayList();
        Map roleDescriptorMap = new HashMap();

        public void addSuppressed(Object item) {
            if (!this.suppressedItems.contains(item)) {
                this.suppressedItems.add(item);
            }
        }

        public void iterate(ComposedAdapterFactory adapterFactory, Object parentObj) {
            ITreeItemContentProvider provider = null;
            provider = parentObj instanceof ITreeItemContentProvider ? (ITreeItemContentProvider)parentObj : (ITreeItemContentProvider)adapterFactory.adapt(parentObj, ITreeItemContentProvider.class);
            if (provider == null) {
                return;
            }
            Collection items = provider.getChildren(parentObj);
            for (Object rawitem : items) {
                MethodElement item = (MethodElement)LibraryUtil.unwrap(rawitem);
                if (item instanceof RoleDescriptor) {
                    this.addRoleDescriptor((RoleDescriptor)item);
                    continue;
                }
                this.iterate(adapterFactory, rawitem);
            }
        }

        private void addRoleDescriptor(RoleDescriptor rdesc) {
            Role r = rdesc.getRole();
            if (r != null) {
                ArrayList<RoleDescriptor> items = (ArrayList<RoleDescriptor>)this.roleDescriptorMap.get(r);
                if (items == null) {
                    items = new ArrayList<RoleDescriptor>();
                    this.roleDescriptorMap.put(r, items);
                    if (ActivityLayout.this.debug) {
                        System.out.println("Added RoleDescriptor " + rdesc.getPresentationName());
                    }
                }
                if (!items.contains(rdesc)) {
                    items.add(rdesc);
                }
            }
        }

        public List getDescriptors(Role r) {
            return (List)this.roleDescriptorMap.get(r);
        }
    }
}

