/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.util;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.epf.common.utils.StrUtil;
import org.eclipse.epf.library.ILibraryServiceListener;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodLibrary;

public class FileNameGenerator {
    public static FileNameGenerator INSTANCE = new FileNameGenerator();
    private Map<String, String> nameToGuidMap = new HashMap<String, String>();
    private Map<String, String> guidToNameMap = new HashMap<String, String>();
    private Map<String, Integer> baseNameIndexMap = new HashMap<String, Integer>();
    private ILibraryServiceListener svcListener = new ILibraryServiceListener(){

        public void configurationSet(MethodConfiguration config) {
        }

        public void libraryClosed(MethodLibrary library) {
            FileNameGenerator.this.clear();
        }

        public void libraryCreated(MethodLibrary library) {
            FileNameGenerator.this.clear();
        }

        public void libraryOpened(MethodLibrary library) {
            FileNameGenerator.this.clear();
        }

        public void libraryReopened(MethodLibrary library) {
            FileNameGenerator.this.clear();
        }

        public void librarySet(MethodLibrary library) {
        }
    };
    private static final int MAX_NAME_LENGTH = 64;

    private FileNameGenerator() {
        LibraryService.getInstance().addListener(this.svcListener);
    }

    public synchronized String getGuidFromFileName(String fileName) {
        if (fileName == null || fileName.equals("")) {
            return null;
        }
        return this.getGuidFromUniqueName(this.getUniqueName(fileName));
    }

    public synchronized String getFileName(MethodElement element, String namePrefix, String nameSuffix, String ext) {
        String uniqueName = this.getUniqueNameForGuid(element.getGuid(), element.getName());
        StringBuffer buffer = new StringBuffer();
        if (namePrefix != null) {
            buffer.append(namePrefix);
        }
        buffer.append(uniqueName);
        if (nameSuffix != null) {
            buffer.append(nameSuffix);
        }
        if (ext != null) {
            if (ext.indexOf(".") < 0) {
                ext = "." + ext;
            }
            buffer.append(ext);
        }
        return buffer.toString();
    }

    public void clear() {
        this.nameToGuidMap.clear();
        this.guidToNameMap.clear();
        this.baseNameIndexMap.clear();
    }

    private String getUniqueNameForGuid(String guid, String defaultName) {
        String baseName;
        if (guid == null || guid.equals("")) {
            return "";
        }
        String uniqueName = this.guidToNameMap.get(guid);
        if (uniqueName != null) {
            return uniqueName;
        }
        if (defaultName == null) {
            defaultName = "";
        }
        if ((baseName = StrUtil.removeSpecialCharacters((String)defaultName)).length() > 64) {
            baseName = baseName.substring(0, 64);
        }
        uniqueName = baseName = String.valueOf(baseName) + "_" + Integer.toHexString(guid.hashCode()).toUpperCase();
        Integer index = this.baseNameIndexMap.get(baseName);
        if (index == null) {
            index = new Integer(1);
        } else {
            index = index + 1;
            uniqueName = String.valueOf(baseName) + "-" + index.toString();
        }
        this.baseNameIndexMap.put(baseName, index);
        this.guidToNameMap.put(guid, uniqueName);
        this.nameToGuidMap.put(uniqueName, guid);
        return uniqueName;
    }

    private String getGuidFromUniqueName(String uniqueName) {
        return this.nameToGuidMap.get(uniqueName);
    }

    private String getUniqueName(String fileName) {
        try {
            File f = new File(fileName);
            fileName = f.getName();
            int index = fileName.lastIndexOf(".");
            if (index < 0) {
                return fileName;
            }
            return fileName.substring(0, index);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return "";
        }
    }
}

