/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.util;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.epf.library.edit.validation.DependencyChecker;
import org.eclipse.epf.library.util.ModelStorage;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.epf.uma.util.AssociationHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginReferenceChecker {
    public static boolean hasCircularConflictWithPlugin(MethodPlugin aPlugin) {
        for (Object base : aPlugin.getBases()) {
            if (DependencyChecker.checkCircularDependency((EObject)aPlugin, (EStructuralFeature)UmaPackage.Literals.METHOD_PLUGIN__BASES, base).isOK()) continue;
            return true;
        }
        return false;
    }

    public static List<MethodPlugin> getApplicableBasePlugins(MethodPlugin aPlugin) {
        List<MethodPlugin> models = ModelStorage.getBaseModels();
        List<MethodPlugin> descendantList = PluginReferenceChecker.getDescendants(aPlugin);
        for (MethodPlugin element : descendantList) {
            if (aPlugin.getBases().contains(element)) continue;
            models.remove(element);
        }
        return models;
    }

    private static List<MethodPlugin> getDescendants(MethodPlugin methodObject) {
        ArrayList<MethodPlugin> descendantList = new ArrayList<MethodPlugin>();
        ArrayList<MethodPlugin> objList = new ArrayList<MethodPlugin>();
        objList.add(methodObject);
        PluginReferenceChecker.getDescendants(descendantList, objList);
        return descendantList;
    }

    private static List<MethodPlugin> getDescendants(List<MethodPlugin> allDescendantList, List<MethodPlugin> methodObjectList) {
        if (methodObjectList.isEmpty()) {
            return allDescendantList;
        }
        ArrayList combDescendantList = new ArrayList();
        for (MethodPlugin element : methodObjectList) {
            List descendantList = AssociationHelper.getPluginDirectExtensions((MethodPlugin)element);
            combDescendantList.addAll(descendantList);
        }
        allDescendantList.addAll(methodObjectList);
        ArrayList<MethodPlugin> nextCheckList = new ArrayList<MethodPlugin>();
        for (MethodPlugin element : combDescendantList) {
            if (allDescendantList.contains(element)) continue;
            nextCheckList.add(element);
        }
        return PluginReferenceChecker.getDescendants(allDescendantList, nextCheckList);
    }

    public static void printPluginList(String desc, List pluginList) {
        System.out.print("$$$ " + desc + ": [");
        for (MethodPlugin plugin : pluginList) {
            System.out.print(String.valueOf(plugin.getName()) + ", ");
        }
        System.out.println("]");
    }
}

