/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.util;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.epf.library.LibraryPlugin;
import org.eclipse.epf.library.edit.util.ITextReferenceReplacer;
import org.eclipse.epf.library.util.ResourceHelper;
import org.eclipse.epf.uma.CapabilityPattern;
import org.eclipse.epf.uma.DeliveryProcess;
import org.eclipse.epf.uma.MethodElement;

public class TextReferenceReplacerImpl
implements ITextReferenceReplacer {
    private static String CAPABILITY_PATH = "capabilitypatterns/";
    private static String DELIVERY_PATH = "deliveryprocesses/";
    private static boolean debug = LibraryPlugin.getDefault().isDebugging();
    private static final boolean localDebug = false;

    private Map convertMap(Map oldToNewObjectMap) {
        if (oldToNewObjectMap == null) {
            return null;
        }
        HashMap<String, String> m = null;
        for (Map.Entry entry : oldToNewObjectMap.entrySet()) {
            Object key = entry.getKey();
            Object val = entry.getValue();
            if (!(key instanceof MethodElement) || !(val instanceof MethodElement)) continue;
            String newKey = ((MethodElement)key).getGuid();
            String newVal = ((MethodElement)val).getGuid();
            if (key == null || val == null) continue;
            if (m == null) {
                m = new HashMap<String, String>();
            }
            m.put(newKey, newVal);
        }
        return m;
    }

    public String replace(String source, EObject owner, Map oldToNewObjectMap) {
        String ret = this.replace_(source, owner, oldToNewObjectMap);
        return ret;
    }

    private String replace_(String source, EObject owner, Map oldToNewObjectMap) {
        Map localMap = this.convertMap(oldToNewObjectMap);
        if (localMap == null) {
            return source;
        }
        String replacingPath = null;
        String replacedPath = null;
        if (owner instanceof DeliveryProcess) {
            replacingPath = DELIVERY_PATH;
            replacedPath = CAPABILITY_PATH;
        } else if (owner instanceof CapabilityPattern) {
            replacingPath = CAPABILITY_PATH;
            replacedPath = DELIVERY_PATH;
        } else {
            replacingPath = "";
            replacedPath = "";
        }
        StringBuffer sb = new StringBuffer();
        Matcher m = ResourceHelper.p_link_ref.matcher(source);
        while (m.find()) {
            String newGuid;
            String text = m.group();
            Map attributeMap = ResourceHelper.getAttributesFromLink(text);
            String oldGuid = (String)attributeMap.get("guid");
            String string = newGuid = oldGuid == null ? null : (String)localMap.get(oldGuid);
            if (newGuid == null || newGuid.equals(oldGuid)) continue;
            String replacement = TextReferenceReplacerImpl.replaceAll(text, oldGuid, newGuid);
            if (replacement.indexOf(replacedPath) > 0) {
                replacement = replacement.replaceFirst(replacedPath, replacingPath);
            }
            m.appendReplacement(sb, replacement);
        }
        m.appendTail(sb);
        return sb.toString();
    }

    public static String replaceAll(String text, String replaced, String replacing) {
        int fromIndex = 0;
        int ix = text.indexOf(replaced, fromIndex);
        if (ix < 0) {
            return text;
        }
        int replacedLen = replaced.length();
        StringBuffer newText = new StringBuffer();
        while (ix >= fromIndex) {
            if (ix > fromIndex) {
                newText.append(text.substring(fromIndex, ix));
            }
            newText.append(replacing);
            fromIndex = ix + replacedLen;
            ix = text.indexOf(replaced, fromIndex);
        }
        if (fromIndex < text.length()) {
            newText.append(text.substring(fromIndex, text.length()));
        }
        return newText.toString();
    }
}

