/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.surround;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.Selection;

public class LocalDeclarationAnalyzer
extends ASTVisitor {
    private Selection fSelection;
    private List fAffectedLocals;

    public static VariableDeclaration[] perform(BodyDeclaration parent, Selection selection) {
        LocalDeclarationAnalyzer analyzer = new LocalDeclarationAnalyzer(selection);
        parent.accept((ASTVisitor)analyzer);
        return analyzer.fAffectedLocals.toArray(new VariableDeclaration[analyzer.fAffectedLocals.size()]);
    }

    private LocalDeclarationAnalyzer(Selection selection) {
        this.fSelection = selection;
        this.fAffectedLocals = new ArrayList(1);
    }

    public boolean visit(SimpleName node) {
        IVariableBinding binding = null;
        if (node.isDeclaration() || !this.considerNode((ASTNode)node) || (binding = ASTNodes.getLocalVariableBinding((Name)node)) == null) {
            return false;
        }
        this.handleReferenceToLocal(node, binding);
        return true;
    }

    private boolean considerNode(ASTNode node) {
        return this.fSelection.getVisitSelectionMode(node) == 3;
    }

    private void handleReferenceToLocal(SimpleName node, IVariableBinding binding) {
        VariableDeclaration declaration = ASTNodes.findVariableDeclaration(binding, (ASTNode)node);
        if (declaration != null && this.fSelection.covers((ASTNode)declaration)) {
            this.addLocalDeclaration(declaration);
        }
    }

    private void addLocalDeclaration(VariableDeclaration declaration) {
        if (!this.fAffectedLocals.contains(declaration)) {
            this.fAffectedLocals.add(declaration);
        }
    }
}

