/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.webapp.servlet;

import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.core.runtime.Path;
import org.eclipse.help.ITopic;
import org.eclipse.help.internal.HelpPlugin;
import org.eclipse.help.internal.webapp.data.UrlUtil;
import org.eclipse.help.internal.webapp.servlet.FilterHTMLHeadAndBodyOutputStream;
import org.eclipse.help.internal.webapp.servlet.IFilter;

public class BreadcrumbsFilter
implements IFilter {
    private static final String HEAD_CONTENT = "\n<link rel=\"stylesheet\" href=\"../content/PLUGINS_ROOT/org.eclipse.help.webapp/advanced/breadcrumbs.css\" charset=\"ISO-8859-1\" type=\"text/css\"></link>\n<script language=\"JavaScript\" src=\"../content/PLUGINS_ROOT/org.eclipse.help/livehelp.js\"> </script>";

    public OutputStream filter(HttpServletRequest req, OutputStream out) {
        String uri = req.getRequestURI();
        if (uri == null || !uri.endsWith("html") && !uri.endsWith("htm") && !uri.startsWith("/help/nav/")) {
            return out;
        }
        if ("/rtopic".equals(req.getServletPath())) {
            return out;
        }
        if (UrlUtil.isBot(req)) {
            return out;
        }
        String pathInfo = req.getPathInfo();
        if (pathInfo == null) {
            return out;
        }
        int[] path = UrlUtil.getTopicPath(uri);
        if (path != null && path.length > 1) {
            boolean isNarrow = "/ntopic".equals(req.getServletPath());
            String locale = UrlUtil.getLocale(req, null);
            String bodyContent = this.getBodyContent(path, this.getBackpath(uri), isNarrow, locale);
            try {
                return new FilterHTMLHeadAndBodyOutputStream(out, HEAD_CONTENT.getBytes("ASCII"), bodyContent);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {}
        }
        return out;
    }

    private String getBackpath(String path) {
        int num = new Path(path).segmentCount() - 2;
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < num) {
            if (i > 0) {
                buf.append('/');
            }
            buf.append("..");
            ++i;
        }
        return buf.toString();
    }

    private String getBodyContent(int[] path, String backPath, boolean isNarrow, String locale) {
        StringBuffer buf = new StringBuffer();
        StringBuffer pathBuf = new StringBuffer();
        ITopic topic = HelpPlugin.getTocManager().getTocs(locale)[path[0]].getTopic(null);
        pathBuf.append(path[0]);
        buf.append("<div class=\"help_breadcrumbs\">");
        int i = 0;
        while (i < path.length - 1) {
            buf.append("<a href=\"");
            String href = topic.getHref();
            href = href != null ? String.valueOf(backPath) + (isNarrow ? "/ntopic" : "/topic") + href : (isNarrow ? "javascript:liveAction('org.eclipse.help.ui', 'org.eclipse.help.ui.internal.ShowInTocAction', '" + pathBuf.toString() + "')" : String.valueOf(backPath) + "/nav/" + pathBuf.toString());
            buf.append(href);
            buf.append("\">");
            buf.append(topic.getLabel());
            buf.append("</a>");
            if (i < path.length - 2 || path.length == 2) {
                buf.append(" > ");
            }
            topic = topic.getSubtopics()[path[i + 1]];
            pathBuf.append('_');
            pathBuf.append(path[i + 1]);
            ++i;
        }
        buf.append("</div>");
        return buf.toString();
    }
}

