/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.persistence;

import java.io.File;
import java.security.AccessController;
import java.text.MessageFormat;
import java.util.ArrayList;
import org.eclipse.core.internal.resources.ResourceException;
import org.eclipse.core.internal.resources.ResourceStatus;
import org.eclipse.core.internal.utils.Messages;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceStatus;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.epf.persistence.IFileInfo;
import org.eclipse.epf.persistence.MultiFileIOException;
import org.eclipse.epf.persistence.MultiFileSaveUtil;
import org.eclipse.epf.persistence.PersistencePlugin;
import org.eclipse.epf.persistence.util.PersistenceResources;
import org.eclipse.epf.services.IFileManager;
import org.eclipse.osgi.util.NLS;
import sun.security.action.GetPropertyAction;

public class FileManager
implements IFileManager {
    public static final String PLUGIN_ID = FileManager.class.getPackage().getName();
    private static FileManager instance = null;
    private static String tmpdir;
    private boolean validateEditInitialized = false;

    public static String getTempDir() {
        if (tmpdir == null) {
            GetPropertyAction a = new GetPropertyAction("java.io.tmpdir");
            tmpdir = AccessController.doPrivileged(a);
        }
        return tmpdir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final FileManager getInstance() {
        if (instance != null) return instance;
        Class<FileManager> clazz = FileManager.class;
        synchronized (FileManager.class) {
            if (instance != null) return instance;
            instance = new FileManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    protected FileManager() {
    }

    public static IResource getResourceForLocation(String location) {
        IFile resource;
        File file = new File(location);
        if (!file.exists()) {
            return null;
        }
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        Path path = new Path(location);
        if (file.isFile()) {
            IResource parentResource;
            resource = workspaceRoot.getFileForLocation((IPath)path);
            if (resource == null && (parentResource = FileManager.getResourceForLocation(file.getParent())) != null) {
                try {
                    parentResource.refreshLocal(1, null);
                }
                catch (CoreException coreException) {}
                resource = workspaceRoot.getFileForLocation((IPath)path);
            }
        } else {
            resource = workspaceRoot.getContainerForLocation((IPath)path);
        }
        return resource;
    }

    public static boolean refresh(IResource resource) throws CoreException {
        if (!resource.exists()) {
            ArrayList<IContainer> foldersToRefresh = new ArrayList<IContainer>();
            IContainer container = resource.getParent();
            while (!container.exists()) {
                foldersToRefresh.add(0, container);
                container = container.getParent();
            }
            if (container.exists()) {
                container.refreshLocal(1, null);
            }
            if (!foldersToRefresh.isEmpty()) {
                for (IFolder iFolder : foldersToRefresh) {
                    if (iFolder.exists()) {
                        iFolder.refreshLocal(1, null);
                        continue;
                    }
                    return false;
                }
            }
        }
        resource.refreshLocal(1, null);
        return true;
    }

    private static boolean refresh(String path) throws CoreException {
        IResource resource = FileManager.getResourceForLocation(path);
        if (resource != null) {
            return FileManager.refresh(resource);
        }
        return false;
    }

    public boolean refresh(Resource resource) {
        try {
            return FileManager.refresh(FileManager.toFileString(resource.getURI()));
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    public boolean move(String oldPath, String newPath) {
        return this.move(oldPath, newPath, false);
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    public boolean move(String oldPath, String newPath, boolean forceRemoveSource) {
        block22: {
            try {
                block23: {
                    FileManager.refresh(oldPath);
                    resource /* !! */  = null;
                    workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
                    destPath = new Path(newPath);
                    if (new File(oldPath).isFile()) {
                        resource /* !! */  = workspaceRoot.getFileForLocation((IPath)destPath);
                        if (resource /* !! */  == null) {
                            resource /* !! */  = workspaceRoot.getContainerForLocation((IPath)destPath);
                        }
                    } else {
                        resource /* !! */  = workspaceRoot.getContainerForLocation((IPath)destPath);
                        if (resource /* !! */  == null) {
                            resource /* !! */  = workspaceRoot.getFileForLocation((IPath)destPath);
                        }
                    }
                    if (resource /* !! */  != null) {
                        if (resource /* !! */ .exists()) {
                            resource /* !! */ .refreshLocal(0, null);
                            if (resource /* !! */ .exists()) {
                                throw new MultiFileIOException(NLS.bind((String)PersistenceResources.moveError_msg, (Object)oldPath, (Object)newPath));
                            }
                        }
                        foldersToCreate = new ArrayList<IContainer>();
                        container = resource /* !! */ .getParent();
                        while (!container.exists()) {
                            foldersToCreate.add(0, container);
                            container = container.getParent();
                        }
                        if (!foldersToCreate.isEmpty()) {
                            container.refreshLocal(1, null);
                            for (IFolder folder : foldersToCreate) {
                                if (!folder.exists()) {
                                    folder.create(true, true, null);
                                    continue;
                                }
                                folder.refreshLocal(1, null);
                            }
                        }
                        destPath = resource /* !! */ .getFullPath();
                    } else if (Platform.getLocation().isPrefixOf((IPath)destPath)) {
                        destPath = new Path(destPath.toOSString().substring(Platform.getLocation().toOSString().length()));
                    }
                    path = new Path(oldPath);
                    file = workspaceRoot.getFileForLocation((IPath)path);
                    resource /* !! */  = file != null && file.exists() != false ? file : workspaceRoot.getContainerForLocation((IPath)path);
                    if (resource /* !! */  == null) break block22;
                    try {
                        resource /* !! */ .move((IPath)destPath, true, null);
                        break block23;
                    }
                    catch (ResourceException e) {
                        PersistencePlugin.getDefault().getLog().log(e.getStatus());
                        if (forceRemoveSource) {
                            throw e;
                        }
                        failed = false;
                        statuses = e.getStatus().getChildren();
                        i = 0;
                        ** while (i < statuses.length)
                    }
lbl-1000:
                    // 1 sources

                    {
                        status = statuses[i];
                        if (status.getCode() == 273 && status.getMessage() == Messages.localstore_deleteProblem) {
                            msg = MessageFormat.format("Warning while moving ''{0}'' to ''{1}'': {2}", new Object[]{oldPath, newPath, status.getMessage()});
                            PersistencePlugin.getDefault().getLogger().logWarning(msg);
                        } else {
                            failed = true;
                        }
                        ++i;
                        continue;
                    }
lbl61:
                    // 1 sources

                    if (failed || !new File(newPath).exists()) {
                        return false;
                    }
                }
                return true;
            }
            catch (CoreException e) {
                PersistencePlugin.getDefault().getLogger().logError((Throwable)e);
                if (!MultiFileSaveUtil.DEBUG) break block22;
                e.printStackTrace();
            }
        }
        return false;
    }

    public boolean rename(File oldFile, File newFile) {
        return this.move(oldFile.getAbsolutePath(), newFile.getAbsolutePath());
    }

    public void deleteResource(String path, IProgressMonitor monitor) throws CoreException {
        IResource resource = FileManager.getResourceForLocation(path);
        if (resource != null) {
            resource.delete(true, monitor);
        }
    }

    public boolean delete(String path) {
        try {
            this.deleteResource(path, null);
            return true;
        }
        catch (CoreException e) {
            CommonPlugin.INSTANCE.log((Object)e);
            if (MultiFileSaveUtil.DEBUG) {
                e.printStackTrace();
            }
            return false;
        }
    }

    private static boolean fromCC(IStatus status) {
        String pluginId = status.getPlugin();
        return pluginId != null && pluginId.toLowerCase().indexOf("clearcase") != -1;
    }

    public IStatus checkModify(String[] paths, Object context) {
        IFile file;
        IStatus status = null;
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IFile[] files = new IFile[paths.length];
        ArrayList<String> notFoundFiles = new ArrayList<String>();
        int i = 0;
        while (i < paths.length) {
            String path = paths[i];
            try {
                FileManager.refresh(path);
            }
            catch (CoreException e) {
                PersistencePlugin.getDefault().getLogger().logError((Throwable)e);
            }
            file = workspace.getRoot().getFileForLocation((IPath)new Path(path));
            if (file == null) {
                notFoundFiles.add(path);
            } else {
                files[i] = file;
            }
            ++i;
        }
        if (!notFoundFiles.isEmpty()) {
            return new Status(2, PLUGIN_ID, 2, NLS.bind((String)PersistenceResources.fileNotFoundError_msg, notFoundFiles), null);
        }
        if (!this.validateEditInitialized) {
            status = workspace.validateEdit(files, context);
            this.validateEditInitialized = true;
            if (status.isOK()) {
                status = workspace.validateEdit(files, context);
            }
        } else {
            status = workspace.validateEdit(files, context);
        }
        if (status.isOK()) {
            MultiStatus multiStatus = new MultiStatus(PLUGIN_ID, 0, PersistenceResources.modifyFilesError_msg, null);
            int i2 = 0;
            while (i2 < files.length) {
                file = files[i2];
                try {
                    file.refreshLocal(0, null);
                }
                catch (CoreException e) {
                    CommonPlugin.INSTANCE.log((Object)e);
                }
                if (file.isReadOnly()) {
                    String localPath = file.getLocation().toOSString();
                    String msg = MessageFormat.format(PersistenceResources.FileManager_fileReadOnly, localPath);
                    multiStatus.add((IStatus)new ResourceStatus(4, 0, file.getFullPath(), msg, null));
                }
                ++i2;
            }
            if (!multiStatus.isOK()) {
                return multiStatus;
            }
        } else if (FileManager.fromCC(status)) {
            String msg = PersistenceResources.modifyFilesError_msg;
            MultiStatus multiStatus = new MultiStatus(PLUGIN_ID, status.getCode(), msg, null);
            multiStatus.add(status);
            return multiStatus;
        }
        if (status instanceof MultiStatus) {
            MultiStatus ms = (MultiStatus)status;
            int i3 = 0;
            while (i3 < ms.getChildren().length) {
                IStatus childStatus = ms.getChildren()[i3];
                ms.getChildren()[i3] = FileManager.toStatusWithLocalPath(childStatus);
                ++i3;
            }
        } else {
            status = FileManager.toStatusWithLocalPath(status);
        }
        return status;
    }

    private static IStatus toStatusWithLocalPath(IStatus status) {
        if (status instanceof IResourceStatus && status.getCode() == 279) {
            IResourceStatus resourceStatus = (IResourceStatus)status;
            IPath path = resourceStatus.getPath();
            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(path);
            String localPath = file.getLocation().toOSString();
            String msg = MessageFormat.format(PersistenceResources.FileManager_fileReadOnly, localPath);
            return new ResourceStatus(status.getSeverity(), status.getCode(), resourceStatus.getPath(), msg, status.getException());
        }
        return status;
    }

    public IStatus checkModify(String path, Object context) {
        return this.checkModify(new String[]{path}, context);
    }

    public boolean isTeamPrivate(String path) {
        IResource resource = FileManager.getResourceForLocation(path);
        return resource != null && resource.isTeamPrivateMember();
    }

    public static IFile getFile(URI uri, URIConverter converter) {
        URI normalized;
        IFile result = null;
        if ("platform".equals(uri.scheme()) && uri.segmentCount() > 2) {
            if ("resource".equals(uri.segment(0))) {
                IPath path = new Path(URI.decode((String)uri.path())).removeFirstSegments(1);
                result = ResourcesPlugin.getWorkspace().getRoot().getFile(path);
            }
        } else if (uri.isFile() && !uri.isRelative()) {
            result = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(uri.toFileString()));
        } else if (converter != null && !uri.equals((Object)(normalized = converter.normalize(uri)))) {
            result = FileManager.getFile(normalized, converter);
        }
        return result;
    }

    public static String toFileString(URI uri, URIConverter converter) {
        if (uri.isFile()) {
            return uri.toFileString();
        }
        IFile file = FileManager.getFile(uri, converter);
        return file != null ? file.getLocation().toOSString() : null;
    }

    public static String toFileString(URI uri) {
        return FileManager.toFileString(uri, null);
    }

    public IFileInfo getFileInfo(Resource resource) {
        IFile file = WorkspaceSynchronizer.getFile((Resource)resource);
        return file != null ? new FileInfo(file) : null;
    }

    public static class FileInfo
    implements IFileInfo {
        private IFile file;

        private FileInfo(IFile file) {
            this.file = file;
        }

        public long getModificationStamp() {
            return this.file.getModificationStamp();
        }

        public boolean isSynchronized() {
            return this.file.isSynchronized(0);
        }

        public File getFile() {
            IPath loc = this.file.getLocation();
            return loc != null ? this.file.getLocation().toFile() : null;
        }
    }
}

