/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.persistence.util;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.epf.common.service.versioning.EPFVersions;
import org.eclipse.epf.common.service.versioning.VersionUtil;
import org.eclipse.epf.library.persistence.ILibraryResource;
import org.eclipse.epf.library.persistence.ILibraryResourceSet;
import org.eclipse.epf.persistence.FileManager;
import org.eclipse.epf.persistence.MultiFileResourceSetImpl;
import org.eclipse.epf.persistence.MultiFileSaveUtil;
import org.eclipse.epf.persistence.PersistencePlugin;
import org.eclipse.epf.persistence.refresh.internal.RefreshEvent;
import org.eclipse.epf.uma.ContentDescription;
import org.eclipse.epf.uma.DescribableElement;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodLibrary;
import org.osgi.framework.Version;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistenceUtil {
    public static final String getUMANsURI() {
        return "http://www.eclipse.org/epf/uma/1.0.5/uma.ecore";
    }

    public static final String getUMANsURI(String libPath) {
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = builder.parse(new File(libPath));
            Element root = doc.getDocumentElement();
            String nsURI = root.getAttribute("xmlns:com.ibm.uma");
            if (nsURI == null || nsURI.equals("")) {
                nsURI = root.getAttribute("xmlns:org.eclipse.epf.uma");
            }
            if (nsURI == null || nsURI.equals("")) {
                nsURI = String.valueOf(root.getAttribute("xmlns:uma")) + "/uma.ecore";
            }
            return nsURI;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static final boolean conversionRequired(String libPath) {
        String libNsURI;
        String currentNsURI = PersistenceUtil.getUMANsURI();
        if (currentNsURI.equals(libNsURI = PersistenceUtil.getUMANsURI(libPath))) {
            return false;
        }
        return "http:///com/ibm/uma.ecore".equals(libNsURI);
    }

    public static final IResource getWorkspaceResource(Object obj) {
        Resource resource = null;
        if (obj instanceof DescribableElement) {
            DescribableElement e = (DescribableElement)obj;
            ContentDescription content = e.getPresentation();
            resource = content.eResource();
            if (resource == null) {
                resource = e.eResource();
            }
        } else if (obj instanceof EObject) {
            resource = ((EObject)obj).eResource();
        } else if (obj instanceof Resource) {
            resource = (Resource)obj;
        }
        if (resource != null && resource.getURI().isFile()) {
            return FileManager.getResourceForLocation(resource.getURI().toFileString());
        }
        return null;
    }

    public static final Collection<EObject> getProxies(EObject obj) {
        ArrayList<EObject> proxies = new ArrayList<EObject>();
        TreeIterator iter = obj.eAllContents();
        while (iter.hasNext()) {
            EObject o = (EObject)iter.next();
            if (!o.eIsProxy()) continue;
            proxies.add(o);
        }
        return proxies;
    }

    public static final int checkToolVersion(Resource resource) {
        String version;
        File file = new File(resource.getURI().toFileString());
        Map fileVersionMap = VersionUtil.readVersionsFromFile((File)file);
        if (fileVersionMap != null && (version = (String)fileVersionMap.get(VersionUtil.getPrimaryToolID())) != null) {
            EPFVersions versions = VersionUtil.getVersions((String)VersionUtil.getPrimaryToolID());
            return versions.getCurrentVersion().compareToolVersionTo(new Version(version));
        }
        return -1;
    }

    public static MethodElement getMethodElement(Resource resource) {
        for (Object element : resource.getContents()) {
            if (!(element instanceof MethodElement)) continue;
            return (MethodElement)element;
        }
        return null;
    }

    public static EObject resolve(EObject proxy, ResourceSet resourceSet) {
        EObject resolved;
        try {
            resolved = EcoreUtil.resolve((EObject)proxy, (ResourceSet)resourceSet);
        }
        catch (Exception exception) {
            resolved = proxy;
        }
        EObject container = proxy.eContainer();
        if (resolved.eContainer() == null && container != null) {
            EReference ref;
            if (container.eIsProxy()) {
                container = PersistenceUtil.resolve(container, resourceSet);
            }
            if ((ref = proxy.eContainmentFeature()).isMany()) {
                List values = (List)container.eGet((EStructuralFeature)ref);
                Iterator iter = values.iterator();
                while (iter.hasNext()) {
                    iter.next();
                }
            } else {
                container.eGet((EStructuralFeature)ref);
            }
        }
        return resolved;
    }

    public static Resource getResource(IPath path, ResourceSet resourceSet) {
        return PersistenceUtil.getResource(path.toOSString(), resourceSet);
    }

    public static Resource getResource(String path, ResourceSet resourceSet) {
        URI uri = URI.createFileURI((String)path);
        for (Resource resource : new ArrayList(resourceSet.getResources())) {
            if (!uri.equals((Object)MultiFileSaveUtil.getFinalURI(resource))) continue;
            return resource;
        }
        return null;
    }

    public static void resolveContainer(Resource resource) {
        ResourceSet resourceSet = resource.getResourceSet();
        if (resourceSet instanceof MultiFileResourceSetImpl) {
            ((MultiFileResourceSetImpl)resourceSet).resolveContainer(resource);
        }
    }

    public static MethodElement getMethodElement(IResource iResource, ResourceSet resourceSet) {
        MethodElement element = null;
        URI uri = URI.createFileURI((String)iResource.getLocation().toOSString());
        Resource resource = resourceSet.getResource(uri, true);
        if (resource != null) {
            EObject container;
            if (resourceSet instanceof MultiFileResourceSetImpl) {
                ((MultiFileResourceSetImpl)resourceSet).resolveContainer(resource);
            }
            if ((element = PersistenceUtil.getMethodElement(resource)) instanceof ContentDescription && (container = ((ContentDescription)element).eContainer()) instanceof MethodElement) {
                element = (MethodElement)container;
            }
        }
        return element;
    }

    public static void loadAllLibraryResources(MethodLibrary lib) {
        TreeIterator iter = lib.eAllContents();
        while (iter.hasNext()) {
            EObject element = (EObject)iter.next();
            if (!(element instanceof MethodElement)) continue;
            try {
                Iterator iterator = element.eCrossReferences().iterator();
                while (iterator.hasNext()) {
                    iterator.next();
                }
            }
            catch (Exception e) {
                CommonPlugin.INSTANCE.log((Object)e);
            }
        }
    }

    public static String getTopAttribute(File file, final String attributeName) {
        SAXParserFactory spf = SAXParserFactory.newInstance();
        try {
            SAXParser saxParser = spf.newSAXParser();
            final String[] valueHolder = new String[1];
            try {
                saxParser.parse(file, new DefaultHandler(){
                    private boolean started;

                    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                        if (this.started) {
                            throw new OperationCanceledException();
                        }
                        valueHolder[0] = attributes.getValue(attributeName);
                        this.started = true;
                    }
                });
            }
            catch (OperationCanceledException operationCanceledException) {}
            return valueHolder[0];
        }
        catch (Exception e) {
            PersistencePlugin.getDefault().getLogger().logError((Throwable)e);
            return null;
        }
    }

    public static void unload(Collection<Resource> removedResources) {
        HashMap<MultiFileResourceSetImpl, ArrayList<Resource>> resourceSetToUnloadedResourcesMap = new HashMap<MultiFileResourceSetImpl, ArrayList<Resource>>();
        for (Resource resource : removedResources) {
            ResourceSet resourceSet = resource.getResourceSet();
            boolean unloaded = false;
            try {
                if (resourceSet instanceof ILibraryResourceSet) {
                    if (((ILibraryResourceSet)resourceSet).unload(resource, Collections.EMPTY_MAP)) {
                        resourceSet.getResources().remove((Object)resource);
                        unloaded = true;
                    }
                } else {
                    if (resource.isLoaded()) {
                        resource.unload();
                        unloaded = true;
                    }
                    if (resourceSet != null) {
                        resourceSet.getResources().remove((Object)resource);
                    }
                }
            }
            catch (Exception e) {
                PersistencePlugin.getDefault().getLogger().logError((Throwable)e);
            }
            if (!unloaded || !(resourceSet instanceof MultiFileResourceSetImpl)) continue;
            ArrayList<Resource> unloadedResources = (ArrayList<Resource>)resourceSetToUnloadedResourcesMap.get(resourceSet);
            if (unloadedResources == null) {
                unloadedResources = new ArrayList<Resource>();
                resourceSetToUnloadedResourcesMap.put((MultiFileResourceSetImpl)resourceSet, unloadedResources);
            }
            unloadedResources.add(resource);
        }
        for (Map.Entry entry : resourceSetToUnloadedResourcesMap.entrySet()) {
            ((MultiFileResourceSetImpl)entry.getKey()).notifyRefreshListeners(new RefreshEvent((Collection)entry.getValue()));
        }
    }

    public static boolean hasDuplicateGUID(MethodElement e, Collection<? extends MethodElement> elements) {
        for (MethodElement methodElement : elements) {
            if (!e.getGuid().equals(methodElement.getGuid())) continue;
            return true;
        }
        return false;
    }

    private static String toPrefix(String path) {
        return path.endsWith(File.separator) ? path : String.valueOf(path) + File.separator;
    }

    public static void replaceURIPrefix(Collection<Resource> resources, String oldPrefix, String newPrefix) {
        URI oldPrefixURI = URI.createFileURI((String)PersistenceUtil.toPrefix(oldPrefix));
        URI newPrefixURI = URI.createFileURI((String)PersistenceUtil.toPrefix(newPrefix));
        for (Resource resource : resources) {
            URI uri = resource.getURI();
            URI newURI = null;
            try {
                newURI = uri.replacePrefix(oldPrefixURI, newPrefixURI);
            }
            catch (Exception exception) {}
            if (newURI == null) continue;
            resource.setURI(newURI);
        }
    }

    public static URI getProxyURI(EObject object) {
        Resource resource = object.eResource();
        URI uri = null;
        if (resource instanceof ILibraryResource) {
            ILibraryResource libResource = (ILibraryResource)resource;
            uri = libResource.getProxyURI(object);
        } else {
            uri = resource.getURI().appendFragment(resource.getURIFragment(object));
        }
        return uri;
    }

    public static MultiFileResourceSetImpl getImportPluginResourceSet() {
        MultiFileResourceSetImpl resourceSet = new MultiFileResourceSetImpl(false){

            protected void demandLoad(Resource resource) throws IOException {
                if (!this.skipDemandLoad(resource)) {
                    super.demandLoad(resource);
                }
            }

            private boolean skipDemandLoad(Resource res) {
                File file = new File(res.getURI().toFileString());
                return !file.exists() && file.getName().equals("plugin.xmi");
            }
        };
        return resourceSet;
    }

    public static void main(String[] args) {
        String attrib = PersistenceUtil.getTopAttribute(new File(args[0]), args[1]);
        System.out.println(attrib);
    }
}

