/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.export.services;

import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.epf.export.ExportPlugin;
import org.eclipse.epf.export.ExportResources;
import org.eclipse.epf.export.services.ConfigurationExportData;
import org.eclipse.epf.library.ILibraryResourceManager;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.LibraryServiceUtil;
import org.eclipse.epf.library.configuration.closure.ConfigurationClosure;
import org.eclipse.epf.library.edit.util.MethodElementUtil;
import org.eclipse.epf.library.layout.LayoutResources;
import org.eclipse.epf.library.util.LibraryUtil;
import org.eclipse.epf.persistence.refresh.RefreshJob;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.epf.uma.MethodPlugin;

public class ConfigurationExportService {
    public static String excludes = ".copyarea.dat, **/.copyarea.dat, .copyarea.db, **/.copyarea.db";
    private ConfigurationExportData data;

    public ConfigurationExportService(ConfigurationExportData data) {
        this.data = data;
    }

    public void run(IProgressMonitor monitor) {
        try {
            if (this.data.selectedConfigs == null || this.data.selectedConfigs.size() == 0) {
                return;
            }
            monitor.setTaskName(ExportResources.ConfigurationExportService_MSG0);
            String exportLibPath = this.data.llData.getParentFolder();
            File exportLibFolder = new File(exportLibPath);
            if (!exportLibFolder.exists()) {
                exportLibFolder.mkdir();
            }
            MethodConfiguration config = (MethodConfiguration)this.data.selectedConfigs.get(0);
            this.exportConfig(config.getName(), exportLibFolder.getAbsolutePath(), monitor);
        }
        catch (Exception e) {
            ExportPlugin.getDefault().getLogger().logError((Throwable)e);
        }
    }

    public void exportConfig(String selectedConfigName, String filePath, IProgressMonitor monitor) throws Exception {
        boolean refresh = RefreshJob.getInstance().isEnabled();
        try {
            if (refresh) {
                RefreshJob.getInstance().setEnabled(false);
            }
            this.doEexportConfig(selectedConfigName, filePath, monitor);
        }
        finally {
            if (refresh) {
                RefreshJob.getInstance().setEnabled(true);
            }
        }
    }

    private void doEexportConfig(String selectedConfigName, String filePath, IProgressMonitor monitor) throws Exception {
        MethodLibrary currentLib = LibraryService.getInstance().getCurrentMethodLibrary();
        try {
            LibraryUtil.loadAll((MethodLibrary)currentLib);
        }
        catch (Throwable e) {
            ExportPlugin.getDefault().getLogger().logError("Error loading library", e);
            this.data.errorMsg = ExportResources.ConfigurationExportService_MSG2;
            return;
        }
        MethodLibrary newLibrary = null;
        try {
            newLibrary = (MethodLibrary)EcoreUtil.copy((EObject)currentLib);
        }
        catch (Throwable e) {
            ExportPlugin.getDefault().getLogger().logError(e);
            this.data.errorMsg = ExportResources.ConfigurationExportService_MSG4;
            return;
        }
        ConfigurationClosure closure = null;
        try {
            LibraryUtil.detachFromResource((MethodLibrary)newLibrary);
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("library.path", filePath);
            params.put("libraryRegisterType", "ConfigExport");
            LibraryService.getInstance().registerMethodLibrary(newLibrary, "xmi", params);
            MethodConfiguration config = LibraryServiceUtil.getMethodConfiguration((MethodLibrary)newLibrary, (String)selectedConfigName);
            LibraryUtil.validateMethodConfiguration(null, (MethodConfiguration)config);
            closure = new ConfigurationClosure(null, config);
            closure.packageLibrary(this.data.removeBrokenReferences);
        }
        catch (Throwable e) {
            ExportPlugin.getDefault().getLogger().logError("Error making library configuration closure", e);
            this.data.errorMsg = ExportResources.ConfigurationExportService_MSG1;
            if (closure != null) {
                closure.dispose();
            }
            LibraryService.getInstance().unRegisterMethodLibrary(newLibrary);
            return;
        }
        try {
            LibraryUtil.saveAll((MethodLibrary)newLibrary);
            LibraryUtil.saveAll((MethodLibrary)newLibrary);
        }
        catch (Throwable e) {
            ExportPlugin.getDefault().getLogger().logError("Error saving library", e);
            this.data.errorMsg = ExportResources.ConfigurationExportService_MSG9;
            if (closure != null) {
                closure.dispose();
            }
            LibraryService.getInstance().unRegisterMethodLibrary(newLibrary);
            return;
        }
        String includes = "resources/**, **/resources/**, **/diagram.xmi";
        File srcDir = LibraryUtil.getLibraryRootPath((MethodLibrary)currentLib);
        File destDir = LibraryUtil.getLibraryRootPath((MethodLibrary)newLibrary);
        LayoutResources.copyDir((File)srcDir, (File)destDir, (String)includes, (String)excludes);
        this.handleExtraResourceCopy(currentLib, newLibrary, srcDir, destDir, includes);
        if (closure != null) {
            closure.dispose();
        }
        LibraryService.getInstance().unRegisterMethodLibrary(newLibrary);
    }

    private void handleExtraResourceCopy(MethodLibrary baseLib, MethodLibrary exportedLib, File baseLibDir, File exportedLibDir, String includes) {
        ILibraryResourceManager libResMgr = LibraryService.getInstance().getCurrentLibraryManager().getResourceManager();
        Map exportedPluginMap = MethodElementUtil.buildMap((Collection)baseLib.getMethodPlugins());
        List basePlugins = baseLib.getMethodPlugins();
        int i = 0;
        while (i < basePlugins.size()) {
            MethodPlugin exportedPlugin;
            MethodPlugin plugin = (MethodPlugin)basePlugins.get(i);
            File pluginFolder = new File(libResMgr.getPhysicalPath((MethodElement)plugin));
            boolean processed = baseLibDir.equals(pluginFolder.getParentFile());
            if (!processed && (exportedPlugin = (MethodPlugin)exportedPluginMap.get(plugin.getGuid())) != null) {
                File destDir = new File(exportedLibDir, exportedPlugin.getName());
                LayoutResources.copyDir((File)pluginFolder, (File)destDir, (String)includes, (String)excludes);
            }
            ++i;
        }
    }
}

