/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.export.services;

import java.io.File;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.epf.common.utils.FileUtil;
import org.eclipse.epf.export.ExportPlugin;
import org.eclipse.epf.export.ExportResources;
import org.eclipse.epf.export.services.BaseExportService;
import org.eclipse.epf.export.services.ConfigurationExportData;
import org.eclipse.epf.export.services.LibraryDocument;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.epf.uma.MethodPackage;
import org.eclipse.epf.uma.MethodPlugin;

public class ConfigurationSpecsExportService
extends BaseExportService {
    private ConfigurationExportData data;

    public ConfigurationSpecsExportService(ConfigurationExportData data) {
        this.data = data;
    }

    public void run(IProgressMonitor monitor) {
        if (this.data.selectedConfigs == null || this.data.selectedConfigs.size() == 0) {
            return;
        }
        monitor.setTaskName(ExportResources.ConfigurationSpecsExportService_MSG0);
        String exportLibPath = new File(this.data.llData.getParentFolder()).getAbsolutePath();
        File exportLibFolder = new File(exportLibPath);
        if (!exportLibFolder.exists()) {
            exportLibFolder.mkdir();
        }
        MethodConfiguration config = (MethodConfiguration)this.data.selectedConfigs.get(0);
        MethodLibrary lib = (MethodLibrary)config.eContainer();
        URI uri = lib.eResource().getURI();
        String path = uri.toFileString();
        File libFolder = new File(path).getParentFile();
        this.getSelectedIds(this.data.selectedConfigs);
        LibraryDocument document = this.processLibraryFile(new File(libFolder, "library.xmi"), new File(exportLibFolder, "export.xmi"));
        if (document != null) {
            this.copyConfigurationFiles(document, libFolder, exportLibFolder);
        }
        monitor.setTaskName(ExportResources.ConfigurationSpecsExportService_MSG1);
    }

    private void copyConfigurationFiles(LibraryDocument document, File libFolder, File exportLibFolder) {
        for (MethodConfiguration config : this.data.selectedConfigs) {
            String guid = config.getGuid();
            String uri = document.getResourceUri(guid);
            String srcUri = null;
            if (uri == null) {
                URI resUri = config.eResource().getURI();
                srcUri = resUri.toFileString();
                uri = "configurations" + File.separator + resUri.lastSegment();
                uri = document.decodeUri(uri);
            }
            if (uri == null) continue;
            File src = srcUri == null ? new File(libFolder, uri) : new File(srcUri);
            File target = new File(exportLibFolder, uri);
            FileUtil.copyFile((File)src, (File)target);
        }
    }

    private void getSelectedIds(List configs) {
        this.selectedIds.clear();
        this.selectedPluginNames.clear();
        if (configs == null || configs.size() == 0) {
            return;
        }
        for (MethodConfiguration config : configs) {
            String guid = config.getGuid();
            if (this.selectedIds.contains(guid)) continue;
            this.selectedIds.add(guid);
            EList refs = config.eCrossReferences();
            for (Object o : refs) {
                if (o instanceof MethodPlugin || o instanceof MethodPackage) {
                    guid = ((MethodElement)o).getGuid();
                    if (this.selectedIds.contains(guid)) continue;
                    this.selectedIds.add(guid);
                    continue;
                }
                ExportPlugin.getDefault().getLogger().logError("Unexpected element type '" + ((MethodElement)o).getType().getName() + "' in configuration '" + config.getName() + "'");
            }
        }
    }
}

