/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.export.wizards;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.epf.authoring.ui.wizards.SaveAllEditorsPage;
import org.eclipse.epf.export.ExportPlugin;
import org.eclipse.epf.export.ExportResources;
import org.eclipse.epf.export.services.ConfigurationExportData;
import org.eclipse.epf.export.services.ConfigurationExportService;
import org.eclipse.epf.export.services.ConfigurationSpecsExportService;
import org.eclipse.epf.export.wizards.ExportConfigCheckingPage;
import org.eclipse.epf.export.wizards.ExportConfigChooseMode;
import org.eclipse.epf.export.wizards.ExportConfigDestinationPage;
import org.eclipse.epf.export.wizards.ExportConfigSelectConfigPage;
import org.eclipse.epf.export.wizards.ExportConfigSelectSpecsPage;
import org.eclipse.epf.export.wizards.ExportUIPreferences;
import org.eclipse.epf.library.ui.LibraryUIImages;
import org.eclipse.epf.library.ui.wizards.DirectoryValidator;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;

public class ExportConfigurationWizard
extends Wizard
implements IImportWizard {
    protected ExportConfigChooseMode modePage;
    protected ExportConfigSelectSpecsPage selectSpecsPage;
    protected ExportConfigSelectConfigPage selectConfigPage;
    protected ExportConfigCheckingPage configCheckingPage;
    protected ExportConfigDestinationPage destinationPage;
    protected boolean okToComplete = false;
    protected ConfigurationExportData data = new ConfigurationExportData();

    public ExportConfigurationWizard() {
        this.setWindowTitle(ExportResources.exportConfigWizard_title);
        this.setNeedsProgressMonitor(true);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public void addPages() {
        SaveAllEditorsPage.addPageIfNeeded((Wizard)this, (boolean)false, null, null, (ImageDescriptor)ExportPlugin.getDefault().getImageDescriptor("full/wizban/ExportLibraryConfiguration.gif"));
        this.modePage = new ExportConfigChooseMode(this.data);
        this.addPage((IWizardPage)this.modePage);
        this.selectSpecsPage = new ExportConfigSelectSpecsPage(this.data);
        this.addPage((IWizardPage)this.selectSpecsPage);
        this.selectConfigPage = new ExportConfigSelectConfigPage(this.data);
        this.addPage((IWizardPage)this.selectConfigPage);
        this.configCheckingPage = new ExportConfigCheckingPage(this.data);
        this.addPage((IWizardPage)this.configCheckingPage);
        this.destinationPage = new ExportConfigDestinationPage(this.data);
        this.addPage((IWizardPage)this.destinationPage);
    }

    public void createPageControls(Composite pageContainer) {
        super.createPageControls(pageContainer);
        pageContainer.getShell().setImage(LibraryUIImages.IMG_METHOD_CONFIGURATON);
    }

    public boolean canFinish() {
        if (this.getContainer().getCurrentPage() != this.destinationPage) {
            return false;
        }
        return this.okToComplete;
    }

    public boolean performFinish() {
        String exportLibPath = this.data.llData.getParentFolder();
        if (!this.checkAndCreateDir(exportLibPath)) {
            return false;
        }
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    try {
                        monitor.beginTask(ExportResources.exportConfigErrorDialog_title, -1);
                        if (ExportConfigurationWizard.this.data.validate()) {
                            if (ExportConfigurationWizard.this.data.exportConfigSpecs) {
                                new ConfigurationSpecsExportService(ExportConfigurationWizard.this.data).run(monitor);
                            } else {
                                new ConfigurationExportService(ExportConfigurationWizard.this.data).run(monitor);
                            }
                        }
                    }
                    catch (Exception e) {
                        throw new InvocationTargetException(e);
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            this.getContainer().run(true, false, op);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException e) {
            Throwable realException = e.getTargetException();
            ExportPlugin.getDefault().getMsgDialog().displayError(ExportResources.exportConfigErrorDialog_title, realException.getMessage());
            return false;
        }
        if (this.data.errorMsg != null && this.data.errorMsg.length() > 0) {
            ExportPlugin.getDefault().getMsgDialog().displayError(ExportResources.exportConfigErrorDialog_title, this.data.errorMsg);
        }
        ExportUIPreferences.addExportConfigDir(exportLibPath);
        return true;
    }

    private boolean checkAndCreateDir(String dir) {
        return DirectoryValidator.checkAndCreateDir((String)dir, (String)ExportResources.exportConfigErrorDialog_title, (String)ExportResources.ExportPluginError_msg, (boolean)false);
    }
}

