/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.export.wizards;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.epf.authoring.ui.wizards.ConfigurationTableLabelProvider;
import org.eclipse.epf.export.ExportPlugin;
import org.eclipse.epf.export.ExportResources;
import org.eclipse.epf.export.services.PluginExportData;
import org.eclipse.epf.export.wizards.ExportPluginSummaryPage;
import org.eclipse.epf.export.wizards.ExportPluginWizard;
import org.eclipse.epf.library.ui.LibraryUIImages;
import org.eclipse.epf.library.util.LibraryUtil;
import org.eclipse.epf.ui.wizards.BaseWizardPage;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;

public class PluginInfoPage
extends BaseWizardPage
implements ISelectionChangedListener,
Listener {
    public static final String PAGE_NAME = PluginInfoPage.class.getName();
    private Table table;
    private TableViewer ctrl_tableViewer;
    private TableViewer ctrl_dependPluginsViewer;
    private TableViewer ctrl_associatedConfigViewer;
    private List dependentPluginList = new ArrayList();
    private List associatedConfigList = new ArrayList();
    private PluginExportData data;

    public PluginInfoPage(PluginExportData data) {
        super(PAGE_NAME);
        this.setTitle(ExportResources.reviewPluginsPage_title);
        this.setDescription(ExportResources.reviewPluginsPage_desc);
        this.setImageDescriptor(ExportPlugin.getDefault().getImageDescriptor("full/wizban/exp_meth_plugin_wizban.gif"));
        this.data = data;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout());
        PluginInfoPage.createLabel((Composite)container, (String)ExportResources.reviewPluginsPage_pluginsLabel_text);
        this.ctrl_tableViewer = PluginInfoPage.createTableViewer((Composite)container, (int)360, (int)60, (int)1);
        this.table = this.ctrl_tableViewer.getTable();
        LabelProvider labelProvider = new LabelProvider(){

            public Image getImage(Object element) {
                return LibraryUIImages.IMG_METHOD_PLUGIN;
            }

            public String getText(Object element) {
                if (element instanceof MethodPlugin) {
                    return ((MethodPlugin)element).getName();
                }
                return element.toString();
            }
        };
        this.ctrl_tableViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        this.ctrl_tableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        if (this.data.getSelectedPlugins() != null) {
            this.ctrl_tableViewer.setInput((Object)this.data.getSelectedPlugins().toArray());
        }
        PluginInfoPage.createLabel((Composite)container, (String)ExportResources.reviewPluginsPage_dependentPluginsLabel_text);
        this.ctrl_dependPluginsViewer = PluginInfoPage.createTableViewer((Composite)container, (int)360, (int)60, (int)1);
        this.ctrl_dependPluginsViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        this.ctrl_dependPluginsViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.ctrl_dependPluginsViewer.setInput((Object)this.dependentPluginList);
        PluginInfoPage.createLabel((Composite)container, (String)ExportResources.reviewPluginsPage_associatedConfigsLabel_text);
        this.ctrl_associatedConfigViewer = PluginInfoPage.createTableViewer((Composite)container, (int)360, (int)60, (int)1);
        this.ctrl_associatedConfigViewer.setLabelProvider((IBaseLabelProvider)new ConfigurationTableLabelProvider());
        this.ctrl_associatedConfigViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.ctrl_associatedConfigViewer.setInput((Object)this.associatedConfigList);
        if (this.data.getSelectedPlugins() != null && !this.data.getSelectedPlugins().isEmpty()) {
            this.table.select(0);
            this.displayRelatedInfo(this.data.getSelectedPlugins().iterator().next());
        }
        this.addListeners();
        this.setControl((Control)container);
        this.setPageComplete(false);
    }

    private void addListeners() {
        this.ctrl_tableViewer.addSelectionChangedListener((ISelectionChangedListener)this);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        StructuredSelection selection = (StructuredSelection)event.getSelection();
        if (!selection.isEmpty()) {
            Object[] plugin = selection.toArray();
            this.displayRelatedInfo((MethodPlugin)plugin[0]);
        }
    }

    public void handleEvent(Event event) {
        this.setPageComplete(this.isPageComplete());
        this.getWizard().getContainer().updateButtons();
    }

    public void onEnterPage(Object obj) {
        if (this.data.getSelectedPlugins() != null && !this.data.getSelectedPlugins().isEmpty()) {
            this.ctrl_tableViewer.setInput((Object)this.data.getSelectedPlugins().toArray());
            this.table.select(0);
            this.displayRelatedInfo(this.data.getSelectedPlugins().iterator().next());
        }
    }

    private void displayRelatedInfo(MethodPlugin plugin) {
        if (plugin == null) {
            return;
        }
        this.dependentPluginList = plugin.getBases();
        this.ctrl_dependPluginsViewer.setInput((Object)this.dependentPluginList.toArray());
        this.associatedConfigList = LibraryUtil.getAssociatedConfigurations((MethodPlugin)plugin);
        this.ctrl_associatedConfigViewer.setInput((Object)this.associatedConfigList.toArray());
    }

    public boolean isPageComplete() {
        return true;
    }

    protected void saveDataToModel() {
        if (this.data.getSelectedPlugins() != null) {
            this.data.associatedConfigMap.clear();
            for (MethodPlugin element : this.data.getSelectedPlugins()) {
                this.data.associatedConfigMap.put(element, LibraryUtil.getAssociatedConfigurations((MethodPlugin)element));
            }
        }
    }

    public IWizardPage getNextPage() {
        this.saveDataToModel();
        ExportPluginSummaryPage page = ((ExportPluginWizard)this.getWizard()).page3;
        page.onEnterPage(null);
        return page;
    }
}

