/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.validation.model;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.emf.validation.internal.EMFModelValidationStatusCodes;
import org.eclipse.emf.validation.internal.l10n.ValidationMessages;
import org.eclipse.emf.validation.internal.util.TextUtils;
import org.eclipse.emf.validation.model.IConstraintStatus;
import org.eclipse.emf.validation.model.IModelConstraint;
import org.eclipse.emf.validation.service.ConstraintRegistry;
import org.eclipse.emf.validation.service.IConstraintDescriptor;

public class ConstraintStatus
extends Status
implements IConstraintStatus {
    private final IModelConstraint constraint;
    private EObject target;
    private Set resultLocus;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.emf.validation.model.ConstraintStatus");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public ConstraintStatus(IModelConstraint constraint, EObject target, String message, Set resultLocus) {
        this(constraint, target, constraint.getDescriptor().getSeverity().toIStatusSeverity(), constraint.getDescriptor().getStatusCode(), message, resultLocus);
    }

    public ConstraintStatus(IModelConstraint constraint, EObject target) {
        this(constraint, target, 0, 0, EMFModelValidationStatusCodes.CONSTRAINT_SUCCESS_MSG, null);
    }

    public ConstraintStatus(IModelConstraint constraint, EObject target, int severity, int code, String message, Set resultLocus) {
        super(severity, constraint.getDescriptor().getPluginId(), code, message, null);
        if (!$assertionsDisabled && constraint == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && target == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && message == null) {
            throw new AssertionError();
        }
        this.constraint = constraint;
        this.target = target;
        this.resultLocus = resultLocus != null ? Collections.unmodifiableSet(new HashSet(resultLocus)) : Collections.EMPTY_SET;
    }

    public static ConstraintStatus createStatus(IValidationContext ctx, EObject target, Collection resultLocus, String messagePattern, Object[] messageArguments) {
        IConstraintDescriptor desc = ConstraintRegistry.getInstance().getDescriptor(ctx.getCurrentConstraintId());
        return ConstraintStatus.createStatus(ctx, target, resultLocus, desc.getSeverity().toIStatusSeverity(), desc.getStatusCode(), messagePattern, messageArguments);
    }

    public static ConstraintStatus createStatus(IValidationContext ctx, EObject target, Collection resultLocus, int severity, int errorCode, String messagePattern, Object[] messageArguments) {
        Set<EObject> results;
        ConstraintStatus result = (ConstraintStatus)ctx.createFailureStatus(null);
        if (target != null) {
            result.target = target;
        }
        if (resultLocus == null) {
            results = Collections.singleton(result.getTarget());
        } else {
            results = new HashSet<EObject>(resultLocus);
            if (!results.contains(result.getTarget())) {
                results.add(result.getTarget());
            }
        }
        String message = TextUtils.formatMessage(messagePattern, messageArguments == null ? new Object[]{} : messageArguments);
        result.setMessage(message);
        result.setSeverity(severity);
        result.setCode(errorCode);
        result.resultLocus = results;
        return result;
    }

    public static ConstraintStatus createStatus(IValidationContext ctx, Collection resultLocus, String messagePattern, Object[] messageArguments) {
        IConstraintDescriptor desc = ConstraintRegistry.getInstance().getDescriptor(ctx.getCurrentConstraintId());
        return ConstraintStatus.createStatus(ctx, null, resultLocus, desc.getSeverity().toIStatusSeverity(), desc.getStatusCode(), messagePattern, messageArguments);
    }

    public static ConstraintStatus createStatus(IValidationContext ctx, Collection resultLocus, int severity, int errorCode, String messagePattern, Object[] messageArguments) {
        return ConstraintStatus.createStatus(ctx, null, resultLocus, severity, errorCode, messagePattern, messageArguments);
    }

    public static IStatus createSuccessStatus(IValidationContext ctx, EObject target, Collection resultLocus) {
        IStatus status = ctx.createSuccessStatus();
        if (status instanceof IConstraintStatus) {
            Set<EObject> results;
            IConstraintStatus successStatus = (IConstraintStatus)status;
            ConstraintStatus constraintStatus = new ConstraintStatus(successStatus.getConstraint(), target);
            if (resultLocus == null) {
                results = Collections.singleton(target);
            } else {
                results = new HashSet<EObject>(resultLocus);
                if (!results.contains(target)) {
                    results.add(target);
                }
            }
            constraintStatus.resultLocus = results;
            return constraintStatus;
        }
        return status;
    }

    public static IStatus createMultiStatus(IValidationContext ctx, Collection statuses) {
        return ConstraintStatus.createMultiStatus(ctx, ValidationMessages.eval_some_fail_WARN_, null, statuses);
    }

    public static IStatus createMultiStatus(IValidationContext ctx, String messagePattern, Object[] messageArguments, Collection statuses) {
        if (statuses == null || statuses.isEmpty()) {
            throw new IllegalArgumentException("no statuses to aggregate");
        }
        IStatus[] children = statuses.toArray(new IStatus[statuses.size()]);
        IConstraintDescriptor desc = ConstraintRegistry.getInstance().getDescriptor(ctx.getCurrentConstraintId());
        String message = TextUtils.formatMessage(messagePattern, messageArguments == null ? new Object[]{} : messageArguments);
        return new Multi(desc.getPluginId(), desc.getStatusCode(), children, message);
    }

    public final IModelConstraint getConstraint() {
        return this.constraint;
    }

    public final EObject getTarget() {
        return this.target;
    }

    public final Set getResultLocus() {
        return this.resultLocus;
    }

    private static final class Multi
    extends MultiStatus
    implements IConstraintStatus {
        private final IModelConstraint constraint;
        private final EObject target;
        private final Set resultLocus;

        Multi(String pluginId, int code, IStatus[] children, String message) {
            super(pluginId, code, children, message, null);
            IConstraintStatus prototype = null;
            int i = 0;
            while (i < children.length) {
                if (children[i] instanceof IConstraintStatus) {
                    prototype = (IConstraintStatus)children[i];
                    break;
                }
                ++i;
            }
            if (prototype == null) {
                this.constraint = null;
                this.target = null;
                this.resultLocus = Collections.EMPTY_SET;
            } else {
                this.constraint = prototype.getConstraint();
                this.target = prototype.getTarget();
                this.resultLocus = Collections.singleton(this.target);
            }
        }

        public IModelConstraint getConstraint() {
            return this.constraint;
        }

        public EObject getTarget() {
            return this.target;
        }

        public Set getResultLocus() {
            return this.resultLocus;
        }
    }
}

