/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.publishing.services;

import java.io.File;
import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.epf.common.serviceability.DebugTrace;
import org.eclipse.epf.library.util.FileNameGenerator;
import org.eclipse.epf.library.util.LibraryUtil;
import org.eclipse.epf.publishing.PublishingPlugin;
import org.eclipse.epf.publishing.PublishingResources;
import org.eclipse.epf.publishing.services.AbstractViewBuilder;
import org.eclipse.epf.publishing.services.ISiteGenerator;
import org.eclipse.epf.publishing.services.PublishHTMLOptions;
import org.eclipse.epf.publishing.services.PublishOptions;
import org.eclipse.epf.publishing.services.PublishingServiceException;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodLibrary;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPublishManager {
    protected static boolean debug = PublishingPlugin.getDefault().isDebugging();
    protected static boolean profiling = PublishingPlugin.getDefault().isProfiling();
    protected String pubDir;
    protected MethodConfiguration config;
    protected PublishHTMLOptions options;
    protected AbstractViewBuilder viewBuilder;
    protected boolean success = false;

    public void init(String pubDir, MethodConfiguration config, PublishOptions options) {
        this.pubDir = pubDir;
        if (!this.pubDir.endsWith(File.separator)) {
            this.pubDir = String.valueOf(this.pubDir) + File.separator;
        }
        this.config = config;
        if (!(options instanceof PublishHTMLOptions)) {
            throw new IllegalArgumentException();
        }
        this.options = (PublishHTMLOptions)options;
        this.viewBuilder = this.createViewBuilder();
    }

    public AbstractViewBuilder getViewBuilder() {
        return this.viewBuilder;
    }

    public ISiteGenerator getSiteGenerator() {
        return this.viewBuilder.getSiteGenerator();
    }

    public void publish(IProgressMonitor monitor) throws PublishingServiceException {
        if (this.options != null) {
            this.options.validate();
        }
        FileNameGenerator.INSTANCE.clear();
        long beginTime = 0L;
        long startTime = 0L;
        Runtime.getRuntime().gc();
        try {
            try {
                if (profiling) {
                    beginTime = startTime = System.currentTimeMillis();
                }
                this.prePublish(monitor);
                if (profiling) {
                    DebugTrace.print((Object)this, (String)"prePublish", (String)(String.valueOf(System.currentTimeMillis() - startTime) + " ms"));
                }
                if (profiling) {
                    startTime = System.currentTimeMillis();
                }
                this.doPublish(monitor);
                if (profiling) {
                    DebugTrace.print((Object)this, (String)"doPublish", (String)(String.valueOf(System.currentTimeMillis() - startTime) + " ms"));
                }
                if (profiling) {
                    startTime = System.currentTimeMillis();
                }
                this.postPublish(monitor);
                if (profiling) {
                    DebugTrace.print((Object)this, (String)"postPublish", (String)(String.valueOf(System.currentTimeMillis() - startTime) + " ms"));
                }
                this.success = true;
            }
            catch (Exception e) {
                throw new PublishingServiceException(e);
            }
        }
        finally {
            if (profiling) {
                System.out.println("Time taken to publish configuration '" + this.config.getName() + "': " + (System.currentTimeMillis() - beginTime) + " ms");
            }
        }
    }

    protected Collection<Resource> loadLibrary(IProgressMonitor monitor) {
        long startTime = 0L;
        monitor.subTask(PublishingResources.loadLibraryTask_name);
        if (profiling) {
            startTime = System.currentTimeMillis();
        }
        Collection changedResources = LibraryUtil.loadAll((MethodLibrary)((MethodLibrary)this.config.eContainer()));
        if (profiling) {
            DebugTrace.print((Object)this, (String)"loadLibrary", (String)("LibraryUtil.loadAll: " + (System.currentTimeMillis() - startTime) + " ms"));
        }
        return changedResources;
    }

    public void dispose() {
        if (this.viewBuilder != null) {
            this.viewBuilder.dispose();
            this.viewBuilder = null;
        }
    }

    public abstract String getPublishedUrl();

    public abstract String getPublishReportUrl();

    protected abstract AbstractViewBuilder createViewBuilder();

    protected abstract void prePublish(IProgressMonitor var1) throws Exception;

    protected abstract void doPublish(IProgressMonitor var1) throws Exception;

    protected abstract void postPublish(IProgressMonitor var1) throws Exception;
}

