/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.publishing.services;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.epf.library.layout.util.XmlElement;

public class IndexList {
    private TreeMap itemMap = new TreeMap();

    public void clear() {
        this.itemMap.clear();
    }

    public void add(String term, String content, String url) {
        IndexItem item = new IndexItem(term, content, url);
        String group = "" + item.termName.charAt(0);
        this.getItemList(group).add(item);
    }

    private List getItemList(String group) {
        ArrayList l = (ArrayList)this.itemMap.get(group = group.toUpperCase());
        if (l == null) {
            l = new ArrayList();
            this.itemMap.put(group, l);
        }
        return l;
    }

    public StringBuffer getXml() {
        XmlElement xe = new XmlElement("Index");
        for (Map.Entry entry : this.itemMap.entrySet()) {
            String group = (String)entry.getKey();
            List items = (List)entry.getValue();
            xe.newChild("item").setAttribute("name", group).setAttribute("presentationName", group).setAttribute("navigation-mark", "true").setAttribute("content", "");
            for (IndexItem item : items) {
                xe.newChild("item").setAttribute("name", item.termName).setAttribute("presentationName", item.termName).setAttribute("content", item.content).setAttribute("url", item.url);
            }
        }
        return xe.toXml();
    }

    class IndexItem {
        public String termName;
        public String content;
        public String url;

        public IndexItem(String termName, String content, String url) {
            this.termName = termName;
            this.content = content;
            this.url = url;
        }
    }
}

