/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.common.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.URL;
import java.nio.CharBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.eclipse.epf.common.CommonPlugin;
import org.eclipse.epf.common.utils.NetUtil;
import org.eclipse.epf.common.utils.StrUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileUtil {
    public static final String LINE_SEP = System.getProperty("line.separator");
    public static final String FILE_SEP = System.getProperty("file.separator");
    public static final int LINE_SEP_LENGTH = LINE_SEP.length();
    public static final String UNC_PATH_PREFIX = "\\\\";
    public static final int UNC_PATH_PREFIX_LENGTH = "\\\\".length();
    public static final String ENCODING_ISO_8859_1 = "ISO-8859-1";
    public static final String ENCODING_UTF_8 = "UTF-8";

    private FileUtil() {
    }

    public static String getAbsolutePath(File file) {
        return file.getAbsolutePath().replace('\\', '/');
    }

    public static String getAbsolutePath(String path) {
        return FileUtil.getAbsolutePath(new File(path));
    }

    public static String getAbsolutePath(URL url) {
        String pathName = url.getFile().substring(1);
        String result = NetUtil.decodeUrl(pathName, null);
        return result;
    }

    public static String getParentDirectory(String path) {
        return new File(path).getParent();
    }

    public static String getFileName(String path) {
        return FileUtil.getFileName(path, true);
    }

    public static String getFileName(String path, boolean withExtension) {
        String normalizedPath = path.replace('\\', '/');
        int prefixLength = 0;
        if (normalizedPath.startsWith("file:/")) {
            prefixLength = NetUtil.FILE_URI_PREFIX_LENGTH;
        } else if (normalizedPath.startsWith("http://")) {
            prefixLength = NetUtil.HTTP_URI_PREFIX_LENGTH;
        }
        int index = normalizedPath.lastIndexOf("/");
        String fileName = index < prefixLength ? normalizedPath.substring(prefixLength) : path.substring(index + 1);
        if (withExtension) {
            return fileName;
        }
        index = fileName.indexOf(".");
        return index > 0 ? fileName.substring(0, index) : fileName;
    }

    public static String getRelativePathToBase(File path, File basePath) {
        try {
            String dir = path.toURL().toExternalForm();
            String baseDir = basePath.toURL().toExternalForm();
            StringBuffer result = new StringBuffer();
            if (dir.indexOf(baseDir) == 0) {
                String delta = dir.substring(baseDir.length());
                int i = 0;
                while (i < delta.length()) {
                    if (delta.charAt(i) == '/') {
                        result.append("../");
                    }
                    ++i;
                }
            }
            return result.toString();
        }
        catch (Exception exception) {
            return "";
        }
    }

    public static String getRelativePath(File path, File basePath) {
        try {
            String dir = path.toURL().toExternalForm();
            String baseDir = FileUtil.appendSeparator(basePath.toURL().toExternalForm(), "/");
            StringBuffer result = new StringBuffer();
            while (dir.indexOf(baseDir) == -1) {
                basePath = basePath.getParentFile();
                baseDir = FileUtil.appendSeparator(basePath.toURL().toExternalForm(), "/");
                result.append("../");
            }
            if (dir.indexOf(baseDir) == 0) {
                String delta = dir.substring(baseDir.length());
                result.append(delta);
            }
            return result.toString();
        }
        catch (Exception exception) {
            return "";
        }
    }

    public static String appendSeparator(String path) {
        return FileUtil.appendSeparator(path, File.separator);
    }

    public static String appendSeparator(String path, String separator) {
        return path.endsWith(separator) ? path : String.valueOf(path) + separator;
    }

    public static String removeSeparator(String path) {
        return path.endsWith(File.separator) ? path.substring(0, path.length() - 1) : path;
    }

    public static String removeAllSeparator(String path) {
        return path.endsWith("/") || path.endsWith("\\") ? path.substring(0, path.length() - 1) : path;
    }

    public static String removeSeparator(String path, String separator) {
        return path.endsWith(separator) ? path.substring(0, path.length() - 1) : path;
    }

    public static String replaceFileName(String path, String oldFileName, String newFileName) {
        int index = path.lastIndexOf(oldFileName);
        return String.valueOf(path.substring(0, index)) + newFileName;
    }

    public static String replaceExtension(String path, String oldExt, String newExt) {
        int index = path.lastIndexOf(oldExt);
        return String.valueOf(path.substring(0, index)) + newExt;
    }

    public static String getLocalePath(String path, String localeStr) {
        if (StrUtil.isBlank(localeStr)) {
            return path;
        }
        String fileName = FileUtil.getFileName(path);
        return FileUtil.replaceFileName(path, fileName, String.valueOf(localeStr) + "/" + fileName);
    }

    public static String getLocalePath(String path, Locale locale) {
        return locale == null ? path : FileUtil.getLocalePath(path, locale.toString());
    }

    public static boolean writeFile(String filename, String text) {
        block14: {
            FileWriter writer = null;
            try {
                try {
                    writer = new FileWriter(filename);
                    writer.write(text);
                    writer.flush();
                }
                catch (IOException iOException) {
                    if (writer != null) {
                        try {
                            writer.close();
                            return true;
                        }
                        catch (Exception exception) {}
                    }
                    break block14;
                }
            }
            catch (Throwable throwable) {
                if (writer != null) {
                    try {
                        writer.close();
                        return true;
                    }
                    catch (Exception exception) {}
                }
                throw throwable;
            }
            if (writer != null) {
                try {
                    writer.close();
                    return true;
                }
                catch (Exception exception) {}
            }
        }
        return false;
    }

    public static boolean writeUTF8File(String filename, String text) {
        return FileUtil.writeUTF8File(filename, text, false);
    }

    public static boolean writeUTF8File(String filename, String text, boolean append) {
        block23: {
            OutputStreamWriter writer = null;
            FileOutputStream fileOut = null;
            try {
                try {
                    fileOut = new FileOutputStream(filename, append);
                    writer = new OutputStreamWriter((OutputStream)fileOut, ENCODING_UTF_8);
                    writer.write(text);
                    writer.flush();
                    fileOut.flush();
                }
                catch (IOException e) {
                    CommonPlugin.getDefault().getLogger().logError(e);
                    if (writer != null) {
                        try {
                            writer.close();
                            return true;
                        }
                        catch (Exception exception) {}
                    }
                    if (fileOut != null) {
                        try {
                            fileOut.close();
                            return true;
                        }
                        catch (Exception exception) {}
                    }
                    break block23;
                }
            }
            catch (Throwable throwable) {
                if (writer != null) {
                    try {
                        writer.close();
                        return true;
                    }
                    catch (Exception exception) {}
                }
                if (fileOut != null) {
                    try {
                        fileOut.close();
                        return true;
                    }
                    catch (Exception exception) {}
                }
                throw throwable;
            }
            if (writer != null) {
                try {
                    writer.close();
                    return true;
                }
                catch (Exception exception) {}
            }
            if (fileOut != null) {
                try {
                    fileOut.close();
                    return true;
                }
                catch (Exception exception) {}
            }
        }
        return false;
    }

    public static void writeFile(String uri, OutputStream output) throws IOException {
        if (uri == null) {
            return;
        }
        InputStream input = null;
        try {
            int bytesRead;
            input = NetUtil.getInputStream(uri);
            byte[] buf = new byte[4096];
            while ((bytesRead = input.read(buf, 0, 4096)) > 0) {
                output.write(buf, 0, bytesRead);
            }
            output.flush();
        }
        catch (Throwable throwable) {
            if (input != null) {
                try {
                    input.close();
                }
                catch (Exception exception) {}
            }
            throw throwable;
        }
        if (input != null) {
            try {
                input.close();
            }
            catch (Exception exception) {}
        }
    }

    public static void writeFile(String uri, PrintWriter pw) throws IOException {
        if (uri == null) {
            return;
        }
        InputStreamReader input = null;
        try {
            int charsRead;
            input = new InputStreamReader(NetUtil.getInputStream(uri));
            char[] buf = new char[4096];
            while ((charsRead = input.read(buf, 0, 4096)) > 0) {
                pw.write(buf, 0, charsRead);
            }
            pw.flush();
        }
        catch (Throwable throwable) {
            if (input != null) {
                try {
                    input.close();
                }
                catch (Exception exception) {}
            }
            throw throwable;
        }
        if (input != null) {
            try {
                input.close();
            }
            catch (Exception exception) {}
        }
    }

    public static boolean deleteAllFiles(String dir) {
        boolean ret = true;
        File targetDir = new File(dir);
        File[] files = targetDir.listFiles();
        if (files != null) {
            int i = 0;
            while (i < files.length) {
                if (files[i].isDirectory()) {
                    ret = ret && FileUtil.deleteAllFiles(files[i].getAbsolutePath());
                }
                ret = ret && files[i].delete();
                ++i;
            }
        }
        return ret;
    }

    public static boolean deleteAllFiles(String dir, List<File> filesNotToDelete) {
        boolean ret = true;
        File targetDir = new File(dir);
        File[] files = targetDir.listFiles();
        if (files != null) {
            int i = 0;
            while (i < files.length) {
                if (!filesNotToDelete.contains(files[i])) {
                    if (files[i].isDirectory()) {
                        ret = ret && FileUtil.deleteAllFiles(files[i].getAbsolutePath(), filesNotToDelete);
                    }
                    ret = ret && files[i].delete();
                }
                ++i;
            }
        }
        return ret;
    }

    public static boolean copyFile(File srcFile, File tgtFile) {
        try {
            return FileUtil.copyfile(srcFile, tgtFile);
        }
        catch (IOException ex) {
            CommonPlugin.getDefault().getLogger().logError(ex);
            return false;
        }
    }

    public static boolean copyFile(String srcFileName, String tgtFileName) {
        return FileUtil.copyFile(new File(srcFileName), new File(tgtFileName));
    }

    private static boolean copyfile(File source, File dest) throws IOException {
        if (source.equals(dest)) {
            return false;
        }
        if (!source.exists() || !source.canRead()) {
            return false;
        }
        if (dest.exists() && !dest.canWrite()) {
            return false;
        }
        if (source.isDirectory()) {
            if (dest.isFile()) {
                return false;
            }
            return FileUtil.copydirectory(source, dest);
        }
        if (dest.isDirectory()) {
            String sourceFileName = source.getName();
            return FileUtil.copyfile(source, new File(dest, sourceFileName));
        }
        boolean needCopy = true;
        if (dest.exists()) {
            boolean bl = needCopy = dest.lastModified() != source.lastModified() || dest.length() != source.length();
        }
        if (needCopy) {
            FileOutputStream output;
            block22: {
                FileInputStream input = null;
                output = null;
                try {
                    input = new FileInputStream(source);
                    FileChannel in = input.getChannel();
                    if (!dest.exists()) {
                        dest.getParentFile().mkdirs();
                    }
                    output = new FileOutputStream(dest);
                    FileChannel out = output.getChannel();
                    out.transferFrom(in, 0L, source.length());
                    dest.setLastModified(source.lastModified());
                    if (input == null) break block22;
                }
                catch (Throwable throwable) {
                    if (input != null) {
                        try {
                            input.close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (output != null) {
                        try {
                            output.close();
                        }
                        catch (IOException iOException) {}
                    }
                    throw throwable;
                }
                try {
                    input.close();
                }
                catch (IOException iOException) {}
            }
            if (output != null) {
                try {
                    output.close();
                }
                catch (IOException iOException) {}
            }
            return true;
        }
        return true;
    }

    public static boolean copyDir(File srcDir, File tgtDir) {
        try {
            return FileUtil.copydirectory(srcDir, tgtDir);
        }
        catch (IOException ex) {
            CommonPlugin.getDefault().getLogger().logError(ex);
            return false;
        }
    }

    public static boolean copyDir(String srcDirName, String tgtDirName) {
        return FileUtil.copyDir(new File(srcDirName), new File(tgtDirName));
    }

    private static boolean copydirectory(File sourceDir, File destDir) throws IOException {
        if (!sourceDir.exists() || !destDir.exists()) {
            return false;
        }
        if (!sourceDir.isDirectory() || !destDir.isDirectory()) {
            return false;
        }
        File[] files = sourceDir.listFiles();
        if (files != null) {
            int i = 0;
            while (i < files.length) {
                String destName = destDir + File.separator + files[i].getAbsolutePath().substring(sourceDir.getAbsolutePath().length() + 1);
                if (files[i].isFile()) {
                    FileUtil.copyfile(files[i], new File(destName));
                } else if (files[i].isDirectory()) {
                    File destFile = new File(destName);
                    destFile.mkdirs();
                    FileUtil.copydirectory(files[i], destFile);
                }
                ++i;
            }
        }
        return true;
    }

    public static CharBuffer readFile(File file) throws IOException {
        FileInputStream input = null;
        CharBuffer charBuffer = null;
        try {
            input = new FileInputStream(file);
            FileChannel inChannel = input.getChannel();
            int length = (int)inChannel.size();
            MappedByteBuffer byteBuffer = inChannel.map(FileChannel.MapMode.READ_ONLY, 0L, length);
            Charset charset = Charset.forName(ENCODING_ISO_8859_1);
            CharsetDecoder decoder = charset.newDecoder();
            charBuffer = decoder.decode(byteBuffer);
        }
        catch (Throwable throwable) {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (input != null) {
            try {
                input.close();
            }
            catch (IOException iOException) {}
        }
        return charBuffer;
    }

    public static String readInputStream(InputStream input) throws IOException {
        String result = "";
        byte[] readData = new byte[8192];
        try {
            int bytesRead = input.read(readData);
            while (bytesRead > 0) {
                result = String.valueOf(result) + new String(readData);
                bytesRead = input.read(readData);
            }
        }
        catch (Throwable throwable) {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (input != null) {
            try {
                input.close();
            }
            catch (IOException iOException) {}
        }
        return result;
    }

    public static StringBuffer readFile(File file, String encoding) throws IOException {
        StringBuffer result = new StringBuffer();
        FileInputStream fis = null;
        InputStreamReader reader = null;
        try {
            try {
                int size;
                Charset cs = Charset.forName(encoding);
                CharsetDecoder csd = cs.newDecoder();
                csd.onMalformedInput(CodingErrorAction.REPLACE);
                char[] buffer = new char[1024];
                fis = new FileInputStream(file);
                reader = new InputStreamReader((InputStream)fis, csd);
                while ((size = reader.read(buffer, 0, 1024)) > 0) {
                    result.append(buffer, 0, size);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                if (fis != null) {
                    fis.close();
                }
                if (reader != null) {
                    reader.close();
                }
            }
        }
        finally {
            if (fis != null) {
                fis.close();
            }
            if (reader != null) {
                reader.close();
            }
        }
        return result;
    }

    /*
     * Loose catch block
     */
    public static long getSize(File file) {
        FileInputStream fis = null;
        fis = new FileInputStream(file);
        long l = fis.getChannel().size();
        try {
            fis.close();
        }
        catch (Exception exception) {}
        return l;
        catch (IOException iOException) {
            try {}
            catch (Throwable throwable) {
                try {
                    fis.close();
                }
                catch (Exception exception) {}
                throw throwable;
            }
            try {
                fis.close();
            }
            catch (Exception exception) {}
        }
        return -1L;
    }

    public static boolean isFileLocked(File file) {
        boolean isLocked;
        block17: {
            isLocked = false;
            FileOutputStream input = null;
            FileLock lock = null;
            if (!file.exists()) {
                return false;
            }
            try {
                try {
                    input = new FileOutputStream(file);
                    FileChannel fileChannel = input.getChannel();
                    lock = fileChannel.tryLock();
                    if (lock == null) {
                        isLocked = true;
                    } else {
                        lock.release();
                    }
                }
                catch (Exception e) {
                    isLocked = e instanceof SecurityException ? true : (e instanceof FileNotFoundException ? false : (e instanceof IOException ? true : !(e instanceof OverlappingFileLockException)));
                    if (input != null) {
                        try {
                            input.close();
                        }
                        catch (Exception exception) {}
                    }
                    break block17;
                }
            }
            catch (Throwable throwable) {
                if (input != null) {
                    try {
                        input.close();
                    }
                    catch (Exception exception) {}
                }
                throw throwable;
            }
            if (input != null) {
                try {
                    input.close();
                }
                catch (Exception exception) {}
            }
        }
        return isLocked;
    }

    /*
     * Loose catch block
     */
    public static FileLock lockFile(File file) {
        FileLock lock;
        FileOutputStream input;
        block16: {
            input = null;
            lock = null;
            input = new FileOutputStream(file);
            FileChannel fileChannel = input.getChannel();
            lock = fileChannel.tryLock();
            if (!lock.isValid()) break block16;
            FileLock fileLock = lock;
            try {
                if (!(input == null || lock != null && lock.isValid())) {
                    input.close();
                }
            }
            catch (Exception exception) {}
            return fileLock;
            catch (Exception exception) {
                try {}
                catch (Throwable throwable) {
                    try {
                        if (!(input == null || lock != null && lock.isValid())) {
                            input.close();
                        }
                    }
                    catch (Exception exception2) {}
                    throw throwable;
                }
                try {
                    if (!(input == null || lock != null && lock.isValid())) {
                        input.close();
                    }
                }
                catch (Exception exception3) {}
                return null;
            }
        }
        try {
            if (!(input == null || lock != null && lock.isValid())) {
                input.close();
            }
        }
        catch (Exception exception) {}
        return null;
    }

    public static void getAllFiles(File path, List<File> fileList, boolean recursive) {
        File[] files;
        if (path.isDirectory() && (files = path.listFiles()) != null) {
            int i = 0;
            while (i < files.length) {
                if (files[i].isFile()) {
                    fileList.add(files[i]);
                } else if (recursive) {
                    FileUtil.getAllFiles(files[i], fileList, recursive);
                }
                ++i;
            }
        }
    }

    public static List<File> fileList(File f, String extension) {
        extension = extension.toUpperCase();
        ArrayList<File> returnList = new ArrayList<File>();
        try {
            if (f.isDirectory()) {
                String[] flist = f.list();
                int i = 0;
                while (i < flist.length) {
                    File fc = new File(f.getPath(), flist[i]);
                    returnList.addAll(FileUtil.fileList(fc, extension));
                    ++i;
                }
            } else if (extension != null) {
                String name = f.getName().toUpperCase();
                if (name.lastIndexOf(".") != -1 && name.substring(name.lastIndexOf(".") + 1).startsWith(extension)) {
                    returnList.add(f);
                }
            } else {
                returnList.add(f);
            }
        }
        catch (Exception e) {
            CommonPlugin.getDefault().getLogger().logError(e);
        }
        return returnList;
    }

    public static List<File> fileListExcludeExt(File f, String extension) {
        ArrayList<File> returnList = new ArrayList<File>();
        try {
            if (f.isDirectory()) {
                String[] flist = f.list();
                int i = 0;
                while (i < flist.length) {
                    File fc = new File(f.getPath(), flist[i]);
                    returnList.addAll(FileUtil.fileListExcludeExt(fc, extension));
                    ++i;
                }
            } else if (extension != null) {
                String name = f.getName();
                if (name.lastIndexOf(".") != -1 && !name.substring(name.lastIndexOf(".") + 1).startsWith(extension)) {
                    returnList.add(f);
                }
            } else {
                returnList.add(f);
            }
        }
        catch (Exception e) {
            CommonPlugin.getDefault().getLogger().logError(e);
        }
        return returnList;
    }

    public static ArrayList<String> getAllFileAbsolutePaths(File path, boolean recursive) {
        ArrayList<File> files = new ArrayList<File>();
        FileUtil.getAllFiles(path, files, recursive);
        ArrayList<String> paths = new ArrayList<String>();
        int i = 0;
        while (i < files.size()) {
            String absPath = files.get(i).getAbsolutePath();
            paths.add(absPath);
            ++i;
        }
        return paths;
    }

    public static boolean moveFile(File sourceFile, File destFile) {
        try {
            FileUtil.doMoveFile(sourceFile, destFile);
            return true;
        }
        catch (Exception e) {
            CommonPlugin.getDefault().getLogger().logError(e);
            return false;
        }
    }

    public static void doMoveFile(File sourceFile, File destFile) throws IOException {
        if (!sourceFile.renameTo(destFile)) {
            FileUtil.copyfile(sourceFile, destFile);
            sourceFile.delete();
        }
    }
}

