/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.common.utils;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public abstract class RestartableJob
extends Job {
    protected static boolean localDebug = false;
    private boolean toRestart = true;
    private boolean schedulingLocked = false;
    private boolean enabled = true;

    public RestartableJob(String name) {
        super(name);
    }

    public final void guardedSchedule(long delay) {
        this.guardedSchedule(delay, false);
    }

    private void guardedSchedule(long delay, boolean inRunCall) {
        if (!this.isEnabled()) {
            return;
        }
        if (!inRunCall && this.getState() != 0) {
            return;
        }
        if (this.isSchedulingLocked()) {
            return;
        }
        if (localDebug) {
            System.out.println("LD> guardedSchedule completed");
        }
        this.setSchedulingLocked(true);
        this.schedule(delay);
    }

    protected final IStatus run(IProgressMonitor monitor) {
        if (localDebug) {
            System.out.println("LD> RestartableJob.run");
        }
        this.setSchedulingLocked(false);
        this.setToRestart(false);
        try {
            this.restartableRun(monitor);
        }
        catch (RestartInterruptException e) {
            this.guardedSchedule(e.getDelay(), true);
        }
        return Status.OK_STATUS;
    }

    protected abstract IStatus restartableRun(IProgressMonitor var1) throws RestartInterruptException;

    protected abstract void resetToRestart();

    private synchronized boolean isSchedulingLocked() {
        return this.schedulingLocked;
    }

    private synchronized void setSchedulingLocked(boolean schedulingLocked) {
        this.schedulingLocked = schedulingLocked;
    }

    private synchronized boolean isToRestart() {
        return this.toRestart;
    }

    private synchronized void setToRestart(boolean toRestart) {
        this.toRestart = toRestart;
    }

    public void enableToRestart() {
        this.setToRestart(true);
    }

    public void checkRestartInterruptException(long delay) throws RestartInterruptException {
        if (this.isToRestart()) {
            this.resetToRestart();
            throw new RestartInterruptException(delay);
        }
    }

    public synchronized boolean isEnabled() {
        return this.enabled;
    }

    public synchronized void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public static class RestartInterruptException
    extends Exception {
        private long delay = 0L;

        public RestartInterruptException(long delay) {
            this.delay = delay;
        }

        public long getDelay() {
            return this.delay;
        }
    }
}

