/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.ui.xmi.internal.migration;

import java.io.File;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.epf.library.layout.LinkInfo;
import org.eclipse.epf.library.ui.xmi.internal.migration.MigratorBase;
import org.eclipse.epf.library.util.ResourceUtil;
import org.eclipse.epf.persistence.MultiFileResourceSetImpl;
import org.eclipse.epf.persistence.migration.UpgradeCallerInfo;
import org.eclipse.epf.persistence.util.PersistenceResources;
import org.eclipse.epf.persistence.util.PersistenceUtil;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodLibrary;

public class Migrator104
extends MigratorBase {
    public void migrate(String libPath, IProgressMonitor monitor) throws Exception {
        this.migrate(libPath, monitor, null);
    }

    public void migrate(String libPath, IProgressMonitor monitor, UpgradeCallerInfo info) throws Exception {
        File libFile = new File(libPath);
        boolean toVerify = true;
        if (info != null && info.getIsExportedPluginLib()) {
            toVerify = false;
        }
        ResourceUtil.open((String)libFile.getParent(), (IProgressMonitor)monitor);
        MultiFileResourceSetImpl resourceSet = null;
        if (info != null) {
            resourceSet = info.getResourceSet();
        }
        try {
            Migrator104.updateStatus(monitor, PersistenceResources.loadLibraryTask_name);
            if (resourceSet == null) {
                resourceSet = toVerify ? new MultiFileResourceSetImpl(false) : PersistenceUtil.getImportPluginResourceSet();
            }
            resourceSet.getLoadOptions().put("RECORD_UNKNOWN_FEATURE", Boolean.TRUE);
            MethodLibrary lib = info == null || info.getResourceSet() == null ? resourceSet.loadLibrary(libPath) : info.loadLibrary(libFile);
            LinkInfo.setLibrary((MethodLibrary)lib);
            Migrator104.updateStatus(monitor, PersistenceResources.loadResourcesTask_name);
            this.updateAllContents(monitor, lib);
            Migrator104.updateStatus(monitor, PersistenceResources.saveLibraryTask_name);
            Map saveOptions = resourceSet.getDefaultSaveOptions();
            resourceSet.save(saveOptions, true);
            Migrator104.updateStatus(monitor, PersistenceResources.refreshLibraryFilesTask_name);
            ResourceUtil.refreshResources((MethodLibrary)lib, (IProgressMonitor)monitor);
            ResourceUtil.refreshResources((MethodLibrary)lib, (IProgressMonitor)monitor);
        }
        finally {
            LinkInfo.setLibrary(null);
            if (resourceSet != null) {
                resourceSet.reset();
                resourceSet = null;
            }
        }
    }

    protected void updateElement(MethodElement element, IProgressMonitor monitor) throws Exception {
    }
}

