/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.diagram.model.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.epf.diagram.model.ActivityDiagram;
import org.eclipse.epf.diagram.model.Link;
import org.eclipse.epf.diagram.model.ModelFactory;
import org.eclipse.epf.diagram.model.ModelPackage;
import org.eclipse.epf.diagram.model.Node;
import org.eclipse.epf.diagram.model.NodeContainer;
import org.eclipse.epf.diagram.model.TypedNode;
import org.eclipse.epf.diagram.model.impl.DiagramImpl;
import org.eclipse.epf.diagram.model.impl.NamedNodeImpl;
import org.eclipse.epf.diagram.model.impl.NodeImpl;
import org.eclipse.epf.diagram.model.util.GraphicalDataHelper;
import org.eclipse.epf.diagram.model.util.IActivityDiagramChangeListener;
import org.eclipse.epf.diagram.model.util.IAdapterFactoryFilter;
import org.eclipse.epf.library.edit.TngAdapterFactory;
import org.eclipse.epf.library.edit.process.ActivityWrapperItemProvider;
import org.eclipse.epf.library.edit.process.BSActivityItemProvider;
import org.eclipse.epf.library.edit.process.BreakdownElementWrapperItemProvider;
import org.eclipse.epf.library.edit.process.IBSItemProvider;
import org.eclipse.epf.library.edit.process.WBSActivityItemProvider;
import org.eclipse.epf.library.edit.util.ConfigurableComposedAdapterFactory;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.Diagram;
import org.eclipse.epf.uma.GraphEdge;
import org.eclipse.epf.uma.GraphNode;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.SemanticModelBridge;
import org.eclipse.epf.uma.SimpleSemanticModelElement;
import org.eclipse.epf.uma.UMASemanticModelBridge;
import org.eclipse.epf.uma.VariabilityElement;
import org.eclipse.epf.uma.WorkBreakdownElement;
import org.eclipse.epf.uma.WorkOrder;

public class ActivityDiagramImpl
extends DiagramImpl
implements ActivityDiagram {
    protected ActivityDiagramImpl() {
        this.diagramChangeListener = new ActivityDiagramChangeListener();
    }

    protected Class getDiagramChangeListenerType() {
        return IActivityDiagramChangeListener.class;
    }

    protected EClass eStaticClass() {
        return ModelPackage.Literals.ACTIVITY_DIAGRAM;
    }

    protected void populateNodes() {
        Diagram diagram = this.getUMADiagram();
        ArrayList<TypedNode> typedNodes = new ArrayList<TypedNode>();
        for (Object element : diagram.getContained()) {
            int type = ActivityDiagramImpl.getType(element);
            if (type <= 0) continue;
            TypedNode node = ModelFactory.eINSTANCE.createTypedNode();
            node.setType(type);
            node.setObject(element);
            typedNodes.add(node);
        }
        this.getNodes().addAll(typedNodes);
        this.addElementNodes();
    }

    private static boolean isValidWorkOrder(WorkOrder wo, Object pred) {
        if (wo.getPred() == pred) {
            return true;
        }
        if (pred instanceof Activity) {
            Activity act = (Activity)pred;
            VariabilityElement ve = act.getVariabilityBasedOnElement();
            while (ve != null) {
                if (ve == wo.getPred()) {
                    return true;
                }
                ve = ve.getVariabilityBasedOnElement();
            }
        }
        return false;
    }

    private boolean isValid(Link link) {
        return link.getSource() != null && link.getTarget() != null && this.getNodes().contains((Object)link.getSource()) && this.getNodes().contains((Object)link.getTarget());
    }

    protected void populateLinks() {
        super.populateLinks();
        for (Node node : this.getNodes()) {
            WorkBreakdownElement wbe = null;
            if (node.getObject() instanceof WorkBreakdownElement) {
                wbe = (WorkBreakdownElement)node.getObject();
            }
            ArrayList<Link> linksToRemove = new ArrayList<Link>();
            for (Link link : node.getIncomingConnections()) {
                if (!this.isValid(link)) {
                    linksToRemove.add(link);
                }
                if (wbe == null || link.getSource() instanceof TypedNode) continue;
                Object pred = link.getSource().getObject();
                boolean workOrderFound = false;
                for (WorkOrder wo : wbe.getLinkToPredecessor()) {
                    if (!ActivityDiagramImpl.isValidWorkOrder(wo, pred)) continue;
                    workOrderFound = true;
                    break;
                }
                if (workOrderFound) continue;
                linksToRemove.add(link);
            }
            for (Link link : linksToRemove) {
                GraphicalDataHelper.removeLink(link);
            }
            linksToRemove.clear();
            for (Link link : node.getOutgoingConnections()) {
                if (this.isValid(link)) continue;
                linksToRemove.add(link);
            }
            for (Link link : linksToRemove) {
                GraphicalDataHelper.removeLink(link);
            }
            linksToRemove.clear();
            linksToRemove = null;
        }
        AdapterFactory adapterFactory = this.getAdapterFactory();
        for (Node node : this.getNodes()) {
            if (!(node.getObject() instanceof WorkBreakdownElement)) continue;
            ArrayList list = new ArrayList();
            WorkBreakdownElement local = (WorkBreakdownElement)node.getObject();
            list.addAll(local.getLinkToPredecessor());
            ITreeItemContentProvider adapter = null;
            adapter = (ITreeItemContentProvider)adapterFactory.adapt((Notifier)local, ITreeItemContentProvider.class);
            if (adapter instanceof IBSItemProvider) {
                list.addAll(((IBSItemProvider)adapter).getPredecessors());
            }
            for (Object next : list) {
                Node predNode;
                WorkOrder workOrder = null;
                WorkBreakdownElement pred = null;
                if (next instanceof WorkOrder) {
                    workOrder = (WorkOrder)next;
                    pred = workOrder.getPred();
                }
                if (next instanceof WBSActivityItemProvider) {
                    pred = (BreakdownElement)((WBSActivityItemProvider)next).getTarget();
                }
                if (pred == null || !(pred instanceof WorkBreakdownElement) || (predNode = GraphicalDataHelper.findNode((NodeContainer)this, (Object)pred, true)) == null) continue;
                boolean linkFound = false;
                for (Link link : node.getIncomingConnections()) {
                    if (link.getSource() != predNode) continue;
                    linkFound = true;
                    GraphEdge edge = (GraphEdge)link.getObject();
                    if (edge.getSemanticModel() != null) break;
                    GraphicalDataHelper.setSemanticModel(link, workOrder);
                    break;
                }
                if (linkFound || ActivityDiagramImpl.canReachAsFirstActivityNode(predNode, node)) continue;
                NamedNodeImpl nodeImpl = (NamedNodeImpl)node;
                NamedNodeImpl predNodeImpl = (NamedNodeImpl)predNode;
                boolean oldNotify = nodeImpl.notificationEnabled;
                boolean predNodeNotify = predNodeImpl.notificationEnabled;
                try {
                    nodeImpl.notificationEnabled = false;
                    predNodeImpl.notificationEnabled = false;
                    nodeImpl.addIncomingConnection((MethodElement)pred);
                }
                finally {
                    nodeImpl.notificationEnabled = oldNotify;
                    predNodeImpl.notificationEnabled = predNodeNotify;
                }
            }
        }
        this.cleanDuplicateLinks();
    }

    private void cleanDuplicateLinks() {
        ArrayList duplicateLinks = new ArrayList();
        for (Object node : this.getNodes()) {
            if (!(node instanceof Node)) continue;
            Node wbNode = (Node)node;
            if (wbNode.getIncomingConnections() != null) {
                this.findDuplicateLinks(duplicateLinks, (List)wbNode.getIncomingConnections());
            }
            if (wbNode.getOutgoingConnections() == null) continue;
            this.findDuplicateLinks(duplicateLinks, (List)wbNode.getOutgoingConnections());
        }
        for (Link link : duplicateLinks) {
            GraphicalDataHelper.removeLink(link);
        }
        duplicateLinks.clear();
        duplicateLinks = null;
    }

    private void findDuplicateLinks(List duplicateLinks, List links) {
        int i = 0;
        while (i < links.size()) {
            Link link = (Link)links.get(i);
            if (!duplicateLinks.contains(link)) {
                int j = i + 1;
                while (j < links.size()) {
                    Link link1 = (Link)links.get(j);
                    if (link1.getSource() == link.getSource() && link1.getTarget() == link.getTarget()) {
                        duplicateLinks.add(link1);
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    private static boolean canReachAsFirstActivityNode(Node src, Node target) {
        for (Link link : src.getOutgoingConnections()) {
            if (link.getTarget() == target) {
                return true;
            }
            if (!(link.getTarget() instanceof TypedNode) || !ActivityDiagramImpl.canReachAsFirstActivityNode(link.getTarget(), target)) continue;
            return true;
        }
        return false;
    }

    protected Node newNode() {
        return ModelFactory.eINSTANCE.createWorkBreakdownElementNode();
    }

    public Collection getChildren() {
        ITreeItemContentProvider adapter = this.getAdapter();
        if (adapter != null) {
            Object obj = null;
            boolean enableVariabilityInfo = false;
            if (adapter instanceof ActivityWrapperItemProvider) {
                obj = ((ActivityWrapperItemProvider)adapter).getDelegatingItemProvider();
            }
            if (adapter instanceof BSActivityItemProvider) {
                obj = adapter;
            }
            if (obj instanceof BSActivityItemProvider) {
                enableVariabilityInfo = ((BSActivityItemProvider)obj).isEnableVariabilityInfo();
                ((BSActivityItemProvider)obj).setEnableVariabilityInfo(false);
            }
            ArrayList children = new ArrayList();
            this.extractChildren(adapter, this.getObject(), children, true);
            if (obj instanceof BSActivityItemProvider) {
                ((BSActivityItemProvider)obj).setEnableVariabilityInfo(enableVariabilityInfo);
            }
            return children;
        }
        return Collections.EMPTY_LIST;
    }

    private void addElementNodes() {
        ArrayList<NamedNodeImpl> nodes = new ArrayList<NamedNodeImpl>();
        for (Object e : this.getChildren()) {
            BreakdownElementWrapperItemProvider wrapper;
            Object child = TngUtil.unwrap(e);
            if (!(child instanceof WorkBreakdownElement)) continue;
            NamedNodeImpl node = (NamedNodeImpl)this.toNode((MethodElement)child);
            if (e instanceof BreakdownElementWrapperItemProvider && (wrapper = (BreakdownElementWrapperItemProvider)e).isReadOnly()) {
                node.itemProvider = wrapper;
                node.readOnly = true;
            }
            nodes.add(node);
        }
        this.getNodes().addAll(nodes);
    }

    private static int getType(Object obj) {
        GraphNode node;
        SemanticModelBridge modelBridge;
        if (obj instanceof GraphNode && (modelBridge = (node = (GraphNode)obj).getSemanticModel()) instanceof SimpleSemanticModelElement) {
            String type = ((SimpleSemanticModelElement)modelBridge).getTypeInfo();
            if ("synchnonization bar".equals(type)) {
                return 1;
            }
            if ("decision node".equals(type)) {
                return 2;
            }
            if ("end node".equals(type)) {
                return 4;
            }
            if ("start node".equals(type)) {
                return 3;
            }
            if ("free text".equals(type)) {
                return 6;
            }
        }
        return -1;
    }

    protected int getType() {
        return 0;
    }

    protected List getBreakdownElementTypes() {
        return Collections.singletonList(WorkBreakdownElement.class);
    }

    /*
     * Unable to fully structure code
     */
    private int toActivityIndex(int index) {
        if (index == -1) {
            return index;
        }
        i = index + 1;
        size = this.getNodes().size();
        if (i == size) {
            return -1;
        }
        node = (Node)this.getNodes().get(i);
        if (node != null) ** GOTO lbl12
        return -1;
lbl-1000:
        // 1 sources

        {
            node = (Node)this.getNodes().get(i);
            ++i;
lbl12:
            // 2 sources

            ** while (!(node.getObject() instanceof BreakdownElement) && i < size)
        }
lbl13:
        // 1 sources

        if (i == size) {
            return -1;
        }
        act = (Activity)this.getObject();
        return act.getBreakdownElements().indexOf(node.getObject());
    }

    protected void addToUmaModel(int position, Node addedNode) {
        if (addedNode.getObject() instanceof BreakdownElement) {
            Activity act = (Activity)this.getObject();
            int i = this.toActivityIndex(position);
            if (i == -1) {
                act.getBreakdownElements().add((BreakdownElement)addedNode.getObject());
            } else {
                act.getBreakdownElements().add(i, (BreakdownElement)addedNode.getObject());
            }
        }
        super.addToUmaModel(position, addedNode);
    }

    protected Node addNode(Collection nodes, Object obj) {
        Activity act;
        VariabilityElement base;
        if (obj instanceof Activity && (base = (act = (Activity)obj).getVariabilityBasedOnElement()) != null) {
            NodeImpl baseNode = (NodeImpl)GraphicalDataHelper.findNode(this, (Object)base);
            if (baseNode != null) {
                GraphNode graphNode = baseNode.getGraphNode();
                UMASemanticModelBridge bridge = (UMASemanticModelBridge)graphNode.getSemanticModel();
                if (bridge.getElement() != act) {
                    bridge.setElement((MethodElement)act);
                }
            } else {
                baseNode = (NodeImpl)GraphicalDataHelper.findNode(this, (Object)act);
            }
            if (baseNode != null) {
                if (baseNode.methodElementAdapter != null) {
                    base.eAdapters().remove((Object)baseNode.methodElementAdapter);
                }
                baseNode.basicSetObject(act);
                baseNode.setReadOnly(false);
                return null;
            }
        }
        return super.addNode(nodes, obj);
    }

    protected boolean removeNode(Object obj) {
        Activity act;
        VariabilityElement base;
        if (obj instanceof Activity && (base = (act = (Activity)obj).getVariabilityBasedOnElement()) != null) {
            NodeImpl node = (NodeImpl)GraphicalDataHelper.findNode(this, (Object)act);
            if (node != null) {
                GraphNode graphNode = node.getGraphNode();
                UMASemanticModelBridge bridge = (UMASemanticModelBridge)graphNode.getSemanticModel();
                if (bridge.getElement() != base) {
                    bridge.setElement((MethodElement)base);
                }
            } else {
                node = (NodeImpl)GraphicalDataHelper.findNode(this, (Object)base);
            }
            if (node != null) {
                if (node.methodElementAdapter != null) {
                    act.eAdapters().remove((Object)node.methodElementAdapter);
                }
                node.basicSetObject(base);
                node.setReadOnly(true);
                return false;
            }
        }
        return super.removeNode(obj);
    }

    private ITreeItemContentProvider getAdapter() {
        Object adapter = null;
        adapter = this.wrapper != null ? this.wrapper : (ITreeItemContentProvider)this.getAdapterFactory().adapt(this.getObject(), ITreeItemContentProvider.class);
        return adapter;
    }

    private AdapterFactory getAdapterFactory() {
        ComposedAdapterFactory adapterFactory = null;
        if (this.filter == null) {
            adapterFactory = TngAdapterFactory.INSTANCE.getWBS_ComposedAdapterFactory();
        } else if (this.filter instanceof IAdapterFactoryFilter) {
            adapterFactory = (ConfigurableComposedAdapterFactory)((IAdapterFactoryFilter)this.filter).getWBSAdapterFactory();
        }
        return adapterFactory;
    }

    private class ActivityDiagramChangeListener
    extends DiagramImpl.ActivityAdapter
    implements IActivityDiagramChangeListener {
        private ActivityDiagramChangeListener() {
            super(ActivityDiagramImpl.this);
        }
    }
}

