/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.actions;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.authoring.ui.actions.LibraryViewSimpleAction;
import org.eclipse.epf.authoring.ui.dialogs.AssignDialog;
import org.eclipse.epf.authoring.ui.views.LibraryView;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.uma.CustomCategory;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.jface.viewers.IStructuredSelection;

public class AssignAction
extends LibraryViewSimpleAction.CustomeCategoryAction {
    public AssignAction(LibraryView libView) {
        super(libView, AuthoringUIResources.assignAction_text);
    }

    protected void doRun() {
        ArrayList elementsToAssign = new ArrayList();
        IStructuredSelection selection = (IStructuredSelection)this.getLibraryView().getSelection();
        for (Object element : selection) {
            if (!(element instanceof MethodElement) && !((element = TngUtil.unwrap(element)) instanceof CustomCategory)) continue;
            elementsToAssign.add(element);
        }
        AssignDialog dlg = this.getDialog(elementsToAssign);
        dlg.open();
    }

    protected AssignDialog getDialog(Collection elements) {
        return AssignDialog.newAssignDialog(this.getLibraryView().getSite().getShell(), elements);
    }

    public boolean updateSelection(IStructuredSelection selection) {
        return this.canAssign(selection);
    }

    private boolean canAssign(IStructuredSelection selection) {
        if (selection.size() > 1) {
            return false;
        }
        Object element = TngUtil.unwrap((Object)selection.getFirstElement());
        if (element instanceof CustomCategory) {
            return this.getSelectionParentObject() instanceof CustomCategory;
        }
        return false;
    }
}

