/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.forms;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.AbstractTreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.authoring.ui.AuthoringUIText;
import org.eclipse.epf.authoring.ui.editors.EditorChooser;
import org.eclipse.epf.authoring.ui.editors.MethodElementEditor;
import org.eclipse.epf.authoring.ui.forms.DescriptionFormPage;
import org.eclipse.epf.authoring.ui.forms.IRefreshable;
import org.eclipse.epf.authoring.ui.views.ViewHelper;
import org.eclipse.epf.common.utils.StrUtil;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.edit.LibraryEditResources;
import org.eclipse.epf.library.edit.command.IResourceAwareCommand;
import org.eclipse.epf.library.edit.command.RemoveReferencesCommand;
import org.eclipse.epf.library.edit.util.Comparators;
import org.eclipse.epf.library.edit.util.Misc;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.ui.LibraryUIText;
import org.eclipse.epf.library.util.LibraryUtil;
import org.eclipse.epf.library.util.PluginReferenceChecker;
import org.eclipse.epf.services.ILibraryPersister;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.epf.uma.util.UmaUtil;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodPluginDescriptionPage
extends DescriptionFormPage
implements IRefreshable {
    protected static final String FORM_PREFIX = String.valueOf(LibraryUIText.TEXT_METHOD_PLUGIN) + ": ";
    protected Text ctrl_r_brief_desc;
    protected CheckboxTableViewer ctrl_refModel;
    protected Section refModelSection;
    protected Composite refModelComposite;
    protected MethodPlugin plugin;
    protected Button ctrl_changeable;
    protected Button supportingPluginCheckbox;
    public boolean notificationEnabled = true;
    protected Adapter userChangeableAdapter;
    protected ModifyListener nameModifyListener;
    protected ISelectionChangedListener refModelSelChangedListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            StructuredSelection selectedList = (StructuredSelection)event.getSelection();
            MethodPlugin selectedObj = (MethodPlugin)selectedList.getFirstElement();
            if (selectedObj == null) {
                return;
            }
            MethodPluginDescriptionPage.this.ctrl_r_brief_desc.setText(selectedObj.getBriefDescription());
        }
    };
    protected ICheckStateListener refModelCheckStateListener = new ICheckStateListener(){

        public void checkStateChanged(CheckStateChangedEvent event) {
            Object obj = event.getElement();
            MethodPluginDescriptionPage.this.ctrl_r_brief_desc.setText(((MethodPlugin)obj).getBriefDescription());
            if (TngUtil.isLocked((EObject)MethodPluginDescriptionPage.this.plugin)) {
                MethodPluginDescriptionPage.this.ctrl_refModel.setChecked(obj, !event.getChecked());
                return;
            }
            if (event.getChecked()) {
                MethodPluginDescriptionPage.this.actionMgr.doAction(3, (EObject)MethodPluginDescriptionPage.this.plugin, (EStructuralFeature)UmaPackage.eINSTANCE.getMethodPlugin_Bases(), (Object)((MethodPlugin)obj), -1);
            } else {
                final MethodPlugin base = (MethodPlugin)obj;
                if (!MethodPluginDescriptionPage.this.removeAllReferences(base)) {
                    Display.getCurrent().asyncExec(new Runnable(){

                        public void run() {
                            (this).MethodPluginDescriptionPage.this.ctrl_refModel.setChecked((Object)base, true);
                        }
                    });
                    return;
                }
                MethodPluginDescriptionPage.this.ctrl_refModel.setChecked((Object)base, false);
                MethodPluginDescriptionPage.this.actionMgr.doAction(4, (EObject)MethodPluginDescriptionPage.this.plugin, (EStructuralFeature)UmaPackage.eINSTANCE.getMethodPlugin_Bases(), (Object)((MethodPlugin)obj), -1);
            }
            PluginReferenceChecker.hasCircularConflictWithPlugin((MethodPlugin)MethodPluginDescriptionPage.this.plugin);
            MethodPluginDescriptionPage.this.updateChangeDate();
        }
    };

    public MethodPluginDescriptionPage(FormEditor editor) {
        super(editor, AuthoringUIText.DESCRIPTION_PAGE_TITLE, AuthoringUIText.DESCRIPTION_PAGE_TITLE);
        this.userChangeableAdapter = new UserChangeableAdapter();
    }

    @Override
    public void init(IEditorSite site, IEditorInput input) {
        super.init(site, input);
        this.plugin = (MethodPlugin)this.methodElement;
        if (this.userChangeableAdapter != null) {
            this.plugin.eAdapters().add((Object)this.userChangeableAdapter);
        }
        this.detailSectionOn = false;
        this.fullDescOn = false;
        this.keyConsiderationOn = false;
        this.variabilitySectionOn = false;
    }

    @Override
    protected void createEditorContent(FormToolkit toolkit) {
        super.createEditorContent(toolkit);
        this.createReferenceSection(toolkit);
        Display display = this.form.getBody().getDisplay();
        if (display != null && !display.isDisposed()) {
            display.asyncExec(new Runnable(){

                public void run() {
                    if (MethodPluginDescriptionPage.this.ctrl_name.isDisposed()) {
                        return;
                    }
                    MethodPluginDescriptionPage.this.ctrl_name.setFocus();
                    MethodPluginDescriptionPage.this.ctrl_name.setSelection(0, MethodPluginDescriptionPage.this.ctrl_name.getText().length());
                }
            });
        }
    }

    protected void createReferenceContent(FormToolkit toolkit) {
        Table ctrl_table = toolkit.createTable(this.refModelComposite, 32);
        GridData gridData = new GridData(1809);
        gridData.heightHint = 100;
        ctrl_table.setLayoutData((Object)gridData);
        this.ctrl_refModel = new CheckboxTableViewer(ctrl_table);
        LabelProvider labelProvider = new LabelProvider(){

            public String getText(Object element) {
                MethodPlugin plugin = (MethodPlugin)element;
                return plugin.getName();
            }
        };
        this.ctrl_refModel.setLabelProvider((IBaseLabelProvider)labelProvider);
        this.createRefModelBriefDescField(toolkit);
        toolkit.paintBordersFor(this.refModelComposite);
    }

    protected void createRefModelBriefDescField(FormToolkit toolkit) {
        Label l_r_brief_desc = toolkit.createLabel(this.refModelComposite, AuthoringUIText.BRIEF_DESCRIPTION_TEXT);
        GridData gridData = new GridData(1);
        gridData.horizontalSpan = 2;
        l_r_brief_desc.setLayoutData((Object)gridData);
        this.ctrl_r_brief_desc = toolkit.createText(this.refModelComposite, "", 586);
        gridData = new GridData(768);
        gridData.heightHint = 80;
        gridData.horizontalSpan = 2;
        this.ctrl_r_brief_desc.setLayoutData((Object)gridData);
    }

    protected void createReferenceSection(FormToolkit toolkit) {
        this.refModelSection = toolkit.createSection(this.sectionComposite, 450);
        GridData td1 = new GridData(1808);
        this.refModelSection.setLayoutData((Object)td1);
        this.refModelSection.setText(AuthoringUIText.REFERENCED_PLUGINS_SECTION_NAME);
        this.refModelSection.setDescription(AuthoringUIText.REFERENCED_PLUGINS_SECTION_DESC);
        this.refModelSection.setLayout((Layout)new GridLayout());
        this.refModelComposite = toolkit.createComposite((Composite)this.refModelSection);
        this.refModelComposite.setLayoutData((Object)new GridData(768));
        this.refModelComposite.setLayout((Layout)new GridLayout(2, false));
        this.refModelSection.setClient((Control)this.refModelComposite);
        this.createReferenceContent(toolkit);
    }

    protected void setCheckboxForCurrentBase(List<MethodPlugin> currentBaseList) {
        this.ctrl_refModel.setAllChecked(false);
        int i = 0;
        while (i < currentBaseList.size()) {
            MethodPlugin model = currentBaseList.get(i);
            this.ctrl_refModel.setChecked((Object)model, true);
            ++i;
        }
    }

    @Override
    protected void addListeners() {
        super.addListeners();
        MethodElementEditor editor = (MethodElementEditor)this.getEditor();
        this.form.addListener(26, new Listener(){

            public void handleEvent(Event e) {
                MethodPluginDescriptionPage.this.refreshReferencedModels();
                if (!MethodPluginDescriptionPage.this.plugin.getUserChangeable().booleanValue()) {
                    MethodPluginDescriptionPage.this.refresh(false);
                } else {
                    MethodPluginDescriptionPage.this.refresh(true);
                }
            }
        });
        this.ctrl_name.removeFocusListener((FocusListener)this.nameFocusListener);
        this.nameModifyListener = editor.createModifyListener((EObject)this.plugin, true);
        this.ctrl_name.addModifyListener(this.nameModifyListener);
        this.ctrl_name.addListener(27, new Listener(){

            public void handleEvent(Event e) {
                String oldContent = MethodPluginDescriptionPage.this.plugin.getName();
                if (((MethodElementEditor)MethodPluginDescriptionPage.this.getEditor()).mustRestoreValue(e.widget, oldContent)) {
                    return;
                }
                if (MethodPluginDescriptionPage.this.ctrl_name.getText().equals(MethodPluginDescriptionPage.this.plugin.getName())) {
                    return;
                }
                String msg = null;
                String name = MethodPluginDescriptionPage.this.ctrl_name.getText().trim();
                if (name != null) {
                    msg = oldContent.indexOf("&") < 0 && name.indexOf("&") > -1 ? NLS.bind((String)LibraryEditResources.invalidElementNameError4_msg, (Object)name) : LibraryUtil.checkPluginName(null, (String)name);
                }
                String validName = StrUtil.makeValidFileName((String)MethodPluginDescriptionPage.this.ctrl_name.getText());
                if (msg == null) {
                    msg = LibraryUtil.checkPluginName((MethodPlugin)MethodPluginDescriptionPage.this.plugin, (String)validName);
                }
                if (msg == null) {
                    if (!validName.equals(MethodPluginDescriptionPage.this.plugin.getName())) {
                        String title;
                        Shell shell = MethodPluginDescriptionPage.this.getSite().getShell();
                        if (!MessageDialog.openConfirm((Shell)shell, (String)(title = AuthoringUIResources.methodPluginDescriptionPage_confirmRename_title), (String)(msg = AuthoringUIResources.bind((String)AuthoringUIResources.methodPluginDescriptionPage_confirmRename, (Object[])new Object[]{MethodPluginDescriptionPage.this.plugin.getName(), MethodPluginDescriptionPage.this.ctrl_name.getText()})))) {
                            MethodPluginDescriptionPage.this.ctrl_name.setText(MethodPluginDescriptionPage.this.plugin.getName());
                            return;
                        }
                        e.doit = true;
                        EditorChooser.getInstance().closeMethodEditorsForPluginElements(MethodPluginDescriptionPage.this.plugin);
                        MethodPluginDescriptionPage.this.ctrl_name.setText(validName);
                        boolean status = MethodPluginDescriptionPage.this.actionMgr.doAction(1, (EObject)MethodPluginDescriptionPage.this.plugin, (EStructuralFeature)UmaPackage.eINSTANCE.getNamedElement_Name(), (Object)validName, -1);
                        if (!status) {
                            return;
                        }
                        MethodPluginDescriptionPage.this.form.setText(String.valueOf(FORM_PREFIX) + MethodPluginDescriptionPage.this.plugin.getName());
                        MethodPluginDescriptionPage.this.updateChangeDate();
                        BusyIndicator.showWhile((Display)MethodPluginDescriptionPage.this.getSite().getShell().getDisplay(), (Runnable)new Runnable(){

                            public void run() {
                                MethodElementEditor editor = (MethodElementEditor)MethodPluginDescriptionPage.this.getEditor();
                                editor.doSave((IProgressMonitor)new NullProgressMonitor());
                                ILibraryPersister.FailSafeMethodLibraryPersister persister = editor.getPersister();
                                try {
                                    persister.adjustLocation((this).MethodPluginDescriptionPage.this.plugin.eResource());
                                    persister.commit();
                                }
                                catch (RuntimeException e) {
                                    AuthoringUIPlugin.getDefault().getLogger().logError((Throwable)e);
                                    try {
                                        persister.rollback();
                                    }
                                    catch (Exception ex) {
                                        AuthoringUIPlugin.getDefault().getLogger().logError((Throwable)ex);
                                        ViewHelper.reloadCurrentLibaryOnRollbackError(MethodPluginDescriptionPage.this.getSite().getShell());
                                        return;
                                    }
                                    AuthoringUIPlugin.getDefault().getMsgDialog().displayWarning(MethodPluginDescriptionPage.this.getSite().getShell().getText(), AuthoringUIResources.methodPluginDescriptionPage_cannotRenamePluginFolder, e.getMessage(), (Throwable)e);
                                }
                            }
                        });
                    }
                } else {
                    MethodPluginDescriptionPage.this.ctrl_name.setText(MethodPluginDescriptionPage.this.plugin.getName());
                    Shell shell = MethodPluginDescriptionPage.this.getSite().getShell();
                    AuthoringUIPlugin.getDefault().getMsgDialog().displayError(shell.getText(), msg);
                    e.doit = false;
                    MethodPluginDescriptionPage.this.ctrl_name.getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            (this).MethodPluginDescriptionPage.this.ctrl_name.setFocus();
                            (this).MethodPluginDescriptionPage.this.ctrl_name.selectAll();
                        }
                    });
                }
            }
        });
        this.ctrl_name.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                ((MethodElementEditor)MethodPluginDescriptionPage.this.getEditor()).setCurrentFeatureEditor(e.widget, (EStructuralFeature)UmaPackage.eINSTANCE.getNamedElement_Name());
            }
        });
        this.addReferencedModelListener();
    }

    protected void addReferencedModelListener() {
        this.ctrl_refModel.addSelectionChangedListener(this.refModelSelChangedListener);
        this.ctrl_refModel.addCheckStateListener(this.refModelCheckStateListener);
    }

    @Override
    protected void refresh(boolean editable) {
        super.refresh(editable);
        this.ctrl_r_brief_desc.setEditable(false);
    }

    @Override
    protected void createGeneralSectionContent() {
        super.createGeneralSectionContent();
        this.supportingPluginCheckbox = this.toolkit.createButton(this.generalComposite, AuthoringUIResources.methodPluginDescriptionPage_supportingPluginLabel, 32);
    }

    @Override
    protected void addGeneralSectionListeners() {
        super.addGeneralSectionListeners();
        this.supportingPluginCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStatus status = TngUtil.checkEdit((EObject)MethodPluginDescriptionPage.this.plugin, (Object)MethodPluginDescriptionPage.this.getSite().getShell());
                if (status.isOK()) {
                    boolean ret = MethodPluginDescriptionPage.this.actionMgr.doAction(1, (EObject)MethodPluginDescriptionPage.this.plugin, (EStructuralFeature)UmaPackage.eINSTANCE.getMethodPlugin_Supporting(), (Object)new Boolean(MethodPluginDescriptionPage.this.supportingPluginCheckbox.getSelection()), -1);
                    if (!ret) {
                        MethodPluginDescriptionPage.this.supportingPluginCheckbox.setSelection(!MethodPluginDescriptionPage.this.supportingPluginCheckbox.getSelection());
                        return;
                    }
                } else {
                    AuthoringUIPlugin.getDefault().getMsgDialog().displayError(AuthoringUIResources.editDialog_title, AuthoringUIResources.editDialog_msgCannotEdit, status);
                    return;
                }
            }
        });
    }

    @Override
    protected void loadGeneralSectionData() {
        super.loadGeneralSectionData();
        this.supportingPluginCheckbox.setSelection(this.plugin.isSupporting());
    }

    @Override
    protected void createVersionSectionContent() {
        super.createVersionSectionContent();
        this.ctrl_changeable = this.toolkit.createButton(this.versionComposite, AuthoringUIResources.methodPluginDescriptionPage_lockPluginLabel, 32);
    }

    @Override
    protected void addVersionSectionListeners() {
        super.addVersionSectionListeners();
        this.ctrl_changeable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MethodPluginDescriptionPage.this.notificationEnabled = true;
                IStatus status = TngUtil.checkEdit((EObject)MethodPluginDescriptionPage.this.plugin, (Object)MethodPluginDescriptionPage.this.getSite().getShell());
                if (status.isOK()) {
                    String message = AuthoringUIResources.bind((String)AuthoringUIResources.methodPluginDescriptionPage_lockPlugin_message, (Object)MethodPluginDescriptionPage.this.plugin.getName());
                    Shell shell = MethodPluginDescriptionPage.this.getSite().getShell();
                    if (AuthoringUIPlugin.getDefault().getMsgDialog().displayConfirmation(shell.getText(), message)) {
                        EditorChooser.getInstance().closeMethodEditorsForPluginElements(MethodPluginDescriptionPage.this.plugin);
                        boolean ret = MethodPluginDescriptionPage.this.actionMgr.doAction(1, (EObject)MethodPluginDescriptionPage.this.plugin, (EStructuralFeature)UmaPackage.eINSTANCE.getMethodPlugin_UserChangeable(), (Object)new Boolean(!MethodPluginDescriptionPage.this.ctrl_changeable.getSelection()), -1);
                        if (!ret) {
                            MethodPluginDescriptionPage.this.ctrl_changeable.setSelection(!MethodPluginDescriptionPage.this.ctrl_changeable.getSelection());
                            return;
                        }
                        MethodPluginDescriptionPage.this.refresh(!MethodPluginDescriptionPage.this.ctrl_changeable.getSelection());
                    } else {
                        MethodPluginDescriptionPage.this.ctrl_changeable.setSelection(!MethodPluginDescriptionPage.this.ctrl_changeable.getSelection());
                        MethodPluginDescriptionPage.this.refresh(!MethodPluginDescriptionPage.this.ctrl_changeable.getSelection());
                    }
                } else {
                    AuthoringUIPlugin.getDefault().getMsgDialog().displayError(AuthoringUIResources.editDialog_title, AuthoringUIResources.editDialog_msgCannotEdit, status);
                    return;
                }
                MethodPluginDescriptionPage.this.copyright_viewer.refresh();
                ((MethodElementEditor)MethodPluginDescriptionPage.this.getEditor()).refreshTitleImage();
            }
        });
    }

    @Override
    protected void loadVersionSectionData() {
        super.loadVersionSectionData();
        this.ctrl_changeable.setSelection(this.plugin.getUserChangeable() == false);
    }

    public void setUserChangeable(boolean userChangeable) {
        if (!this.notificationEnabled) {
            return;
        }
        this.notificationEnabled = false;
        this.plugin.setUserChangeable(Boolean.valueOf(userChangeable));
    }

    @Override
    public void dispose() {
        this.plugin.eAdapters().remove((Object)this.userChangeableAdapter);
        super.dispose();
    }

    protected static boolean isOneOrBaseOf(MethodPlugin base, Collection<MethodPlugin> plugins) {
        for (MethodPlugin plugin : plugins) {
            if (base != plugin && !Misc.isBaseOf((MethodPlugin)base, (MethodPlugin)plugin)) continue;
            return true;
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    protected boolean removeAllReferences(MethodPlugin unCheckedPlugin) {
        removedBases = new ArrayList<MethodPlugin>();
        removedBases.add(unCheckedPlugin);
        iter = new AbstractTreeIterator<MethodPlugin>((Object)unCheckedPlugin, false){
            private static final long serialVersionUID = 1L;

            protected Iterator<? extends MethodPlugin> getChildren(Object object) {
                if (object instanceof MethodPlugin && object != MethodPluginDescriptionPage.this.plugin) {
                    return ((MethodPlugin)object).getBases().iterator();
                }
                Collection empty = Collections.emptyList();
                return empty.iterator();
            }
        };
        while (iter.hasNext()) {
            base = (MethodPlugin)iter.next();
            plugins = new ArrayList<MethodPlugin>(this.plugin.getBases());
            plugins.remove(unCheckedPlugin);
            if (MethodPluginDescriptionPage.isOneOrBaseOf(base, plugins)) continue;
            removedBases.add(base);
        }
        affectedPlugins = new ArrayList<MethodPlugin>();
        plugins = LibraryService.getInstance().getCurrentMethodLibrary().getMethodPlugins();
        for (MethodPlugin mp : plugins) {
            if (mp == this.plugin || !Misc.isBaseOf((MethodPlugin)this.plugin, (MethodPlugin)mp)) continue;
            affectedPlugins.add(mp);
        }
        commands = new ArrayList<RemoveReferencesCommand>();
        for (MethodPlugin base : removedBases) {
            if (UmaUtil.hasReference((MethodPlugin)this.plugin, (MethodPlugin)base)) {
                commands.add(new RemoveReferencesCommand(this.plugin, base));
            }
            for (MethodPlugin mp : affectedPlugins) {
                bases = new ArrayList<MethodPlugin>(mp.getBases());
                bases.remove(base);
                if (MethodPluginDescriptionPage.isOneOrBaseOf(base, bases) || !UmaUtil.hasReference((MethodPlugin)mp, (MethodPlugin)base)) continue;
                commands.add(new RemoveReferencesCommand(mp, base));
            }
        }
        if (!commands.isEmpty()) {
            message = AuthoringUIResources.bind((String)AuthoringUIResources.methodPluginDescriptionRemoveRefConfirm_message, (Object)this.plugin.getName());
            shell = this.getSite().getShell();
            if (AuthoringUIPlugin.getDefault().getMsgDialog().displayConfirmation(shell.getText(), message)) {
                i = 0;
                try {
                    for (RemoveReferencesCommand cmd : commands) {
                        this.actionMgr.execute((IResourceAwareCommand)cmd);
                        ++i;
                    }
                    return true;
                }
                catch (Exception e) {
                    AuthoringUIPlugin.getDefault().getLogger().logError((Throwable)e);
                    ** while (i > 0)
                }
lbl-1000:
                // 1 sources

                {
                    this.actionMgr.undo();
                    --i;
                    continue;
                }
lbl53:
                // 1 sources

                return false;
            }
            return false;
        }
        return true;
    }

    @Override
    public void loadSectionDescription() {
        this.generalSectionDescription = AuthoringUIResources.plugin_generalInfoSection_desc;
        this.versionSectionDescription = AuthoringUIResources.plugin_versionInfoSection_desc;
    }

    @Override
    protected Object getContentElement() {
        return this.plugin;
    }

    protected void refreshReferencedModels() {
        this.ctrl_refModel.getTable().clearAll();
        this.ctrl_refModel.refresh();
        List allowableList = PluginReferenceChecker.getApplicableBasePlugins((MethodPlugin)this.plugin);
        Collections.sort(allowableList, Comparators.PLUGINPACKAGE_COMPARATOR);
        this.ctrl_refModel.add(allowableList.toArray());
        List currentBaseList = this.plugin.getBases();
        this.setCheckboxForCurrentBase(currentBaseList);
    }

    protected class UserChangeableAdapter
    extends AdapterImpl {
        protected UserChangeableAdapter() {
        }

        public void notifyChanged(Notification msg) {
            switch (msg.getFeatureID(MethodPlugin.class)) {
                case 14: {
                    Boolean b = (Boolean)msg.getNewValue();
                    MethodPluginDescriptionPage.this.setUserChangeable(b);
                    return;
                }
            }
        }
    }
}

