/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.forms;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.authoring.ui.AuthoringUIText;
import org.eclipse.epf.authoring.ui.filters.CategoryFilter;
import org.eclipse.epf.authoring.ui.filters.CustomCategoryFilter;
import org.eclipse.epf.authoring.ui.forms.AssociationFormPage;
import org.eclipse.epf.library.edit.IFilter;
import org.eclipse.epf.library.edit.TngAdapterFactory;
import org.eclipse.epf.library.edit.itemsfilter.FilterConstants;
import org.eclipse.epf.library.util.LibraryManager;
import org.eclipse.epf.uma.CustomCategory;
import org.eclipse.epf.uma.DescribableElement;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.Role;
import org.eclipse.epf.uma.RoleSet;
import org.eclipse.epf.uma.util.AssociationHelper;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.forms.editor.FormEditor;

public class RoleCategoriesPage
extends AssociationFormPage {
    private static final String FORM_PAGE_ID = "roleCategoriesPage";
    private Role role;

    public RoleCategoriesPage(FormEditor editor) {
        super(editor, FORM_PAGE_ID, AuthoringUIText.CATEGORIES_PAGE_TITLE);
    }

    public void init(IEditorSite site, IEditorInput input) {
        super.init(site, input);
        this.role = (Role)this.contentElement;
        this.setAllowChange1(true);
        this.setAllowChange2(true);
        this.setUseCategory3(false);
        this.setCategoryIsSingleSelection1(false);
    }

    protected void initContentProviderSelected() {
        this.contentProviderSelected = new AdapterFactoryContentProvider((AdapterFactory)TngAdapterFactory.INSTANCE.getNavigatorView_ComposedAdapterFactory()){

            public Object[] getElements(Object object) {
                return AssociationHelper.getRoleSets((Role)((Role)object)).toArray();
            }
        };
        this.viewer_selected.setContentProvider((IContentProvider)this.contentProviderSelected);
    }

    protected void addItemsToModel1(ArrayList addItems) {
        if (!addItems.isEmpty()) {
            for (RoleSet roleSet : addItems) {
                LibraryManager.getInstance().addToRoleSet(this.getActionManager(), roleSet, this.role, (List)this.usedCategories);
            }
        }
    }

    protected void removeItemsFromModel1(ArrayList rmItems) {
        if (!rmItems.isEmpty()) {
            for (RoleSet roleSet : rmItems) {
                LibraryManager.getInstance().removeFromRoleSet(this.getActionManager(), roleSet, this.role, (List)this.usedCategories);
            }
        }
    }

    protected void initContentProviderSelected2() {
        this.contentProviderSelected2 = new AdapterFactoryContentProvider((AdapterFactory)TngAdapterFactory.INSTANCE.getNavigatorView_ComposedAdapterFactory()){

            public Object[] getElements(Object object) {
                return AssociationHelper.getCustomCategories((DescribableElement)((Role)object)).toArray();
            }
        };
        this.viewer_selected2.setContentProvider((IContentProvider)this.contentProviderSelected2);
    }

    protected void addItemsToModel2(ArrayList addItems) {
        if (!addItems.isEmpty()) {
            for (CustomCategory customCategory : addItems) {
                LibraryManager.getInstance().addToCustomCategory(this.getActionManager(), customCategory, (MethodElement)this.role, (List)this.usedCategories);
            }
        }
    }

    protected void removeItemsFromModel2(ArrayList rmItems) {
        if (!rmItems.isEmpty()) {
            for (CustomCategory customCategory : rmItems) {
                LibraryManager.getInstance().removeFromCustomCategory(this.getActionManager(), customCategory, (MethodElement)this.role, (List)this.usedCategories);
            }
        }
    }

    protected Object getContentElement() {
        return this.role;
    }

    protected String getTabString() {
        return FilterConstants.ROLESETS;
    }

    protected String getTabString2() {
        return FilterConstants.CUSTOM_CATEGORIES;
    }

    protected IFilter getFilter() {
        this.filter = new CategoryFilter(){

            protected boolean childAccept(Object obj) {
                return obj instanceof RoleSet;
            }
        };
        return this.filter;
    }

    protected IFilter getFilter2() {
        this.filter = new CustomCategoryFilter();
        return this.filter;
    }

    protected String getSectionDescription() {
        return AuthoringUIResources.roleCategoriesPage_sectionDescription;
    }

    protected String getSectionName() {
        return AuthoringUIResources.roleCategoriesPage_sectionName;
    }

    protected String getSelectedLabel() {
        return AuthoringUIResources.roleCategoriesPage_selectedLabel;
    }

    protected String getSelectedLabel2() {
        return AuthoringUIResources.roleCategoriesPage_selectedLabel2;
    }

    protected String getSelectedLabel3() {
        return null;
    }

    protected String getMultipleSelectDescriptionString() {
        return AuthoringUIResources.roleCategoriesPage_multipleSelectDescription;
    }
}

