/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.forms;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.authoring.ui.AuthoringUIText;
import org.eclipse.epf.authoring.ui.dialogs.ItemsFilterDialog;
import org.eclipse.epf.authoring.ui.editors.MethodElementEditor;
import org.eclipse.epf.authoring.ui.filters.ContentFilter;
import org.eclipse.epf.authoring.ui.filters.WorkProductFilter;
import org.eclipse.epf.authoring.ui.forms.DescriptionFormPage;
import org.eclipse.epf.authoring.ui.richtext.IMethodRichText;
import org.eclipse.epf.authoring.ui.util.UIHelper;
import org.eclipse.epf.library.edit.IFilter;
import org.eclipse.epf.library.edit.TngAdapterFactory;
import org.eclipse.epf.library.edit.command.IActionManager;
import org.eclipse.epf.library.edit.itemsfilter.FilterConstants;
import org.eclipse.epf.library.edit.itemsfilter.VariabilityBaseElementFilter;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.uma.Artifact;
import org.eclipse.epf.uma.ArtifactDescription;
import org.eclipse.epf.uma.ContentElement;
import org.eclipse.epf.uma.Deliverable;
import org.eclipse.epf.uma.DeliverableDescription;
import org.eclipse.epf.uma.Outcome;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.epf.uma.VariabilityElement;
import org.eclipse.epf.uma.WorkProduct;
import org.eclipse.epf.uma.WorkProductDescription;
import org.eclipse.epf.uma.util.AssociationHelper;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class WorkProductDescriptionPage
extends DescriptionFormPage {
    private static final String FORM_PAGE_ID = "workProductDescriptionPage";
    private IMethodRichText ctrl_impact;
    private IMethodRichText ctrl_reason;
    private IMethodRichText ctrl_brief_outline;
    private IMethodRichText ctrl_representation_options;
    private IMethodRichText ctrl_external_desc;
    private IMethodRichText ctrl_packaging_guidance;
    private IMethodRichText ctrl_representation;
    private IMethodRichText ctrl_notation;
    private WorkProduct workProduct;
    private Button ctrl_slot_button;
    private Section slotSection;
    private Composite slotComposite;
    private String slotSectionDescription;
    private Button addSlotButton;
    private Button removeSlotButton;
    private Table ctrl_slot;
    private TableViewer slotViewer;
    private IStructuredContentProvider slotContentProvider = new AdapterFactoryContentProvider((AdapterFactory)TngAdapterFactory.INSTANCE.getNavigatorView_ComposedAdapterFactory()){

        public Object[] getElements(Object object) {
            ArrayList list = new ArrayList();
            list.addAll(WorkProductDescriptionPage.this.workProduct.getFulfills());
            return list.toArray();
        }
    };
    protected ILabelProvider slotLabelProvider = new AdapterFactoryLabelProvider((AdapterFactory)TngAdapterFactory.INSTANCE.getNavigatorView_ComposedAdapterFactory()){

        public String getColumnText(Object object, int columnIndex) {
            return TngUtil.getLabelWithPath((Object)object);
        }
    };

    public WorkProductDescriptionPage(FormEditor editor) {
        super(editor, FORM_PAGE_ID, AuthoringUIText.DESCRIPTION_PAGE_TITLE);
    }

    public void init(IEditorSite site, IEditorInput input) {
        super.init(site, input);
        this.workProduct = (WorkProduct)this.contentElement;
        this.purposeOn = true;
        this.setExternalIDOn(true);
        if (!(this.contentElement instanceof Outcome)) {
            this.notationSectionOn = true;
        }
        this.tailoringSectionOn = true;
        this.iconSectionOn = true;
        this.slotSectionOn = true;
    }

    protected void createNotationSectionContent() {
        super.createNotationSectionContent();
        if (this.workProduct instanceof Artifact) {
            this.ctrl_brief_outline = this.createRichTextEditWithLinkForSection(this.toolkit, this.notationComposite, AuthoringUIText.BRIEF_OUTLINE_TEXT, 40, 400, 4);
            this.ctrl_representation = this.createRichTextEditWithLinkForSection(this.toolkit, this.notationComposite, AuthoringUIText.REPRESENTATION_TEXT, 40, 400, 4);
            this.ctrl_notation = this.createRichTextEditWithLinkForSection(this.toolkit, this.notationComposite, AuthoringUIText.NOTATION_TEXT, 40, 400, 4);
        } else if (this.workProduct instanceof Deliverable) {
            this.ctrl_external_desc = this.createRichTextEditWithLinkForSection(this.toolkit, this.notationComposite, AuthoringUIText.EXTERNAL_DESCRIPTION_TEXT, 40, 400, 4);
            this.ctrl_packaging_guidance = this.createRichTextEditWithLinkForSection(this.toolkit, this.notationComposite, AuthoringUIText.PACKAGING_GUIDANCE_TEXT, 40, 400, 4);
        }
    }

    protected void createTailoringSectionContent() {
        super.createTailoringSectionContent();
        this.ctrl_impact = this.createRichTextEditWithLinkForSection(this.toolkit, this.tailoringComposite, AuthoringUIText.IMPACT_OF_NOT_HAVING_TEXT, 40, 400, 5);
        this.ctrl_reason = this.createRichTextEditWithLinkForSection(this.toolkit, this.tailoringComposite, AuthoringUIText.REASON_FOR_NOT_NEEDING_TEXT, 40, 400, 5);
        if (this.workProduct instanceof Artifact) {
            this.ctrl_representation_options = this.createRichTextEditWithLinkForSection(this.toolkit, this.tailoringComposite, AuthoringUIText.REPRESENTATION_OPTIONS_TEXT, 40, 400, 4);
        }
    }

    protected void createEditorContent(FormToolkit toolkit) {
        super.createEditorContent(toolkit);
    }

    protected void createSlotSection(FormToolkit toolkit) {
        this.slotSection = this.createSection(toolkit, this.sectionComposite, AuthoringUIText.SLOT_SECTION_NAME, this.slotSectionDescription);
        this.slotComposite = this.createComposite(toolkit, this.slotSection);
        this.slotComposite.setLayoutData((Object)new GridData(768));
        this.slotComposite.setLayout((Layout)new GridLayout(5, false));
        this.createSlotSectionContent();
        toolkit.paintBordersFor(this.slotComposite);
    }

    private void createSlotSectionContent() {
        this.ctrl_slot_button = this.toolkit.createButton(this.slotComposite, AuthoringUIResources.workproductDescriptionPage_slot_text, 32);
        GridData data = new GridData();
        data.horizontalSpan = 5;
        this.ctrl_slot_button.setLayoutData((Object)data);
        WorkProductDescriptionPage.createLabel(this.toolkit, this.slotComposite, AuthoringUIResources.slotsLabel_text, 2);
        this.ctrl_slot = WorkProductDescriptionPage.createTable(this.toolkit, this.slotComposite, 10, 769, 5, 300, 1, 2);
        GridData gridData = new GridData(769);
        gridData.horizontalSpan = 2;
        gridData.heightHint = 30;
        gridData.widthHint = 300;
        this.ctrl_slot.setLayoutData((Object)gridData);
        this.slotViewer = new TableViewer(this.ctrl_slot);
        this.slotViewer.setContentProvider((IContentProvider)this.slotContentProvider);
        this.slotViewer.setLabelProvider((IBaseLabelProvider)this.slotLabelProvider);
        this.slotViewer.setInput((Object)this.methodElement);
        Composite buttonPane = WorkProductDescriptionPage.createComposite(this.toolkit, this.slotComposite, 128, 1, 1, 1);
        GridData gridData2 = new GridData(128);
        buttonPane.setLayoutData((Object)gridData2);
        this.addSlotButton = this.toolkit.createButton(buttonPane, AuthoringUIText.ADD_BUTTON_TEXT, 64);
        gridData2 = new GridData(768);
        gridData2.widthHint = 150;
        this.addSlotButton.setLayoutData((Object)gridData2);
        this.removeSlotButton = this.toolkit.createButton(buttonPane, AuthoringUIText.REMOVE_BUTTON_TEXT, 64);
        gridData2 = new GridData(768);
        gridData2.widthHint = 150;
        this.removeSlotButton.setLayoutData((Object)gridData2);
        this.removeSlotButton.setEnabled(false);
    }

    protected void addListeners() {
        final IActionManager actionMgr = ((MethodElementEditor)this.getEditor()).getActionManager();
        super.addListeners();
        if (this.slotSectionOn) {
            this.addSlotListeners();
        }
        if (this.purposeOn) {
            this.ctrl_purpose.setModalObject((EObject)this.contentElement.getPresentation());
            this.ctrl_purpose.setModalObjectFeature((EStructuralFeature)UmaPackage.eINSTANCE.getWorkProductDescription_Purpose());
            this.ctrl_purpose.addModifyListener(this.contentModifyListener);
            this.ctrl_purpose.addListener(27, new Listener(){

                public void handleEvent(Event e) {
                    boolean success;
                    IMethodRichText control;
                    IMethodRichText iMethodRichText = control = WorkProductDescriptionPage.this.descExpandFlag ? WorkProductDescriptionPage.this.ctrl_expanded : WorkProductDescriptionPage.this.ctrl_purpose;
                    if (!control.getModified()) {
                        return;
                    }
                    String oldContent = ((WorkProductDescription)WorkProductDescriptionPage.this.workProduct.getPresentation()).getPurpose();
                    if (((MethodElementEditor)WorkProductDescriptionPage.this.getEditor()).mustRestoreValue(control, oldContent)) {
                        return;
                    }
                    String newContent = control.getText();
                    if (!newContent.equals(oldContent) && (success = actionMgr.doAction(1, (EObject)WorkProductDescriptionPage.this.contentElement.getPresentation(), (EStructuralFeature)UmaPackage.eINSTANCE.getWorkProductDescription_Purpose(), (Object)newContent, -1)) && WorkProductDescriptionPage.this.isVersionSectionOn()) {
                        WorkProductDescriptionPage.this.updateChangeDate();
                    }
                }
            });
        }
        if (this.tailoringSectionOn) {
            this.ctrl_impact.setModalObject((EObject)this.contentElement.getPresentation());
            this.ctrl_impact.setModalObjectFeature((EStructuralFeature)UmaPackage.eINSTANCE.getWorkProductDescription_ImpactOfNotHaving());
            this.ctrl_impact.addModifyListener(this.contentModifyListener);
            this.ctrl_impact.addListener(27, new Listener(){

                public void handleEvent(Event e) {
                    boolean success;
                    IMethodRichText control;
                    IMethodRichText iMethodRichText = control = WorkProductDescriptionPage.this.descExpandFlag ? WorkProductDescriptionPage.this.ctrl_expanded : WorkProductDescriptionPage.this.ctrl_impact;
                    if (!control.getModified()) {
                        return;
                    }
                    String oldContent = ((WorkProductDescription)WorkProductDescriptionPage.this.workProduct.getPresentation()).getImpactOfNotHaving();
                    if (((MethodElementEditor)WorkProductDescriptionPage.this.getEditor()).mustRestoreValue(control, oldContent)) {
                        return;
                    }
                    String newContent = control.getText();
                    if (!newContent.equals(oldContent) && (success = actionMgr.doAction(1, (EObject)WorkProductDescriptionPage.this.contentElement.getPresentation(), (EStructuralFeature)UmaPackage.eINSTANCE.getWorkProductDescription_ImpactOfNotHaving(), (Object)newContent, -1)) && WorkProductDescriptionPage.this.isVersionSectionOn()) {
                        WorkProductDescriptionPage.this.updateChangeDate();
                    }
                }
            });
            this.ctrl_reason.setModalObject((EObject)this.contentElement.getPresentation());
            this.ctrl_reason.setModalObjectFeature((EStructuralFeature)UmaPackage.eINSTANCE.getWorkProductDescription_ReasonsForNotNeeding());
            this.ctrl_reason.addModifyListener(this.contentModifyListener);
            this.ctrl_reason.addListener(27, new Listener(){

                public void handleEvent(Event e) {
                    boolean success;
                    IMethodRichText control;
                    IMethodRichText iMethodRichText = control = WorkProductDescriptionPage.this.descExpandFlag ? WorkProductDescriptionPage.this.ctrl_expanded : WorkProductDescriptionPage.this.ctrl_reason;
                    if (!control.getModified()) {
                        return;
                    }
                    String oldContent = ((WorkProductDescription)WorkProductDescriptionPage.this.workProduct.getPresentation()).getReasonsForNotNeeding();
                    if (((MethodElementEditor)WorkProductDescriptionPage.this.getEditor()).mustRestoreValue(control, oldContent)) {
                        return;
                    }
                    String newContent = control.getText();
                    if (!newContent.equals(oldContent) && (success = actionMgr.doAction(1, (EObject)WorkProductDescriptionPage.this.contentElement.getPresentation(), (EStructuralFeature)UmaPackage.eINSTANCE.getWorkProductDescription_ReasonsForNotNeeding(), (Object)newContent, -1)) && WorkProductDescriptionPage.this.isVersionSectionOn()) {
                        WorkProductDescriptionPage.this.updateChangeDate();
                    }
                }
            });
            if (this.workProduct instanceof Artifact) {
                this.ctrl_representation_options.setModalObject((EObject)this.contentElement.getPresentation());
                this.ctrl_representation_options.setModalObjectFeature((EStructuralFeature)UmaPackage.eINSTANCE.getArtifactDescription_RepresentationOptions());
                this.ctrl_representation_options.addModifyListener(this.contentModifyListener);
                this.ctrl_representation_options.addListener(27, new Listener(){

                    public void handleEvent(Event e) {
                        boolean success;
                        IMethodRichText control;
                        IMethodRichText iMethodRichText = control = WorkProductDescriptionPage.this.descExpandFlag ? WorkProductDescriptionPage.this.ctrl_expanded : WorkProductDescriptionPage.this.ctrl_representation_options;
                        if (!control.getModified()) {
                            return;
                        }
                        String oldContent = ((ArtifactDescription)WorkProductDescriptionPage.this.workProduct.getPresentation()).getRepresentationOptions();
                        if (((MethodElementEditor)WorkProductDescriptionPage.this.getEditor()).mustRestoreValue(control, oldContent)) {
                            return;
                        }
                        String newContent = control.getText();
                        if (!newContent.equals(oldContent) && (success = actionMgr.doAction(1, (EObject)WorkProductDescriptionPage.this.contentElement.getPresentation(), (EStructuralFeature)UmaPackage.eINSTANCE.getArtifactDescription_RepresentationOptions(), (Object)newContent, -1)) && WorkProductDescriptionPage.this.isVersionSectionOn()) {
                            WorkProductDescriptionPage.this.updateChangeDate();
                        }
                    }
                });
            }
        }
        if (this.notationSectionOn) {
            if (this.workProduct instanceof Artifact) {
                this.ctrl_brief_outline.setModalObject((EObject)this.contentElement.getPresentation());
                this.ctrl_brief_outline.setModalObjectFeature((EStructuralFeature)UmaPackage.eINSTANCE.getArtifactDescription_BriefOutline());
                this.ctrl_brief_outline.addModifyListener(this.contentModifyListener);
                this.ctrl_brief_outline.addListener(27, new Listener(){

                    public void handleEvent(Event e) {
                        boolean success;
                        String newContent;
                        IMethodRichText control;
                        IMethodRichText iMethodRichText = control = WorkProductDescriptionPage.this.descExpandFlag ? WorkProductDescriptionPage.this.ctrl_expanded : WorkProductDescriptionPage.this.ctrl_brief_outline;
                        if (!control.getModified()) {
                            return;
                        }
                        String oldContent = ((ArtifactDescription)WorkProductDescriptionPage.this.workProduct.getPresentation()).getBriefOutline();
                        if (((MethodElementEditor)WorkProductDescriptionPage.this.getEditor()).mustRestoreValue(control, oldContent)) {
                            return;
                        }
                        String string = newContent = WorkProductDescriptionPage.this.descExpandFlag ? WorkProductDescriptionPage.this.ctrl_expanded.getText() : WorkProductDescriptionPage.this.ctrl_brief_outline.getText();
                        if (!newContent.equals(oldContent) && (success = actionMgr.doAction(1, (EObject)WorkProductDescriptionPage.this.contentElement.getPresentation(), (EStructuralFeature)UmaPackage.eINSTANCE.getArtifactDescription_BriefOutline(), (Object)newContent, -1)) && WorkProductDescriptionPage.this.isVersionSectionOn()) {
                            WorkProductDescriptionPage.this.updateChangeDate();
                        }
                    }
                });
                this.ctrl_representation.setModalObject((EObject)this.contentElement.getPresentation());
                this.ctrl_representation.setModalObjectFeature((EStructuralFeature)UmaPackage.eINSTANCE.getArtifactDescription_Representation());
                this.ctrl_representation.addModifyListener(this.contentModifyListener);
                this.ctrl_representation.addListener(27, new Listener(){

                    public void handleEvent(Event e) {
                        boolean success;
                        String newContent;
                        IMethodRichText control;
                        IMethodRichText iMethodRichText = control = WorkProductDescriptionPage.this.descExpandFlag ? WorkProductDescriptionPage.this.ctrl_expanded : WorkProductDescriptionPage.this.ctrl_representation;
                        if (!control.getModified()) {
                            return;
                        }
                        String oldContent = ((ArtifactDescription)WorkProductDescriptionPage.this.workProduct.getPresentation()).getRepresentation();
                        if (((MethodElementEditor)WorkProductDescriptionPage.this.getEditor()).mustRestoreValue(control, oldContent)) {
                            return;
                        }
                        String string = newContent = WorkProductDescriptionPage.this.descExpandFlag ? WorkProductDescriptionPage.this.ctrl_expanded.getText() : WorkProductDescriptionPage.this.ctrl_representation.getText();
                        if (!newContent.equals(oldContent) && (success = actionMgr.doAction(1, (EObject)WorkProductDescriptionPage.this.contentElement.getPresentation(), (EStructuralFeature)UmaPackage.eINSTANCE.getArtifactDescription_Representation(), (Object)newContent, -1)) && WorkProductDescriptionPage.this.isVersionSectionOn()) {
                            WorkProductDescriptionPage.this.updateChangeDate();
                        }
                    }
                });
                this.ctrl_notation.setModalObject((EObject)this.contentElement.getPresentation());
                this.ctrl_notation.setModalObjectFeature((EStructuralFeature)UmaPackage.eINSTANCE.getArtifactDescription_Notation());
                this.ctrl_notation.addModifyListener(this.contentModifyListener);
                this.ctrl_notation.addListener(27, new Listener(){

                    public void handleEvent(Event e) {
                        boolean success;
                        String newContent;
                        IMethodRichText control;
                        IMethodRichText iMethodRichText = control = WorkProductDescriptionPage.this.descExpandFlag ? WorkProductDescriptionPage.this.ctrl_expanded : WorkProductDescriptionPage.this.ctrl_notation;
                        if (!control.getModified()) {
                            return;
                        }
                        String oldContent = ((ArtifactDescription)WorkProductDescriptionPage.this.workProduct.getPresentation()).getNotation();
                        if (((MethodElementEditor)WorkProductDescriptionPage.this.getEditor()).mustRestoreValue(control, oldContent)) {
                            return;
                        }
                        String string = newContent = WorkProductDescriptionPage.this.descExpandFlag ? WorkProductDescriptionPage.this.ctrl_expanded.getText() : WorkProductDescriptionPage.this.ctrl_notation.getText();
                        if (!newContent.equals(oldContent) && (success = actionMgr.doAction(1, (EObject)WorkProductDescriptionPage.this.contentElement.getPresentation(), (EStructuralFeature)UmaPackage.eINSTANCE.getArtifactDescription_Notation(), (Object)newContent, -1)) && WorkProductDescriptionPage.this.isVersionSectionOn()) {
                            WorkProductDescriptionPage.this.updateChangeDate();
                        }
                    }
                });
            }
            if (this.workProduct instanceof Deliverable) {
                this.ctrl_external_desc.setModalObject((EObject)this.contentElement.getPresentation());
                this.ctrl_external_desc.setModalObjectFeature((EStructuralFeature)UmaPackage.eINSTANCE.getDeliverableDescription_ExternalDescription());
                this.ctrl_external_desc.addModifyListener(this.contentModifyListener);
                this.ctrl_external_desc.addListener(27, new Listener(){

                    public void handleEvent(Event e) {
                        boolean success;
                        IMethodRichText control;
                        IMethodRichText iMethodRichText = control = WorkProductDescriptionPage.this.descExpandFlag ? WorkProductDescriptionPage.this.ctrl_expanded : WorkProductDescriptionPage.this.ctrl_external_desc;
                        if (!control.getModified()) {
                            return;
                        }
                        String oldContent = ((DeliverableDescription)WorkProductDescriptionPage.this.workProduct.getPresentation()).getExternalDescription();
                        if (((MethodElementEditor)WorkProductDescriptionPage.this.getEditor()).mustRestoreValue(control, oldContent)) {
                            return;
                        }
                        String newContent = control.getText();
                        if (!newContent.equals(oldContent) && (success = actionMgr.doAction(1, (EObject)WorkProductDescriptionPage.this.contentElement.getPresentation(), (EStructuralFeature)UmaPackage.eINSTANCE.getDeliverableDescription_ExternalDescription(), (Object)newContent, -1)) && WorkProductDescriptionPage.this.isVersionSectionOn()) {
                            WorkProductDescriptionPage.this.updateChangeDate();
                        }
                    }
                });
                this.ctrl_packaging_guidance.setModalObject((EObject)this.contentElement.getPresentation());
                this.ctrl_packaging_guidance.setModalObjectFeature((EStructuralFeature)UmaPackage.eINSTANCE.getDeliverableDescription_PackagingGuidance());
                this.ctrl_packaging_guidance.addModifyListener(this.contentModifyListener);
                this.ctrl_packaging_guidance.addListener(27, new Listener(){

                    public void handleEvent(Event e) {
                        boolean success;
                        IMethodRichText control;
                        IMethodRichText iMethodRichText = control = WorkProductDescriptionPage.this.descExpandFlag ? WorkProductDescriptionPage.this.ctrl_expanded : WorkProductDescriptionPage.this.ctrl_packaging_guidance;
                        if (!control.getModified()) {
                            return;
                        }
                        String oldContent = ((DeliverableDescription)WorkProductDescriptionPage.this.workProduct.getPresentation()).getPackagingGuidance();
                        if (((MethodElementEditor)WorkProductDescriptionPage.this.getEditor()).mustRestoreValue(control, oldContent)) {
                            return;
                        }
                        String newContent = control.getText();
                        if (!newContent.equals(oldContent) && (success = actionMgr.doAction(1, (EObject)WorkProductDescriptionPage.this.contentElement.getPresentation(), (EStructuralFeature)UmaPackage.eINSTANCE.getDeliverableDescription_PackagingGuidance(), (Object)newContent, -1)) && WorkProductDescriptionPage.this.isVersionSectionOn()) {
                            WorkProductDescriptionPage.this.updateChangeDate();
                        }
                    }
                });
            }
        }
    }

    private void addSlotListeners() {
        this.ctrl_slot_button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Boolean isSlot = new Boolean(WorkProductDescriptionPage.this.ctrl_slot_button.getSelection());
                if (isSlot.booleanValue()) {
                    List fulFills = WorkProductDescriptionPage.this.workProduct.getFulfills();
                    if (fulFills != null && fulFills.size() != 0) {
                        boolean val = AuthoringUIPlugin.getDefault().getMsgDialog().displayConfirmation(AuthoringUIResources.slotConfirmDialog_title, AuthoringUIResources.wpFulFillsConfirmDialog_message);
                        if (!val) {
                            WorkProductDescriptionPage.this.ctrl_slot_button.setSelection(WorkProductDescriptionPage.this.workProduct.getIsAbstract().booleanValue());
                            return;
                        }
                        WorkProductDescriptionPage.this.actionMgr.doAction(6, (EObject)WorkProductDescriptionPage.this.workProduct, (EStructuralFeature)UmaPackage.eINSTANCE.getFulfillableElement_Fulfills(), (Object)fulFills, -1);
                    }
                } else {
                    ArrayList fulFills = new ArrayList();
                    fulFills.addAll(AssociationHelper.getFullFills((WorkProduct)WorkProductDescriptionPage.this.workProduct));
                    if (fulFills != null && fulFills.size() != 0) {
                        boolean val = AuthoringUIPlugin.getDefault().getMsgDialog().displayConfirmation(AuthoringUIResources.slotConfirmDialog_title, AuthoringUIResources.wpSlotFulFillsConfirmDialog_message);
                        if (!val) {
                            WorkProductDescriptionPage.this.ctrl_slot_button.setSelection(WorkProductDescriptionPage.this.workProduct.getIsAbstract().booleanValue());
                            return;
                        }
                        for (WorkProduct wp : fulFills) {
                            WorkProductDescriptionPage.this.actionMgr.doAction(4, (EObject)wp, (EStructuralFeature)UmaPackage.eINSTANCE.getFulfillableElement_Fulfills(), (Object)WorkProductDescriptionPage.this.workProduct, -1);
                        }
                    }
                }
                WorkProductDescriptionPage.this.actionMgr.doAction(1, (EObject)WorkProductDescriptionPage.this.methodElement, (EStructuralFeature)UmaPackage.eINSTANCE.getClassifier_IsAbstract(), (Object)isSlot, -1);
                if (isSlot.booleanValue()) {
                    WorkProductDescriptionPage.this.addSlotButton.setEnabled(false);
                } else {
                    WorkProductDescriptionPage.this.addSlotButton.setEnabled(true);
                }
            }
        });
        this.addSlotButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WorkProductFilter filter = new WorkProductFilter(){

                    protected boolean childAccept(Object obj) {
                        if (obj instanceof WorkProduct) {
                            return ((WorkProduct)obj).getIsAbstract();
                        }
                        return false;
                    }
                };
                ArrayList alreadyExisting = new ArrayList();
                alreadyExisting.addAll(WorkProductDescriptionPage.this.workProduct.getFulfills());
                ItemsFilterDialog fd = new ItemsFilterDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (IFilter)filter, WorkProductDescriptionPage.this.methodElement, FilterConstants.WORKPRODUCTS, alreadyExisting);
                fd.setViewerSelectionSingle(false);
                fd.setBlockOnOpen(true);
                fd.setTitle(FilterConstants.WORKPRODUCTS);
                fd.open();
                if (fd.getSelectedItems().size() > 0) {
                    boolean status = WorkProductDescriptionPage.this.actionMgr.doAction(5, (EObject)WorkProductDescriptionPage.this.workProduct, (EStructuralFeature)UmaPackage.eINSTANCE.getFulfillableElement_Fulfills(), (Object)fd.getSelectedItems(), -1);
                    if (!status) {
                        return;
                    }
                    WorkProductDescriptionPage.this.slotViewer.refresh();
                }
            }
        });
        this.removeSlotButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)WorkProductDescriptionPage.this.slotViewer.getSelection();
                if (selection.size() > 0) {
                    boolean status = WorkProductDescriptionPage.this.actionMgr.doAction(6, (EObject)WorkProductDescriptionPage.this.workProduct, (EStructuralFeature)UmaPackage.eINSTANCE.getFulfillableElement_Fulfills(), (Object)selection.toList(), -1);
                    if (!status) {
                        return;
                    }
                    WorkProductDescriptionPage.this.slotViewer.refresh();
                    WorkProductDescriptionPage.this.removeSlotButton.setEnabled(false);
                }
            }
        });
        this.slotViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent e) {
                IStructuredSelection selection = (IStructuredSelection)WorkProductDescriptionPage.this.slotViewer.getSelection();
                if (selection.size() > 0 && !TngUtil.isLocked((EObject)WorkProductDescriptionPage.this.workProduct)) {
                    WorkProductDescriptionPage.this.removeSlotButton.setEnabled(true);
                }
            }
        });
    }

    protected void refresh(boolean editable) {
        super.refresh(editable);
        if (this.slotSectionOn) {
            this.ctrl_slot_button.setEnabled(editable);
            Boolean isAbstract = this.workProduct.getIsAbstract();
            if (isAbstract != null && editable) {
                if (isAbstract.booleanValue()) {
                    this.addSlotButton.setEnabled(false);
                } else {
                    this.addSlotButton.setEnabled(true);
                }
            } else {
                this.addSlotButton.setEnabled(editable);
            }
            IStructuredSelection selection = (IStructuredSelection)this.slotViewer.getSelection();
            if (selection.size() > 0 && editable) {
                this.removeSlotButton.setEnabled(true);
            } else {
                this.removeSlotButton.setEnabled(false);
            }
        }
        if (this.tailoringSectionOn) {
            this.ctrl_impact.setEditable(editable);
            this.ctrl_reason.setEditable(editable);
            if (this.workProduct instanceof Artifact) {
                this.ctrl_representation_options.setEditable(editable);
            }
        }
        if (this.notationSectionOn) {
            if (this.workProduct instanceof Artifact) {
                this.ctrl_brief_outline.setEditable(editable);
                this.ctrl_representation.setEditable(editable);
                this.ctrl_notation.setEditable(editable);
            }
            if (this.workProduct instanceof Deliverable) {
                this.ctrl_external_desc.setEditable(editable);
                this.ctrl_packaging_guidance.setEditable(editable);
            }
        }
    }

    protected void loadData() {
        super.loadData();
        if (this.slotSectionOn) {
            Boolean isAbstract = this.workProduct.getIsAbstract();
            if (isAbstract != null) {
                this.ctrl_slot_button.setSelection(isAbstract.booleanValue());
            } else {
                this.ctrl_slot_button.setSelection(false);
            }
        }
        WorkProductDescription content = (WorkProductDescription)this.workProduct.getPresentation();
        if (this.purposeOn) {
            String purpose = content.getPurpose();
            this.ctrl_purpose.setText(purpose == null ? "" : purpose);
        }
        if (this.tailoringSectionOn) {
            String impact = content.getImpactOfNotHaving();
            String reason = content.getReasonsForNotNeeding();
            this.ctrl_impact.setText(impact == null ? "" : impact);
            this.ctrl_reason.setText(reason == null ? "" : reason);
            if (this.workProduct instanceof Artifact) {
                this.ctrl_representation_options.setText(((ArtifactDescription)content).getRepresentationOptions() == null ? "" : ((ArtifactDescription)content).getRepresentationOptions());
            }
        }
        if (this.notationSectionOn) {
            if (this.workProduct instanceof Artifact) {
                this.ctrl_brief_outline.setText(((ArtifactDescription)content).getBriefOutline() == null ? "" : ((ArtifactDescription)content).getBriefOutline());
                this.ctrl_representation.setText(((ArtifactDescription)content).getRepresentation() == null ? "" : ((ArtifactDescription)content).getRepresentation());
                this.ctrl_notation.setText(((ArtifactDescription)content).getNotation() == null ? "" : ((ArtifactDescription)content).getNotation());
            } else if (this.workProduct instanceof Deliverable) {
                this.ctrl_external_desc.setText(((DeliverableDescription)content).getExternalDescription() == null ? "" : ((DeliverableDescription)content).getExternalDescription());
                this.ctrl_packaging_guidance.setText(((DeliverableDescription)content).getPackagingGuidance() == null ? "" : ((DeliverableDescription)content).getPackagingGuidance());
            }
        }
    }

    protected Object getContentElement() {
        return this.workProduct;
    }

    protected String getTabString() {
        return FilterConstants.WORKPRODUCTS;
    }

    protected IFilter getFilter() {
        this.filter = new WorkProductFilter(){
            List badlist = new ArrayList();

            protected boolean childAccept(Object obj) {
                if (super.childAccept(obj) && obj instanceof ContentElement && obj instanceof WorkProduct && ((ContentElement)this.getHelper().getContentElement()).getType().equals(((ContentElement)obj).getType())) {
                    if (obj instanceof Deliverable && WorkProductDescriptionPage.this.workProduct instanceof Deliverable) {
                        if (!UIHelper.checkCircularDeliverables((Deliverable)obj, (Deliverable)WorkProductDescriptionPage.this.workProduct)) {
                            this.badlist.add(obj);
                            return false;
                        }
                        if (((Deliverable)obj).getVariabilityBasedOnElement() != null && !UIHelper.checkCircularDeliverables((Deliverable)((Deliverable)obj).getVariabilityBasedOnElement(), (Deliverable)WorkProductDescriptionPage.this.workProduct)) {
                            this.badlist.add(obj);
                            return false;
                        }
                        Iterator it1 = TngUtil.getGeneralizers((VariabilityElement)((Deliverable)obj));
                        while (it1.hasNext()) {
                            VariabilityElement ve = (VariabilityElement)it1.next();
                            if (ve == null) continue;
                            if (ve.equals(obj)) {
                                return false;
                            }
                            if (UIHelper.checkCircularDeliverables((Deliverable)ve, (Deliverable)WorkProductDescriptionPage.this.workProduct)) continue;
                            this.badlist.add(obj);
                            return false;
                        }
                        ArrayList templist = new ArrayList();
                        for (Object bad : this.badlist) {
                            UIHelper.deliverablePartsChain((Deliverable)bad, templist);
                        }
                        if (templist.contains(obj)) {
                            return false;
                        }
                    }
                    return true;
                }
                return false;
            }
        };
        ((ContentFilter)this.filter).setAdditionalFilters(new IFilter[]{new VariabilityBaseElementFilter((VariabilityElement)this.workProduct)});
        return this.filter;
    }

    public void loadSectionDescription() {
        if (this.contentElement instanceof Artifact) {
            this.generalSectionDescription = AuthoringUIResources.artifact_generalInfoSection_desc;
            this.detailSectionDescription = AuthoringUIResources.artifact_detailSection_desc;
            this.variabilitySectionDescription = AuthoringUIResources.artifact_variabilitySection_desc;
            this.versionSectionDescription = AuthoringUIResources.artifact_versionInfoSection_desc;
            this.notationSectionDescription = AuthoringUIResources.artifact_notationSection_desc;
            this.tailoringSectionDescription = AuthoringUIResources.artifact_tailoringSection_desc;
            this.iconSectionDescription = AuthoringUIResources.artifact_iconSection_desc;
            this.slotSectionDescription = AuthoringUIResources.artifact_slotSection_desc;
        }
        if (this.contentElement instanceof Outcome) {
            this.generalSectionDescription = AuthoringUIResources.outcome_generalInfoSection_desc;
            this.detailSectionDescription = AuthoringUIResources.outcome_detailSection_desc;
            this.variabilitySectionDescription = AuthoringUIResources.outcome_variabilitySection_desc;
            this.versionSectionDescription = AuthoringUIResources.outcome_versionInfoSection_desc;
            this.notationSectionDescription = AuthoringUIResources.outcome_notationSection_desc;
            this.tailoringSectionDescription = AuthoringUIResources.outcome_tailoringSection_desc;
            this.iconSectionDescription = AuthoringUIResources.outcome_iconSection_desc;
            this.slotSectionDescription = AuthoringUIResources.outcome_slotSection_desc;
        }
        if (this.contentElement instanceof Deliverable) {
            this.generalSectionDescription = AuthoringUIResources.deliverable_generalInfoSection_desc;
            this.detailSectionDescription = AuthoringUIResources.deliverable_detailSection_desc;
            this.variabilitySectionDescription = AuthoringUIResources.deliverable_variabilitySection_desc;
            this.versionSectionDescription = AuthoringUIResources.deliverable_versionInfoSection_desc;
            this.notationSectionDescription = AuthoringUIResources.deliverable_notationSection_desc;
            this.tailoringSectionDescription = AuthoringUIResources.deliverable_tailoringSection_desc;
            this.iconSectionDescription = AuthoringUIResources.deliverable_iconSection_desc;
            this.slotSectionDescription = AuthoringUIResources.deliverable_slotSection_desc;
        }
    }
}

