/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.internal.wizards;

import java.util.Map;
import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.authoring.ui.AuthoringUIText;
import org.eclipse.epf.library.LibraryManagerFactory;
import org.eclipse.epf.library.ui.wizards.NewLibraryWizardPage;
import org.eclipse.epf.library.ui.wizards.NewLibraryWizardPageFactory;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class NewLibraryMainPage2
extends WizardPage {
    public static final String PAGE_NAME = NewLibraryMainPage2.class.getName();
    private static final String TYPE_ID = "typeId";
    private Text nameText;
    private Text briefDescText;
    private Button[] radioButtons;

    public NewLibraryMainPage2() {
        super(PAGE_NAME);
        this.setTitle(AuthoringUIResources.newLibraryWizardMainPage_title);
        this.setDescription(AuthoringUIResources.newLibraryWizardMainPage_description);
        this.setImageDescriptor(AuthoringUIPlugin.getDefault().getImageDescriptor("full/wizban/New.gif"));
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(3, false));
        Label nameLabel = new Label(composite, 0);
        nameLabel.setText(AuthoringUIText.NAME_TEXT);
        this.nameText = new Text(composite, 2048);
        this.nameText.setLayoutData((Object)new GridData(768));
        ((GridData)this.nameText.getLayoutData()).horizontalSpan = 2;
        Label briefDescLabel = new Label(composite, 0);
        briefDescLabel.setText(AuthoringUIText.DESCRIPTION_TEXT);
        this.briefDescText = new Text(composite, 2626);
        this.briefDescText.setLayoutData((Object)new GridData(768));
        ((GridData)this.briefDescText.getLayoutData()).horizontalSpan = 2;
        ((GridData)this.briefDescText.getLayoutData()).heightHint = 70;
        ((GridData)this.briefDescText.getLayoutData()).widthHint = 480;
        Label libraryTypeLabel = new Label(composite, 0);
        libraryTypeLabel.setText(AuthoringUIResources.libraryTypeLabel_text);
        Composite typeComposite = new Composite(composite, 0);
        typeComposite.setLayout((Layout)new GridLayout(2, false));
        typeComposite.setLayoutData((Object)new GridData(768));
        Map types = LibraryManagerFactory.getInstance().getLibraryTypes();
        this.radioButtons = new Button[types.size()];
        int radioButtonIndex = 0;
        for (String typeId : types.keySet()) {
            String typeName = (String)types.get(typeId);
            Button radioButton = new Button(typeComposite, 16);
            radioButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    NewLibraryMainPage2.this.setPageComplete(NewLibraryMainPage2.this.isPageComplete());
                    NewLibraryMainPage2.this.getWizard().getContainer().updateButtons();
                }
            });
            radioButton.setText(typeName);
            radioButton.setData(TYPE_ID, (Object)typeId);
            this.radioButtons[radioButtonIndex++] = radioButton;
        }
        if (this.radioButtons.length > 0) {
            this.radioButtons[0].setSelection(true);
        }
        this.addListeners();
        this.setPageComplete(this.isPageComplete());
        this.setControl((Control)composite);
    }

    public IWizardPage getNextPage() {
        NewLibraryWizardPage wizardPage = NewLibraryWizardPageFactory.getInstance().getWizardPage(this.getLibraryType());
        if (wizardPage != null) {
            wizardPage.onEnterPage((Object)this.getLibraryName());
        }
        return wizardPage;
    }

    public boolean isPageComplete() {
        return this.getLibraryName().length() > 0;
    }

    private void addListeners() {
        this.nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewLibraryMainPage2.this.setPageComplete(NewLibraryMainPage2.this.isPageComplete());
                NewLibraryMainPage2.this.getWizard().getContainer().updateButtons();
            }
        });
    }

    public String getLibraryName() {
        return this.nameText.getText().trim();
    }

    public String getLibraryType() {
        int i = 0;
        while (i < this.radioButtons.length) {
            Button radioButton = this.radioButtons[i];
            if (radioButton.getSelection()) {
                return (String)radioButton.getData(TYPE_ID);
            }
            ++i;
        }
        return (String)this.radioButtons[0].getData(TYPE_ID);
    }
}

