/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.internal.wizards;

import org.eclipse.epf.authoring.ui.AuthoringPerspective;
import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.authoring.ui.wizards.NewLibraryMainPage;
import org.eclipse.epf.authoring.ui.wizards.SaveAllEditorsPage;
import org.eclipse.epf.common.ui.util.PerspectiveUtil;
import org.eclipse.epf.library.LibraryManagerFactory;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.ui.LibraryUIPlugin;
import org.eclipse.epf.library.ui.preferences.LibraryUIPreferences;
import org.eclipse.epf.library.ui.wizards.NewLibraryWizardPage;
import org.eclipse.epf.library.ui.wizards.NewLibraryWizardPageFactory;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class NewLibraryWizard2
extends Wizard
implements INewWizard {
    public static final String WIZARD_ID = NewLibraryWizard2.class.getName();
    private NewLibraryMainPage mainPage;

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.setWindowTitle(AuthoringUIResources.newLibraryWizard_title);
    }

    public void addPages() {
        SaveAllEditorsPage.addPageIfNeeded(this, true, null, null, null);
        this.mainPage = new NewLibraryMainPage();
        this.addPage((IWizardPage)this.mainPage);
        for (String persistenceId : LibraryManagerFactory.getInstance().getLibraryTypes().keySet()) {
            String pageId = String.valueOf(persistenceId) + "Page";
            NewLibraryWizardPage page = NewLibraryWizardPageFactory.getInstance().createWizardPage(pageId, persistenceId);
            if (page == null) continue;
            page.setImageDescriptor(AuthoringUIPlugin.getDefault().getImageDescriptor("full/wizban/New.gif"));
            this.addPage((IWizardPage)page);
        }
    }

    public void createPageControls(Composite pageContainer) {
        super.createPageControls(pageContainer);
        pageContainer.getShell().setImage(AuthoringUIPlugin.getDefault().getSharedImage("full/obj16/MethodLibrary.gif"));
    }

    public boolean canFinish() {
        IWizardPage[] pages = this.getPages();
        int i = 1;
        while (i < pages.length) {
            if (!pages[i].isPageComplete()) {
                return false;
            }
            ++i;
        }
        return this.getContainer().getCurrentPage() != this.mainPage;
    }

    public boolean performFinish() {
        String name = this.mainPage.getLibraryName();
        String type = this.mainPage.getLibraryType();
        NewLibraryWizardPage page = NewLibraryWizardPageFactory.getInstance().getWizardPage(type);
        try {
            MethodLibrary library = LibraryService.getInstance().createMethodLibrary(name, type, page.getSelections());
            if (library != null) {
                this.addRecentlyOpenedLibrary(library);
                PerspectiveUtil.openPerspective((String)AuthoringPerspective.PERSPECTIVE_ID);
                return true;
            }
        }
        catch (Exception e) {
            String reason = e.getMessage();
            if (reason == null) {
                reason = AuthoringUIResources.newLibraryInternlError_reason;
            }
            reason = String.valueOf(reason) + "\n\n" + AuthoringUIResources.newLibraryError_advice;
            if (e.getMessage() != null) {
                LibraryUIPlugin.getDefault().getMsgDialog().displayError(AuthoringUIResources.newLibraryWizard_title, AuthoringUIResources.newLibraryError_msg, reason);
            }
            LibraryUIPlugin.getDefault().getMsgDialog().displayError(AuthoringUIResources.newLibraryWizard_title, AuthoringUIResources.newLibraryError_msg, reason, (Throwable)e);
        }
        return false;
    }

    protected void addRecentlyOpenedLibrary(MethodLibrary library) {
        if (library != null) {
            String libraryURI = LibraryService.getInstance().getLibraryManager(library).getMethodLibraryURI().toString();
            LibraryUIPreferences.addOpenLibraryURI((String)libraryURI);
        }
    }
}

