/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.properties;

import java.util.HashMap;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.epf.authoring.ui.editors.ColumnDescriptor;
import org.eclipse.epf.authoring.ui.properties.AbstractSection;
import org.eclipse.epf.authoring.ui.properties.FormUI;
import org.eclipse.epf.authoring.ui.properties.PropertiesResources;
import org.eclipse.epf.authoring.ui.providers.ExposedAdapterFactoryContentProvider;
import org.eclipse.epf.authoring.ui.views.ProcessViewer;
import org.eclipse.epf.common.preferences.IPreferenceStoreWrapper;
import org.eclipse.epf.library.LibraryPlugin;
import org.eclipse.epf.library.edit.process.IBSItemProvider;
import org.eclipse.epf.library.edit.process.IColumnAware;
import org.eclipse.epf.uma.Activity;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public abstract class ActivityRollupSection
extends AbstractSection {
    private FormToolkit toolkit;
    protected Section section;
    private Composite rollupComposite;
    private ProcessViewer viewer;
    private Activity element;
    protected IPreferenceStoreWrapper store;
    protected ColumnDescriptor[] columnDescriptors;
    protected ComposedAdapterFactory adapterFactory;
    private ILabelProvider labelProvider;
    private IContentProvider contentProvider;

    private void init() {
        this.element = (Activity)this.getElement();
        this.toolkit = this.getWidgetFactory();
        this.store = LibraryPlugin.getDefault().getPreferenceStore();
    }

    public void createControls(Composite parent, TabbedPropertySheetPage tabbedPropertySheetPage) {
        super.createControls(parent, tabbedPropertySheetPage);
        this.init();
        parent.setLayout((Layout)new GridLayout());
        parent.setLayoutData((Object)new GridData(1808));
        this.createRollupSection(parent);
    }

    private void createRollupSection(Composite composite) {
        this.section = FormUI.createSection(this.toolkit, composite, PropertiesResources.Activity_WorkRollup, PropertiesResources.Activity_WorkRollupDescription);
        this.rollupComposite = FormUI.createComposite(this.toolkit, this.section, 2, false);
        this.setSectionLabels();
        this.viewer = new ProcessViewer(this.rollupComposite, 68354);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.verticalIndent = 10;
        this.viewer.getControl().setLayoutData((Object)gridData);
        this.initAdapterFactory();
        this.viewer.setupColumns(this.columnDescriptors);
        ActivityRollupSection.setColumnIndexToNameMap((AdapterFactory)this.adapterFactory, this.columnDescriptors);
        this.viewer.setContentProvider((IContentProvider)new ExposedAdapterFactoryContentProvider((AdapterFactory)this.adapterFactory));
        this.viewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider((AdapterFactory)this.adapterFactory));
        this.rollUp();
    }

    private void rollUp() {
        this.viewer.setInput(this.element);
        IBSItemProvider adapter = (IBSItemProvider)this.adapterFactory.adapt((Notifier)this.element, ITreeItemContentProvider.class);
        adapter.setRolledUp(true);
        this.viewer.refresh();
    }

    private static void setColumnIndexToNameMap(AdapterFactory factory, ColumnDescriptor[] columnDescriptors) {
        HashMap<Integer, String> columnIndexToNameMap = new HashMap<Integer, String>();
        int i = 0;
        while (i < columnDescriptors.length) {
            columnIndexToNameMap.put(new Integer(i), columnDescriptors[i].id);
            ++i;
        }
        ((IColumnAware)factory).setColumnIndexToNameMap(columnIndexToNameMap);
    }

    public void dispose() {
        super.dispose();
        if (this.adapterFactory != null) {
            this.adapterFactory.dispose();
        }
        if (this.labelProvider != null) {
            this.labelProvider.dispose();
        }
        if (this.contentProvider != null) {
            this.contentProvider.dispose();
        }
    }

    public void refresh() {
        try {
            if (this.getElement() instanceof Activity) {
                this.element = (Activity)this.getElement();
                this.rollUp();
            }
        }
        catch (Exception ex) {
            this.logger.logError("Error refreshing activity work roll up section", (Throwable)ex);
        }
    }

    protected abstract void initAdapterFactory();

    protected abstract void setSectionLabels();
}

