/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.properties;

import com.ibm.icu.util.StringTokenizer;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.epf.authoring.ui.editors.ColumnDescriptor;
import org.eclipse.epf.authoring.ui.editors.ProcessEditor;
import org.eclipse.epf.authoring.ui.properties.ActivityRollupSection;
import org.eclipse.epf.authoring.ui.properties.PropertiesResources;
import org.eclipse.epf.library.edit.IFilter;
import org.eclipse.epf.library.edit.TngAdapterFactory;
import org.eclipse.epf.library.edit.util.ConfigurableComposedAdapterFactory;

public class ActivityWorkRollupSection
extends ActivityRollupSection {
    protected void initAdapterFactory() {
        this.columnDescriptors = this.getColumnDescriptors();
        this.adapterFactory = TngAdapterFactory.INSTANCE.createWBSComposedAdapterFactory();
        if (this.adapterFactory instanceof ConfigurableComposedAdapterFactory) {
            ((ConfigurableComposedAdapterFactory)this.adapterFactory).setFilter((IFilter)this.configurator);
        }
    }

    private ColumnDescriptor[] getColumnDescriptors() {
        ColumnDescriptor[] descriptors = ActivityWorkRollupSection.toColumnDescriptors(this.store.getString("org.eclipse.epf.library.edit.wbs_columns"));
        int index = -1;
        int i = 0;
        while (i < descriptors.length) {
            if (descriptors[i] == ProcessEditor.COL_DESC_PREDECESSORS) {
                index = i;
                break;
            }
            ++i;
        }
        if (index != -1) {
            int len;
            ColumnDescriptor[] colDescriptors = new ColumnDescriptor[descriptors.length - 1];
            if (index > 0) {
                System.arraycopy(descriptors, 0, colDescriptors, 0, index);
            }
            if ((len = descriptors.length - 1 - index) > 0) {
                System.arraycopy(descriptors, index + 1, colDescriptors, index, len);
            }
            return colDescriptors;
        }
        return descriptors;
    }

    public static EList toColumnDescriptorList(String str) {
        BasicEList columnDescriptors = new BasicEList();
        StringTokenizer tokens = new StringTokenizer(str, ",");
        while (tokens.hasMoreTokens()) {
            ColumnDescriptor columnDescriptor;
            String token = tokens.nextToken();
            if (token.equals(ProcessEditor.COL_DESC_ID.id) || (columnDescriptor = ProcessEditor.idToColumnDescriptorMap.get(token)) == null) continue;
            columnDescriptors.add((Object)columnDescriptor);
        }
        return columnDescriptors;
    }

    public static ColumnDescriptor[] toColumnDescriptors(String str) {
        EList list = ActivityWorkRollupSection.toColumnDescriptorList(str);
        ColumnDescriptor[] columns = new ColumnDescriptor[list.size()];
        list.toArray(columns);
        return columns;
    }

    protected void setSectionLabels() {
        this.section.setText(PropertiesResources.Activity_WorkRollup);
        this.section.setDescription(PropertiesResources.Activity_WorkRollupDescription);
    }
}

