/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.properties;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.emf.edit.provider.WrapperItemProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.authoring.ui.editors.ColumnDescriptor;
import org.eclipse.epf.authoring.ui.properties.BreakdownElementGeneralSection;
import org.eclipse.epf.authoring.ui.properties.EPFPropertySheetPage;
import org.eclipse.epf.authoring.ui.properties.FormUI;
import org.eclipse.epf.authoring.ui.properties.PredecessorDialog;
import org.eclipse.epf.authoring.ui.properties.PredecessorMap;
import org.eclipse.epf.authoring.ui.properties.PropertiesResources;
import org.eclipse.epf.common.ui.util.MsgDialog;
import org.eclipse.epf.common.utils.StrUtil;
import org.eclipse.epf.library.edit.process.BreakdownElementWrapperItemProvider;
import org.eclipse.epf.library.edit.process.IBSItemProvider;
import org.eclipse.epf.library.edit.util.PredecessorList;
import org.eclipse.epf.library.edit.util.ProcessUtil;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.ui.LibraryUIText;
import org.eclipse.epf.uma.Milestone;
import org.eclipse.epf.uma.TeamProfile;
import org.eclipse.epf.uma.UmaFactory;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.epf.uma.VariabilityElement;
import org.eclipse.epf.uma.WorkBreakdownElement;
import org.eclipse.epf.uma.WorkOrder;
import org.eclipse.epf.uma.WorkOrderType;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.PlatformUI;

public class WorkBreakdownElementGeneralSection
extends BreakdownElementGeneralSection {
    protected WorkBreakdownElement element;
    protected Button eventDrivenButton;
    protected Button ongoingButton;
    protected Button repeatableButton;
    protected Button addButton;
    protected Button editButton;
    protected Button removeButton;
    private TableViewer viewer;
    private TextCellEditor textCellEditor;
    private ValidatingTextCellEditor idCellEditor;
    private ComboBoxCellEditor comboBoxCellEditor;
    private List predMapList = new ArrayList();
    private static final String FINISH_TO_START = PropertiesResources.WorkOrderType_FINISH_TO_START;
    private static final String FINISH_TO_FINISH = PropertiesResources.WorkOrderType_FINISH_TO_FINISH;
    private static final String START_TO_START = PropertiesResources.WorkOrderType_START_TO_START;
    private static final String START_TO_FINISH = PropertiesResources.WorkOrderType_START_TO_FINISH;
    private static final String COL_ID = "id";
    private static final String COL_PRESENTATION_NAME = "presentation_name";
    private static final String COL_DEPENDENCY = "dependency";
    public static final ColumnDescriptor COL_DESC_ID = new ColumnDescriptor("id", PropertiesResources.WorkBreakdownElement_Dependency_COL_ID_TEXT, 0, 100, true, 1, 0x1000000);
    public static final ColumnDescriptor COL_DESC_PRESENTATION_NAME = new ColumnDescriptor("presentation_name", PropertiesResources.WorkBreakdownElement_Dependency_COL_PRESENTATION_NAME_TEXT, 1, 250, true, 0);
    public static final ColumnDescriptor COL_DESC_DEPENDENCY = new ColumnDescriptor("dependency", PropertiesResources.WorkBreakdownElement_Dependency_COL_DEPENDENCY_TEXT, 2, 100, true, 2);
    ColumnDescriptor[] columnDescriptors = new ColumnDescriptor[]{COL_DESC_ID, COL_DESC_PRESENTATION_NAME, COL_DESC_DEPENDENCY};

    protected void init() {
        super.init();
        this.element = (WorkBreakdownElement)this.getElement();
    }

    protected void createGeneralSection(Composite composite) {
        super.createGeneralSection(composite);
        this.eventDrivenButton = FormUI.createCheckButton(this.toolkit, this.checkBoxComposite, 1);
        this.eventDrivenButton.setText(PropertiesResources.WorkBreakdownElement_EventDriven);
        this.ongoingButton = FormUI.createCheckButton(this.toolkit, this.checkBoxComposite, 1);
        this.ongoingButton.setText(PropertiesResources.WorkBreakdownElement_Ongoing);
        this.repeatableButton = FormUI.createCheckButton(this.toolkit, this.checkBoxComposite, 2);
        this.repeatableButton.setText(PropertiesResources.WorkBreakdownElement_Repeatable);
        FormUI.createLabel(this.toolkit, this.generalComposite, PropertiesResources.WorkBreakdownElement_Dependency);
        try {
            this.createViewer(this.generalComposite, 2);
        }
        catch (Exception ex) {
            this.logger.logError("Error creating viewer for workbreakdown element general section: ", (Throwable)ex);
        }
        Composite buttonPane = this.toolkit.createComposite(this.generalComposite);
        buttonPane.setLayoutData((Object)new GridData(1040));
        buttonPane.setLayout((Layout)new GridLayout());
        FormUI.createLabel(this.toolkit, buttonPane, "");
        this.addButton = FormUI.createButton(this.toolkit, buttonPane, PropertiesResources.WorkBreakdownElement_Dependency_Add);
        this.editButton = FormUI.createButton(this.toolkit, buttonPane, PropertiesResources.WorkBreakdownElement_Dependency_Edit);
        this.removeButton = FormUI.createButton(this.toolkit, buttonPane, PropertiesResources.WorkBreakdownElement_Dependency_Remove);
        this.editButton.setEnabled(false);
        this.removeButton.setEnabled(false);
    }

    protected void addListeners() {
        super.addListeners();
        this.eventDrivenButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                WorkBreakdownElementGeneralSection.this.element = (WorkBreakdownElement)WorkBreakdownElementGeneralSection.this.getElement();
                boolean status = WorkBreakdownElementGeneralSection.this.actionMgr.doAction(1, (EObject)WorkBreakdownElementGeneralSection.this.element, (EStructuralFeature)UmaPackage.eINSTANCE.getWorkBreakdownElement_IsEventDriven(), (Object)WorkBreakdownElementGeneralSection.this.eventDrivenButton.getSelection(), -1);
                if (!status) {
                    WorkBreakdownElementGeneralSection.this.eventDrivenButton.setSelection(WorkBreakdownElementGeneralSection.this.element.getIsEventDriven().booleanValue());
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.ongoingButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                WorkBreakdownElementGeneralSection.this.element = (WorkBreakdownElement)WorkBreakdownElementGeneralSection.this.getElement();
                boolean status = WorkBreakdownElementGeneralSection.this.actionMgr.doAction(1, (EObject)WorkBreakdownElementGeneralSection.this.element, (EStructuralFeature)UmaPackage.eINSTANCE.getWorkBreakdownElement_IsOngoing(), (Object)WorkBreakdownElementGeneralSection.this.ongoingButton.getSelection(), -1);
                if (!status) {
                    WorkBreakdownElementGeneralSection.this.ongoingButton.setSelection(WorkBreakdownElementGeneralSection.this.element.getIsOngoing().booleanValue());
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.repeatableButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                WorkBreakdownElementGeneralSection.this.element = (WorkBreakdownElement)WorkBreakdownElementGeneralSection.this.getElement();
                boolean status = WorkBreakdownElementGeneralSection.this.actionMgr.doAction(1, (EObject)WorkBreakdownElementGeneralSection.this.element, (EStructuralFeature)UmaPackage.eINSTANCE.getWorkBreakdownElement_IsRepeatable(), (Object)WorkBreakdownElementGeneralSection.this.repeatableButton.getSelection(), -1);
                if (!status) {
                    WorkBreakdownElementGeneralSection.this.repeatableButton.setSelection(WorkBreakdownElementGeneralSection.this.element.getIsRepeatable().booleanValue());
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.addButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                WorkOrder o = UmaFactory.eINSTANCE.createWorkOrder();
                o.setLinkType(WorkOrderType.FINISH_TO_START);
                PredecessorMap map = new PredecessorMap(-1, o);
                WorkBreakdownElementGeneralSection.this.predMapList.add(map);
                WorkBreakdownElementGeneralSection.this.viewer.refresh();
                WorkBreakdownElementGeneralSection.this.viewer.editElement((Object)map, 0);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.editButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)WorkBreakdownElementGeneralSection.this.viewer.getSelection();
                if (selection.size() > 0) {
                    PredecessorMap predMap = (PredecessorMap)selection.getFirstElement();
                    IBSItemProvider adapter = (IBSItemProvider)WorkBreakdownElementGeneralSection.this.getBSAdapter();
                    Object process = adapter.getTopItem();
                    PredecessorDialog dlg = new PredecessorDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), WorkBreakdownElementGeneralSection.this.element, process, WorkBreakdownElementGeneralSection.this.getAdapterFactory(), predMap, WorkBreakdownElementGeneralSection.this.predMapList, WorkBreakdownElementGeneralSection.this.actionMgr);
                    dlg.open();
                    WorkBreakdownElementGeneralSection.this.viewer.refresh();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.removeButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)WorkBreakdownElementGeneralSection.this.viewer.getSelection();
                if (selection.size() > 0) {
                    PredecessorMap map = (PredecessorMap)selection.getFirstElement();
                    WorkBreakdownElementGeneralSection.this.predMapList.remove(map);
                    WorkOrder wo = map.getWorkOrder();
                    WorkBreakdownElement wbe = (WorkBreakdownElement)WorkBreakdownElementGeneralSection.this.getElement();
                    WorkBreakdownElementGeneralSection.this.actionMgr.doAction(4, (EObject)wbe, (EStructuralFeature)UmaPackage.eINSTANCE.getWorkBreakdownElement_LinkToPredecessor(), (Object)wo, -1);
                    WorkBreakdownElementGeneralSection.this.viewer.refresh();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)WorkBreakdownElementGeneralSection.this.viewer.getSelection();
                if (selection.size() == 1 && WorkBreakdownElementGeneralSection.this.editable) {
                    WorkBreakdownElementGeneralSection.this.removeButton.setEnabled(true);
                    WorkBreakdownElementGeneralSection.this.editButton.setEnabled(true);
                }
            }
        });
    }

    protected void updateControls() {
        super.updateControls();
        this.eventDrivenButton.setEnabled(this.editable);
        this.ongoingButton.setEnabled(this.editable);
        this.repeatableButton.setEnabled(this.editable);
        this.viewer.getTable().setEnabled(this.editable);
        this.addButton.setEnabled(this.editable);
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.size() == 1 && this.editable) {
            this.removeButton.setEnabled(this.editable);
            this.editButton.setEnabled(this.editable);
        } else {
            this.removeButton.setEnabled(false);
            this.editButton.setEnabled(false);
        }
        if (!EPFPropertySheetPage.formPageID.equals("wbs") && !EPFPropertySheetPage.formPageID.equals("consolidated")) {
            this.addButton.setEnabled(false);
            this.removeButton.setEnabled(false);
            this.editButton.setEnabled(false);
            this.viewer.getTable().setEnabled(false);
        }
    }

    public void refresh() {
        try {
            if (this.getElement() instanceof WorkBreakdownElement) {
                super.refresh();
                this.element = (WorkBreakdownElement)this.getElement();
                this.eventDrivenButton.setSelection(this.element.getIsEventDriven().booleanValue());
                this.ongoingButton.setSelection(this.element.getIsOngoing().booleanValue());
                this.repeatableButton.setSelection(this.element.getIsRepeatable().booleanValue());
                this.predMapList = new ArrayList();
                this.initializePredList();
                this.viewer.refresh();
            }
        }
        catch (Exception ex) {
            this.logger.logError("Error refreshing Workbreakdown element general section:", (Throwable)ex);
        }
    }

    private void createViewer(Composite parent, int horizontalSpan) {
        this.viewer = new TableViewer(parent, 68356);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.verticalIndent = 10;
        gridData.heightHint = 50;
        gridData.horizontalSpan = horizontalSpan;
        this.viewer.getControl().setLayoutData((Object)gridData);
        String[] colProps = new String[this.columnDescriptors.length];
        int i = 0;
        while (i < this.columnDescriptors.length) {
            colProps[i] = this.columnDescriptors[i].id;
            TableColumn column = new TableColumn(this.viewer.getTable(), this.columnDescriptors[i].alignment);
            column.setText(this.columnDescriptors[i].label);
            column.setResizable(this.columnDescriptors[i].resizable);
            column.setWidth(this.columnDescriptors[i].width);
            ++i;
        }
        this.viewer.getTable().setHeaderVisible(true);
        this.viewer.setColumnProperties(colProps);
        AdapterFactoryContentProvider contentProvider = new AdapterFactoryContentProvider(this.getAdapterFactory()){

            public Object[] getElements(Object obj) {
                if (obj instanceof List) {
                    return WorkBreakdownElementGeneralSection.this.predMapList.toArray();
                }
                return null;
            }
        };
        this.viewer.setContentProvider((IContentProvider)contentProvider);
        AdapterFactoryLabelProvider labelProvider = new AdapterFactoryLabelProvider(this.getAdapterFactory()){

            public String getColumnText(Object obj, int i) {
                if (obj instanceof PredecessorMap) {
                    int id = ((PredecessorMap)obj).getId();
                    WorkOrder wo = ((PredecessorMap)obj).getWorkOrder();
                    if (i == 0) {
                        return String.valueOf(id);
                    }
                    if (i == 1) {
                        String name = "";
                        if (wo.getPred() != null && StrUtil.isBlank((String)(name = wo.getPred().getPresentationName()))) {
                            return wo.getPred().getName();
                        }
                        return name;
                    }
                    if (i == 2) {
                        if (wo.getLinkType() == WorkOrderType.FINISH_TO_FINISH) {
                            return FINISH_TO_FINISH;
                        }
                        if (wo.getLinkType() == WorkOrderType.FINISH_TO_START) {
                            return FINISH_TO_START;
                        }
                        if (wo.getLinkType() == WorkOrderType.START_TO_START) {
                            return START_TO_START;
                        }
                        if (wo.getLinkType() == WorkOrderType.START_TO_FINISH) {
                            return START_TO_FINISH;
                        }
                        return wo.getLinkType().getName();
                    }
                }
                return "";
            }
        };
        this.viewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        this.textCellEditor = new TextCellEditor((Composite)this.viewer.getTable());
        this.comboBoxCellEditor = new ComboBoxCellEditor((Composite)this.viewer.getTable(), new String[]{FINISH_TO_START, FINISH_TO_FINISH, START_TO_START, START_TO_FINISH});
        this.setCellEditors();
        this.setCellModifiers();
        this.initializePredList();
        this.viewer.setInput((Object)this.predMapList);
        this.viewer.refresh();
    }

    private int getCellEditorType(String property) {
        int i = 0;
        while (i < this.columnDescriptors.length) {
            ColumnDescriptor desc = this.columnDescriptors[i];
            if (desc.id == property) {
                return desc.cellEditorType;
            }
            ++i;
        }
        return 0;
    }

    public CellEditor getCellEditor(String columnID, int columnIndex) {
        if (columnID == COL_ID) {
            if (this.idCellEditor == null) {
                this.idCellEditor = new ValidatingTextCellEditor((Composite)this.viewer.getTable()){

                    protected String isValid(Object e, String txt) {
                        e = TngUtil.unwrap((Object)e);
                        IBSItemProvider adapter = (IBSItemProvider)WorkBreakdownElementGeneralSection.this.getBSAdapter();
                        Object process = adapter.getTopItem();
                        ArrayList predecessors = new ArrayList();
                        WorkBreakdownElement wbe = (WorkBreakdownElement)WorkBreakdownElementGeneralSection.this.getElement();
                        String str = WorkBreakdownElementGeneralSection.this.getPredId();
                        String result = ProcessUtil.checkPredecessorList((WorkBreakdownElement)wbe, (String)str, (AdapterFactory)WorkBreakdownElementGeneralSection.this.getAdapterFactory(), (Object)process, predecessors);
                        return result;
                    }
                };
                this.idCellEditor.setValidator(new CellEditorValidator(this.idCellEditor));
                this.idCellEditor.getControl().addListener(27, (Listener)new ValidatingDeactivateListener(this.idCellEditor));
            }
            this.idCellEditor.setColumnIndex(columnIndex);
            return this.idCellEditor;
        }
        return null;
    }

    private void setCellEditors() {
        CellEditor[] cellEditors = new CellEditor[this.columnDescriptors.length];
        int i = 0;
        while (i < this.columnDescriptors.length) {
            CellEditor cellEditor = this.getCellEditor(this.columnDescriptors[i].id, i);
            if (cellEditor != null) {
                cellEditors[i] = cellEditor;
            } else {
                switch (this.columnDescriptors[i].cellEditorType) {
                    case 1: {
                        cellEditors[i] = this.textCellEditor;
                        break;
                    }
                    case 2: {
                        cellEditors[i] = this.comboBoxCellEditor;
                        break;
                    }
                    default: {
                        cellEditors[i] = null;
                    }
                }
            }
            ++i;
        }
        this.viewer.setCellEditors(cellEditors);
    }

    private void setCellModifiers() {
        this.viewer.setCellModifier(new ICellModifier(){

            public boolean canModify(Object element, String property) {
                if (!(element instanceof PredecessorMap)) {
                    return false;
                }
                return property != WorkBreakdownElementGeneralSection.COL_PRESENTATION_NAME;
            }

            public Object getValue(Object element, String property) {
                String val = null;
                switch (WorkBreakdownElementGeneralSection.this.getCellEditorType(property)) {
                    case 1: {
                        val = new Integer(((PredecessorMap)element).getId()).toString();
                        return val;
                    }
                    case 2: {
                        int value = ((PredecessorMap)element).getWorkOrder().getLinkType().getValue();
                        if (value == 0) {
                            return new Integer(0);
                        }
                        if (1 == value) {
                            return new Integer(1);
                        }
                        if (2 == value) {
                            return new Integer(2);
                        }
                        return new Integer(3);
                    }
                }
                return "";
            }

            public void modify(Object element, String property, Object value) {
                TableItem item = (TableItem)element;
                PredecessorMap predMap = (PredecessorMap)item.getData();
                WorkOrder wo = predMap.getWorkOrder();
                if (property.equals(WorkBreakdownElementGeneralSection.COL_ID)) {
                    int predId;
                    item.setText(0, value.toString());
                    try {
                        predId = new Integer(value.toString());
                        if (predId < 0) {
                            throw new Exception();
                        }
                    }
                    catch (Exception exception) {
                        AuthoringUIPlugin.getDefault().getMsgDialog().displayWarning(PropertiesResources.Process_predecessors_validNumberTitle, PropertiesResources.Process_predecessors_validNumberMessage);
                        WorkBreakdownElementGeneralSection.this.predMapList.remove(predMap);
                        WorkBreakdownElementGeneralSection.this.viewer.refresh();
                        return;
                    }
                    predMap.setId(predId);
                }
                int columnIndex = WorkBreakdownElementGeneralSection.this.getColumnIndex(property);
                CellEditor cellEditor = WorkBreakdownElementGeneralSection.this.viewer.getCellEditors()[columnIndex];
                String errMsg = cellEditor.getErrorMessage();
                if (errMsg != null) {
                    return;
                }
                IBSItemProvider adapter = (IBSItemProvider)WorkBreakdownElementGeneralSection.this.getBSAdapter();
                WorkBreakdownElement wbe = (WorkBreakdownElement)WorkBreakdownElementGeneralSection.this.getElement();
                switch (WorkBreakdownElementGeneralSection.this.getCellEditorType(property)) {
                    case 1: {
                        Object process = adapter.getTopItem();
                        ArrayList predecessors = new ArrayList();
                        String str = WorkBreakdownElementGeneralSection.this.getPredId();
                        String result = ProcessUtil.checkPredecessorList((WorkBreakdownElement)wbe, (String)str, (AdapterFactory)WorkBreakdownElementGeneralSection.this.getAdapterFactory(), (Object)process, predecessors);
                        if (result == null) {
                            ArrayList addList = new ArrayList();
                            ArrayList predToBeDeleted = new ArrayList();
                            PredecessorList.prepareUpdatePredecessors((AdapterFactory)WorkBreakdownElementGeneralSection.this.getAdapterFactory(), (WorkBreakdownElement)wbe, predecessors, addList, predToBeDeleted);
                            if (!predToBeDeleted.isEmpty()) {
                                WorkBreakdownElementGeneralSection.this.actionMgr.doAction(6, (EObject)wbe, (EStructuralFeature)UmaPackage.eINSTANCE.getWorkBreakdownElement_LinkToPredecessor(), predToBeDeleted, -1);
                            }
                            if (addList.isEmpty()) break;
                            boolean status = WorkBreakdownElementGeneralSection.this.actionMgr.doAction(5, (EObject)wbe, (EStructuralFeature)UmaPackage.eINSTANCE.getWorkBreakdownElement_LinkToPredecessor(), addList, -1);
                            if (status) {
                                predMap.setWorkOrder((WorkOrder)addList.get(addList.size() - 1));
                                break;
                            }
                            WorkBreakdownElementGeneralSection.this.predMapList.remove(predMap);
                            break;
                        }
                        String title = WorkBreakdownElementGeneralSection.this.getEditor().getTitle();
                        String problem = PropertiesResources.ProcessEditorFormProperties_cellEditor_invalidPredcessor_problem_msg;
                        MsgDialog dialog = AuthoringUIPlugin.getDefault().getMsgDialog();
                        dialog.displayWarning(title, problem, result);
                        WorkBreakdownElementGeneralSection.this.predMapList.remove(predMap);
                        break;
                    }
                    case 2: {
                        boolean removed = false;
                        WorkBreakdownElement wbeCopy = null;
                        WorkOrder o = null;
                        int index = ((Number)value).intValue();
                        Iterator iter = wbe.getLinkToPredecessor().iterator();
                        while (iter.hasNext()) {
                            o = (WorkOrder)iter.next();
                            if (o.getPred() != wo.getPred() || o.getLinkType().getValue() == index) continue;
                            wbeCopy = o.getPred();
                            iter.remove();
                            removed = true;
                        }
                        WorkOrderType type = index == 0 ? WorkOrderType.FINISH_TO_START : (index == 1 ? WorkOrderType.FINISH_TO_FINISH : (index == 2 ? WorkOrderType.START_TO_START : WorkOrderType.START_TO_FINISH));
                        if (removed && wbeCopy != null) {
                            wo.setPred(wbeCopy);
                            wo.setLinkType(type);
                            boolean status = WorkBreakdownElementGeneralSection.this.actionMgr.doAction(3, (EObject)wbe, (EStructuralFeature)UmaPackage.eINSTANCE.getWorkBreakdownElement_LinkToPredecessor(), (Object)wo, -1);
                            if (!status) break;
                            predMap.setWorkOrder(o);
                            break;
                        }
                        WorkBreakdownElementGeneralSection.this.actionMgr.doAction(1, (EObject)wo, (EStructuralFeature)UmaPackage.eINSTANCE.getWorkOrder_LinkType(), (Object)type, -1);
                        break;
                    }
                    default: {
                        WorkOrderType workOrderType = WorkOrderType.FINISH_TO_FINISH;
                    }
                }
                WorkBreakdownElementGeneralSection.this.viewer.refresh();
            }
        });
    }

    private ItemProviderAdapter getBSAdapter() {
        try {
            AdapterFactory factory = this.getAdapterFactory();
            this.element = (WorkBreakdownElement)this.getElement();
            ItemProviderAdapter provider = (ItemProviderAdapter)factory.adapt((Notifier)this.element, ITreeItemContentProvider.class);
            return provider;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private int getColumnIndex(String property) {
        Object[] colProps = this.viewer.getColumnProperties();
        int i = 0;
        while (i < colProps.length) {
            if (colProps[i] == property) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public String getNamePrefix() {
        if (this.element instanceof TeamProfile) {
            return String.valueOf(LibraryUIText.TEXT_TEAM_PROFILE) + ": ";
        }
        if (this.element instanceof Milestone) {
            return String.valueOf(LibraryUIText.TEXT_MILESTONE) + ": ";
        }
        return String.valueOf(LibraryUIText.TEXT_WORK_PRODUCT_ELEMENT) + ": ";
    }

    private String getPredId() {
        StringBuffer buf = new StringBuffer();
        for (PredecessorMap map : this.predMapList) {
            buf.append(map.getId());
            buf.append(",");
        }
        return buf.toString();
    }

    private void initializePredList() {
        try {
            Object input;
            ISelection selection;
            ItemProviderAdapter provider;
            PredecessorList predProviders = null;
            this.element = (WorkBreakdownElement)this.getElement();
            AdapterFactory factory = this.getAdapterFactory();
            if (factory != null && (provider = (ItemProviderAdapter)factory.adapt((Notifier)this.element, ITreeItemContentProvider.class)) instanceof IBSItemProvider) {
                predProviders = ((IBSItemProvider)provider).getPredecessors();
            }
            if ((selection = this.getSelection()) instanceof IStructuredSelection && (input = ((IStructuredSelection)selection).getFirstElement()) instanceof BreakdownElementWrapperItemProvider) {
                predProviders = ((BreakdownElementWrapperItemProvider)input).getPredecessors();
            }
            if (this.element != null && predProviders != null) {
                List predList = this.element.getLinkToPredecessor();
                Iterator itemIterator = predProviders.iterator();
                while (itemIterator.hasNext()) {
                    VariabilityElement ve;
                    int id;
                    boolean found = false;
                    Object itemObj = itemIterator.next();
                    Object targetObj = null;
                    if (itemObj instanceof WrapperItemProvider) {
                        targetObj = ((WrapperItemProvider)itemObj).getValue();
                    }
                    if (itemObj instanceof ItemProviderAdapter) {
                        targetObj = ((ItemProviderAdapter)itemObj).getTarget();
                    }
                    if (targetObj == null || (found = this.addPredecessor(predList, id = ((IBSItemProvider)itemObj).getId(), targetObj)) || !(targetObj instanceof VariabilityElement) || (ve = (VariabilityElement)targetObj).getVariabilityBasedOnElement() == null) continue;
                    VariabilityElement el = ve.getVariabilityBasedOnElement();
                    targetObj = el;
                    this.addPredecessor(predList, id, targetObj);
                }
            }
        }
        catch (Exception e) {
            this.logger.logError("Initializing Predecessor List", (Throwable)e);
        }
    }

    private boolean addPredecessor(List predList, int id, Object targetObj) {
        for (Object o : predList) {
            WorkBreakdownElement wbe;
            if (!(o instanceof WorkOrder) || !targetObj.equals(wbe = ((WorkOrder)o).getPred())) continue;
            PredecessorMap map = new PredecessorMap(id, (WorkOrder)o);
            this.predMapList.add(map);
            return true;
        }
        return false;
    }

    private static class CellEditorValidator
    implements ICellEditorValidator {
        private ValidatingTextCellEditor cellEditor;

        public CellEditorValidator(ValidatingTextCellEditor cellEditor) {
            this.cellEditor = cellEditor;
        }

        public String isValid(Object value) {
            return this.cellEditor.isValid((String)value);
        }
    }

    private class ValidatingDeactivateListener
    implements Listener {
        private ValidatingTextCellEditor cellEditor;

        ValidatingDeactivateListener(ValidatingTextCellEditor cellEditor) {
            this.cellEditor = cellEditor;
        }

        public void handleEvent(Event e) {
            Display.getCurrent().asyncExec(new Runnable(){

                public void run() {
                    if (ValidatingDeactivateListener.this.cellEditor.getLastInvalidElement() != null) {
                        String message = ValidatingDeactivateListener.this.cellEditor.getErrorMessage();
                        String title = WorkBreakdownElementGeneralSection.this.getEditor().getTitle();
                        String problem = PropertiesResources.ProcessEditorFormProperties_textEditCell_problem_msg;
                        MsgDialog dialog = AuthoringUIPlugin.getDefault().getMsgDialog();
                        dialog.displayError(title, problem, message);
                        WorkBreakdownElementGeneralSection.this.viewer.editElement(ValidatingDeactivateListener.this.cellEditor.getLastInvalidElement(), ValidatingDeactivateListener.this.cellEditor.getColumnIndex());
                    }
                }
            });
        }
    }

    private class ValidatingTextCellEditor
    extends TextCellEditor {
        protected Object lastInvalidElement;
        private int columnIndex;

        public ValidatingTextCellEditor(Composite parent) {
            super(parent);
        }

        void setColumnIndex(int columnIndex) {
            this.columnIndex = columnIndex;
        }

        public int getColumnIndex() {
            return this.columnIndex;
        }

        public Object getLastInvalidElement() {
            return this.lastInvalidElement;
        }

        String isValid(String txt) {
            IStructuredSelection selection = (IStructuredSelection)WorkBreakdownElementGeneralSection.this.viewer.getSelection();
            if (selection.size() == 1) {
                Object e = selection.getFirstElement();
                String msg = this.isValid(e, txt);
                this.lastInvalidElement = msg != null ? e : null;
                return msg;
            }
            return null;
        }

        protected String isValid(Object e, String txt) {
            return null;
        }
    }
}

