/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.wizards;

import java.io.File;
import java.util.HashMap;
import org.eclipse.epf.authoring.ui.AuthoringPerspective;
import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.authoring.ui.wizards.NewLibraryMainPage;
import org.eclipse.epf.authoring.ui.wizards.SaveAllEditorsPage;
import org.eclipse.epf.common.ui.util.PerspectiveUtil;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.ui.LibraryUIPlugin;
import org.eclipse.epf.library.ui.LibraryUIResources;
import org.eclipse.epf.library.ui.preferences.LibraryUIPreferences;
import org.eclipse.epf.library.xmi.XMILibraryUtil;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class NewLibraryWizard
extends Wizard
implements INewWizard {
    public static final String WIZARD_ID = NewLibraryWizard.class.getName();
    private NewLibraryMainPage mainPage;

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.setWindowTitle(AuthoringUIResources.newLibraryWizard_title);
    }

    public void addPages() {
        SaveAllEditorsPage.addPageIfNeeded(this, true, null, null, null);
        this.mainPage = new NewLibraryMainPage();
        this.addPage((IWizardPage)this.mainPage);
    }

    public void createPageControls(Composite pageContainer) {
        super.createPageControls(pageContainer);
        pageContainer.getShell().setImage(AuthoringUIPlugin.getDefault().getSharedImage("full/obj16/MethodLibrary.gif"));
    }

    public boolean performFinish() {
        try {
            String name = this.mainPage.getLibraryName();
            String desc = this.mainPage.getLibraryDescription();
            String type = this.mainPage.getLibraryType();
            HashMap<String, String> options = new HashMap<String, String>();
            File libraryPath = new File(this.mainPage.getLibraryPath());
            options.put("library.path", libraryPath.getAbsolutePath());
            if (XMILibraryUtil.containsPluginOrConfigSpecExportFile((String)libraryPath.getAbsolutePath())) {
                throw new Exception(LibraryUIResources.openLibraryError_reason4);
            }
            MethodLibrary library = LibraryService.getInstance().createMethodLibrary(name, type, options);
            if (library != null) {
                if (desc.length() > 0) {
                    library.setBriefDescription(desc);
                }
                LibraryUIPreferences.addNewLibraryPath((String)libraryPath.getAbsolutePath());
                PerspectiveUtil.openPerspective((String)AuthoringPerspective.PERSPECTIVE_ID);
                return true;
            }
        }
        catch (Exception e) {
            String reason = e.getMessage();
            if (reason == null) {
                reason = AuthoringUIResources.newLibraryInternlError_reason;
            }
            reason = String.valueOf(reason) + "\n\n" + AuthoringUIResources.newLibraryError_advice;
            if (e.getMessage() != null) {
                LibraryUIPlugin.getDefault().getMsgDialog().displayError(AuthoringUIResources.newLibraryWizard_title, AuthoringUIResources.newLibraryError_msg, reason);
            }
            LibraryUIPlugin.getDefault().getMsgDialog().displayError(AuthoringUIResources.newLibraryWizard_title, AuthoringUIResources.newLibraryError_msg, reason, (Throwable)e);
        }
        return false;
    }
}

