/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.wizards;

import java.util.Iterator;
import java.util.List;
import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.authoring.ui.AuthoringUIText;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.ui.LibraryUIImages;
import org.eclipse.epf.library.ui.LibraryUIResources;
import org.eclipse.epf.library.util.LibraryUtil;
import org.eclipse.epf.library.util.ModelStorage;
import org.eclipse.epf.ui.wizards.BaseWizardPage;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class NewPluginMainPage
extends BaseWizardPage {
    public static final String PAGE_NAME = NewPluginMainPage.class.getName();
    protected Composite composite;
    protected Label nameTextLabel;
    protected Text nameText;
    protected Text briefDescText;
    protected Text authorsText;
    protected Label referencedPluginsLabel;
    protected CheckboxTableViewer referencedPluginsViewer;
    protected List<MethodPlugin> plugins;

    public NewPluginMainPage(String pageName) {
        super(pageName);
        this.setTitle(AuthoringUIResources.newPluginWizardPage_title);
        this.setDescription(AuthoringUIResources.newPluginWizardPage_text);
        this.setImageDescriptor(AuthoringUIPlugin.getDefault().getImageDescriptor("full/wizban/New.gif"));
    }

    public NewPluginMainPage() {
        this(PAGE_NAME);
    }

    public void createControl(Composite parent) {
        this.composite = NewPluginMainPage.createGridLayoutComposite((Composite)parent, (int)2);
        this.createNameField(this.composite);
        this.createBriefDescField(this.composite);
        this.createAuthorsField(this.composite);
        this.createReferencedModelsViewer(this.composite);
        this.initControls();
        this.addListeners();
        this.setControl((Control)this.composite);
    }

    protected void createReferencedModelsViewer(Composite composite) {
        this.referencedPluginsLabel = NewPluginMainPage.createVerticallyAlignedLabel((Composite)composite, (String)AuthoringUIText.REFERENCED_PLUGINS_SECTION_NAME);
        this.referencedPluginsViewer = CheckboxTableViewer.newCheckList((Composite)composite, (int)2308);
        GridData referencedPluginsGridData = new GridData(768);
        referencedPluginsGridData.heightHint = 150;
        this.referencedPluginsViewer.getTable().setLayoutData((Object)referencedPluginsGridData);
    }

    protected void createAuthorsField(Composite composite) {
        NewPluginMainPage.createVerticallyAlignedLabel((Composite)composite, (String)AuthoringUIText.AUTHORS_TEXT);
        this.authorsText = NewPluginMainPage.createEditableText((Composite)composite, (int)400, (int)40, (int)1);
    }

    protected void createBriefDescField(Composite composite) {
        NewPluginMainPage.createVerticallyAlignedLabel((Composite)composite, (String)AuthoringUIText.BRIEF_DESCRIPTION_TEXT);
        this.briefDescText = NewPluginMainPage.createEditableText((Composite)composite, (int)400, (int)80, (int)1);
    }

    protected void createNameField(Composite composite) {
        this.nameTextLabel = NewPluginMainPage.createVerticallyAlignedLabel((Composite)composite, (String)AuthoringUIText.NAME_TEXT);
        this.nameText = NewPluginMainPage.createEditableText((Composite)composite);
    }

    protected void initControls() {
        this.initNameField();
        this.initReferencedModelsViewer();
    }

    protected void initNameField() {
        String name = "new_plug-in";
        if (LibraryService.getInstance().getCurrentMethodLibrary() != null) {
            name = TngUtil.getNextAvailableName((List)LibraryService.getInstance().getCurrentMethodLibrary().getMethodPlugins(), (String)name);
        }
        this.nameText.setText(name);
    }

    protected void initReferencedModelsViewer() {
        LabelProvider labelProvider = new LabelProvider(){

            public Image getImage(Object element) {
                return LibraryUIImages.IMG_METHOD_PLUGIN;
            }

            public String getText(Object element) {
                if (element instanceof MethodPlugin) {
                    return ((MethodPlugin)element).getName();
                }
                return element.toString();
            }
        };
        this.referencedPluginsViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        this.referencedPluginsViewer.setSorter(new ViewerSorter());
        this.plugins = ModelStorage.getBaseModels();
        String[] items = new String[this.plugins.size()];
        int i = 0;
        while (i < this.plugins.size()) {
            MethodPlugin plugin = this.plugins.get(i);
            items[i] = plugin.getName();
            ++i;
        }
        if (this.plugins != null) {
            Iterator<MethodPlugin> it = this.plugins.iterator();
            while (it.hasNext()) {
                this.referencedPluginsViewer.add((Object)it.next());
            }
        }
    }

    protected void addListeners() {
        this.addNameFieldListeners();
    }

    protected void addNameFieldListeners() {
        this.nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewPluginMainPage.this.setPageComplete(NewPluginMainPage.this.isPageComplete());
                NewPluginMainPage.this.getWizard().getContainer().updateButtons();
            }
        });
    }

    public void onEnterPage(Object obj) {
        if (this.nameText != null) {
            this.nameText.setFocus();
            this.nameText.selectAll();
        }
        this.setPageComplete(this.isPageComplete());
    }

    public boolean isPageComplete() {
        this.setErrorMessage(null);
        if (LibraryService.getInstance().getCurrentMethodLibrary() == null) {
            this.setErrorMessage(LibraryUIResources.noOpenLibraryWarning_msg);
            return false;
        }
        return this.validatePluginName(this.getPluginName());
    }

    protected boolean validatePluginName(String name) {
        String errmsg = LibraryUtil.checkPluginName(null, (String)name);
        if (errmsg != null) {
            errmsg = errmsg.replaceAll("\n\n", " ");
        }
        this.setErrorMessage(errmsg);
        return errmsg == null;
    }

    public String getPluginName() {
        return this.nameText.getText() != null ? this.nameText.getText().trim() : null;
    }

    public String getBriefDescription() {
        return this.briefDescText.getText();
    }

    public String getAuthors() {
        return this.authorsText.getText();
    }

    public Object[] getReferencedPlugins() {
        return this.referencedPluginsViewer.getCheckedElements();
    }
}

