/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.query.conditions.strings;

import com.ibm.icu.text.Collator;
import com.ibm.icu.text.RuleBasedCollator;
import com.ibm.icu.text.StringSearch;
import org.eclipse.emf.query.conditions.strings.StringAdapter;
import org.eclipse.emf.query.conditions.strings.StringValue;

public class SubStringValue
extends StringValue {
    private static RuleBasedCollator CASE_INSENSITIVE_COLLATOR = (RuleBasedCollator)Collator.getInstance();

    static {
        CASE_INSENSITIVE_COLLATOR.setStrength(0);
    }

    public SubStringValue(String subString) {
        this(subString, true);
    }

    public SubStringValue(String subString, StringAdapter adpater) {
        this(subString, true, adpater);
    }

    public SubStringValue(String subString, boolean caseSensitive) {
        this(subString, caseSensitive, StringAdapter.DEFAULT);
    }

    public SubStringValue(String subString, boolean caseSensitive, StringAdapter adpater) {
        super(subString, caseSensitive, adpater);
    }

    public boolean isSatisfied(String str) {
        String theString = this.getString();
        if (str == null) {
            return theString == null;
        }
        if (theString.length() == 0) {
            return true;
        }
        if (str.length() == 0) {
            return false;
        }
        StringSearch search = new StringSearch(theString, str);
        if (!this.isCaseSensitive()) {
            search.setCollator(CASE_INSENSITIVE_COLLATOR);
        }
        return search.next() != -1;
    }
}

